/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.Log;
import com.blankj.utilcode.util.Utils;
import java.lang.reflect.Field;

public final class AdaptScreenUtils {
    private static boolean isInitMiui = false;
    private static Field mTmpMetricsField;

    public static Resources adaptWidth(Resources resources, int designWidth) {
        DisplayMetrics dm = AdaptScreenUtils.getDisplayMetrics(resources);
        float newXdpi = dm.xdpi = (float)dm.widthPixels * 72.0f / (float)designWidth;
        AdaptScreenUtils.setAppDmXdpi(newXdpi);
        return resources;
    }

    public static Resources adaptHeight(Resources resources, int designHeight) {
        DisplayMetrics dm = AdaptScreenUtils.getDisplayMetrics(resources);
        float newXdpi = dm.xdpi = (float)dm.heightPixels * 72.0f / (float)designHeight;
        AdaptScreenUtils.setAppDmXdpi(newXdpi);
        return resources;
    }

    public static Resources closeAdapt(Resources resources) {
        DisplayMetrics dm = AdaptScreenUtils.getDisplayMetrics(resources);
        float newXdpi = dm.xdpi = dm.density * 72.0f;
        AdaptScreenUtils.setAppDmXdpi(newXdpi);
        return resources;
    }

    public static int pt2Px(float ptValue) {
        DisplayMetrics metrics = Utils.getApp().getResources().getDisplayMetrics();
        return (int)((double)(ptValue * metrics.xdpi / 72.0f) + 0.5);
    }

    public static int px2Pt(float pxValue) {
        DisplayMetrics metrics = Utils.getApp().getResources().getDisplayMetrics();
        return (int)((double)(pxValue * 72.0f / metrics.xdpi) + 0.5);
    }

    private static void setAppDmXdpi(float xdpi) {
        Utils.getApp().getResources().getDisplayMetrics().xdpi = xdpi;
    }

    private static DisplayMetrics getDisplayMetrics(Resources resources) {
        DisplayMetrics miuiDisplayMetrics = AdaptScreenUtils.getMiuiTmpMetrics(resources);
        if (miuiDisplayMetrics == null) {
            return resources.getDisplayMetrics();
        }
        return miuiDisplayMetrics;
    }

    private static DisplayMetrics getMiuiTmpMetrics(Resources resources) {
        if (!isInitMiui) {
            DisplayMetrics ret = null;
            String simpleName = resources.getClass().getSimpleName();
            if ("MiuiResources".equals(simpleName) || "XResources".equals(simpleName)) {
                try {
                    mTmpMetricsField = Resources.class.getDeclaredField("mTmpMetrics");
                    mTmpMetricsField.setAccessible(true);
                    ret = (DisplayMetrics)mTmpMetricsField.get(resources);
                }
                catch (Exception e) {
                    Log.e((String)"AdaptScreenUtils", (String)"no field of mTmpMetrics in resources.");
                }
            }
            isInitMiui = true;
            return ret;
        }
        if (mTmpMetricsField == null) {
            return null;
        }
        try {
            return (DisplayMetrics)mTmpMetricsField.get(resources);
        }
        catch (Exception e) {
            return null;
        }
    }
}

