/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import androidx.annotation.AnimRes;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityOptionsCompat;
import androidx.core.util.Pair;
import com.blankj.utilcode.util.Utils;
import java.util.LinkedList;
import java.util.List;

public final class ActivityUtils {
    private ActivityUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Activity getActivityByView(@NonNull View view) {
        return ActivityUtils.getActivityByContext(view.getContext());
    }

    public static Activity getActivityByContext(@NonNull Context context) {
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    public static boolean isActivityExists(@NonNull String pkg, @NonNull String cls) {
        Intent intent = new Intent();
        intent.setClassName(pkg, cls);
        return Utils.getApp().getPackageManager().resolveActivity(intent, 0) != null && intent.resolveActivity(Utils.getApp().getPackageManager()) != null && Utils.getApp().getPackageManager().queryIntentActivities(intent, 0).size() != 0;
    }

    public static void startActivity(@NonNull Class<? extends Activity> clz) {
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, null, context.getPackageName(), clz.getName(), null);
    }

    public static void startActivity(@NonNull Class<? extends Activity> clz, Bundle options) {
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, null, context.getPackageName(), clz.getName(), options);
    }

    public static void startActivity(@NonNull Class<? extends Activity> clz, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, null, context.getPackageName(), clz.getName(), ActivityUtils.getOptionsBundle(context, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Class<? extends Activity> clz) {
        ActivityUtils.startActivity((Context)activity, null, activity.getPackageName(), clz.getName(), null);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Class<? extends Activity> clz, Bundle options) {
        ActivityUtils.startActivity((Context)activity, null, activity.getPackageName(), clz.getName(), options);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Class<? extends Activity> clz, View ... sharedElements) {
        ActivityUtils.startActivity((Context)activity, null, activity.getPackageName(), clz.getName(), ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Class<? extends Activity> clz, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivity((Context)activity, null, activity.getPackageName(), clz.getName(), ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Class<? extends Activity> clz) {
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, extras, context.getPackageName(), clz.getName(), null);
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Class<? extends Activity> clz, @NonNull Bundle options) {
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, extras, context.getPackageName(), clz.getName(), options);
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Class<? extends Activity> clz, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, extras, context.getPackageName(), clz.getName(), ActivityUtils.getOptionsBundle(context, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Activity activity, @NonNull Class<? extends Activity> clz) {
        ActivityUtils.startActivity((Context)activity, extras, activity.getPackageName(), clz.getName(), null);
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Activity activity, @NonNull Class<? extends Activity> clz, @NonNull Bundle options) {
        ActivityUtils.startActivity((Context)activity, extras, activity.getPackageName(), clz.getName(), options);
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Activity activity, @NonNull Class<? extends Activity> clz, View ... sharedElements) {
        ActivityUtils.startActivity((Context)activity, extras, activity.getPackageName(), clz.getName(), ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Activity activity, @NonNull Class<? extends Activity> clz, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivity((Context)activity, extras, activity.getPackageName(), clz.getName(), ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivity(@NonNull String pkg, @NonNull String cls) {
        ActivityUtils.startActivity(Utils.getTopActivityOrApp(), null, pkg, cls, null);
    }

    public static void startActivity(@NonNull String pkg, @NonNull String cls, Bundle options) {
        ActivityUtils.startActivity(Utils.getTopActivityOrApp(), null, pkg, cls, options);
    }

    public static void startActivity(@NonNull String pkg, @NonNull String cls, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, null, pkg, cls, ActivityUtils.getOptionsBundle(context, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivity(@NonNull Activity activity, @NonNull String pkg, @NonNull String cls) {
        ActivityUtils.startActivity((Context)activity, null, pkg, cls, null);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull String pkg, @NonNull String cls, Bundle options) {
        ActivityUtils.startActivity((Context)activity, null, pkg, cls, options);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull String pkg, @NonNull String cls, View ... sharedElements) {
        ActivityUtils.startActivity((Context)activity, null, pkg, cls, ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivity(@NonNull Activity activity, @NonNull String pkg, @NonNull String cls, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivity((Context)activity, null, pkg, cls, ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull String pkg, @NonNull String cls) {
        ActivityUtils.startActivity(Utils.getTopActivityOrApp(), extras, pkg, cls, null);
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull String pkg, @NonNull String cls, Bundle options) {
        ActivityUtils.startActivity(Utils.getTopActivityOrApp(), extras, pkg, cls, options);
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull String pkg, @NonNull String cls, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, extras, pkg, cls, ActivityUtils.getOptionsBundle(context, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Activity activity, @NonNull String pkg, @NonNull String cls) {
        ActivityUtils.startActivity((Context)activity, extras, pkg, cls, null);
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Activity activity, @NonNull String pkg, @NonNull String cls, Bundle options) {
        ActivityUtils.startActivity((Context)activity, extras, pkg, cls, options);
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Activity activity, @NonNull String pkg, @NonNull String cls, View ... sharedElements) {
        ActivityUtils.startActivity((Context)activity, extras, pkg, cls, ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Activity activity, @NonNull String pkg, @NonNull String cls, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivity((Context)activity, extras, pkg, cls, ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static boolean startActivity(@NonNull Intent intent) {
        return ActivityUtils.startActivity(intent, Utils.getTopActivityOrApp(), null);
    }

    public static boolean startActivity(@NonNull Intent intent, @NonNull Bundle options) {
        return ActivityUtils.startActivity(intent, Utils.getTopActivityOrApp(), options);
    }

    public static boolean startActivity(@NonNull Intent intent, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        Context context = Utils.getTopActivityOrApp();
        boolean isSuccess = ActivityUtils.startActivity(intent, context, ActivityUtils.getOptionsBundle(context, enterAnim, exitAnim));
        if (isSuccess && Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(enterAnim, exitAnim);
        }
        return isSuccess;
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Intent intent) {
        ActivityUtils.startActivity(intent, (Context)activity, null);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Intent intent, Bundle options) {
        ActivityUtils.startActivity(intent, (Context)activity, options);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Intent intent, View ... sharedElements) {
        ActivityUtils.startActivity(intent, (Context)activity, ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Intent intent, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivity(intent, (Context)activity, ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Class<? extends Activity> clz, int requestCode) {
        ActivityUtils.startActivityForResult(activity, null, activity.getPackageName(), clz.getName(), requestCode, null);
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Class<? extends Activity> clz, int requestCode, Bundle options) {
        ActivityUtils.startActivityForResult(activity, null, activity.getPackageName(), clz.getName(), requestCode, options);
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Class<? extends Activity> clz, int requestCode, View ... sharedElements) {
        ActivityUtils.startActivityForResult(activity, null, activity.getPackageName(), clz.getName(), requestCode, ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Class<? extends Activity> clz, int requestCode, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivityForResult(activity, null, activity.getPackageName(), clz.getName(), requestCode, ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Activity activity, @NonNull Class<? extends Activity> clz, int requestCode) {
        ActivityUtils.startActivityForResult(activity, extras, activity.getPackageName(), clz.getName(), requestCode, null);
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Activity activity, @NonNull Class<? extends Activity> clz, int requestCode, @NonNull Bundle options) {
        ActivityUtils.startActivityForResult(activity, extras, activity.getPackageName(), clz.getName(), requestCode, options);
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Activity activity, @NonNull Class<? extends Activity> clz, int requestCode, View ... sharedElements) {
        ActivityUtils.startActivityForResult(activity, extras, activity.getPackageName(), clz.getName(), requestCode, ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Activity activity, @NonNull Class<? extends Activity> clz, int requestCode, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivityForResult(activity, extras, activity.getPackageName(), clz.getName(), requestCode, ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Activity activity, @NonNull String pkg, @NonNull String cls, int requestCode) {
        ActivityUtils.startActivityForResult(activity, extras, pkg, cls, requestCode, null);
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Activity activity, @NonNull String pkg, @NonNull String cls, int requestCode, Bundle options) {
        ActivityUtils.startActivityForResult(activity, extras, pkg, cls, requestCode, options);
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Activity activity, @NonNull String pkg, @NonNull String cls, int requestCode, View ... sharedElements) {
        ActivityUtils.startActivityForResult(activity, extras, pkg, cls, requestCode, ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Activity activity, @NonNull String pkg, @NonNull String cls, int requestCode, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivityForResult(activity, extras, pkg, cls, requestCode, ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Intent intent, int requestCode) {
        ActivityUtils.startActivityForResult(intent, activity, requestCode, null);
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Intent intent, int requestCode, Bundle options) {
        ActivityUtils.startActivityForResult(intent, activity, requestCode, options);
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Intent intent, int requestCode, View ... sharedElements) {
        ActivityUtils.startActivityForResult(intent, activity, requestCode, ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Intent intent, int requestCode, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivityForResult(intent, activity, requestCode, ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivities(@NonNull Intent[] intents) {
        ActivityUtils.startActivities(intents, Utils.getTopActivityOrApp(), null);
    }

    public static void startActivities(@NonNull Intent[] intents, Bundle options) {
        ActivityUtils.startActivities(intents, Utils.getTopActivityOrApp(), options);
    }

    public static void startActivities(@NonNull Intent[] intents, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivities(intents, context, ActivityUtils.getOptionsBundle(context, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivities(@NonNull Activity activity, @NonNull Intent[] intents) {
        ActivityUtils.startActivities(intents, (Context)activity, null);
    }

    public static void startActivities(@NonNull Activity activity, @NonNull Intent[] intents, Bundle options) {
        ActivityUtils.startActivities(intents, (Context)activity, options);
    }

    public static void startActivities(@NonNull Activity activity, @NonNull Intent[] intents, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivities(intents, (Context)activity, ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startHomeActivity() {
        Intent homeIntent = new Intent("android.intent.action.MAIN");
        homeIntent.addCategory("android.intent.category.HOME");
        ActivityUtils.startActivity(homeIntent);
    }

    public static List<Activity> getActivityList() {
        return Utils.getActivityList();
    }

    public static String getLauncherActivity() {
        return ActivityUtils.getLauncherActivity(Utils.getApp().getPackageName());
    }

    public static String getLauncherActivity(@NonNull String pkg) {
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.addFlags(0x10000000);
        PackageManager pm = Utils.getApp().getPackageManager();
        List info = pm.queryIntentActivities(intent, 0);
        for (ResolveInfo aInfo : info) {
            if (!aInfo.activityInfo.packageName.equals(pkg)) continue;
            return aInfo.activityInfo.name;
        }
        return "no " + pkg;
    }

    public static Activity getTopActivity() {
        return Utils.getActivityLifecycle().getTopActivity();
    }

    public static boolean isActivityExistsInStack(@NonNull Activity activity) {
        LinkedList<Activity> activities = Utils.getActivityList();
        for (Activity aActivity : activities) {
            if (!aActivity.equals(activity)) continue;
            return true;
        }
        return false;
    }

    public static boolean isActivityExistsInStack(@NonNull Class<? extends Activity> clz) {
        LinkedList<Activity> activities = Utils.getActivityList();
        for (Activity aActivity : activities) {
            if (!aActivity.getClass().equals(clz)) continue;
            return true;
        }
        return false;
    }

    public static void finishActivity(@NonNull Activity activity) {
        ActivityUtils.finishActivity(activity, false);
    }

    public static void finishActivity(@NonNull Activity activity, boolean isLoadAnim) {
        activity.finish();
        if (!isLoadAnim) {
            activity.overridePendingTransition(0, 0);
        }
    }

    public static void finishActivity(@NonNull Activity activity, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        activity.finish();
        activity.overridePendingTransition(enterAnim, exitAnim);
    }

    public static void finishActivity(@NonNull Class<? extends Activity> clz) {
        ActivityUtils.finishActivity(clz, false);
    }

    public static void finishActivity(@NonNull Class<? extends Activity> clz, boolean isLoadAnim) {
        LinkedList<Activity> activities = Utils.getActivityList();
        for (Activity activity : activities) {
            if (!activity.getClass().equals(clz)) continue;
            activity.finish();
            if (isLoadAnim) continue;
            activity.overridePendingTransition(0, 0);
        }
    }

    public static void finishActivity(@NonNull Class<? extends Activity> clz, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        LinkedList<Activity> activities = Utils.getActivityList();
        for (Activity activity : activities) {
            if (!activity.getClass().equals(clz)) continue;
            activity.finish();
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static boolean finishToActivity(@NonNull Activity activity, boolean isIncludeSelf) {
        return ActivityUtils.finishToActivity(activity, isIncludeSelf, false);
    }

    public static boolean finishToActivity(@NonNull Activity activity, boolean isIncludeSelf, boolean isLoadAnim) {
        LinkedList<Activity> activities = Utils.getActivityList();
        for (int i = activities.size() - 1; i >= 0; --i) {
            Activity aActivity = (Activity)activities.get(i);
            if (aActivity.equals(activity)) {
                if (isIncludeSelf) {
                    ActivityUtils.finishActivity(aActivity, isLoadAnim);
                }
                return true;
            }
            ActivityUtils.finishActivity(aActivity, isLoadAnim);
        }
        return false;
    }

    public static boolean finishToActivity(@NonNull Activity activity, boolean isIncludeSelf, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        LinkedList<Activity> activities = Utils.getActivityList();
        for (int i = activities.size() - 1; i >= 0; --i) {
            Activity aActivity = (Activity)activities.get(i);
            if (aActivity.equals(activity)) {
                if (isIncludeSelf) {
                    ActivityUtils.finishActivity(aActivity, enterAnim, exitAnim);
                }
                return true;
            }
            ActivityUtils.finishActivity(aActivity, enterAnim, exitAnim);
        }
        return false;
    }

    public static boolean finishToActivity(@NonNull Class<? extends Activity> clz, boolean isIncludeSelf) {
        return ActivityUtils.finishToActivity(clz, isIncludeSelf, false);
    }

    public static boolean finishToActivity(@NonNull Class<? extends Activity> clz, boolean isIncludeSelf, boolean isLoadAnim) {
        LinkedList<Activity> activities = Utils.getActivityList();
        for (int i = activities.size() - 1; i >= 0; --i) {
            Activity aActivity = (Activity)activities.get(i);
            if (aActivity.getClass().equals(clz)) {
                if (isIncludeSelf) {
                    ActivityUtils.finishActivity(aActivity, isLoadAnim);
                }
                return true;
            }
            ActivityUtils.finishActivity(aActivity, isLoadAnim);
        }
        return false;
    }

    public static boolean finishToActivity(@NonNull Class<? extends Activity> clz, boolean isIncludeSelf, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        LinkedList<Activity> activities = Utils.getActivityList();
        for (int i = activities.size() - 1; i >= 0; --i) {
            Activity aActivity = (Activity)activities.get(i);
            if (aActivity.getClass().equals(clz)) {
                if (isIncludeSelf) {
                    ActivityUtils.finishActivity(aActivity, enterAnim, exitAnim);
                }
                return true;
            }
            ActivityUtils.finishActivity(aActivity, enterAnim, exitAnim);
        }
        return false;
    }

    public static void finishOtherActivities(@NonNull Class<? extends Activity> clz) {
        ActivityUtils.finishOtherActivities(clz, false);
    }

    public static void finishOtherActivities(@NonNull Class<? extends Activity> clz, boolean isLoadAnim) {
        LinkedList<Activity> activities = Utils.getActivityList();
        for (int i = activities.size() - 1; i >= 0; --i) {
            Activity activity = (Activity)activities.get(i);
            if (activity.getClass().equals(clz)) continue;
            ActivityUtils.finishActivity(activity, isLoadAnim);
        }
    }

    public static void finishOtherActivities(@NonNull Class<? extends Activity> clz, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        LinkedList<Activity> activities = Utils.getActivityList();
        for (int i = activities.size() - 1; i >= 0; --i) {
            Activity activity = (Activity)activities.get(i);
            if (activity.getClass().equals(clz)) continue;
            ActivityUtils.finishActivity(activity, enterAnim, exitAnim);
        }
    }

    public static void finishAllActivities() {
        ActivityUtils.finishAllActivities(false);
    }

    public static void finishAllActivities(boolean isLoadAnim) {
        LinkedList<Activity> activityList = Utils.getActivityList();
        for (int i = activityList.size() - 1; i >= 0; --i) {
            Activity activity = (Activity)activityList.get(i);
            activity.finish();
            if (isLoadAnim) continue;
            activity.overridePendingTransition(0, 0);
        }
    }

    public static void finishAllActivities(@AnimRes int enterAnim, @AnimRes int exitAnim) {
        LinkedList<Activity> activityList = Utils.getActivityList();
        for (int i = activityList.size() - 1; i >= 0; --i) {
            Activity activity = (Activity)activityList.get(i);
            activity.finish();
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void finishAllActivitiesExceptNewest() {
        ActivityUtils.finishAllActivitiesExceptNewest(false);
    }

    public static void finishAllActivitiesExceptNewest(boolean isLoadAnim) {
        LinkedList<Activity> activities = Utils.getActivityList();
        for (int i = activities.size() - 2; i >= 0; --i) {
            ActivityUtils.finishActivity((Activity)activities.get(i), isLoadAnim);
        }
    }

    public static void finishAllActivitiesExceptNewest(@AnimRes int enterAnim, @AnimRes int exitAnim) {
        LinkedList<Activity> activities = Utils.getActivityList();
        for (int i = activities.size() - 2; i >= 0; --i) {
            ActivityUtils.finishActivity((Activity)activities.get(i), enterAnim, exitAnim);
        }
    }

    public static Drawable getActivityIcon(@NonNull Activity activity) {
        return ActivityUtils.getActivityIcon(activity.getComponentName());
    }

    public static Drawable getActivityIcon(@NonNull Class<? extends Activity> clz) {
        return ActivityUtils.getActivityIcon(new ComponentName((Context)Utils.getApp(), clz));
    }

    public static Drawable getActivityIcon(@NonNull ComponentName activityName) {
        PackageManager pm = Utils.getApp().getPackageManager();
        try {
            return pm.getActivityIcon(activityName);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Drawable getActivityLogo(@NonNull Activity activity) {
        return ActivityUtils.getActivityLogo(activity.getComponentName());
    }

    public static Drawable getActivityLogo(@NonNull Class<? extends Activity> clz) {
        return ActivityUtils.getActivityLogo(new ComponentName((Context)Utils.getApp(), clz));
    }

    public static Drawable getActivityLogo(@NonNull ComponentName activityName) {
        PackageManager pm = Utils.getApp().getPackageManager();
        try {
            return pm.getActivityLogo(activityName);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void startActivity(Context context, Bundle extras, String pkg, String cls, Bundle options) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (extras != null) {
            intent.putExtras(extras);
        }
        intent.setComponent(new ComponentName(pkg, cls));
        ActivityUtils.startActivity(intent, context, options);
    }

    private static boolean startActivity(Intent intent, Context context, Bundle options) {
        if (!ActivityUtils.isIntentAvailable(intent)) {
            Log.e((String)"ActivityUtils", (String)"intent is unavailable");
            return false;
        }
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        if (options != null && Build.VERSION.SDK_INT >= 16) {
            context.startActivity(intent, options);
        } else {
            context.startActivity(intent);
        }
        return true;
    }

    private static boolean isIntentAvailable(Intent intent) {
        return Utils.getApp().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }

    private static boolean startActivityForResult(Activity activity, Bundle extras, String pkg, String cls, int requestCode, Bundle options) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (extras != null) {
            intent.putExtras(extras);
        }
        intent.setComponent(new ComponentName(pkg, cls));
        return ActivityUtils.startActivityForResult(intent, activity, requestCode, options);
    }

    private static boolean startActivityForResult(Intent intent, Activity activity, int requestCode, Bundle options) {
        if (!ActivityUtils.isIntentAvailable(intent)) {
            Log.e((String)"ActivityUtils", (String)"intent is unavailable");
            return false;
        }
        if (options != null && Build.VERSION.SDK_INT >= 16) {
            activity.startActivityForResult(intent, requestCode, options);
        } else {
            activity.startActivityForResult(intent, requestCode);
        }
        return true;
    }

    private static void startActivities(Intent[] intents, Context context, Bundle options) {
        if (!(context instanceof Activity)) {
            for (Intent intent : intents) {
                intent.addFlags(0x10000000);
            }
        }
        if (options != null && Build.VERSION.SDK_INT >= 16) {
            context.startActivities(intents, options);
        } else {
            context.startActivities(intents);
        }
    }

    private static Bundle getOptionsBundle(Context context, int enterAnim, int exitAnim) {
        return ActivityOptionsCompat.makeCustomAnimation((Context)context, (int)enterAnim, (int)exitAnim).toBundle();
    }

    private static Bundle getOptionsBundle(Activity activity, View[] sharedElements) {
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        if (sharedElements == null) {
            return null;
        }
        int len = sharedElements.length;
        if (len <= 0) {
            return null;
        }
        Pair[] pairs = new Pair[len];
        for (int i = 0; i < len; ++i) {
            pairs[i] = Pair.create((Object)sharedElements[i], (Object)sharedElements[i].getTransitionName());
        }
        return ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)activity, (Pair[])pairs).toBundle();
    }
}

