/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.animation.ValueAnimator;
import android.app.Activity;
import android.app.Application;
import android.arch.lifecycle.Lifecycle;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Window;
import android.view.WindowManager;
import com.blankj.utilcode.util.LanguageUtils;
import com.blankj.utilcode.util.Utils;
import com.blankj.utilcode.util.UtilsBridge;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

final class UtilsActivityLifecycleImpl
implements Application.ActivityLifecycleCallbacks {
    static final UtilsActivityLifecycleImpl INSTANCE = new UtilsActivityLifecycleImpl();
    private final LinkedList<Activity> mActivityList = new LinkedList();
    private final List<Utils.OnAppStatusChangedListener> mStatusListeners = new CopyOnWriteArrayList<Utils.OnAppStatusChangedListener>();
    private final Map<Activity, List<Utils.ActivityLifecycleCallbacks>> mActivityLifecycleCallbacksMap = new ConcurrentHashMap<Activity, List<Utils.ActivityLifecycleCallbacks>>();
    private static final Activity STUB = new Activity();
    private int mForegroundCount = 0;
    private int mConfigCount = 0;
    private boolean mIsBackground = false;

    UtilsActivityLifecycleImpl() {
    }

    void init(Application app) {
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    void unInit(Application app) {
        this.mActivityList.clear();
        app.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    Activity getTopActivity() {
        List<Activity> activityList = this.getActivityList();
        for (Activity activity : activityList) {
            if (!UtilsBridge.isActivityAlive(activity)) continue;
            return activity;
        }
        return null;
    }

    List<Activity> getActivityList() {
        if (!this.mActivityList.isEmpty()) {
            return new LinkedList<Activity>(this.mActivityList);
        }
        List<Activity> reflectActivities = this.getActivitiesByReflect();
        this.mActivityList.addAll(reflectActivities);
        return new LinkedList<Activity>(this.mActivityList);
    }

    void addOnAppStatusChangedListener(Utils.OnAppStatusChangedListener listener) {
        this.mStatusListeners.add(listener);
    }

    void removeOnAppStatusChangedListener(Utils.OnAppStatusChangedListener listener) {
        this.mStatusListeners.remove(listener);
    }

    void addActivityLifecycleCallbacks(Utils.ActivityLifecycleCallbacks listener) {
        this.addActivityLifecycleCallbacks(STUB, listener);
    }

    void addActivityLifecycleCallbacks(final Activity activity, final Utils.ActivityLifecycleCallbacks listener) {
        if (activity == null || listener == null) {
            return;
        }
        UtilsBridge.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                UtilsActivityLifecycleImpl.this.addActivityLifecycleCallbacksInner(activity, listener);
            }
        });
    }

    boolean isAppForeground() {
        return !this.mIsBackground;
    }

    private void addActivityLifecycleCallbacksInner(Activity activity, Utils.ActivityLifecycleCallbacks callbacks) {
        List<Utils.ActivityLifecycleCallbacks> callbacksList = this.mActivityLifecycleCallbacksMap.get(activity);
        if (callbacksList == null) {
            callbacksList = new CopyOnWriteArrayList<Utils.ActivityLifecycleCallbacks>();
            this.mActivityLifecycleCallbacksMap.put(activity, callbacksList);
        } else if (callbacksList.contains(callbacks)) {
            return;
        }
        callbacksList.add(callbacks);
    }

    void removeActivityLifecycleCallbacks(Utils.ActivityLifecycleCallbacks callbacks) {
        this.removeActivityLifecycleCallbacks(STUB, callbacks);
    }

    void removeActivityLifecycleCallbacks(final Activity activity) {
        if (activity == null) {
            return;
        }
        UtilsBridge.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                UtilsActivityLifecycleImpl.this.mActivityLifecycleCallbacksMap.remove(activity);
            }
        });
    }

    void removeActivityLifecycleCallbacks(final Activity activity, final Utils.ActivityLifecycleCallbacks callbacks) {
        if (activity == null || callbacks == null) {
            return;
        }
        UtilsBridge.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                UtilsActivityLifecycleImpl.this.removeActivityLifecycleCallbacksInner(activity, callbacks);
            }
        });
    }

    private void removeActivityLifecycleCallbacksInner(Activity activity, Utils.ActivityLifecycleCallbacks callbacks) {
        List<Utils.ActivityLifecycleCallbacks> callbacksList = this.mActivityLifecycleCallbacksMap.get(activity);
        if (callbacksList != null && !callbacksList.isEmpty()) {
            callbacksList.remove(callbacks);
        }
    }

    private void consumeActivityLifecycleCallbacks(Activity activity, Lifecycle.Event event) {
        this.consumeLifecycle(activity, event, this.mActivityLifecycleCallbacksMap.get(activity));
        this.consumeLifecycle(activity, event, this.mActivityLifecycleCallbacksMap.get(STUB));
    }

    private void consumeLifecycle(Activity activity, Lifecycle.Event event, List<Utils.ActivityLifecycleCallbacks> listeners) {
        if (listeners == null) {
            return;
        }
        for (Utils.ActivityLifecycleCallbacks listener : listeners) {
            listener.onLifecycleChanged(activity, event);
            if (event.equals((Object)Lifecycle.Event.ON_CREATE)) {
                listener.onActivityCreated(activity);
                continue;
            }
            if (event.equals((Object)Lifecycle.Event.ON_START)) {
                listener.onActivityStarted(activity);
                continue;
            }
            if (event.equals((Object)Lifecycle.Event.ON_RESUME)) {
                listener.onActivityResumed(activity);
                continue;
            }
            if (event.equals((Object)Lifecycle.Event.ON_PAUSE)) {
                listener.onActivityPaused(activity);
                continue;
            }
            if (event.equals((Object)Lifecycle.Event.ON_STOP)) {
                listener.onActivityStopped(activity);
                continue;
            }
            if (!event.equals((Object)Lifecycle.Event.ON_DESTROY)) continue;
            listener.onActivityDestroyed(activity);
        }
        if (event.equals((Object)Lifecycle.Event.ON_DESTROY)) {
            this.mActivityLifecycleCallbacksMap.remove(activity);
        }
    }

    Application getApplicationByReflect() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Object thread = this.getActivityThread();
            Object app = activityThreadClass.getMethod("getApplication", new Class[0]).invoke(thread, new Object[0]);
            if (app == null) {
                return null;
            }
            return (Application)app;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void onActivityPreCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
    }

    public void onActivityCreated(@NonNull Activity activity, Bundle savedInstanceState) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (this.mActivityList.size() == 0) {
            this.postStatus(activity, true);
        }
        LanguageUtils.applyLanguage(activity);
        UtilsActivityLifecycleImpl.setAnimatorsEnabled();
        this.setTopActivity(activity);
        this.consumeActivityLifecycleCallbacks(activity, Lifecycle.Event.ON_CREATE);
    }

    public void onActivityPostCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
    }

    public void onActivityPreStarted(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
    }

    public void onActivityStarted(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (!this.mIsBackground) {
            this.setTopActivity(activity);
        }
        if (this.mConfigCount < 0) {
            ++this.mConfigCount;
        } else {
            ++this.mForegroundCount;
        }
        this.consumeActivityLifecycleCallbacks(activity, Lifecycle.Event.ON_START);
    }

    public void onActivityPostStarted(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
    }

    public void onActivityPreResumed(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
    }

    public void onActivityResumed(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.setTopActivity(activity);
        if (this.mIsBackground) {
            this.mIsBackground = false;
            this.postStatus(activity, true);
        }
        this.processHideSoftInputOnActivityDestroy(activity, false);
        this.consumeActivityLifecycleCallbacks(activity, Lifecycle.Event.ON_RESUME);
    }

    public void onActivityPostResumed(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
    }

    public void onActivityPrePaused(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
    }

    public void onActivityPaused(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.consumeActivityLifecycleCallbacks(activity, Lifecycle.Event.ON_PAUSE);
    }

    public void onActivityPostPaused(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
    }

    public void onActivityPreStopped(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
    }

    public void onActivityStopped(Activity activity) {
        if (activity.isChangingConfigurations()) {
            --this.mConfigCount;
        } else {
            --this.mForegroundCount;
            if (this.mForegroundCount <= 0) {
                this.mIsBackground = true;
                this.postStatus(activity, false);
            }
        }
        this.processHideSoftInputOnActivityDestroy(activity, true);
        this.consumeActivityLifecycleCallbacks(activity, Lifecycle.Event.ON_STOP);
    }

    public void onActivityPostStopped(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
    }

    public void onActivityPreSaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (outState == null) {
            throw new NullPointerException("Argument 'outState' of type Bundle (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (outState == null) {
            throw new NullPointerException("Argument 'outState' of type Bundle (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
    }

    public void onActivityPostSaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (outState == null) {
            throw new NullPointerException("Argument 'outState' of type Bundle (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
    }

    public void onActivityPreDestroyed(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.mActivityList.remove(activity);
        UtilsBridge.fixSoftInputLeaks(activity);
        this.consumeActivityLifecycleCallbacks(activity, Lifecycle.Event.ON_DESTROY);
    }

    public void onActivityPostDestroyed(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
    }

    private void processHideSoftInputOnActivityDestroy(final Activity activity, boolean isSave) {
        try {
            if (isSave) {
                Window window = activity.getWindow();
                WindowManager.LayoutParams attrs = window.getAttributes();
                int softInputMode = attrs.softInputMode;
                window.getDecorView().setTag(-123, (Object)softInputMode);
                window.setSoftInputMode(3);
            } else {
                final Object tag = activity.getWindow().getDecorView().getTag(-123);
                if (!(tag instanceof Integer)) {
                    return;
                }
                UtilsBridge.runOnUiThreadDelayed(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Window window = activity.getWindow();
                            if (window != null) {
                                window.setSoftInputMode(((Integer)tag).intValue());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, 100L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void postStatus(Activity activity, boolean isForeground) {
        if (this.mStatusListeners.isEmpty()) {
            return;
        }
        for (Utils.OnAppStatusChangedListener statusListener : this.mStatusListeners) {
            if (isForeground) {
                statusListener.onForeground(activity);
                continue;
            }
            statusListener.onBackground(activity);
        }
    }

    private void setTopActivity(Activity activity) {
        if (this.mActivityList.contains(activity)) {
            if (!this.mActivityList.getFirst().equals(activity)) {
                this.mActivityList.remove(activity);
                this.mActivityList.addFirst(activity);
            }
        } else {
            this.mActivityList.addFirst(activity);
        }
    }

    private List<Activity> getActivitiesByReflect() {
        LinkedList<Activity> list = new LinkedList<Activity>();
        Activity topActivity = null;
        try {
            Object activityThread = this.getActivityThread();
            Field mActivitiesField = activityThread.getClass().getDeclaredField("mActivities");
            mActivitiesField.setAccessible(true);
            Object mActivities = mActivitiesField.get(activityThread);
            if (!(mActivities instanceof Map)) {
                return list;
            }
            Map binder_activityClientRecord_map = (Map)mActivities;
            for (Object activityRecord : binder_activityClientRecord_map.values()) {
                Class<?> activityClientRecordClass = activityRecord.getClass();
                Field activityField = activityClientRecordClass.getDeclaredField("activity");
                activityField.setAccessible(true);
                Activity activity = (Activity)activityField.get(activityRecord);
                if (topActivity == null) {
                    Field pausedField = activityClientRecordClass.getDeclaredField("paused");
                    pausedField.setAccessible(true);
                    if (!pausedField.getBoolean(activityRecord)) {
                        topActivity = activity;
                        continue;
                    }
                    list.add(activity);
                    continue;
                }
                list.add(activity);
            }
        }
        catch (Exception e) {
            Log.e((String)"UtilsActivityLifecycle", (String)("getActivitiesByReflect: " + e.getMessage()));
        }
        if (topActivity != null) {
            list.addFirst(topActivity);
        }
        return list;
    }

    private Object getActivityThread() {
        Object activityThread = this.getActivityThreadInActivityThreadStaticField();
        if (activityThread != null) {
            return activityThread;
        }
        return this.getActivityThreadInActivityThreadStaticMethod();
    }

    private Object getActivityThreadInActivityThreadStaticField() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Field sCurrentActivityThreadField = activityThreadClass.getDeclaredField("sCurrentActivityThread");
            sCurrentActivityThreadField.setAccessible(true);
            return sCurrentActivityThreadField.get(null);
        }
        catch (Exception e) {
            Log.e((String)"UtilsActivityLifecycle", (String)("getActivityThreadInActivityThreadStaticField: " + e.getMessage()));
            return null;
        }
    }

    private Object getActivityThreadInActivityThreadStaticMethod() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            return activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            Log.e((String)"UtilsActivityLifecycle", (String)("getActivityThreadInActivityThreadStaticMethod: " + e.getMessage()));
            return null;
        }
    }

    private static void setAnimatorsEnabled() {
        if (Build.VERSION.SDK_INT >= 26 && ValueAnimator.areAnimatorsEnabled()) {
            return;
        }
        try {
            Field sDurationScaleField = ValueAnimator.class.getDeclaredField("sDurationScale");
            sDurationScaleField.setAccessible(true);
            float sDurationScale = ((Float)sDurationScaleField.get(null)).floatValue();
            if (sDurationScale == 0.0f) {
                sDurationScaleField.set(null, Float.valueOf(1.0f));
                Log.i((String)"UtilsActivityLifecycle", (String)"setAnimatorsEnabled: Animators are enabled now!");
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

