/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.format.Formatter;
import com.blankj.utilcode.util.ShellUtils;
import com.blankj.utilcode.util.Utils;
import com.blankj.utilcode.util.UtilsBridge;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;

public final class NetworkUtils {
    private static final long SCAN_PERIOD_MILLIS = 3000L;
    private static final Set<Utils.Consumer<WifiScanResults>> SCAN_RESULT_CONSUMERS = new CopyOnWriteArraySet<Utils.Consumer<WifiScanResults>>();
    private static Timer sScanWifiTimer;
    private static WifiScanResults sPreWifiScanResults;

    private NetworkUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void openWirelessSettings() {
        Utils.getApp().startActivity(new Intent("android.settings.WIRELESS_SETTINGS").setFlags(0x10000000));
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isConnected() {
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Utils.Task<Boolean> isAvailableAsync(@NonNull Utils.Consumer<Boolean> consumer) {
        if (consumer == null) {
            throw new NullPointerException("Argument 'consumer' of type Utils.Consumer<Boolean> (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return UtilsBridge.doAsync(new Utils.Task<Boolean>(consumer){

            @Override
            @RequiresPermission(value="android.permission.INTERNET")
            public Boolean doInBackground() {
                return NetworkUtils.isAvailable();
            }
        });
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static boolean isAvailable() {
        return NetworkUtils.isAvailableByDns() || NetworkUtils.isAvailableByPing(null);
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static void isAvailableByPingAsync(Utils.Consumer<Boolean> consumer) {
        NetworkUtils.isAvailableByPingAsync("", consumer);
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Utils.Task<Boolean> isAvailableByPingAsync(final String ip, @NonNull Utils.Consumer<Boolean> consumer) {
        if (consumer == null) {
            throw new NullPointerException("Argument 'consumer' of type Utils.Consumer<Boolean> (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return UtilsBridge.doAsync(new Utils.Task<Boolean>(consumer){

            @Override
            @RequiresPermission(value="android.permission.INTERNET")
            public Boolean doInBackground() {
                return NetworkUtils.isAvailableByPing(ip);
            }
        });
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static boolean isAvailableByPing() {
        return NetworkUtils.isAvailableByPing("");
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static boolean isAvailableByPing(String ip) {
        String realIp = TextUtils.isEmpty((CharSequence)ip) ? "223.5.5.5" : ip;
        ShellUtils.CommandResult result = ShellUtils.execCmd(String.format("ping -c 1 %s", realIp), false);
        return result.result == 0;
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static void isAvailableByDnsAsync(Utils.Consumer<Boolean> consumer) {
        NetworkUtils.isAvailableByDnsAsync("", consumer);
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Utils.Task isAvailableByDnsAsync(final String domain, @NonNull Utils.Consumer<Boolean> consumer) {
        if (consumer == null) {
            throw new NullPointerException("Argument 'consumer' of type Utils.Consumer<Boolean> (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return UtilsBridge.doAsync(new Utils.Task<Boolean>(consumer){

            @Override
            @RequiresPermission(value="android.permission.INTERNET")
            public Boolean doInBackground() {
                return NetworkUtils.isAvailableByDns(domain);
            }
        });
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static boolean isAvailableByDns() {
        return NetworkUtils.isAvailableByDns("");
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static boolean isAvailableByDns(String domain) {
        String realDomain = TextUtils.isEmpty((CharSequence)domain) ? "www.baidu.com" : domain;
        try {
            InetAddress inetAddress = InetAddress.getByName(realDomain);
            return inetAddress != null;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean getMobileDataEnabled() {
        try {
            TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
            if (tm == null) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 26) {
                return tm.isDataEnabled();
            }
            Method getMobileDataEnabledMethod = tm.getClass().getDeclaredMethod("getDataEnabled", new Class[0]);
            if (null != getMobileDataEnabledMethod) {
                return (Boolean)getMobileDataEnabledMethod.invoke((Object)tm, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isMobileData() {
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo();
        return null != info && info.isAvailable() && info.getType() == 0;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean is4G() {
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo();
        return info != null && info.isAvailable() && info.getSubtype() == 13;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean is5G() {
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo();
        return info != null && info.isAvailable() && info.getSubtype() == 20;
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static boolean getWifiEnabled() {
        WifiManager manager = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (manager == null) {
            return false;
        }
        return manager.isWifiEnabled();
    }

    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public static void setWifiEnabled(boolean enabled) {
        WifiManager manager = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (manager == null) {
            return;
        }
        if (enabled == manager.isWifiEnabled()) {
            return;
        }
        manager.setWifiEnabled(enabled);
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isWifiConnected() {
        ConnectivityManager cm = (ConnectivityManager)Utils.getApp().getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo ni = cm.getActiveNetworkInfo();
        return ni != null && ni.getType() == 1;
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.INTERNET"})
    public static boolean isWifiAvailable() {
        return NetworkUtils.getWifiEnabled() && NetworkUtils.isAvailable();
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.INTERNET"})
    public static Utils.Task<Boolean> isWifiAvailableAsync(@NonNull Utils.Consumer<Boolean> consumer) {
        if (consumer == null) {
            throw new NullPointerException("Argument 'consumer' of type Utils.Consumer<Boolean> (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return UtilsBridge.doAsync(new Utils.Task<Boolean>(consumer){

            @Override
            @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.INTERNET"})
            public Boolean doInBackground() {
                return NetworkUtils.isWifiAvailable();
            }
        });
    }

    public static String getNetworkOperatorName() {
        TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
        if (tm == null) {
            return "";
        }
        return tm.getNetworkOperatorName();
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static NetworkType getNetworkType() {
        if (NetworkUtils.isEthernet()) {
            return NetworkType.NETWORK_ETHERNET;
        }
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo();
        if (info != null && info.isAvailable()) {
            if (info.getType() == 1) {
                return NetworkType.NETWORK_WIFI;
            }
            if (info.getType() == 0) {
                switch (info.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        return NetworkType.NETWORK_2G;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        return NetworkType.NETWORK_3G;
                    }
                    case 13: 
                    case 18: {
                        return NetworkType.NETWORK_4G;
                    }
                    case 20: {
                        return NetworkType.NETWORK_5G;
                    }
                }
                String subtypeName = info.getSubtypeName();
                if (subtypeName.equalsIgnoreCase("TD-SCDMA") || subtypeName.equalsIgnoreCase("WCDMA") || subtypeName.equalsIgnoreCase("CDMA2000")) {
                    return NetworkType.NETWORK_3G;
                }
                return NetworkType.NETWORK_UNKNOWN;
            }
            return NetworkType.NETWORK_UNKNOWN;
        }
        return NetworkType.NETWORK_NO;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private static boolean isEthernet() {
        ConnectivityManager cm = (ConnectivityManager)Utils.getApp().getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo info = cm.getNetworkInfo(9);
        if (info == null) {
            return false;
        }
        NetworkInfo.State state = info.getState();
        if (null == state) {
            return false;
        }
        return state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private static NetworkInfo getActiveNetworkInfo() {
        ConnectivityManager cm = (ConnectivityManager)Utils.getApp().getSystemService("connectivity");
        if (cm == null) {
            return null;
        }
        return cm.getActiveNetworkInfo();
    }

    public static Utils.Task<String> getIPAddressAsync(final boolean useIPv4, @NonNull Utils.Consumer<String> consumer) {
        if (consumer == null) {
            throw new NullPointerException("Argument 'consumer' of type Utils.Consumer<String> (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return UtilsBridge.doAsync(new Utils.Task<String>(consumer){

            @Override
            @RequiresPermission(value="android.permission.INTERNET")
            public String doInBackground() {
                return NetworkUtils.getIPAddress(useIPv4);
            }
        });
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static String getIPAddress(boolean useIPv4) {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            LinkedList<InetAddress> adds = new LinkedList<InetAddress>();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    adds.addFirst(addresses.nextElement());
                }
            }
            for (InetAddress add : adds) {
                boolean isIPv4;
                if (add.isLoopbackAddress()) continue;
                String hostAddress = add.getHostAddress();
                boolean bl = isIPv4 = hostAddress.indexOf(58) < 0;
                if (useIPv4) {
                    if (!isIPv4) continue;
                    return hostAddress;
                }
                if (isIPv4) continue;
                int index = hostAddress.indexOf(37);
                return index < 0 ? hostAddress.toUpperCase() : hostAddress.substring(0, index).toUpperCase();
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getBroadcastIpAddress() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            LinkedList adds = new LinkedList();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                List<InterfaceAddress> ias = ni.getInterfaceAddresses();
                int size = ias.size();
                for (int i = 0; i < size; ++i) {
                    InterfaceAddress ia = ias.get(i);
                    InetAddress broadcast = ia.getBroadcast();
                    if (broadcast == null) continue;
                    return broadcast.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return "";
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Utils.Task<String> getDomainAddressAsync(final String domain, @NonNull Utils.Consumer<String> consumer) {
        if (consumer == null) {
            throw new NullPointerException("Argument 'consumer' of type Utils.Consumer<String> (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return UtilsBridge.doAsync(new Utils.Task<String>(consumer){

            @Override
            @RequiresPermission(value="android.permission.INTERNET")
            public String doInBackground() {
                return NetworkUtils.getDomainAddress(domain);
            }
        });
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static String getDomainAddress(String domain) {
        try {
            InetAddress inetAddress = InetAddress.getByName(domain);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "";
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getIpAddressByWifi() {
        WifiManager wm = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        return Formatter.formatIpAddress((int)wm.getDhcpInfo().ipAddress);
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getGatewayByWifi() {
        WifiManager wm = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        return Formatter.formatIpAddress((int)wm.getDhcpInfo().gateway);
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getNetMaskByWifi() {
        WifiManager wm = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        return Formatter.formatIpAddress((int)wm.getDhcpInfo().netmask);
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getServerAddressByWifi() {
        WifiManager wm = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        return Formatter.formatIpAddress((int)wm.getDhcpInfo().serverAddress);
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getSSID() {
        WifiManager wm = (WifiManager)Utils.getApp().getApplicationContext().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        WifiInfo wi = wm.getConnectionInfo();
        if (wi == null) {
            return "";
        }
        String ssid = wi.getSSID();
        if (TextUtils.isEmpty((CharSequence)ssid)) {
            return "";
        }
        if (ssid.length() > 2 && ssid.charAt(0) == '\"' && ssid.charAt(ssid.length() - 1) == '\"') {
            return ssid.substring(1, ssid.length() - 1);
        }
        return ssid;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static void registerNetworkStatusChangedListener(OnNetworkStatusChangedListener listener) {
        NetworkChangedReceiver.getInstance().registerListener(listener);
    }

    public static boolean isRegisteredNetworkStatusChangedListener(OnNetworkStatusChangedListener listener) {
        return NetworkChangedReceiver.getInstance().isRegistered(listener);
    }

    public static void unregisterNetworkStatusChangedListener(OnNetworkStatusChangedListener listener) {
        NetworkChangedReceiver.getInstance().unregisterListener(listener);
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.ACCESS_COARSE_LOCATION"})
    public static WifiScanResults getWifiScanResult() {
        WifiScanResults result = new WifiScanResults();
        if (!NetworkUtils.getWifiEnabled()) {
            return result;
        }
        WifiManager wm = (WifiManager)Utils.getApp().getSystemService("wifi");
        List results = wm.getScanResults();
        if (results != null) {
            result.setAllResults(results);
        }
        return result;
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE", "android.permission.ACCESS_COARSE_LOCATION"})
    public static void addOnWifiChangedConsumer(final Utils.Consumer<WifiScanResults> consumer) {
        if (consumer == null) {
            return;
        }
        UtilsBridge.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (SCAN_RESULT_CONSUMERS.isEmpty()) {
                    SCAN_RESULT_CONSUMERS.add(consumer);
                    NetworkUtils.startScanWifi();
                    return;
                }
                consumer.accept(sPreWifiScanResults);
                SCAN_RESULT_CONSUMERS.add(consumer);
            }
        });
    }

    private static void startScanWifi() {
        sPreWifiScanResults = new WifiScanResults();
        sScanWifiTimer = new Timer();
        sScanWifiTimer.schedule(new TimerTask(){

            @Override
            @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE", "android.permission.ACCESS_COARSE_LOCATION"})
            public void run() {
                NetworkUtils.startScanWifiIfEnabled();
                WifiScanResults scanResults = NetworkUtils.getWifiScanResult();
                if (NetworkUtils.isSameScanResults(sPreWifiScanResults.allResults, scanResults.allResults)) {
                    return;
                }
                sPreWifiScanResults = scanResults;
                UtilsBridge.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        for (Utils.Consumer consumer : SCAN_RESULT_CONSUMERS) {
                            consumer.accept(sPreWifiScanResults);
                        }
                    }
                });
            }
        }, 0L, 3000L);
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE"})
    private static void startScanWifiIfEnabled() {
        if (!NetworkUtils.getWifiEnabled()) {
            return;
        }
        WifiManager wm = (WifiManager)Utils.getApp().getSystemService("wifi");
        wm.startScan();
    }

    public static void removeOnWifiChangedConsumer(final Utils.Consumer<WifiScanResults> consumer) {
        if (consumer == null) {
            return;
        }
        UtilsBridge.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SCAN_RESULT_CONSUMERS.remove(consumer);
                if (SCAN_RESULT_CONSUMERS.isEmpty()) {
                    NetworkUtils.stopScanWifi();
                }
            }
        });
    }

    private static void stopScanWifi() {
        if (sScanWifiTimer != null) {
            sScanWifiTimer.cancel();
            sScanWifiTimer = null;
        }
    }

    private static boolean isSameScanResults(List<ScanResult> l1, List<ScanResult> l2) {
        if (l1 == null && l2 == null) {
            return true;
        }
        if (l1 == null || l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            ScanResult r2;
            ScanResult r1 = l1.get(i);
            if (NetworkUtils.isSameScanResultContent(r1, r2 = l2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameScanResultContent(ScanResult r1, ScanResult r2) {
        return r1 != null && r2 != null && UtilsBridge.equals(r1.BSSID, r2.BSSID) && UtilsBridge.equals(r1.SSID, r2.SSID) && UtilsBridge.equals(r1.capabilities, r2.capabilities) && r1.level == r2.level;
    }

    public static final class WifiScanResults {
        private List<ScanResult> allResults = new ArrayList<ScanResult>();
        private List<ScanResult> filterResults = new ArrayList<ScanResult>();

        public List<ScanResult> getAllResults() {
            return this.allResults;
        }

        public List<ScanResult> getFilterResults() {
            return this.filterResults;
        }

        public void setAllResults(List<ScanResult> allResults) {
            this.allResults = allResults;
            this.filterResults = WifiScanResults.filterScanResult(allResults);
        }

        private static List<ScanResult> filterScanResult(List<ScanResult> results) {
            if (results == null || results.isEmpty()) {
                return new ArrayList<ScanResult>();
            }
            LinkedHashMap<String, ScanResult> map = new LinkedHashMap<String, ScanResult>(results.size());
            for (ScanResult result : results) {
                ScanResult resultInMap;
                if (TextUtils.isEmpty((CharSequence)result.SSID) || (resultInMap = (ScanResult)map.get(result.SSID)) != null && resultInMap.level >= result.level) continue;
                map.put(result.SSID, result);
            }
            return new ArrayList<ScanResult>(map.values());
        }
    }

    public static interface OnNetworkStatusChangedListener {
        public void onDisconnected();

        public void onConnected(NetworkType var1);
    }

    public static final class NetworkChangedReceiver
    extends BroadcastReceiver {
        private NetworkType mType;
        private Set<OnNetworkStatusChangedListener> mListeners = new HashSet<OnNetworkStatusChangedListener>();

        private static NetworkChangedReceiver getInstance() {
            return LazyHolder.INSTANCE;
        }

        @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
        void registerListener(final OnNetworkStatusChangedListener listener) {
            if (listener == null) {
                return;
            }
            UtilsBridge.runOnUiThread(new Runnable(){

                @Override
                @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
                public void run() {
                    int preSize = NetworkChangedReceiver.this.mListeners.size();
                    NetworkChangedReceiver.this.mListeners.add(listener);
                    if (preSize == 0 && NetworkChangedReceiver.this.mListeners.size() == 1) {
                        NetworkChangedReceiver.this.mType = NetworkUtils.getNetworkType();
                        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
                        Utils.getApp().registerReceiver((BroadcastReceiver)NetworkChangedReceiver.getInstance(), intentFilter);
                    }
                }
            });
        }

        boolean isRegistered(OnNetworkStatusChangedListener listener) {
            if (listener == null) {
                return false;
            }
            return this.mListeners.contains(listener);
        }

        void unregisterListener(final OnNetworkStatusChangedListener listener) {
            if (listener == null) {
                return;
            }
            UtilsBridge.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    int preSize = NetworkChangedReceiver.this.mListeners.size();
                    NetworkChangedReceiver.this.mListeners.remove(listener);
                    if (preSize == 1 && NetworkChangedReceiver.this.mListeners.size() == 0) {
                        Utils.getApp().unregisterReceiver((BroadcastReceiver)NetworkChangedReceiver.getInstance());
                    }
                }
            });
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
                UtilsBridge.runOnUiThreadDelayed(new Runnable(){

                    @Override
                    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
                    public void run() {
                        NetworkType networkType = NetworkUtils.getNetworkType();
                        if (NetworkChangedReceiver.this.mType == networkType) {
                            return;
                        }
                        NetworkChangedReceiver.this.mType = networkType;
                        if (networkType == NetworkType.NETWORK_NO) {
                            for (OnNetworkStatusChangedListener listener : NetworkChangedReceiver.this.mListeners) {
                                listener.onDisconnected();
                            }
                        } else {
                            for (OnNetworkStatusChangedListener listener : NetworkChangedReceiver.this.mListeners) {
                                listener.onConnected(networkType);
                            }
                        }
                    }
                }, 1000L);
            }
        }

        private static class LazyHolder {
            private static final NetworkChangedReceiver INSTANCE = new NetworkChangedReceiver();

            private LazyHolder() {
            }
        }
    }

    public static enum NetworkType {
        NETWORK_ETHERNET,
        NETWORK_WIFI,
        NETWORK_5G,
        NETWORK_4G,
        NETWORK_3G,
        NETWORK_2G,
        NETWORK_UNKNOWN,
        NETWORK_NO;

    }
}

