/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import com.blankj.utilcode.util.Utils;

public final class ColorUtils {
    private ColorUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static int getColor(@ColorRes int id2) {
        return ContextCompat.getColor((Context)Utils.getApp(), (int)id2);
    }

    public static int setAlphaComponent(@ColorInt int color, @IntRange(from=0L, to=255L) int alpha) {
        return color & 0xFFFFFF | alpha << 24;
    }

    public static int setAlphaComponent(@ColorInt int color, @FloatRange(from=0.0, to=1.0) float alpha) {
        return color & 0xFFFFFF | (int)(alpha * 255.0f + 0.5f) << 24;
    }

    public static int setRedComponent(@ColorInt int color, @IntRange(from=0L, to=255L) int red) {
        return color & 0xFF00FFFF | red << 16;
    }

    public static int setRedComponent(@ColorInt int color, @FloatRange(from=0.0, to=1.0) float red) {
        return color & 0xFF00FFFF | (int)(red * 255.0f + 0.5f) << 16;
    }

    public static int setGreenComponent(@ColorInt int color, @IntRange(from=0L, to=255L) int green) {
        return color & 0xFFFF00FF | green << 8;
    }

    public static int setGreenComponent(@ColorInt int color, @FloatRange(from=0.0, to=1.0) float green) {
        return color & 0xFFFF00FF | (int)(green * 255.0f + 0.5f) << 8;
    }

    public static int setBlueComponent(@ColorInt int color, @IntRange(from=0L, to=255L) int blue) {
        return color & 0xFFFFFF00 | blue;
    }

    public static int setBlueComponent(@ColorInt int color, @FloatRange(from=0.0, to=1.0) float blue) {
        return color & 0xFFFFFF00 | (int)(blue * 255.0f + 0.5f);
    }

    public static int string2Int(@NonNull String colorString) {
        if (colorString == null) {
            throw new NullPointerException("Argument 'colorString' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return Color.parseColor((String)colorString);
    }

    public static String int2RgbString(@ColorInt int colorInt) {
        String color = Integer.toHexString(colorInt &= 0xFFFFFF);
        while (color.length() < 6) {
            color = "0" + color;
        }
        return "#" + color;
    }

    public static String int2ArgbString(@ColorInt int colorInt) {
        String color = Integer.toHexString(colorInt);
        while (color.length() < 6) {
            color = "0" + color;
        }
        while (color.length() < 8) {
            color = "f" + color;
        }
        return "#" + color;
    }

    public static int getRandomColor() {
        return ColorUtils.getRandomColor(true);
    }

    public static int getRandomColor(boolean supportAlpha) {
        int high = supportAlpha ? (int)(Math.random() * 256.0) << 24 : -16777216;
        return high | (int)(Math.random() * 1.6777216E7);
    }
}

