/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.Activity;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.support.annotation.NonNull;
import com.blankj.utilcode.util.Utils;

public final class MetaDataUtils {
    private MetaDataUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String getMetaDataInApp(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        String value = "";
        PackageManager pm = Utils.getApp().getPackageManager();
        String packageName = Utils.getApp().getPackageName();
        try {
            ApplicationInfo ai = pm.getApplicationInfo(packageName, 128);
            value = String.valueOf(ai.metaData.get(key));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getMetaDataInActivity(@NonNull Activity activity, @NonNull String key) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return MetaDataUtils.getMetaDataInActivity(activity.getClass(), key);
    }

    public static String getMetaDataInActivity(@NonNull Class<? extends Activity> clz, @NonNull String key) {
        if (clz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        String value = "";
        PackageManager pm = Utils.getApp().getPackageManager();
        ComponentName componentName = new ComponentName((Context)Utils.getApp(), clz);
        try {
            ActivityInfo ai = pm.getActivityInfo(componentName, 128);
            value = String.valueOf(ai.metaData.get(key));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getMetaDataInService(@NonNull Service service, @NonNull String key) {
        if (service == null) {
            throw new NullPointerException("Argument 'service' of type Service (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return MetaDataUtils.getMetaDataInService(service.getClass(), key);
    }

    public static String getMetaDataInService(@NonNull Class<? extends Service> clz, @NonNull String key) {
        if (clz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Service> (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        String value = "";
        PackageManager pm = Utils.getApp().getPackageManager();
        ComponentName componentName = new ComponentName((Context)Utils.getApp(), clz);
        try {
            ServiceInfo info = pm.getServiceInfo(componentName, 128);
            value = String.valueOf(info.metaData.get(key));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getMetaDataInReceiver(@NonNull BroadcastReceiver receiver, @NonNull String key) {
        if (receiver == null) {
            throw new NullPointerException("Argument 'receiver' of type BroadcastReceiver (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return MetaDataUtils.getMetaDataInReceiver(receiver, key);
    }

    public static String getMetaDataInReceiver(@NonNull Class<? extends BroadcastReceiver> clz, @NonNull String key) {
        if (clz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends BroadcastReceiver> (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        String value = "";
        PackageManager pm = Utils.getApp().getPackageManager();
        ComponentName componentName = new ComponentName((Context)Utils.getApp(), clz);
        try {
            ActivityInfo info = pm.getReceiverInfo(componentName, 128);
            value = String.valueOf(info.metaData.get(key));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return value;
    }
}

