/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.view.View;
import android.view.ViewGroup;
import com.blankj.utilcode.util.Utils;

public class ViewUtils {
    public static void setViewEnabled(View view, boolean enabled) {
        ViewUtils.setViewEnabled(view, enabled, new View[]{null});
    }

    public static void setViewEnabled(View view, boolean enabled, View ... excludes) {
        if (view == null) {
            return;
        }
        if (excludes != null) {
            for (View exclude : excludes) {
                if (view != exclude) continue;
                return;
            }
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int childCount = viewGroup.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                ViewUtils.setViewEnabled(viewGroup.getChildAt(i), enabled, excludes);
            }
        }
        view.setEnabled(enabled);
    }

    public static void runOnUiThread(Runnable runnable) {
        Utils.runOnUiThread(runnable);
    }

    public static void runOnUiThreadDelayed(Runnable runnable, long delayMillis) {
        Utils.runOnUiThreadDelayed(runnable, delayMillis);
    }

    public static void fixScrollViewTopping(View view) {
        view.setFocusable(false);
        ViewGroup viewGroup = null;
        if (view instanceof ViewGroup) {
            viewGroup = (ViewGroup)view;
        }
        if (viewGroup == null) {
            return;
        }
        int n = viewGroup.getChildCount();
        for (int i = 0; i < n; ++i) {
            View childAt = viewGroup.getChildAt(i);
            childAt.setFocusable(false);
            if (!(childAt instanceof ViewGroup)) continue;
            ViewUtils.fixScrollViewTopping(childAt);
        }
    }
}

