/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.util.Log;
import com.blankj.utilcode.util.Utils;
import java.io.File;

public final class UriUtils {
    private UriUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Uri file2Uri(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("Argument 'file' of type File (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT >= 24) {
            String authority = Utils.getApp().getPackageName() + ".utilcode.provider";
            return FileProvider.getUriForFile((Context)Utils.getApp(), (String)authority, (File)file);
        }
        return Uri.fromFile((File)file);
    }

    public static File uri2File(@NonNull Uri uri) {
        File file;
        if (uri == null) {
            throw new NullPointerException("Argument 'uri' of type Uri (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Log.d((String)"UriUtils", (String)uri.toString());
        String authority = uri.getAuthority();
        String scheme = uri.getScheme();
        String path = uri.getPath();
        if (Build.VERSION.SDK_INT >= 24 && path != null && path.startsWith("/external/") && (file = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + path.replace("/external", ""))).exists()) {
            Log.d((String)"UriUtils", (String)(uri.toString() + " -> /external"));
            return file;
        }
        if ("file".equals(scheme)) {
            if (path != null) {
                return new File(path);
            }
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 0"));
            return null;
        }
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)Utils.getApp(), (Uri)uri)) {
            String docId;
            if ("com.android.externalstorage.documents".equals(authority)) {
                docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return new File(Environment.getExternalStorageDirectory() + "/" + split[1]);
                }
                Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 1_0"));
                return null;
            }
            if ("com.android.providers.downloads.documents".equals(authority)) {
                block20: {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    if (!TextUtils.isEmpty((CharSequence)id2)) {
                        try {
                            Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
                            return UriUtils.getFileFromUri(contentUri, "1_1");
                        }
                        catch (NumberFormatException e) {
                            if (!id2.startsWith("raw:")) break block20;
                            return new File(id2.substring(4));
                        }
                    }
                }
                Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 1_1"));
                return null;
            }
            if ("com.android.providers.media.documents".equals(authority)) {
                Uri contentUri;
                docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("image".equals(type)) {
                    contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(type)) {
                    contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(type)) {
                    contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                } else {
                    Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 1_2"));
                    return null;
                }
                String selection = "_id=?";
                String[] selectionArgs = new String[]{split[1]};
                return UriUtils.getFileFromUri(contentUri, "_id=?", selectionArgs, "1_2");
            }
            if ("content".equals(scheme)) {
                return UriUtils.getFileFromUri(uri, "1_3");
            }
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 1_4"));
            return null;
        }
        if ("content".equals(scheme)) {
            return UriUtils.getFileFromUri(uri, "2");
        }
        Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 3"));
        return null;
    }

    private static File getFileFromUri(Uri uri, String code) {
        return UriUtils.getFileFromUri(uri, null, null, code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getFileFromUri(Uri uri, String selection, String[] selectionArgs, String code) {
        Cursor cursor = Utils.getApp().getContentResolver().query(uri, new String[]{"_data"}, selection, selectionArgs, null);
        if (cursor == null) {
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed(cursor is null). -> " + code));
            return null;
        }
        try {
            if (cursor.moveToFirst()) {
                int columnIndex = cursor.getColumnIndex("_data");
                if (columnIndex > -1) {
                    File file = new File(cursor.getString(columnIndex));
                    return file;
                }
                Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed(columnIndex: " + columnIndex + " is wrong). -> " + code));
                File file = null;
                return file;
            }
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed(moveToFirst return false). -> " + code));
            File columnIndex = null;
            return columnIndex;
        }
        catch (Exception e) {
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> " + code));
            File file = null;
            return file;
        }
        finally {
            cursor.close();
        }
    }
}

