/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.util.Log;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadUtils {
    private static final Map<Integer, Map<Integer, ExecutorService>> TYPE_PRIORITY_POOLS = new HashMap<Integer, Map<Integer, ExecutorService>>();
    private static final Map<Task, TaskInfo> TASK_TASKINFO_MAP = new ConcurrentHashMap<Task, TaskInfo>();
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final Timer TIMER = new Timer();
    private static final byte TYPE_SINGLE = -1;
    private static final byte TYPE_CACHED = -2;
    private static final byte TYPE_IO = -4;
    private static final byte TYPE_CPU = -8;
    private static Executor sDeliver;

    public static boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static ExecutorService getFixedPool(@IntRange(from=1L) int size) {
        return ThreadUtils.getPoolByTypeAndPriority(size);
    }

    public static ExecutorService getFixedPool(@IntRange(from=1L) int size, @IntRange(from=1L, to=10L) int priority) {
        return ThreadUtils.getPoolByTypeAndPriority(size, priority);
    }

    public static ExecutorService getSinglePool() {
        return ThreadUtils.getPoolByTypeAndPriority(-1);
    }

    public static ExecutorService getSinglePool(@IntRange(from=1L, to=10L) int priority) {
        return ThreadUtils.getPoolByTypeAndPriority(-1, priority);
    }

    public static ExecutorService getCachedPool() {
        return ThreadUtils.getPoolByTypeAndPriority(-2);
    }

    public static ExecutorService getCachedPool(@IntRange(from=1L, to=10L) int priority) {
        return ThreadUtils.getPoolByTypeAndPriority(-2, priority);
    }

    public static ExecutorService getIoPool() {
        return ThreadUtils.getPoolByTypeAndPriority(-4);
    }

    public static ExecutorService getIoPool(@IntRange(from=1L, to=10L) int priority) {
        return ThreadUtils.getPoolByTypeAndPriority(-4, priority);
    }

    public static ExecutorService getCpuPool() {
        return ThreadUtils.getPoolByTypeAndPriority(-8);
    }

    public static ExecutorService getCpuPool(@IntRange(from=1L, to=10L) int priority) {
        return ThreadUtils.getPoolByTypeAndPriority(-8, priority);
    }

    public static <T> void executeByFixed(@IntRange(from=1L) int size, Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(size), task);
    }

    public static <T> void executeByFixed(@IntRange(from=1L) int size, Task<T> task, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(size, priority), task);
    }

    public static <T> void executeByFixedWithDelay(@IntRange(from=1L) int size, Task<T> task, long delay, TimeUnit unit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(size), task, delay, unit);
    }

    public static <T> void executeByFixedWithDelay(@IntRange(from=1L) int size, Task<T> task, long delay, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(size, priority), task, delay, unit);
    }

    public static <T> void executeByFixedAtFixRate(@IntRange(from=1L) int size, Task<T> task, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(size), task, 0L, period, unit);
    }

    public static <T> void executeByFixedAtFixRate(@IntRange(from=1L) int size, Task<T> task, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(size, priority), task, 0L, period, unit);
    }

    public static <T> void executeByFixedAtFixRate(@IntRange(from=1L) int size, Task<T> task, long initialDelay, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(size), task, initialDelay, period, unit);
    }

    public static <T> void executeByFixedAtFixRate(@IntRange(from=1L) int size, Task<T> task, long initialDelay, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(size, priority), task, initialDelay, period, unit);
    }

    public static <T> void executeBySingle(Task<T> task) {
        ThreadUtils.getPoolByTypeAndPriority(-1).execute(task);
    }

    public static <T> void executeBySingle(Task<T> task, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-1, priority), task);
    }

    public static <T> void executeBySingleWithDelay(Task<T> task, long delay, TimeUnit unit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-1), task, delay, unit);
    }

    public static <T> void executeBySingleWithDelay(Task<T> task, long delay, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-1, priority), task, delay, unit);
    }

    public static <T> void executeBySingleAtFixRate(Task<T> task, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-1), task, 0L, period, unit);
    }

    public static <T> void executeBySingleAtFixRate(Task<T> task, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-1, priority), task, 0L, period, unit);
    }

    public static <T> void executeBySingleAtFixRate(Task<T> task, long initialDelay, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-1), task, initialDelay, period, unit);
    }

    public static <T> void executeBySingleAtFixRate(Task<T> task, long initialDelay, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-1, priority), task, initialDelay, period, unit);
    }

    public static <T> void executeByCached(Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-2), task);
    }

    public static <T> void executeByCached(Task<T> task, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-2, priority), task);
    }

    public static <T> void executeByCachedWithDelay(Task<T> task, long delay, TimeUnit unit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-2), task, delay, unit);
    }

    public static <T> void executeByCachedWithDelay(Task<T> task, long delay, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-2, priority), task, delay, unit);
    }

    public static <T> void executeByCachedAtFixRate(Task<T> task, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-2), task, 0L, period, unit);
    }

    public static <T> void executeByCachedAtFixRate(Task<T> task, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-2, priority), task, 0L, period, unit);
    }

    public static <T> void executeByCachedAtFixRate(Task<T> task, long initialDelay, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-2), task, initialDelay, period, unit);
    }

    public static <T> void executeByCachedAtFixRate(Task<T> task, long initialDelay, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-2, priority), task, initialDelay, period, unit);
    }

    public static <T> void executeByIo(Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-4), task);
    }

    public static <T> void executeByIo(Task<T> task, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-4, priority), task);
    }

    public static <T> void executeByIoWithDelay(Task<T> task, long delay, TimeUnit unit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-4), task, delay, unit);
    }

    public static <T> void executeByIoWithDelay(Task<T> task, long delay, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-4, priority), task, delay, unit);
    }

    public static <T> void executeByIoAtFixRate(Task<T> task, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-4), task, 0L, period, unit);
    }

    public static <T> void executeByIoAtFixRate(Task<T> task, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-4, priority), task, 0L, period, unit);
    }

    public static <T> void executeByIoAtFixRate(Task<T> task, long initialDelay, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-4), task, initialDelay, period, unit);
    }

    public static <T> void executeByIoAtFixRate(Task<T> task, long initialDelay, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-4, priority), task, initialDelay, period, unit);
    }

    public static <T> void executeByCpu(Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-8), task);
    }

    public static <T> void executeByCpu(Task<T> task, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-8, priority), task);
    }

    public static <T> void executeByCpuWithDelay(Task<T> task, long delay, TimeUnit unit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-8), task, delay, unit);
    }

    public static <T> void executeByCpuWithDelay(Task<T> task, long delay, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-8, priority), task, delay, unit);
    }

    public static <T> void executeByCpuAtFixRate(Task<T> task, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-8), task, 0L, period, unit);
    }

    public static <T> void executeByCpuAtFixRate(Task<T> task, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-8, priority), task, 0L, period, unit);
    }

    public static <T> void executeByCpuAtFixRate(Task<T> task, long initialDelay, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-8), task, initialDelay, period, unit);
    }

    public static <T> void executeByCpuAtFixRate(Task<T> task, long initialDelay, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-8, priority), task, initialDelay, period, unit);
    }

    public static <T> void executeByCustom(ExecutorService pool, Task<T> task) {
        ThreadUtils.execute(pool, task);
    }

    public static <T> void executeByCustomWithDelay(ExecutorService pool, Task<T> task, long delay, TimeUnit unit) {
        ThreadUtils.executeWithDelay(pool, task, delay, unit);
    }

    public static <T> void executeByCustomAtFixRate(ExecutorService pool, Task<T> task, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(pool, task, 0L, period, unit);
    }

    public static <T> void executeByCustomAtFixRate(ExecutorService pool, Task<T> task, long initialDelay, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(pool, task, initialDelay, period, unit);
    }

    public static void cancel(Task task) {
        if (task == null) {
            return;
        }
        task.cancel();
    }

    public static void cancel(Task ... tasks) {
        if (tasks == null || tasks.length == 0) {
            return;
        }
        for (Task task : tasks) {
            if (task == null) continue;
            task.cancel();
        }
    }

    public static void cancel(List<Task> tasks) {
        if (tasks == null || tasks.size() == 0) {
            return;
        }
        for (Task task : tasks) {
            if (task == null) continue;
            task.cancel();
        }
    }

    public static void cancel(ExecutorService executorService) {
        if (executorService instanceof ThreadPoolExecutor4Util) {
            for (Map.Entry<Task, TaskInfo> taskTaskInfoEntry : TASK_TASKINFO_MAP.entrySet()) {
                if (taskTaskInfoEntry.getValue().mService != executorService) continue;
                ThreadUtils.cancel(taskTaskInfoEntry.getKey());
            }
        } else {
            Log.e((String)"LogUtils", (String)"The executorService is not ThreadUtils's pool.");
        }
    }

    public static void setDeliver(Executor deliver) {
        sDeliver = deliver;
    }

    private static <T> void executeWithDelay(final ExecutorService pool, final Task<T> task, long delay, TimeUnit unit) {
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                ThreadUtils.execute(pool, task, this);
            }
        };
        TIMER.schedule(timerTask, unit.toMillis(delay));
    }

    private static <T> void executeAtFixedRate(final ExecutorService pool, final Task<T> task, long initialDelay, long period, TimeUnit unit) {
        ((Task)task).setSchedule(true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                ThreadUtils.execute(pool, task, this);
            }
        };
        TIMER.scheduleAtFixedRate(timerTask, unit.toMillis(initialDelay), unit.toMillis(period));
    }

    private static <T> void execute(ExecutorService pool, Task<T> task) {
        ThreadUtils.execute(pool, task, null);
    }

    private static <T> void execute(ExecutorService pool, Task<T> task, TimerTask timerTask) {
        pool.execute(task);
        TASK_TASKINFO_MAP.put(task, new TaskInfo(timerTask, pool));
    }

    private static ExecutorService getPoolByTypeAndPriority(int type) {
        return ThreadUtils.getPoolByTypeAndPriority(type, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorService getPoolByTypeAndPriority(int type, int priority) {
        Map<Integer, Map<Integer, ExecutorService>> map = TYPE_PRIORITY_POOLS;
        synchronized (map) {
            ExecutorService pool;
            Map<Integer, ExecutorService> priorityPools = TYPE_PRIORITY_POOLS.get(type);
            if (priorityPools == null) {
                priorityPools = new ConcurrentHashMap<Integer, ExecutorService>();
                pool = ThreadPoolExecutor4Util.createPool(type, priority);
                priorityPools.put(priority, pool);
                TYPE_PRIORITY_POOLS.put(type, priorityPools);
            } else {
                pool = priorityPools.get(priority);
                if (pool == null) {
                    pool = ThreadPoolExecutor4Util.createPool(type, priority);
                    priorityPools.put(priority, pool);
                }
            }
            return pool;
        }
    }

    private static Executor getGlobalDeliver() {
        if (sDeliver == null) {
            sDeliver = new Executor(){
                private final Handler mHandler = new Handler(Looper.getMainLooper());

                @Override
                public void execute(@NonNull Runnable command) {
                    if (command == null) {
                        throw new NullPointerException("Argument 'command' of type Runnable (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
                    }
                    this.mHandler.post(command);
                }
            };
        }
        return sDeliver;
    }

    private static void removeTask(Task task) {
        TASK_TASKINFO_MAP.remove(task);
    }

    private static class TaskInfo {
        private TimerTask mTimerTask;
        private ExecutorService mService;

        private TaskInfo(TimerTask timerTask, ExecutorService service) {
            this.mTimerTask = timerTask;
            this.mService = service;
        }
    }

    public static abstract class Task<T>
    implements Runnable {
        private static final int NEW = 0;
        private static final int COMPLETING = 1;
        private static final int CANCELLED = 2;
        private static final int EXCEPTIONAL = 3;
        private static final Object LOCK = "";
        private volatile int state = 0;
        private volatile boolean isSchedule;
        private volatile Thread runner;
        private Executor deliver;

        public abstract T doInBackground() throws Throwable;

        public abstract void onSuccess(T var1);

        public abstract void onCancel();

        public abstract void onFail(Throwable var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.state != 0) {
                return;
            }
            Object object = LOCK;
            synchronized (object) {
                this.runner = Thread.currentThread();
            }
            try {
                final T result = this.doInBackground();
                if (this.state != 0) {
                    return;
                }
                if (this.isSchedule) {
                    this.getDeliver().execute(new Runnable(){

                        @Override
                        public void run() {
                            Task.this.onSuccess(result);
                        }
                    });
                } else {
                    this.state = 1;
                    this.getDeliver().execute(new Runnable(){

                        @Override
                        public void run() {
                            Task.this.onSuccess(result);
                            ThreadUtils.removeTask(Task.this);
                        }
                    });
                }
            }
            catch (InterruptedException result) {
            }
            catch (Throwable throwable) {
                if (this.state != 0) {
                    return;
                }
                this.state = 3;
                this.getDeliver().execute(new Runnable(){

                    @Override
                    public void run() {
                        Task.this.onFail(throwable);
                        ThreadUtils.removeTask(Task.this);
                    }
                });
            }
        }

        public void cancel() {
            this.cancel(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(boolean mayInterruptIfRunning) {
            if (this.state != 0) {
                return;
            }
            if (mayInterruptIfRunning) {
                Object object = LOCK;
                synchronized (object) {
                    if (this.runner != null) {
                        this.runner.interrupt();
                    }
                }
            }
            this.state = 2;
            this.getDeliver().execute(new Runnable(){

                @Override
                public void run() {
                    Task.this.onCancel();
                    ThreadUtils.removeTask(Task.this);
                }
            });
        }

        public boolean isCanceled() {
            return this.state == 2;
        }

        public boolean isDone() {
            return this.state != 0;
        }

        public Task<T> setDeliver(Executor deliver) {
            this.deliver = deliver;
            return this;
        }

        private void setSchedule(boolean isSchedule) {
            this.isSchedule = isSchedule;
        }

        private Executor getDeliver() {
            if (this.deliver == null) {
                return ThreadUtils.getGlobalDeliver();
            }
            return this.deliver;
        }
    }

    public static abstract class SimpleTask<T>
    extends Task<T> {
        @Override
        public void onCancel() {
            Log.e((String)"ThreadUtils", (String)("onCancel: " + Thread.currentThread()));
        }

        @Override
        public void onFail(Throwable t) {
            Log.e((String)"ThreadUtils", (String)"onFail: ", (Throwable)t);
        }
    }

    private static final class UtilsThreadFactory
    extends AtomicLong
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private static final long serialVersionUID = -9209200509960368598L;
        private final String namePrefix;
        private final int priority;
        private final boolean isDaemon;

        UtilsThreadFactory(String prefix, int priority) {
            this(prefix, priority, false);
        }

        UtilsThreadFactory(String prefix, int priority, boolean isDaemon) {
            this.namePrefix = prefix + "-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";
            this.priority = priority;
            this.isDaemon = isDaemon;
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            if (r == null) {
                throw new NullPointerException("Argument 'r' of type Runnable (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
            }
            Thread t = new Thread(r, this.namePrefix + this.getAndIncrement()){

                @Override
                public void run() {
                    try {
                        super.run();
                    }
                    catch (Throwable t) {
                        Log.e((String)"ThreadUtils", (String)"Request threw uncaught throwable", (Throwable)t);
                    }
                }
            };
            t.setDaemon(this.isDaemon);
            t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    System.out.println(e);
                }
            });
            t.setPriority(this.priority);
            return t;
        }
    }

    private static final class LinkedBlockingQueue4Util
    extends LinkedBlockingQueue<Runnable> {
        private volatile ThreadPoolExecutor4Util mPool;
        private int mCapacity = Integer.MAX_VALUE;

        LinkedBlockingQueue4Util() {
        }

        LinkedBlockingQueue4Util(boolean isAddSubThreadFirstThenAddQueue) {
            if (isAddSubThreadFirstThenAddQueue) {
                this.mCapacity = 0;
            }
        }

        LinkedBlockingQueue4Util(int capacity) {
            this.mCapacity = capacity;
        }

        @Override
        public boolean offer(@NonNull Runnable runnable) {
            if (runnable == null) {
                throw new NullPointerException("Argument 'runnable' of type Runnable (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
            }
            if (this.mCapacity <= this.size() && this.mPool != null && this.mPool.getPoolSize() < this.mPool.getMaximumPoolSize()) {
                return false;
            }
            return super.offer(runnable);
        }
    }

    static final class ThreadPoolExecutor4Util
    extends ThreadPoolExecutor {
        private final AtomicInteger mSubmittedCount = new AtomicInteger();
        private LinkedBlockingQueue4Util mWorkQueue;

        private static ExecutorService createPool(int type, int priority) {
            switch (type) {
                case -1: {
                    return new ThreadPoolExecutor4Util(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue4Util(), (ThreadFactory)new UtilsThreadFactory("single", priority));
                }
                case -2: {
                    return new ThreadPoolExecutor4Util(0, 128, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue4Util(true), (ThreadFactory)new UtilsThreadFactory("cached", priority));
                }
                case -4: {
                    return new ThreadPoolExecutor4Util(2 * CPU_COUNT + 1, 2 * CPU_COUNT + 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue4Util(), (ThreadFactory)new UtilsThreadFactory("io", priority));
                }
                case -8: {
                    return new ThreadPoolExecutor4Util(CPU_COUNT + 1, 2 * CPU_COUNT + 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue4Util(true), (ThreadFactory)new UtilsThreadFactory("cpu", priority));
                }
            }
            return new ThreadPoolExecutor4Util(type, type, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue4Util(), (ThreadFactory)new UtilsThreadFactory("fixed(" + type + ")", priority));
        }

        ThreadPoolExecutor4Util(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, LinkedBlockingQueue4Util workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)workQueue, threadFactory);
            workQueue.mPool = this;
            this.mWorkQueue = workQueue;
        }

        private int getSubmittedCount() {
            return this.mSubmittedCount.get();
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            this.mSubmittedCount.decrementAndGet();
            super.afterExecute(r, t);
        }

        @Override
        public void execute(@NonNull Runnable command) {
            if (command == null) {
                throw new NullPointerException("Argument 'command' of type Runnable (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
            }
            if (this.isShutdown()) {
                return;
            }
            this.mSubmittedCount.incrementAndGet();
            try {
                super.execute(command);
            }
            catch (RejectedExecutionException ignore) {
                Log.e((String)"ThreadUtils", (String)"This will not happen!");
                this.mWorkQueue.offer(command);
            }
            catch (Throwable t) {
                this.mSubmittedCount.decrementAndGet();
            }
        }
    }
}

