/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.blankj.utilcode.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class ConvertUtils {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private ConvertUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String bytes2Bits(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            for (int j = 7; j >= 0; --j) {
                sb.append((aByte >> j & 1) == 0 ? (char)'0' : '1');
            }
        }
        return sb.toString();
    }

    public static byte[] bits2Bytes(String bits) {
        int lenMod = bits.length() % 8;
        int byteLen = bits.length() / 8;
        if (lenMod != 0) {
            for (int i = lenMod; i < 8; ++i) {
                bits = "0" + bits;
            }
            ++byteLen;
        }
        byte[] bytes = new byte[byteLen];
        for (int i = 0; i < byteLen; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n = i;
                bytes[n] = (byte)(bytes[n] << 1);
                int n2 = i;
                bytes[n2] = (byte)(bytes[n2] | bits.charAt(i * 8 + j) - 48);
            }
        }
        return bytes;
    }

    public static char[] bytes2Chars(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int len = bytes.length;
        if (len <= 0) {
            return null;
        }
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)(bytes[i] & 0xFF);
        }
        return chars;
    }

    public static byte[] chars2Bytes(char[] chars) {
        if (chars == null || chars.length <= 0) {
            return null;
        }
        int len = chars.length;
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }

    public static String bytes2HexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        int len = bytes.length;
        if (len <= 0) {
            return "";
        }
        char[] ret = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            ret[j++] = hexDigits[bytes[i] >> 4 & 0xF];
            ret[j++] = hexDigits[bytes[i] & 0xF];
        }
        return new String(ret);
    }

    public static byte[] hexString2Bytes(String hexString) {
        if (ConvertUtils.isSpace(hexString)) {
            return null;
        }
        int len = hexString.length();
        if (len % 2 != 0) {
            hexString = "0" + hexString;
            ++len;
        }
        char[] hexBytes = hexString.toUpperCase().toCharArray();
        byte[] ret = new byte[len >> 1];
        for (int i = 0; i < len; i += 2) {
            ret[i >> 1] = (byte)(ConvertUtils.hex2Int(hexBytes[i]) << 4 | ConvertUtils.hex2Int(hexBytes[i + 1]));
        }
        return ret;
    }

    private static int hex2Int(char hexChar) {
        if (hexChar >= '0' && hexChar <= '9') {
            return hexChar - 48;
        }
        if (hexChar >= 'A' && hexChar <= 'F') {
            return hexChar - 65 + 10;
        }
        throw new IllegalArgumentException();
    }

    public static long memorySize2Byte(long memorySize, int unit) {
        if (memorySize < 0L) {
            return -1L;
        }
        return memorySize * (long)unit;
    }

    public static double byte2MemorySize(long byteSize, int unit) {
        if (byteSize < 0L) {
            return -1.0;
        }
        return (double)byteSize / (double)unit;
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String byte2FitMemorySize(long byteSize) {
        if (byteSize < 0L) {
            return "shouldn't be less than zero!";
        }
        if (byteSize < 1024L) {
            return String.format("%.3fB", byteSize);
        }
        if (byteSize < 0x100000L) {
            return String.format("%.3fKB", (double)byteSize / 1024.0);
        }
        if (byteSize < 0x40000000L) {
            return String.format("%.3fMB", (double)byteSize / 1048576.0);
        }
        return String.format("%.3fGB", (double)byteSize / 1.073741824E9);
    }

    public static long timeSpan2Millis(long timeSpan, int unit) {
        return timeSpan * (long)unit;
    }

    public static long millis2TimeSpan(long millis, int unit) {
        return millis / (long)unit;
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String millis2FitTimeSpan(long millis, int precision) {
        if (millis <= 0L || precision <= 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String[] units = new String[]{"\u5929", "\u5c0f\u65f6", "\u5206\u949f", "\u79d2", "\u6beb\u79d2"};
        int[] unitLen = new int[]{86400000, 3600000, 60000, 1000, 1};
        precision = Math.min(precision, 5);
        for (int i = 0; i < precision; ++i) {
            if (millis < (long)unitLen[i]) continue;
            long mode = millis / (long)unitLen[i];
            millis -= mode * (long)unitLen[i];
            sb.append(mode).append(units[i]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream input2OutputStream(InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            int len;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((len = is.read(b, 0, 1024)) != -1) {
                os.write(b, 0, len);
            }
            ByteArrayOutputStream byteArrayOutputStream = os;
            return byteArrayOutputStream;
        }
        catch (IOException e) {
            e.printStackTrace();
            ByteArrayOutputStream byteArrayOutputStream = null;
            return byteArrayOutputStream;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public ByteArrayInputStream output2InputStream(OutputStream out) {
        if (out == null) {
            return null;
        }
        return new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
    }

    public static byte[] inputStream2Bytes(InputStream is) {
        if (is == null) {
            return null;
        }
        return ConvertUtils.input2OutputStream(is).toByteArray();
    }

    public static InputStream bytes2InputStream(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public static byte[] outputStream2Bytes(OutputStream out) {
        if (out == null) {
            return null;
        }
        return ((ByteArrayOutputStream)out).toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream bytes2OutputStream(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            os.write(bytes);
            ByteArrayOutputStream byteArrayOutputStream = os;
            return byteArrayOutputStream;
        }
        catch (IOException e) {
            e.printStackTrace();
            OutputStream outputStream = null;
            return outputStream;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String inputStream2String(InputStream is, String charsetName) {
        if (is == null || ConvertUtils.isSpace(charsetName)) {
            return "";
        }
        try {
            ByteArrayOutputStream baos = ConvertUtils.input2OutputStream(is);
            if (baos == null) {
                return "";
            }
            return baos.toString(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static InputStream string2InputStream(String string, String charsetName) {
        if (string == null || ConvertUtils.isSpace(charsetName)) {
            return null;
        }
        try {
            return new ByteArrayInputStream(string.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String outputStream2String(OutputStream out, String charsetName) {
        if (out == null || ConvertUtils.isSpace(charsetName)) {
            return "";
        }
        try {
            return new String(ConvertUtils.outputStream2Bytes(out), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static OutputStream string2OutputStream(String string, String charsetName) {
        if (string == null || ConvertUtils.isSpace(charsetName)) {
            return null;
        }
        try {
            return ConvertUtils.bytes2OutputStream(string.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] bitmap2Bytes(Bitmap bitmap, Bitmap.CompressFormat format) {
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(format, 100, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static Bitmap bytes2Bitmap(byte[] bytes) {
        return bytes == null || bytes.length == 0 ? null : BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public static Bitmap drawable2Bitmap(Drawable drawable) {
        BitmapDrawable bitmapDrawable;
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        Bitmap bitmap = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565)) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    public static Drawable bitmap2Drawable(Bitmap bitmap) {
        return bitmap == null ? null : new BitmapDrawable(Utils.getApp().getResources(), bitmap);
    }

    public static byte[] drawable2Bytes(Drawable drawable, Bitmap.CompressFormat format) {
        return drawable == null ? null : ConvertUtils.bitmap2Bytes(ConvertUtils.drawable2Bitmap(drawable), format);
    }

    public static Drawable bytes2Drawable(byte[] bytes) {
        return bytes == null ? null : ConvertUtils.bitmap2Drawable(ConvertUtils.bytes2Bitmap(bytes));
    }

    public static Bitmap view2Bitmap(View view) {
        if (view == null) {
            return null;
        }
        Bitmap ret = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(ret);
        Drawable bgDrawable = view.getBackground();
        if (bgDrawable != null) {
            bgDrawable.draw(canvas);
        } else {
            canvas.drawColor(-1);
        }
        view.draw(canvas);
        return ret;
    }

    public static int dp2px(float dpValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dp(float pxValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int sp2px(float spValue) {
        float fontScale = Resources.getSystem().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int px2sp(float pxValue) {
        float fontScale = Resources.getSystem().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

