/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.support.annotation.RequiresApi;
import android.support.v4.util.SimpleArrayMap;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import java.util.Collection;
import java.util.Collections;

public final class ContainerUtils {
    private ContainerUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static <T> boolean isEmpty(T[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean isEmpty(Collection obj) {
        return obj == null || obj.isEmpty();
    }

    public static boolean isEmpty(java.util.Map obj) {
        return obj == null || obj.isEmpty();
    }

    public static boolean isEmpty(SimpleArrayMap obj) {
        return obj == null || obj.isEmpty();
    }

    public static boolean isEmpty(SparseArray obj) {
        return obj == null || obj.size() == 0;
    }

    public static boolean isEmpty(SparseBooleanArray obj) {
        return obj == null || obj.size() == 0;
    }

    public static boolean isEmpty(SparseIntArray obj) {
        return obj == null || obj.size() == 0;
    }

    public static boolean isEmpty(android.support.v4.util.LongSparseArray obj) {
        return obj == null || obj.size() == 0;
    }

    @RequiresApi(api=16)
    public static boolean isEmpty(LongSparseArray obj) {
        return obj == null || obj.size() == 0;
    }

    @RequiresApi(api=18)
    public static boolean isEmpty(SparseLongArray obj) {
        return obj == null || obj.size() == 0;
    }

    public static <V> boolean isNotEmpty(V[] obj) {
        return !ContainerUtils.isEmpty(obj);
    }

    public static boolean isNotEmpty(Collection obj) {
        return !ContainerUtils.isEmpty(obj);
    }

    public static boolean isNotEmpty(java.util.Map obj) {
        return !ContainerUtils.isEmpty(obj);
    }

    public static boolean isNotEmpty(SimpleArrayMap obj) {
        return !ContainerUtils.isEmpty(obj);
    }

    public static boolean isNotEmpty(SparseArray obj) {
        return !ContainerUtils.isEmpty(obj);
    }

    public static boolean isNotEmpty(SparseBooleanArray obj) {
        return !ContainerUtils.isEmpty(obj);
    }

    public static boolean isNotEmpty(SparseIntArray obj) {
        return !ContainerUtils.isEmpty(obj);
    }

    public static boolean isNotEmpty(android.support.v4.util.LongSparseArray obj) {
        return !ContainerUtils.isEmpty(obj);
    }

    @RequiresApi(api=16)
    public static boolean isNotEmpty(LongSparseArray obj) {
        return !ContainerUtils.isEmpty(obj);
    }

    @RequiresApi(api=18)
    public static boolean isNotEmpty(SparseLongArray obj) {
        return !ContainerUtils.isEmpty(obj);
    }

    public static final class Map {
        private Map() {
            throw new UnsupportedOperationException("u can't instantiate me...");
        }

        public static <K, V> int getSize(java.util.Map<K, V> map) {
            if (ContainerUtils.isEmpty(map)) {
                return 0;
            }
            return map.size();
        }
    }

    public static final class List {
        private List() {
            throw new UnsupportedOperationException("u can't instantiate me...");
        }

        public static <T> int getSize(java.util.List<T> list) {
            if (ContainerUtils.isEmpty(list)) {
                return 0;
            }
            return list.size();
        }

        public static <V> void reverse(java.util.List<V> list) {
            if (List.getSize(list) <= 1) {
                return;
            }
            Collections.reverse(list);
        }
    }

    public static final class Array {
        private Array() {
            throw new UnsupportedOperationException("u can't instantiate me...");
        }

        public static <T> int getSize(T[] arr) {
            if (ContainerUtils.isEmpty(arr)) {
                return 0;
            }
            return arr.length;
        }

        public static <T> void reverse(T[] arr) {
            int size = Array.getSize(arr);
            if (size <= 1) {
                return;
            }
            int mid = size >> 1;
            for (int i = 0; i < mid; ++i) {
                T tmp = arr[i];
                arr[i] = arr[size - i - 1];
                arr[size - i - 1] = tmp;
            }
        }
    }
}

