/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.view.MotionEvent;
import android.view.View;

public class ClickUtils {
    private static final int SCALE = -1;
    private static final float SCALE_DEFAULT_FACTOR = -0.06f;
    private static final long DEBOUNCING_DEFAULT_DURATION = 200L;

    public static void applyScale(View ... views) {
        ClickUtils.applyScale(views, null);
    }

    public static void applyScale(View[] views, float[] scaleFactors) {
        if (views == null || views.length == 0) {
            return;
        }
        for (int i = 0; i < views.length; ++i) {
            if (views[i] == null) continue;
            if (scaleFactors == null || i >= scaleFactors.length) {
                views[i].setTag(-1, (Object)Float.valueOf(-0.06f));
            } else {
                views[i].setTag(-1, (Object)Float.valueOf(scaleFactors[i]));
            }
            views[i].setClickable(true);
            views[i].setOnTouchListener((View.OnTouchListener)OnUtilsTouchListener.getInstance());
        }
    }

    public static void applySingleDebouncing(View view, View.OnClickListener listener) {
        ClickUtils.applySingleDebouncing(new View[]{view}, listener);
    }

    public static void applySingleDebouncing(View view, @IntRange(from=0L) long duration, View.OnClickListener listener) {
        ClickUtils.applySingleDebouncing(new View[]{view}, duration, listener);
    }

    public static void applySingleDebouncing(View[] views, View.OnClickListener listener) {
        ClickUtils.applySingleDebouncing(views, 200L, listener);
    }

    public static void applySingleDebouncing(View[] views, @IntRange(from=0L) long duration, View.OnClickListener listener) {
        ClickUtils.applyDebouncing(views, false, duration, listener);
    }

    public static void applyGlobalDebouncing(View view, View.OnClickListener listener) {
        ClickUtils.applyGlobalDebouncing(new View[]{view}, listener);
    }

    public static void applyGlobalDebouncing(View view, @IntRange(from=0L) long duration, View.OnClickListener listener) {
        ClickUtils.applyGlobalDebouncing(new View[]{view}, duration, listener);
    }

    public static void applyGlobalDebouncing(View[] views, View.OnClickListener listener) {
        ClickUtils.applyGlobalDebouncing(views, 200L, listener);
    }

    public static void applyGlobalDebouncing(View[] views, @IntRange(from=0L) long duration, View.OnClickListener listener) {
        ClickUtils.applyDebouncing(views, true, duration, listener);
    }

    private static void applyDebouncing(View[] views, boolean isGlobal, @IntRange(from=0L) long duration, final View.OnClickListener listener) {
        if (views == null || views.length == 0 || listener == null) {
            return;
        }
        for (View view : views) {
            if (view == null) continue;
            view.setOnClickListener((View.OnClickListener)new OnDebouncingClickListener(isGlobal, duration){

                @Override
                public void onDebouncingClick(View v) {
                    listener.onClick(v);
                }
            });
        }
    }

    private static class LazyHolder {
        private static final OnUtilsTouchListener INSTANCE = new OnUtilsTouchListener();

        private LazyHolder() {
        }
    }

    private static class OnUtilsTouchListener
    implements View.OnTouchListener {
        public static OnUtilsTouchListener getInstance() {
            return LazyHolder.INSTANCE;
        }

        private OnUtilsTouchListener() {
        }

        public boolean onTouch(View v, MotionEvent event) {
            int action = event.getAction();
            if (action == 0) {
                this.processScale(v, true);
            } else if (action == 1 || action == 3) {
                this.processScale(v, false);
            }
            return false;
        }

        private void processScale(View view, boolean isDown) {
            Object tag = view.getTag(-1);
            if (!(tag instanceof Float)) {
                return;
            }
            float value = isDown ? 1.0f + ((Float)tag).floatValue() : 1.0f;
            view.animate().scaleX(value).scaleY(value).setDuration(100L).start();
        }
    }

    public static abstract class OnMultiClickListener
    implements View.OnClickListener {
        private static final long DEFAULT_INTERVAL = 666L;
        private final int mTriggerClickCount;
        private final long mClickInterval;
        private long mLastClickTime;
        private int mClickCount;

        public OnMultiClickListener(int triggerClickCount) {
            this(triggerClickCount, 666L);
        }

        public OnMultiClickListener(int triggerClickCount, long clickInterval) {
            this.mTriggerClickCount = triggerClickCount;
            this.mClickInterval = clickInterval;
        }

        public abstract void onTriggerClick(View var1);

        public abstract void onBeforeTriggerClick(View var1, int var2);

        public void onClick(View v) {
            if (this.mTriggerClickCount <= 1) {
                this.onTriggerClick(v);
                return;
            }
            long curTime = System.currentTimeMillis();
            if (curTime - this.mLastClickTime < this.mClickInterval) {
                ++this.mClickCount;
                if (this.mClickCount == this.mTriggerClickCount) {
                    this.onTriggerClick(v);
                } else if (this.mClickCount < this.mTriggerClickCount) {
                    this.onBeforeTriggerClick(v, this.mClickCount);
                } else {
                    this.mClickCount = 1;
                    this.onBeforeTriggerClick(v, this.mClickCount);
                }
            } else {
                this.mClickCount = 1;
                this.onBeforeTriggerClick(v, this.mClickCount);
            }
            this.mLastClickTime = curTime;
        }
    }

    public static abstract class OnDebouncingClickListener
    implements View.OnClickListener {
        private static final int TAG_KEY = 0x7EFFFFFF;
        private static boolean mEnabled = true;
        private static final Runnable ENABLE_AGAIN = new Runnable(){

            @Override
            public void run() {
                mEnabled = true;
            }
        };
        private long mDuration;
        private boolean mIsGlobal;

        private static boolean isValid(@NonNull View view, long duration) {
            if (view == null) {
                throw new NullPointerException("Argument 'view' of type View (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
            }
            long curTime = System.currentTimeMillis();
            Object tag = view.getTag(0x7EFFFFFF);
            if (!(tag instanceof Long)) {
                view.setTag(0x7EFFFFFF, (Object)curTime);
                return true;
            }
            long preTime = (Long)tag;
            if (curTime - preTime <= duration) {
                return false;
            }
            view.setTag(0x7EFFFFFF, (Object)curTime);
            return true;
        }

        public OnDebouncingClickListener() {
            this(true, 200L);
        }

        public OnDebouncingClickListener(boolean isGlobal) {
            this(isGlobal, 200L);
        }

        public OnDebouncingClickListener(long duration) {
            this(true, duration);
        }

        public OnDebouncingClickListener(boolean isGlobal, long duration) {
            this.mIsGlobal = isGlobal;
            this.mDuration = duration;
        }

        public abstract void onDebouncingClick(View var1);

        public final void onClick(View v) {
            if (this.mIsGlobal) {
                if (mEnabled) {
                    mEnabled = false;
                    v.postDelayed(ENABLE_AGAIN, this.mDuration);
                    this.onDebouncingClick(v);
                }
            } else if (OnDebouncingClickListener.isValid(v, this.mDuration)) {
                this.onDebouncingClick(v);
            }
        }
    }
}

