/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.os.Environment;
import com.blankj.utilcode.util.Utils;
import java.io.File;

public final class CleanUtils {
    private CleanUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean cleanInternalCache() {
        return CleanUtils.deleteFilesInDir(Utils.getApp().getCacheDir());
    }

    public static boolean cleanInternalFiles() {
        return CleanUtils.deleteFilesInDir(Utils.getApp().getFilesDir());
    }

    public static boolean cleanInternalDbs() {
        return CleanUtils.deleteFilesInDir(new File(Utils.getApp().getFilesDir().getParent(), "databases"));
    }

    public static boolean cleanInternalDbByName(String dbName) {
        return Utils.getApp().deleteDatabase(dbName);
    }

    public static boolean cleanInternalSp() {
        return CleanUtils.deleteFilesInDir(new File(Utils.getApp().getFilesDir().getParent(), "shared_prefs"));
    }

    public static boolean cleanExternalCache() {
        return "mounted".equals(Environment.getExternalStorageState()) && CleanUtils.deleteFilesInDir(Utils.getApp().getExternalCacheDir());
    }

    public static boolean cleanCustomDir(String dirPath) {
        return CleanUtils.deleteFilesInDir(dirPath);
    }

    public static boolean cleanCustomDir(File dir) {
        return CleanUtils.deleteFilesInDir(dir);
    }

    public static boolean deleteFilesInDir(String dirPath) {
        return CleanUtils.deleteFilesInDir(CleanUtils.getFileByPath(dirPath));
    }

    private static boolean deleteFilesInDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!(file.isFile() ? !file.delete() : file.isDirectory() && !CleanUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!(file.isFile() ? !file.delete() : file.isDirectory() && !CleanUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private static File getFileByPath(String filePath) {
        return CleanUtils.isSpace(filePath) ? null : new File(filePath);
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

