/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.app.NotificationManagerCompat;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.TextView;
import android.widget.Toast;
import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.Utils;
import java.lang.reflect.Field;

public final class ToastUtils {
    private static final int COLOR_DEFAULT = -16777217;
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private static final String NULL = "null";
    private static IToast sToast;
    private static int sGravity;
    private static int sXOffset;
    private static int sYOffset;
    private static int sBgColor;
    private static int sBgResource;
    private static int sMsgColor;
    private static int sMsgTextSize;

    private ToastUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void setGravity(int gravity, int xOffset, int yOffset) {
        sGravity = gravity;
        sXOffset = xOffset;
        sYOffset = yOffset;
    }

    public static void setBgColor(@ColorInt int backgroundColor) {
        sBgColor = backgroundColor;
    }

    public static void setBgResource(@DrawableRes int bgResource) {
        sBgResource = bgResource;
    }

    public static void setMsgColor(@ColorInt int msgColor) {
        sMsgColor = msgColor;
    }

    public static void setMsgTextSize(int textSize) {
        sMsgTextSize = textSize;
    }

    public static void showShort(CharSequence text) {
        ToastUtils.show(text == null ? NULL : text, 0);
    }

    public static void showShort(@StringRes int resId) {
        ToastUtils.show(resId, 0);
    }

    public static void showShort(@StringRes int resId, Object ... args) {
        ToastUtils.show(resId, 0, args);
    }

    public static void showShort(String format, Object ... args) {
        ToastUtils.show(format, 0, args);
    }

    public static void showLong(CharSequence text) {
        ToastUtils.show(text == null ? NULL : text, 1);
    }

    public static void showLong(@StringRes int resId) {
        ToastUtils.show(resId, 1);
    }

    public static void showLong(@StringRes int resId, Object ... args) {
        ToastUtils.show(resId, 1, args);
    }

    public static void showLong(String format, Object ... args) {
        ToastUtils.show(format, 1, args);
    }

    public static View showCustomShort(@LayoutRes int layoutId) {
        View view = ToastUtils.getView(layoutId);
        ToastUtils.show(view, 0);
        return view;
    }

    public static View showCustomLong(@LayoutRes int layoutId) {
        View view = ToastUtils.getView(layoutId);
        ToastUtils.show(view, 1);
        return view;
    }

    public static void cancel() {
        if (sToast != null) {
            sToast.cancel();
        }
    }

    private static void show(int resId, int duration) {
        try {
            CharSequence text = Utils.getApp().getResources().getText(resId);
            ToastUtils.show(text, duration);
        }
        catch (Exception ignore) {
            ToastUtils.show(String.valueOf(resId), duration);
        }
    }

    private static void show(int resId, int duration, Object ... args) {
        try {
            CharSequence text = Utils.getApp().getResources().getText(resId);
            String format = String.format(text.toString(), args);
            ToastUtils.show(format, duration);
        }
        catch (Exception ignore) {
            ToastUtils.show(String.valueOf(resId), duration);
        }
    }

    private static void show(String format, int duration, Object ... args) {
        String text;
        if (format == null) {
            text = NULL;
        } else {
            text = String.format(format, args);
            if (text == null) {
                text = NULL;
            }
        }
        ToastUtils.show(text, duration);
    }

    private static void show(final CharSequence text, final int duration) {
        HANDLER.post(new Runnable(){

            @Override
            @SuppressLint(value={"ShowToast"})
            public void run() {
                ToastUtils.cancel();
                if (Utils.isAdaptScreen()) {
                    Utils.cancelAdaptScreen();
                    sToast = ToastFactory.makeToast((Context)Utils.getApp(), text, duration);
                    Utils.restoreAdaptScreen();
                } else {
                    sToast = ToastFactory.makeToast((Context)Utils.getApp(), text, duration);
                }
                TextView tvMessage = (TextView)sToast.getView().findViewById(16908299);
                if (sMsgColor != -16777217) {
                    tvMessage.setTextColor(sMsgColor);
                }
                if (sMsgTextSize != -1) {
                    tvMessage.setTextSize((float)sMsgTextSize);
                }
                if (sGravity != -1 || sXOffset != -1 || sYOffset != -1) {
                    sToast.setGravity(sGravity, sXOffset, sYOffset);
                }
                ToastUtils.setBg(tvMessage);
                sToast.show();
            }
        });
    }

    private static void show(final View view, final int duration) {
        HANDLER.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.cancel();
                sToast = ToastFactory.newToast((Context)Utils.getApp());
                sToast.setView(view);
                sToast.setDuration(duration);
                if (sGravity != -1 || sXOffset != -1 || sYOffset != -1) {
                    sToast.setGravity(sGravity, sXOffset, sYOffset);
                }
                ToastUtils.setBg();
                sToast.show();
            }
        });
    }

    private static void setBg() {
        if (sBgResource != -1) {
            View toastView = sToast.getView();
            toastView.setBackgroundResource(sBgResource);
        } else if (sBgColor != -16777217) {
            View toastView = sToast.getView();
            Drawable background = toastView.getBackground();
            if (background != null) {
                background.setColorFilter((ColorFilter)new PorterDuffColorFilter(sBgColor, PorterDuff.Mode.SRC_IN));
            } else if (Build.VERSION.SDK_INT >= 16) {
                toastView.setBackground((Drawable)new ColorDrawable(sBgColor));
            } else {
                toastView.setBackgroundDrawable((Drawable)new ColorDrawable(sBgColor));
            }
        }
    }

    private static void setBg(TextView tvMsg) {
        if (sBgResource != -1) {
            View toastView = sToast.getView();
            toastView.setBackgroundResource(sBgResource);
            tvMsg.setBackgroundColor(0);
        } else if (sBgColor != -16777217) {
            View toastView = sToast.getView();
            Drawable tvBg = toastView.getBackground();
            Drawable msgBg = tvMsg.getBackground();
            if (tvBg != null && msgBg != null) {
                tvBg.setColorFilter((ColorFilter)new PorterDuffColorFilter(sBgColor, PorterDuff.Mode.SRC_IN));
                tvMsg.setBackgroundColor(0);
            } else if (tvBg != null) {
                tvBg.setColorFilter((ColorFilter)new PorterDuffColorFilter(sBgColor, PorterDuff.Mode.SRC_IN));
            } else if (msgBg != null) {
                msgBg.setColorFilter((ColorFilter)new PorterDuffColorFilter(sBgColor, PorterDuff.Mode.SRC_IN));
            } else {
                toastView.setBackgroundColor(sBgColor);
            }
        }
    }

    private static View getView(@LayoutRes int layoutId) {
        LayoutInflater inflate = (LayoutInflater)Utils.getApp().getSystemService("layout_inflater");
        return inflate.inflate(layoutId, null);
    }

    static {
        sGravity = -1;
        sXOffset = -1;
        sYOffset = -1;
        sBgColor = -16777217;
        sBgResource = -1;
        sMsgColor = -16777217;
        sMsgTextSize = -1;
    }

    static interface IToast {
        public void show();

        public void cancel();

        public void setView(View var1);

        public View getView();

        public void setDuration(int var1);

        public void setGravity(int var1, int var2, int var3);

        public void setText(@StringRes int var1);

        public void setText(CharSequence var1);
    }

    static class ToastWithoutNotification
    implements IToast {
        private Toast mToast;
        private WindowManager mWM;
        private View mView;
        private WindowManager.LayoutParams mParams = new WindowManager.LayoutParams();
        private Handler mHandler = new Handler(Looper.myLooper());

        ToastWithoutNotification(@NonNull Toast toast) {
            if (toast == null) {
                throw new NullPointerException("Argument 'toast' of type Toast (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
            }
            this.mToast = toast;
            this.mParams.height = -2;
            this.mParams.width = -2;
            this.mParams.format = -3;
            this.mParams.windowAnimations = 16973828;
            this.mParams.type = 2005;
            this.mParams.setTitle((CharSequence)"ToastWithoutNotification");
            this.mParams.flags = 152;
        }

        @Override
        public void show() {
            this.mView = this.mToast.getView();
            if (this.mView == null) {
                return;
            }
            Context context = this.mToast.getView().getContext();
            this.mWM = (WindowManager)context.getSystemService("window");
            Configuration config = context.getResources().getConfiguration();
            int gravity = Build.VERSION.SDK_INT >= 17 ? Gravity.getAbsoluteGravity((int)this.mToast.getGravity(), (int)config.getLayoutDirection()) : this.mToast.getGravity();
            this.mParams.gravity = gravity;
            if ((gravity & 7) == 7) {
                this.mParams.horizontalWeight = 1.0f;
            }
            if ((gravity & 0x70) == 112) {
                this.mParams.verticalWeight = 1.0f;
            }
            this.mParams.x = this.mToast.getXOffset();
            this.mParams.y = this.mToast.getYOffset();
            this.mParams.packageName = Utils.getApp().getPackageName();
            try {
                this.mWM.addView(this.mView, (ViewGroup.LayoutParams)this.mParams);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ToastWithoutNotification.this.cancel();
                }
            }, this.mToast.getDuration() == 0 ? 2000L : 3500L);
        }

        @Override
        public void cancel() {
            try {
                this.mWM.removeView(this.mView);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.mView = null;
            this.mHandler = null;
            this.mToast = null;
        }

        @Override
        public void setView(View view) {
            this.mToast.setView(view);
        }

        @Override
        public View getView() {
            return this.mToast.getView();
        }

        @Override
        public void setDuration(int duration) {
            this.mToast.setDuration(duration);
        }

        @Override
        public void setGravity(int gravity, int xOffset, int yOffset) {
            this.mToast.setGravity(gravity, xOffset, yOffset);
        }

        @Override
        public void setText(int resId) {
            this.mToast.setText(resId);
        }

        @Override
        public void setText(CharSequence s) {
            this.mToast.setText(s);
        }
    }

    static class SystemToast
    implements IToast {
        Toast mToast;
        private static Field sField_mTN;
        private static Field sField_TN_Handler;

        SystemToast(@NonNull Toast toast) {
            if (toast == null) {
                throw new NullPointerException("Argument 'toast' of type Toast (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
            }
            this.mToast = toast;
            if (Build.VERSION.SDK_INT == 25) {
                try {
                    sField_mTN = Toast.class.getDeclaredField("mTN");
                    sField_mTN.setAccessible(true);
                    Object mTN = sField_mTN.get(toast);
                    sField_TN_Handler = sField_mTN.getType().getDeclaredField("mHandler");
                    sField_TN_Handler.setAccessible(true);
                    Handler tnHandler = (Handler)sField_TN_Handler.get(mTN);
                    sField_TN_Handler.set(mTN, (Object)new SafeHandler(tnHandler));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void show() {
            this.mToast.show();
        }

        @Override
        public void cancel() {
            this.mToast.cancel();
        }

        @Override
        public void setView(View view) {
            this.mToast.setView(view);
        }

        @Override
        public View getView() {
            return this.mToast.getView();
        }

        @Override
        public void setDuration(int duration) {
            this.mToast.setDuration(duration);
        }

        @Override
        public void setGravity(int gravity, int xOffset, int yOffset) {
            this.mToast.setGravity(gravity, xOffset, yOffset);
        }

        @Override
        public void setText(int resId) {
            this.mToast.setText(resId);
        }

        @Override
        public void setText(CharSequence s) {
            this.mToast.setText(s);
        }

        static class SafeHandler
        extends Handler {
            private Handler impl;

            SafeHandler(Handler impl) {
                this.impl = impl;
            }

            public void handleMessage(Message msg) {
                try {
                    this.impl.handleMessage(msg);
                }
                catch (Exception e) {
                    LogUtils.e(e);
                }
            }

            public void dispatchMessage(Message msg) {
                this.impl.dispatchMessage(msg);
            }
        }
    }

    static class ToastFactory {
        ToastFactory() {
        }

        static IToast makeToast(Context context, CharSequence text, int duration) {
            if (NotificationManagerCompat.from((Context)context).areNotificationsEnabled()) {
                return new SystemToast(ToastFactory.makeNormalToast(context, text, duration));
            }
            if (Build.VERSION.SDK_INT < 25) {
                return new ToastWithoutNotification(ToastFactory.makeNormalToast(context, text, duration));
            }
            Log.e((String)"ToastUtils", (String)"Toast is GG. In fact, next step is useless.");
            return new SystemToast(ToastFactory.makeNormalToast(context, text, duration));
        }

        static IToast newToast(Context context) {
            if (NotificationManagerCompat.from((Context)context).areNotificationsEnabled()) {
                return new SystemToast(new Toast(context));
            }
            if (Build.VERSION.SDK_INT < 25) {
                return new ToastWithoutNotification(new Toast(context));
            }
            Log.e((String)"ToastUtils", (String)"Toast is GG. In fact, next step is useless.");
            return new SystemToast(new Toast(context));
        }

        private static Toast makeNormalToast(Context context, CharSequence text, int duration) {
            if ("Xiaomi".equals(Build.MANUFACTURER)) {
                Toast toast = Toast.makeText((Context)context, (CharSequence)"", (int)duration);
                toast.setText(text);
                return toast;
            }
            return Toast.makeText((Context)context, (CharSequence)text, (int)duration);
        }
    }
}

