/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadUtils {
    private static final Map<Integer, Map<Integer, ExecutorService>> TYPE_PRIORITY_POOLS = new ConcurrentHashMap<Integer, Map<Integer, ExecutorService>>();
    private static final Map<Task, ScheduledExecutorService> TASK_SCHEDULED = new ConcurrentHashMap<Task, ScheduledExecutorService>();
    private static final byte TYPE_SINGLE = -1;
    private static final byte TYPE_CACHED = -2;
    private static final byte TYPE_IO = -4;
    private static final byte TYPE_CPU = -8;
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();

    public static boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static ExecutorService getFixedPool(@IntRange(from=1L) int size) {
        return ThreadUtils.getPoolByTypeAndPriority(size);
    }

    public static ExecutorService getFixedPool(@IntRange(from=1L) int size, @IntRange(from=1L, to=10L) int priority) {
        return ThreadUtils.getPoolByTypeAndPriority(size, priority);
    }

    public static ExecutorService getSinglePool() {
        return ThreadUtils.getPoolByTypeAndPriority(-1);
    }

    public static ExecutorService getSinglePool(@IntRange(from=1L, to=10L) int priority) {
        return ThreadUtils.getPoolByTypeAndPriority(-1, priority);
    }

    public static ExecutorService getCachedPool() {
        return ThreadUtils.getPoolByTypeAndPriority(-2);
    }

    public static ExecutorService getCachedPool(@IntRange(from=1L, to=10L) int priority) {
        return ThreadUtils.getPoolByTypeAndPriority(-2, priority);
    }

    public static ExecutorService getIoPool() {
        return ThreadUtils.getPoolByTypeAndPriority(-2);
    }

    public static ExecutorService getIoPool(@IntRange(from=1L, to=10L) int priority) {
        return ThreadUtils.getPoolByTypeAndPriority(-2, priority);
    }

    public static ExecutorService getCpuPool() {
        return ThreadUtils.getPoolByTypeAndPriority(-8);
    }

    public static ExecutorService getCpuPool(@IntRange(from=1L, to=10L) int priority) {
        return ThreadUtils.getPoolByTypeAndPriority(-8, priority);
    }

    public static <T> void executeByFixed(@IntRange(from=1L) int size, Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(size), task);
    }

    public static <T> void executeByFixed(@IntRange(from=1L) int size, Task<T> task, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(size, priority), task);
    }

    public static <T> void executeByFixedWithDelay(@IntRange(from=1L) int size, Task<T> task, long delay, TimeUnit unit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(size), task, delay, unit);
    }

    public static <T> void executeByFixedWithDelay(@IntRange(from=1L) int size, Task<T> task, long delay, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(size, priority), task, delay, unit);
    }

    public static <T> void executeByFixedAtFixRate(@IntRange(from=1L) int size, Task<T> task, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(size), task, 0L, period, unit);
    }

    public static <T> void executeByFixedAtFixRate(@IntRange(from=1L) int size, Task<T> task, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(size, priority), task, 0L, period, unit);
    }

    public static <T> void executeByFixedAtFixRate(@IntRange(from=1L) int size, Task<T> task, long initialDelay, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(size), task, initialDelay, period, unit);
    }

    public static <T> void executeByFixedAtFixRate(@IntRange(from=1L) int size, Task<T> task, long initialDelay, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(size, priority), task, initialDelay, period, unit);
    }

    public static <T> void executeBySingle(Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-1), task);
    }

    public static <T> void executeBySingle(Task<T> task, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-1, priority), task);
    }

    public static <T> void executeBySingleWithDelay(Task<T> task, long delay, TimeUnit unit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-1), task, delay, unit);
    }

    public static <T> void executeBySingleWithDelay(Task<T> task, long delay, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-1, priority), task, delay, unit);
    }

    public static <T> void executeBySingleAtFixRate(Task<T> task, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-1), task, 0L, period, unit);
    }

    public static <T> void executeBySingleAtFixRate(Task<T> task, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-1, priority), task, 0L, period, unit);
    }

    public static <T> void executeBySingleAtFixRate(Task<T> task, long initialDelay, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-1), task, initialDelay, period, unit);
    }

    public static <T> void executeBySingleAtFixRate(Task<T> task, long initialDelay, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-1, priority), task, initialDelay, period, unit);
    }

    public static <T> void executeByCached(Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-2), task);
    }

    public static <T> void executeByCached(Task<T> task, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-2, priority), task);
    }

    public static <T> void executeByCachedWithDelay(Task<T> task, long delay, TimeUnit unit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-2), task, delay, unit);
    }

    public static <T> void executeByCachedWithDelay(Task<T> task, long delay, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-2, priority), task, delay, unit);
    }

    public static <T> void executeByCachedAtFixRate(Task<T> task, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-2), task, 0L, period, unit);
    }

    public static <T> void executeByCachedAtFixRate(Task<T> task, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-2, priority), task, 0L, period, unit);
    }

    public static <T> void executeByCachedAtFixRate(Task<T> task, long initialDelay, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-2), task, initialDelay, period, unit);
    }

    public static <T> void executeByCachedAtFixRate(Task<T> task, long initialDelay, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-2, priority), task, initialDelay, period, unit);
    }

    public static <T> void executeByIo(Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-4), task);
    }

    public static <T> void executeByIo(Task<T> task, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-4, priority), task);
    }

    public static <T> void executeByIoWithDelay(Task<T> task, long delay, TimeUnit unit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-4), task, delay, unit);
    }

    public static <T> void executeByIoWithDelay(Task<T> task, long delay, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-4, priority), task, delay, unit);
    }

    public static <T> void executeByIoAtFixRate(Task<T> task, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-4), task, 0L, period, unit);
    }

    public static <T> void executeByIoAtFixRate(Task<T> task, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-4, priority), task, 0L, period, unit);
    }

    public static <T> void executeByIoAtFixRate(Task<T> task, long initialDelay, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-4), task, initialDelay, period, unit);
    }

    public static <T> void executeByIoAtFixRate(Task<T> task, long initialDelay, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-4, priority), task, initialDelay, period, unit);
    }

    public static <T> void executeByCpu(Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-8), task);
    }

    public static <T> void executeByCpu(Task<T> task, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-8, priority), task);
    }

    public static <T> void executeByCpuWithDelay(Task<T> task, long delay, TimeUnit unit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-8), task, delay, unit);
    }

    public static <T> void executeByCpuWithDelay(Task<T> task, long delay, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-8, priority), task, delay, unit);
    }

    public static <T> void executeByCpuAtFixRate(Task<T> task, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-8), task, 0L, period, unit);
    }

    public static <T> void executeByCpuAtFixRate(Task<T> task, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-8, priority), task, 0L, period, unit);
    }

    public static <T> void executeByCpuAtFixRate(Task<T> task, long initialDelay, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-8), task, initialDelay, period, unit);
    }

    public static <T> void executeByCpuAtFixRate(Task<T> task, long initialDelay, long period, TimeUnit unit, @IntRange(from=1L, to=10L) int priority) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-8, priority), task, initialDelay, period, unit);
    }

    public static <T> void executeByCustom(ExecutorService pool, Task<T> task) {
        ThreadUtils.execute(pool, task);
    }

    public static <T> void executeByCustomWithDelay(ExecutorService pool, Task<T> task, long delay, TimeUnit unit) {
        ThreadUtils.executeWithDelay(pool, task, delay, unit);
    }

    public static <T> void executeByCustomAtFixRate(ExecutorService pool, Task<T> task, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(pool, task, 0L, period, unit);
    }

    public static <T> void executeByCustomAtFixRate(ExecutorService pool, Task<T> task, long initialDelay, long period, TimeUnit unit) {
        ThreadUtils.executeAtFixedRate(pool, task, initialDelay, period, unit);
    }

    public static void cancel(Task task) {
        task.cancel();
    }

    private static <T> void execute(ExecutorService pool, Task<T> task) {
        ThreadUtils.executeWithDelay(pool, task, 0L, TimeUnit.MILLISECONDS);
    }

    private static <T> void executeWithDelay(final ExecutorService pool, final Task<T> task, long delay, TimeUnit unit) {
        if (delay <= 0L) {
            ThreadUtils.getScheduledByTask(task).execute(new Runnable(){

                @Override
                public void run() {
                    pool.execute(task);
                }
            });
        } else {
            ThreadUtils.getScheduledByTask(task).schedule(new Runnable(){

                @Override
                public void run() {
                    pool.execute(task);
                }
            }, delay, unit);
        }
    }

    private static <T> void executeAtFixedRate(final ExecutorService pool, final Task<T> task, long initialDelay, long period, TimeUnit unit) {
        ((Task)task).isSchedule = true;
        ThreadUtils.getScheduledByTask(task).scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                pool.execute(task);
            }
        }, initialDelay, period, unit);
    }

    private static ScheduledExecutorService getScheduledByTask(Task task) {
        ScheduledExecutorService scheduled = TASK_SCHEDULED.get(task);
        if (scheduled == null) {
            UtilsThreadFactory factory = new UtilsThreadFactory("scheduled", 10);
            scheduled = Executors.newScheduledThreadPool(1, factory);
            TASK_SCHEDULED.put(task, scheduled);
        }
        return scheduled;
    }

    private static void removeScheduleByTask(Task task) {
        ScheduledExecutorService scheduled = TASK_SCHEDULED.get(task);
        if (scheduled != null) {
            TASK_SCHEDULED.remove(task);
            ThreadUtils.shutdownAndAwaitTermination(scheduled);
        }
    }

    private static ExecutorService getPoolByTypeAndPriority(int type) {
        return ThreadUtils.getPoolByTypeAndPriority(type, 5);
    }

    private static ExecutorService getPoolByTypeAndPriority(int type, int priority) {
        ExecutorService pool;
        Map<Integer, ExecutorService> priorityPools = TYPE_PRIORITY_POOLS.get(type);
        if (priorityPools == null) {
            priorityPools = new ConcurrentHashMap<Integer, ExecutorService>();
            pool = ThreadUtils.createPoolByTypeAndPriority(type, priority);
            priorityPools.put(priority, pool);
            TYPE_PRIORITY_POOLS.put(type, priorityPools);
        } else {
            pool = priorityPools.get(priority);
            if (pool == null) {
                pool = ThreadUtils.createPoolByTypeAndPriority(type, priority);
                priorityPools.put(priority, pool);
            }
        }
        return pool;
    }

    private static ExecutorService createPoolByTypeAndPriority(int type, int priority) {
        switch (type) {
            case -1: {
                return Executors.newSingleThreadExecutor(new UtilsThreadFactory("single", priority));
            }
            case -2: {
                return Executors.newCachedThreadPool(new UtilsThreadFactory("cached", priority));
            }
            case -4: {
                return new ThreadPoolExecutor(2 * CPU_COUNT + 1, 2 * CPU_COUNT + 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), new UtilsThreadFactory("io", priority));
            }
            case -8: {
                return new ThreadPoolExecutor(CPU_COUNT + 1, 2 * CPU_COUNT + 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), new UtilsThreadFactory("cpu", priority));
            }
        }
        return Executors.newFixedThreadPool(type, new UtilsThreadFactory("fixed(" + type + ")", priority));
    }

    private static void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException e) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
    }

    private static class Deliver {
        private static final Handler MAIN_HANDLER;

        private Deliver() {
        }

        static void post(Runnable runnable) {
            if (MAIN_HANDLER != null) {
                MAIN_HANDLER.post(runnable);
            } else {
                runnable.run();
            }
        }

        static {
            Looper looper;
            try {
                looper = Looper.getMainLooper();
            }
            catch (Exception e) {
                looper = null;
            }
            MAIN_HANDLER = looper != null ? new Handler(looper) : null;
        }
    }

    private static final class UtilsThreadFactory
    extends AtomicLong
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final String namePrefix;
        private final int priority;

        UtilsThreadFactory(String prefix, int priority) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = prefix + "-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";
            this.priority = priority;
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            if (r == null) {
                throw new NullPointerException("Argument 'r' of type Runnable (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
            }
            Thread t = new Thread(this.group, r, this.namePrefix + this.getAndIncrement(), 0L){

                @Override
                public void run() {
                    try {
                        super.run();
                    }
                    catch (Throwable t) {
                        Log.e((String)"ThreadUtils", (String)"Request threw uncaught throwable", (Throwable)t);
                    }
                }
            };
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            t.setPriority(this.priority);
            return t;
        }
    }

    public static abstract class Task<T>
    implements Runnable {
        private boolean isSchedule;
        private volatile int state = 0;
        private static final int NEW = 0;
        private static final int COMPLETING = 1;
        private static final int CANCELLED = 2;
        private static final int EXCEPTIONAL = 3;

        @Nullable
        public abstract T doInBackground() throws Throwable;

        public abstract void onSuccess(@Nullable T var1);

        public abstract void onCancel();

        public abstract void onFail(Throwable var1);

        @Override
        public void run() {
            try {
                final T result = this.doInBackground();
                if (this.state != 0) {
                    return;
                }
                if (this.isSchedule) {
                    Deliver.post(new Runnable(){

                        @Override
                        public void run() {
                            Task.this.onSuccess(result);
                        }
                    });
                } else {
                    this.state = 1;
                    Deliver.post(new Runnable(){

                        @Override
                        public void run() {
                            Task.this.onSuccess(result);
                            ThreadUtils.removeScheduleByTask(Task.this);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                if (this.state != 0) {
                    return;
                }
                this.state = 3;
                Deliver.post(new Runnable(){

                    @Override
                    public void run() {
                        Task.this.onFail(throwable);
                        ThreadUtils.removeScheduleByTask(Task.this);
                    }
                });
            }
        }

        public void cancel() {
            if (this.state != 0) {
                return;
            }
            this.state = 2;
            Deliver.post(new Runnable(){

                @Override
                public void run() {
                    Task.this.onCancel();
                    ThreadUtils.removeScheduleByTask(Task.this);
                }
            });
        }
    }

    public static abstract class SimpleTask<T>
    extends Task<T> {
        @Override
        public void onCancel() {
            Log.e((String)"ThreadUtils", (String)("onCancel: " + Thread.currentThread()));
        }

        @Override
        public void onFail(Throwable t) {
            Log.e((String)"ThreadUtils", (String)"onFail: ", (Throwable)t);
        }
    }
}

