/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntRange;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.design.widget.Snackbar;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;

public final class SnackbarUtils {
    public static final int LENGTH_INDEFINITE = -2;
    public static final int LENGTH_SHORT = -1;
    public static final int LENGTH_LONG = 0;
    private static final int COLOR_DEFAULT = -16777217;
    private static final int COLOR_SUCCESS = -13912576;
    private static final int COLOR_WARNING = -16128;
    private static final int COLOR_ERROR = -65536;
    private static final int COLOR_MESSAGE = -1;
    private static WeakReference<Snackbar> sReference;
    private View view;
    private CharSequence message;
    private int messageColor;
    private int bgColor;
    private int bgResource;
    private int duration;
    private CharSequence actionText;
    private int actionTextColor;
    private View.OnClickListener actionListener;
    private int bottomMargin;

    private SnackbarUtils(View parent) {
        this.setDefault();
        this.view = parent;
    }

    private void setDefault() {
        this.message = "";
        this.messageColor = -16777217;
        this.bgColor = -16777217;
        this.bgResource = -1;
        this.duration = -1;
        this.actionText = "";
        this.actionTextColor = -16777217;
        this.bottomMargin = 0;
    }

    public static SnackbarUtils with(@NonNull View view) {
        if (view == null) {
            throw new NullPointerException("Argument 'view' of type View (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return new SnackbarUtils(view);
    }

    public SnackbarUtils setMessage(@NonNull CharSequence msg) {
        if (msg == null) {
            throw new NullPointerException("Argument 'msg' of type CharSequence (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.message = msg;
        return this;
    }

    public SnackbarUtils setMessageColor(@ColorInt int color) {
        this.messageColor = color;
        return this;
    }

    public SnackbarUtils setBgColor(@ColorInt int color) {
        this.bgColor = color;
        return this;
    }

    public SnackbarUtils setBgResource(@DrawableRes int bgResource) {
        this.bgResource = bgResource;
        return this;
    }

    public SnackbarUtils setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public SnackbarUtils setAction(@NonNull CharSequence text, @NonNull View.OnClickListener listener) {
        if (text == null) {
            throw new NullPointerException("Argument 'text' of type CharSequence (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (listener == null) {
            throw new NullPointerException("Argument 'listener' of type View.OnClickListener (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.setAction(text, -16777217, listener);
    }

    public SnackbarUtils setAction(@NonNull CharSequence text, @ColorInt int color, @NonNull View.OnClickListener listener) {
        if (text == null) {
            throw new NullPointerException("Argument 'text' of type CharSequence (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (listener == null) {
            throw new NullPointerException("Argument 'listener' of type View.OnClickListener (#2 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.actionText = text;
        this.actionTextColor = color;
        this.actionListener = listener;
        return this;
    }

    public SnackbarUtils setBottomMargin(@IntRange(from=1L) int bottomMargin) {
        this.bottomMargin = bottomMargin;
        return this;
    }

    public void show() {
        View view = this.view;
        if (view == null) {
            return;
        }
        if (this.messageColor != -16777217) {
            SpannableString spannableString = new SpannableString(this.message);
            ForegroundColorSpan colorSpan = new ForegroundColorSpan(this.messageColor);
            spannableString.setSpan((Object)colorSpan, 0, spannableString.length(), 33);
            sReference = new WeakReference<Snackbar>(Snackbar.make((View)view, (CharSequence)spannableString, (int)this.duration));
        } else {
            sReference = new WeakReference<Snackbar>(Snackbar.make((View)view, (CharSequence)this.message, (int)this.duration));
        }
        Snackbar snackbar = (Snackbar)sReference.get();
        View snackbarView = snackbar.getView();
        if (this.bgResource != -1) {
            snackbarView.setBackgroundResource(this.bgResource);
        } else if (this.bgColor != -16777217) {
            snackbarView.setBackgroundColor(this.bgColor);
        }
        if (this.bottomMargin != 0) {
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)snackbarView.getLayoutParams();
            params.bottomMargin = this.bottomMargin;
        }
        if (this.actionText.length() > 0 && this.actionListener != null) {
            if (this.actionTextColor != -16777217) {
                snackbar.setActionTextColor(this.actionTextColor);
            }
            snackbar.setAction(this.actionText, this.actionListener);
        }
        snackbar.show();
    }

    public void showSuccess() {
        this.bgColor = -13912576;
        this.messageColor = -1;
        this.actionTextColor = -1;
        this.show();
    }

    public void showWarning() {
        this.bgColor = -16128;
        this.messageColor = -1;
        this.actionTextColor = -1;
        this.show();
    }

    public void showError() {
        this.bgColor = -65536;
        this.messageColor = -1;
        this.actionTextColor = -1;
        this.show();
    }

    public static void dismiss() {
        if (sReference != null && sReference.get() != null) {
            ((Snackbar)sReference.get()).dismiss();
            sReference = null;
        }
    }

    public static View getView() {
        Snackbar snackbar = (Snackbar)sReference.get();
        if (snackbar == null) {
            return null;
        }
        return snackbar.getView();
    }

    public static void addView(@LayoutRes int layoutId, @NonNull ViewGroup.LayoutParams params) {
        if (params == null) {
            throw new NullPointerException("Argument 'params' of type ViewGroup.LayoutParams (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        View view = SnackbarUtils.getView();
        if (view != null) {
            view.setPadding(0, 0, 0, 0);
            Snackbar.SnackbarLayout layout = (Snackbar.SnackbarLayout)view;
            View child = LayoutInflater.from((Context)view.getContext()).inflate(layoutId, null);
            layout.addView(child, -1, params);
        }
    }

    public static void addView(@NonNull View child, @NonNull ViewGroup.LayoutParams params) {
        if (child == null) {
            throw new NullPointerException("Argument 'child' of type View (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (params == null) {
            throw new NullPointerException("Argument 'params' of type ViewGroup.LayoutParams (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        View view = SnackbarUtils.getView();
        if (view != null) {
            view.setPadding(0, 0, 0, 0);
            Snackbar.SnackbarLayout layout = (Snackbar.SnackbarLayout)view;
            layout.addView(child, params);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Duration {
    }
}

