/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.os.Environment;
import android.os.storage.StorageManager;
import com.blankj.utilcode.util.Utils;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SDCardUtils {
    private SDCardUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isSDCardEnableByEnvironment() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    public static String getSDCardPathByEnvironment() {
        if ("mounted".equals(Environment.getExternalStorageState())) {
            return Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        return "";
    }

    public static boolean isSDCardEnable() {
        return !SDCardUtils.getSDCardPaths().isEmpty();
    }

    public static List<String> getSDCardPaths(boolean removable) {
        ArrayList<String> paths = new ArrayList<String>();
        StorageManager sm = (StorageManager)Utils.getApp().getSystemService("storage");
        try {
            Class<?> storageVolumeClazz = Class.forName("android.os.storage.StorageVolume");
            Method getVolumeList = StorageManager.class.getMethod("getVolumeList", new Class[0]);
            Method getPath = storageVolumeClazz.getMethod("getPath", new Class[0]);
            Method isRemovable = storageVolumeClazz.getMethod("isRemovable", new Class[0]);
            Object result = getVolumeList.invoke((Object)sm, new Object[0]);
            int length = Array.getLength(result);
            for (int i = 0; i < length; ++i) {
                Object storageVolumeElement = Array.get(result, i);
                String path = (String)getPath.invoke(storageVolumeElement, new Object[0]);
                boolean res = (Boolean)isRemovable.invoke(storageVolumeElement, new Object[0]);
                if (removable != res) continue;
                paths.add(path);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return paths;
    }

    public static List<String> getSDCardPaths() {
        StorageManager storageManager = (StorageManager)Utils.getApp().getSystemService("storage");
        List<String> paths = new ArrayList<String>();
        try {
            Method getVolumePathsMethod = StorageManager.class.getMethod("getVolumePaths", new Class[0]);
            getVolumePathsMethod.setAccessible(true);
            Object invoke = getVolumePathsMethod.invoke((Object)storageManager, new Object[0]);
            paths = Arrays.asList((String[])invoke);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return paths;
    }
}

