/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.RequiresPermission;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.blankj.utilcode.util.Utils;
import java.util.ArrayList;

public final class PhoneUtils {
    private PhoneUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isPhone() {
        TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
        return tm.getPhoneType() != 0;
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getDeviceId() {
        TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
        if (Build.VERSION.SDK_INT >= 26) {
            String imei = tm.getImei();
            if (!TextUtils.isEmpty((CharSequence)imei)) {
                return imei;
            }
            String meid = tm.getMeid();
            return TextUtils.isEmpty((CharSequence)meid) ? "" : meid;
        }
        return tm.getDeviceId();
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getSerial() {
        return Build.VERSION.SDK_INT >= 26 ? Build.getSerial() : Build.SERIAL;
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getIMEI() {
        TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
        if (Build.VERSION.SDK_INT >= 26) {
            return tm.getImei();
        }
        return tm.getDeviceId();
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getMEID() {
        TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
        if (Build.VERSION.SDK_INT >= 26) {
            return tm.getMeid();
        }
        return tm.getDeviceId();
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getIMSI() {
        TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
        return tm.getSubscriberId();
    }

    public static int getPhoneType() {
        TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
        return tm.getPhoneType();
    }

    public static boolean isSimCardReady() {
        TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
        return tm.getSimState() == 5;
    }

    public static String getSimOperatorName() {
        TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
        return tm.getSimOperatorName();
    }

    public static String getSimOperatorByMnc() {
        TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
        String operator = tm.getSimOperator();
        if (operator == null) {
            return "";
        }
        switch (operator) {
            case "46000": 
            case "46002": 
            case "46007": 
            case "46020": {
                return "\u4e2d\u56fd\u79fb\u52a8";
            }
            case "46001": 
            case "46006": 
            case "46009": {
                return "\u4e2d\u56fd\u8054\u901a";
            }
            case "46003": 
            case "46005": 
            case "46011": {
                return "\u4e2d\u56fd\u7535\u4fe1";
            }
        }
        return operator;
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getPhoneStatus() {
        TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
        String str = "";
        str = str + "DeviceId(IMEI) = " + tm.getDeviceId() + "\n";
        str = str + "DeviceSoftwareVersion = " + tm.getDeviceSoftwareVersion() + "\n";
        str = str + "Line1Number = " + tm.getLine1Number() + "\n";
        str = str + "NetworkCountryIso = " + tm.getNetworkCountryIso() + "\n";
        str = str + "NetworkOperator = " + tm.getNetworkOperator() + "\n";
        str = str + "NetworkOperatorName = " + tm.getNetworkOperatorName() + "\n";
        str = str + "NetworkType = " + tm.getNetworkType() + "\n";
        str = str + "PhoneType = " + tm.getPhoneType() + "\n";
        str = str + "SimCountryIso = " + tm.getSimCountryIso() + "\n";
        str = str + "SimOperator = " + tm.getSimOperator() + "\n";
        str = str + "SimOperatorName = " + tm.getSimOperatorName() + "\n";
        str = str + "SimSerialNumber = " + tm.getSimSerialNumber() + "\n";
        str = str + "SimState = " + tm.getSimState() + "\n";
        str = str + "SubscriberId(IMSI) = " + tm.getSubscriberId() + "\n";
        str = str + "VoiceMailNumber = " + tm.getVoiceMailNumber() + "\n";
        return str;
    }

    public static void dial(String phoneNumber) {
        Intent intent = new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + phoneNumber)));
        Utils.getApp().startActivity(intent.addFlags(0x10000000));
    }

    @RequiresPermission(value="android.permission.CALL_PHONE")
    public static void call(String phoneNumber) {
        Intent intent = new Intent("android.intent.action.CALL", Uri.parse((String)("tel:" + phoneNumber)));
        Utils.getApp().startActivity(intent.addFlags(0x10000000));
    }

    public static void sendSms(String phoneNumber, String content) {
        Uri uri = Uri.parse((String)("smsto:" + phoneNumber));
        Intent intent = new Intent("android.intent.action.SENDTO", uri);
        intent.putExtra("sms_body", content);
        Utils.getApp().startActivity(intent.addFlags(0x10000000));
    }

    @RequiresPermission(value="android.permission.SEND_SMS")
    public static void sendSmsSilent(String phoneNumber, String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return;
        }
        PendingIntent sentIntent = PendingIntent.getBroadcast((Context)Utils.getApp(), (int)0, (Intent)new Intent("send"), (int)0);
        SmsManager smsManager = SmsManager.getDefault();
        if (content.length() >= 70) {
            ArrayList ms = smsManager.divideMessage(content);
            for (String str : ms) {
                smsManager.sendTextMessage(phoneNumber, null, str, sentIntent, null);
            }
        } else {
            smsManager.sendTextMessage(phoneNumber, null, content, sentIntent, null);
        }
    }
}

