/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import com.blankj.utilcode.util.Utils;
import java.lang.reflect.Field;

public final class KeyboardUtils {
    private static int sDecorViewInvisibleHeightPre;
    private static ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener;
    private static OnSoftInputChangedListener onSoftInputChangedListener;
    private static int sContentViewInvisibleHeightPre5497;
    private static int sDecorViewDelta;

    private KeyboardUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void showSoftInput(Activity activity) {
        InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
        if (imm == null) {
            return;
        }
        View view = activity.getCurrentFocus();
        if (view == null) {
            view = new View((Context)activity);
            view.setFocusable(true);
            view.setFocusableInTouchMode(true);
            view.requestFocus();
        }
        imm.showSoftInput(view, 2);
    }

    public static void showSoftInput(View view) {
        InputMethodManager imm = (InputMethodManager)Utils.getApp().getSystemService("input_method");
        view.setFocusable(true);
        view.setFocusableInTouchMode(true);
        view.requestFocus();
        imm.showSoftInput(view, 2);
    }

    public static void showSoftInputUsingToggle(Activity activity) {
        if (KeyboardUtils.isSoftInputVisible(activity)) {
            return;
        }
        KeyboardUtils.toggleSoftInput();
    }

    public static void hideSoftInput(Activity activity) {
        InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
        if (imm == null) {
            return;
        }
        View view = activity.getCurrentFocus();
        if (view == null) {
            view = new View((Context)activity);
        }
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void hideSoftInput(View view) {
        InputMethodManager imm = (InputMethodManager)Utils.getApp().getSystemService("input_method");
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void hideSoftInputUsingToggle(Activity activity) {
        if (!KeyboardUtils.isSoftInputVisible(activity)) {
            return;
        }
        KeyboardUtils.toggleSoftInput();
    }

    public static void toggleSoftInput() {
        InputMethodManager imm = (InputMethodManager)Utils.getApp().getSystemService("input_method");
        imm.toggleSoftInput(2, 0);
    }

    public static boolean isSoftInputVisible(Activity activity) {
        return KeyboardUtils.getDecorViewInvisibleHeight(activity) > 0;
    }

    private static int getDecorViewInvisibleHeight(Activity activity) {
        View decorView = activity.getWindow().getDecorView();
        if (decorView == null) {
            return sDecorViewInvisibleHeightPre;
        }
        Rect outRect = new Rect();
        decorView.getWindowVisibleDisplayFrame(outRect);
        Log.d((String)"KeyboardUtils", (String)("getDecorViewInvisibleHeight: " + (decorView.getBottom() - outRect.bottom)));
        int delta = Math.abs(decorView.getBottom() - outRect.bottom);
        if (delta <= KeyboardUtils.getNavBarHeight()) {
            sDecorViewDelta = delta;
            return 0;
        }
        return delta - sDecorViewDelta;
    }

    public static void registerSoftInputChangedListener(final Activity activity, OnSoftInputChangedListener listener) {
        int flags = activity.getWindow().getAttributes().flags;
        if ((flags & 0x200) != 0) {
            activity.getWindow().clearFlags(512);
        }
        FrameLayout contentView = (FrameLayout)activity.findViewById(0x1020002);
        sDecorViewInvisibleHeightPre = KeyboardUtils.getDecorViewInvisibleHeight(activity);
        onSoftInputChangedListener = listener;
        onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (onSoftInputChangedListener != null) {
                    int height = KeyboardUtils.getDecorViewInvisibleHeight(activity);
                    if (sDecorViewInvisibleHeightPre != height) {
                        onSoftInputChangedListener.onSoftInputChanged(height);
                        sDecorViewInvisibleHeightPre = height;
                    }
                }
            }
        };
        contentView.getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
    }

    @TargetApi(value=16)
    public static void unregisterSoftInputChangedListener(Activity activity) {
        View contentView = activity.findViewById(0x1020002);
        contentView.getViewTreeObserver().removeOnGlobalLayoutListener(onGlobalLayoutListener);
        onSoftInputChangedListener = null;
        onGlobalLayoutListener = null;
    }

    public static void fixAndroidBug5497(final Activity activity) {
        FrameLayout contentView = (FrameLayout)activity.findViewById(0x1020002);
        final View contentViewChild = contentView.getChildAt(0);
        final int paddingBottom = contentViewChild.getPaddingBottom();
        sContentViewInvisibleHeightPre5497 = KeyboardUtils.getContentViewInvisibleHeight(activity);
        contentView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                int height = KeyboardUtils.getContentViewInvisibleHeight(activity);
                if (sContentViewInvisibleHeightPre5497 != height) {
                    contentViewChild.setPadding(contentViewChild.getPaddingLeft(), contentViewChild.getPaddingTop(), contentViewChild.getPaddingRight(), paddingBottom + KeyboardUtils.getDecorViewInvisibleHeight(activity));
                    sContentViewInvisibleHeightPre5497 = height;
                }
            }
        });
    }

    private static int getContentViewInvisibleHeight(Activity activity) {
        View contentView = activity.findViewById(0x1020002);
        if (contentView == null) {
            return sContentViewInvisibleHeightPre5497;
        }
        Rect outRect = new Rect();
        contentView.getWindowVisibleDisplayFrame(outRect);
        Log.d((String)"KeyboardUtils", (String)("getContentViewInvisibleHeight: " + (contentView.getBottom() - outRect.bottom)));
        int delta = Math.abs(contentView.getBottom() - outRect.bottom);
        if (delta <= KeyboardUtils.getStatusBarHeight() + KeyboardUtils.getNavBarHeight()) {
            return 0;
        }
        return delta;
    }

    public static void fixSoftInputLeaks(Context context) {
        if (context == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)Utils.getApp().getSystemService("input_method");
        String[] strArr = new String[]{"mCurRootView", "mServedView", "mNextServedView", "mLastSrvView"};
        for (int i = 0; i < 4; ++i) {
            try {
                Object obj;
                Field declaredField = imm.getClass().getDeclaredField(strArr[i]);
                if (declaredField == null) continue;
                if (!declaredField.isAccessible()) {
                    declaredField.setAccessible(true);
                }
                if ((obj = declaredField.get(imm)) == null || !(obj instanceof View)) continue;
                View view = (View)obj;
                if (view.getContext() == context) {
                    declaredField.set(imm, null);
                    continue;
                }
                return;
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    public static void clickBlankArea2HideSoftInput() {
        Log.i((String)"KeyboardUtils", (String)"Please refer to the following code.");
    }

    private static int getStatusBarHeight() {
        Resources resources = Resources.getSystem();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        return resources.getDimensionPixelSize(resourceId);
    }

    private static int getNavBarHeight() {
        Resources res = Resources.getSystem();
        int resourceId = res.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId != 0) {
            return res.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    static {
        sDecorViewDelta = 0;
    }

    public static interface OnSoftInputChangedListener {
        public void onSoftInputChanged(int var1);
    }
}

