/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import com.blankj.utilcode.util.ShellUtils;
import com.blankj.utilcode.util.Utils;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public final class DeviceUtils {
    private DeviceUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isDeviceRooted() {
        String[] locations;
        String su = "su";
        for (String location : locations = new String[]{"/system/bin/", "/system/xbin/", "/sbin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/xbin/", "/data/local/bin/", "/data/local/"}) {
            if (!new File(location + su).exists()) continue;
            return true;
        }
        return false;
    }

    public static String getSDKVersionName() {
        return Build.VERSION.RELEASE;
    }

    public static int getSDKVersionCode() {
        return Build.VERSION.SDK_INT;
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getAndroidID() {
        String id2 = Settings.Secure.getString((ContentResolver)Utils.getApp().getContentResolver(), (String)"android_id");
        return id2 == null ? "" : id2;
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.INTERNET"})
    public static String getMacAddress() {
        return DeviceUtils.getMacAddress(null);
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.INTERNET"})
    public static String getMacAddress(String ... excepts) {
        String macAddress = DeviceUtils.getMacAddressByWifiInfo();
        if (DeviceUtils.isAddressNotInExcepts(macAddress, excepts)) {
            return macAddress;
        }
        macAddress = DeviceUtils.getMacAddressByNetworkInterface();
        if (DeviceUtils.isAddressNotInExcepts(macAddress, excepts)) {
            return macAddress;
        }
        macAddress = DeviceUtils.getMacAddressByInetAddress();
        if (DeviceUtils.isAddressNotInExcepts(macAddress, excepts)) {
            return macAddress;
        }
        macAddress = DeviceUtils.getMacAddressByFile();
        if (DeviceUtils.isAddressNotInExcepts(macAddress, excepts)) {
            return macAddress;
        }
        return "";
    }

    private static boolean isAddressNotInExcepts(String address, String ... excepts) {
        if (excepts == null || excepts.length == 0) {
            return !"02:00:00:00:00:00".equals(address);
        }
        for (String filter : excepts) {
            if (!address.equals(filter)) continue;
            return false;
        }
        return true;
    }

    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    private static String getMacAddressByWifiInfo() {
        try {
            WifiInfo info;
            Context context = Utils.getApp().getApplicationContext();
            WifiManager wifi = (WifiManager)context.getSystemService("wifi");
            if (wifi != null && (info = wifi.getConnectionInfo()) != null) {
                return info.getMacAddress();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static String getMacAddressByNetworkInterface() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                byte[] macBytes;
                NetworkInterface ni = nis.nextElement();
                if (ni == null || !ni.getName().equalsIgnoreCase("wlan0") || (macBytes = ni.getHardwareAddress()) == null || macBytes.length <= 0) continue;
                StringBuilder sb = new StringBuilder();
                for (byte b : macBytes) {
                    sb.append(String.format("%02x:", b));
                }
                return sb.substring(0, sb.length() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static String getMacAddressByInetAddress() {
        try {
            byte[] macBytes;
            NetworkInterface ni;
            InetAddress inetAddress = DeviceUtils.getInetAddress();
            if (inetAddress != null && (ni = NetworkInterface.getByInetAddress(inetAddress)) != null && (macBytes = ni.getHardwareAddress()) != null && macBytes.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (byte b : macBytes) {
                    sb.append(String.format("%02x:", b));
                }
                return sb.substring(0, sb.length() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static InetAddress getInetAddress() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    String hostAddress;
                    InetAddress inetAddress = addresses.nextElement();
                    if (inetAddress.isLoopbackAddress() || (hostAddress = inetAddress.getHostAddress()).indexOf(58) >= 0) continue;
                    return inetAddress;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getMacAddressByFile() {
        String name;
        ShellUtils.CommandResult result = ShellUtils.execCmd("getprop wifi.interface", false);
        if (result.result == 0 && (name = result.successMsg) != null) {
            String address;
            result = ShellUtils.execCmd("cat /sys/class/net/" + name + "/address", false);
            if (result.result == 0 && (address = result.successMsg) != null && address.length() > 0) {
                return address;
            }
        }
        return "02:00:00:00:00:00";
    }

    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getModel() {
        String model = Build.MODEL;
        model = model != null ? model.trim().replaceAll("\\s*", "") : "";
        return model;
    }

    public static String[] getABIs() {
        if (Build.VERSION.SDK_INT >= 21) {
            return Build.SUPPORTED_ABIS;
        }
        if (!TextUtils.isEmpty((CharSequence)Build.CPU_ABI2)) {
            return new String[]{Build.CPU_ABI, Build.CPU_ABI2};
        }
        return new String[]{Build.CPU_ABI};
    }

    public static void shutdown() {
        ShellUtils.execCmd("reboot -p", true);
        Intent intent = new Intent("android.intent.action.ACTION_REQUEST_SHUTDOWN");
        intent.putExtra("android.intent.extra.KEY_CONFIRM", false);
        Utils.getApp().startActivity(intent.addFlags(0x10000000));
    }

    public static void reboot() {
        ShellUtils.execCmd("reboot", true);
        Intent intent = new Intent("android.intent.action.REBOOT");
        intent.putExtra("nowait", 1);
        intent.putExtra("interval", 1);
        intent.putExtra("window", 0);
        Utils.getApp().sendBroadcast(intent);
    }

    public static void reboot(String reason) {
        PowerManager pm = (PowerManager)Utils.getApp().getSystemService("power");
        pm.reboot(reason);
    }

    public static void reboot2Recovery() {
        ShellUtils.execCmd("reboot recovery", true);
    }

    public static void reboot2Bootloader() {
        ShellUtils.execCmd("reboot bootloader", true);
    }
}

