/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.support.annotation.NonNull;
import android.support.v4.util.LruCache;
import android.support.v4.util.SimpleArrayMap;
import com.blankj.utilcode.constant.CacheConstants;

public final class CacheMemoryUtils
implements CacheConstants {
    private static final int DEFAULT_MAX_COUNT = 256;
    private static final SimpleArrayMap<String, CacheMemoryUtils> CACHE_MAP = new SimpleArrayMap();
    private final String mCacheKey;
    private final LruCache<String, CacheValue> mMemoryCache;

    public static CacheMemoryUtils getInstance() {
        return CacheMemoryUtils.getInstance(256);
    }

    public static CacheMemoryUtils getInstance(int maxCount) {
        return CacheMemoryUtils.getInstance(String.valueOf(maxCount), maxCount);
    }

    public static CacheMemoryUtils getInstance(String cacheKey, int maxCount) {
        CacheMemoryUtils cache = (CacheMemoryUtils)CACHE_MAP.get((Object)cacheKey);
        if (cache == null) {
            cache = new CacheMemoryUtils(cacheKey, (LruCache<String, CacheValue>)new LruCache(maxCount));
            CACHE_MAP.put((Object)cacheKey, (Object)cache);
        }
        return cache;
    }

    private CacheMemoryUtils(String cacheKey, LruCache<String, CacheValue> memoryCache) {
        this.mCacheKey = cacheKey;
        this.mMemoryCache = memoryCache;
    }

    public String toString() {
        return this.mCacheKey + "@" + Integer.toHexString(this.hashCode());
    }

    public void put(@NonNull String key, Object value) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, Object value, int saveTime) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (value == null) {
            return;
        }
        long dueTime = saveTime < 0 ? -1L : System.currentTimeMillis() + (long)(saveTime * 1000);
        this.mMemoryCache.put((Object)key, (Object)new CacheValue(dueTime, value));
    }

    public <T> T get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.get(key, null);
    }

    public <T> T get(@NonNull String key, T defaultValue) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        CacheValue val = (CacheValue)this.mMemoryCache.get((Object)key);
        if (val == null) {
            return defaultValue;
        }
        if (val.dueTime == -1L || val.dueTime >= System.currentTimeMillis()) {
            return (T)val.value;
        }
        this.mMemoryCache.remove((Object)key);
        return defaultValue;
    }

    public int getCacheCount() {
        return this.mMemoryCache.size();
    }

    public Object remove(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        CacheValue remove = (CacheValue)this.mMemoryCache.remove((Object)key);
        if (remove == null) {
            return null;
        }
        return remove.value;
    }

    public void clear() {
        this.mMemoryCache.evictAll();
    }

    private static final class CacheValue {
        long dueTime;
        Object value;

        CacheValue(long dueTime, Object value) {
            this.dueTime = dueTime;
            this.value = value;
        }
    }
}

