/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.util.SimpleArrayMap;
import com.blankj.utilcode.constant.CacheConstants;
import com.blankj.utilcode.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONArray;
import org.json.JSONObject;

public final class CacheDiskUtils
implements CacheConstants {
    private static final long DEFAULT_MAX_SIZE = Long.MAX_VALUE;
    private static final int DEFAULT_MAX_COUNT = Integer.MAX_VALUE;
    private static final SimpleArrayMap<String, CacheDiskUtils> CACHE_MAP = new SimpleArrayMap();
    private final String mCacheKey;
    private final DiskCacheManager mDiskCacheManager;

    public static CacheDiskUtils getInstance() {
        return CacheDiskUtils.getInstance("", Long.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static CacheDiskUtils getInstance(String cacheName) {
        return CacheDiskUtils.getInstance(cacheName, Long.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static CacheDiskUtils getInstance(long maxSize, int maxCount) {
        return CacheDiskUtils.getInstance("", maxSize, maxCount);
    }

    public static CacheDiskUtils getInstance(String cacheName, long maxSize, int maxCount) {
        if (CacheDiskUtils.isSpace(cacheName)) {
            cacheName = "cacheUtils";
        }
        File file = new File(Utils.getApp().getCacheDir(), cacheName);
        return CacheDiskUtils.getInstance(file, maxSize, maxCount);
    }

    public static CacheDiskUtils getInstance(@NonNull File cacheDir) {
        if (cacheDir == null) {
            throw new NullPointerException("Argument 'cacheDir' of type File (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return CacheDiskUtils.getInstance(cacheDir, Long.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static CacheDiskUtils getInstance(@NonNull File cacheDir, long maxSize, int maxCount) {
        if (cacheDir == null) {
            throw new NullPointerException("Argument 'cacheDir' of type File (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        String cacheKey = cacheDir.getAbsoluteFile() + "_" + maxSize + "_" + maxCount;
        if (cacheDir.exists()) {
            CacheDiskUtils cache = (CacheDiskUtils)CACHE_MAP.get((Object)cacheKey);
            if (cache == null) {
                DiskCacheManager cacheManager = new DiskCacheManager(cacheDir, maxSize, maxCount);
                cache = new CacheDiskUtils(cacheKey, cacheManager);
                CACHE_MAP.put((Object)cacheKey, (Object)cache);
            }
            return cache;
        }
        if (cacheDir.mkdirs()) {
            DiskCacheManager cacheManager = new DiskCacheManager(cacheDir, maxSize, maxCount);
            CacheDiskUtils cacheDiskUtils = new CacheDiskUtils(cacheKey, cacheManager);
            CACHE_MAP.put((Object)cacheKey, (Object)cacheDiskUtils);
            return cacheDiskUtils;
        }
        throw new RuntimeException("can't make dirs in " + cacheDir.getAbsolutePath());
    }

    private CacheDiskUtils(String cacheKey, DiskCacheManager cacheManager) {
        this.mCacheKey = cacheKey;
        this.mDiskCacheManager = cacheManager;
    }

    public String toString() {
        return this.mCacheKey + "@" + Integer.toHexString(this.hashCode());
    }

    public void put(@NonNull String key, byte[] value) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, byte[] value, int saveTime) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (value == null) {
            return;
        }
        if (saveTime >= 0) {
            value = DiskCacheHelper.newByteArrayWithTime(saveTime, value);
        }
        File file = this.mDiskCacheManager.getFileBeforePut(key);
        CacheDiskUtils.writeFileFromBytes(file, value);
        this.mDiskCacheManager.updateModify(file);
        this.mDiskCacheManager.put(file);
    }

    public byte[] getBytes(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getBytes(key, null);
    }

    public byte[] getBytes(@NonNull String key, byte[] defaultValue) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        File file = this.mDiskCacheManager.getFileIfExists(key);
        if (file == null) {
            return defaultValue;
        }
        byte[] data = CacheDiskUtils.readFile2Bytes(file);
        if (DiskCacheHelper.isDue(data)) {
            this.mDiskCacheManager.removeByKey(key);
            return defaultValue;
        }
        this.mDiskCacheManager.updateModify(file);
        return DiskCacheHelper.getDataWithoutDueTime(data);
    }

    public void put(@NonNull String key, String value) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, String value, int saveTime) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(key, CacheDiskUtils.string2Bytes(value), saveTime);
    }

    public String getString(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getString(key, null);
    }

    public String getString(@NonNull String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        byte[] bytes = this.getBytes(key);
        if (bytes == null) {
            return defaultValue;
        }
        return CacheDiskUtils.bytes2String(bytes);
    }

    public void put(@NonNull String key, JSONObject value) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, JSONObject value, int saveTime) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(key, CacheDiskUtils.jsonObject2Bytes(value), saveTime);
    }

    public JSONObject getJSONObject(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getJSONObject(key, null);
    }

    public JSONObject getJSONObject(@NonNull String key, JSONObject defaultValue) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        byte[] bytes = this.getBytes(key);
        if (bytes == null) {
            return defaultValue;
        }
        return CacheDiskUtils.bytes2JSONObject(bytes);
    }

    public void put(@NonNull String key, JSONArray value) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, JSONArray value, int saveTime) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(key, CacheDiskUtils.jsonArray2Bytes(value), saveTime);
    }

    public JSONArray getJSONArray(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getJSONArray(key, null);
    }

    public JSONArray getJSONArray(@NonNull String key, JSONArray defaultValue) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        byte[] bytes = this.getBytes(key);
        if (bytes == null) {
            return defaultValue;
        }
        return CacheDiskUtils.bytes2JSONArray(bytes);
    }

    public void put(@NonNull String key, Bitmap value) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, Bitmap value, int saveTime) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(key, CacheDiskUtils.bitmap2Bytes(value), saveTime);
    }

    public Bitmap getBitmap(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getBitmap(key, null);
    }

    public Bitmap getBitmap(@NonNull String key, Bitmap defaultValue) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        byte[] bytes = this.getBytes(key);
        if (bytes == null) {
            return defaultValue;
        }
        return CacheDiskUtils.bytes2Bitmap(bytes);
    }

    public void put(@NonNull String key, Drawable value) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, Drawable value, int saveTime) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(key, CacheDiskUtils.drawable2Bytes(value), saveTime);
    }

    public Drawable getDrawable(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getDrawable(key, null);
    }

    public Drawable getDrawable(@NonNull String key, Drawable defaultValue) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        byte[] bytes = this.getBytes(key);
        if (bytes == null) {
            return defaultValue;
        }
        return CacheDiskUtils.bytes2Drawable(bytes);
    }

    public void put(@NonNull String key, Parcelable value) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, Parcelable value, int saveTime) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(key, CacheDiskUtils.parcelable2Bytes(value), saveTime);
    }

    public <T> T getParcelable(@NonNull String key, @NonNull Parcelable.Creator<T> creator) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (creator == null) {
            throw new NullPointerException("Argument 'creator' of type Parcelable.Creator<T> (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getParcelable(key, creator, null);
    }

    public <T> T getParcelable(@NonNull String key, @NonNull Parcelable.Creator<T> creator, T defaultValue) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (creator == null) {
            throw new NullPointerException("Argument 'creator' of type Parcelable.Creator<T> (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        byte[] bytes = this.getBytes(key);
        if (bytes == null) {
            return defaultValue;
        }
        return CacheDiskUtils.bytes2Parcelable(bytes, creator);
    }

    public void put(@NonNull String key, Serializable value) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, Serializable value, int saveTime) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(key, CacheDiskUtils.serializable2Bytes(value), saveTime);
    }

    public Object getSerializable(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getSerializable(key, null);
    }

    public Object getSerializable(@NonNull String key, Object defaultValue) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        byte[] bytes = this.getBytes(key);
        if (bytes == null) {
            return defaultValue;
        }
        return CacheDiskUtils.bytes2Object(this.getBytes(key));
    }

    public long getCacheSize() {
        return this.mDiskCacheManager.getCacheSize();
    }

    public int getCacheCount() {
        return this.mDiskCacheManager.getCacheCount();
    }

    public boolean remove(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.mDiskCacheManager.removeByKey(key);
    }

    public boolean clear() {
        return this.mDiskCacheManager.clear();
    }

    private static byte[] string2Bytes(String string) {
        if (string == null) {
            return null;
        }
        return string.getBytes();
    }

    private static String bytes2String(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }

    private static byte[] jsonObject2Bytes(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return jsonObject.toString().getBytes();
    }

    private static JSONObject bytes2JSONObject(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new JSONObject(new String(bytes));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] jsonArray2Bytes(JSONArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        return jsonArray.toString().getBytes();
    }

    private static JSONArray bytes2JSONArray(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new JSONArray(new String(bytes));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] parcelable2Bytes(Parcelable parcelable) {
        if (parcelable == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        parcelable.writeToParcel(parcel, 0);
        byte[] bytes = parcel.marshall();
        parcel.recycle();
        return bytes;
    }

    private static <T> T bytes2Parcelable(byte[] bytes, Parcelable.Creator<T> creator) {
        if (bytes == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(bytes, 0, bytes.length);
        parcel.setDataPosition(0);
        Object result = creator.createFromParcel(parcel);
        parcel.recycle();
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] serializable2Bytes(Serializable serializable) {
        if (serializable == null) {
            return null;
        }
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(serializable);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object bytes2Object(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            Object var3_5 = null;
            return var3_5;
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static byte[] bitmap2Bytes(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        return baos.toByteArray();
    }

    private static Bitmap bytes2Bitmap(byte[] bytes) {
        return bytes == null || bytes.length <= 0 ? null : BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    private static byte[] drawable2Bytes(Drawable drawable) {
        return drawable == null ? null : CacheDiskUtils.bitmap2Bytes(CacheDiskUtils.drawable2Bitmap(drawable));
    }

    private static Drawable bytes2Drawable(byte[] bytes) {
        return bytes == null ? null : CacheDiskUtils.bitmap2Drawable(CacheDiskUtils.bytes2Bitmap(bytes));
    }

    private static Bitmap drawable2Bitmap(Drawable drawable) {
        BitmapDrawable bitmapDrawable;
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        Bitmap bitmap = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565)) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    private static Drawable bitmap2Drawable(Bitmap bitmap) {
        return bitmap == null ? null : new BitmapDrawable(Utils.getApp().getResources(), bitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFileFromBytes(File file, byte[] bytes) {
        FileChannel fc = null;
        try {
            fc = new FileOutputStream(file, false).getChannel();
            fc.write(ByteBuffer.wrap(bytes));
            fc.force(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fc != null) {
                    fc.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFile2Bytes(File file) {
        FileChannel fc = null;
        try {
            fc = new RandomAccessFile(file, "r").getChannel();
            int size = (int)fc.size();
            MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, size).load();
            byte[] data = new byte[size];
            mbb.get(data, 0, size);
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (fc != null) {
                    fc.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static final class DiskCacheHelper {
        static final int TIME_INFO_LEN = 14;

        private DiskCacheHelper() {
        }

        private static byte[] newByteArrayWithTime(int second, byte[] data) {
            byte[] time = DiskCacheHelper.createDueTime(second).getBytes();
            byte[] content = new byte[time.length + data.length];
            System.arraycopy(time, 0, content, 0, time.length);
            System.arraycopy(data, 0, content, time.length, data.length);
            return content;
        }

        private static String createDueTime(int seconds) {
            return String.format(Locale.getDefault(), "_$%010d$_", System.currentTimeMillis() / 1000L + (long)seconds);
        }

        private static boolean isDue(byte[] data) {
            long millis = DiskCacheHelper.getDueTime(data);
            return millis != -1L && System.currentTimeMillis() > millis;
        }

        private static long getDueTime(byte[] data) {
            if (DiskCacheHelper.hasTimeInfo(data)) {
                String millis = new String(DiskCacheHelper.copyOfRange(data, 2, 12));
                try {
                    return Long.parseLong(millis) * 1000L;
                }
                catch (NumberFormatException e) {
                    return -1L;
                }
            }
            return -1L;
        }

        private static byte[] getDataWithoutDueTime(byte[] data) {
            if (DiskCacheHelper.hasTimeInfo(data)) {
                return DiskCacheHelper.copyOfRange(data, 14, data.length);
            }
            return data;
        }

        private static byte[] copyOfRange(byte[] original, int from, int to) {
            int newLength = to - from;
            if (newLength < 0) {
                throw new IllegalArgumentException(from + " > " + to);
            }
            byte[] copy = new byte[newLength];
            System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
            return copy;
        }

        private static boolean hasTimeInfo(byte[] data) {
            return data != null && data.length >= 14 && data[0] == 95 && data[1] == 36 && data[12] == 36 && data[13] == 95;
        }
    }

    private static final class DiskCacheManager {
        private final AtomicLong cacheSize;
        private final AtomicInteger cacheCount;
        private final long sizeLimit;
        private final int countLimit;
        private final Map<File, Long> lastUsageDates = Collections.synchronizedMap(new HashMap());
        private final File cacheDir;
        private final Thread mThread;

        private DiskCacheManager(final File cacheDir, long sizeLimit, int countLimit) {
            this.cacheDir = cacheDir;
            this.sizeLimit = sizeLimit;
            this.countLimit = countLimit;
            this.cacheSize = new AtomicLong();
            this.cacheCount = new AtomicInteger();
            this.mThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int size = 0;
                    int count = 0;
                    File[] cachedFiles = cacheDir.listFiles();
                    if (cachedFiles != null) {
                        for (File cachedFile : cachedFiles) {
                            size = (int)((long)size + cachedFile.length());
                            ++count;
                            DiskCacheManager.this.lastUsageDates.put(cachedFile, cachedFile.lastModified());
                        }
                        DiskCacheManager.this.cacheSize.getAndAdd(size);
                        DiskCacheManager.this.cacheCount.getAndAdd(count);
                    }
                }
            });
            this.mThread.start();
        }

        private long getCacheSize() {
            try {
                this.mThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.cacheSize.get();
        }

        private int getCacheCount() {
            try {
                this.mThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.cacheCount.get();
        }

        private File getFileBeforePut(String key) {
            File file = new File(this.cacheDir, String.valueOf(key.hashCode()));
            if (file.exists()) {
                this.cacheCount.addAndGet(-1);
                this.cacheSize.addAndGet(-file.length());
            }
            return file;
        }

        private File getFileIfExists(String key) {
            File file = new File(this.cacheDir, String.valueOf(key.hashCode()));
            if (!file.exists()) {
                return null;
            }
            return file;
        }

        private void put(File file) {
            this.cacheCount.addAndGet(1);
            this.cacheSize.addAndGet(file.length());
            while (this.cacheCount.get() > this.countLimit || this.cacheSize.get() > this.sizeLimit) {
                this.cacheSize.addAndGet(-this.removeOldest());
                this.cacheCount.addAndGet(-1);
            }
        }

        private void updateModify(File file) {
            Long millis = System.currentTimeMillis();
            file.setLastModified(millis);
            this.lastUsageDates.put(file, millis);
        }

        private boolean removeByKey(String key) {
            File file = this.getFileIfExists(key);
            if (file == null) {
                return true;
            }
            if (!file.delete()) {
                return false;
            }
            this.cacheSize.addAndGet(-file.length());
            this.cacheCount.addAndGet(-1);
            this.lastUsageDates.remove(file);
            return true;
        }

        private boolean clear() {
            File[] files = this.cacheDir.listFiles();
            if (files == null || files.length <= 0) {
                return true;
            }
            boolean flag = true;
            for (File file : files) {
                if (!file.delete()) {
                    flag = false;
                    continue;
                }
                this.cacheSize.addAndGet(-file.length());
                this.cacheCount.addAndGet(-1);
                this.lastUsageDates.remove(file);
            }
            if (flag) {
                this.lastUsageDates.clear();
                this.cacheSize.set(0L);
                this.cacheCount.set(0);
            }
            return flag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long removeOldest() {
            if (this.lastUsageDates.isEmpty()) {
                return 0L;
            }
            Long oldestUsage = Long.MAX_VALUE;
            File oldestFile = null;
            Set<Map.Entry<File, Long>> entries = this.lastUsageDates.entrySet();
            Map<File, Long> map = this.lastUsageDates;
            synchronized (map) {
                for (Map.Entry<File, Long> entry : entries) {
                    Long lastValueUsage = entry.getValue();
                    if (lastValueUsage >= oldestUsage) continue;
                    oldestUsage = lastValueUsage;
                    oldestFile = entry.getKey();
                }
            }
            if (oldestFile == null) {
                return 0L;
            }
            long fileSize = oldestFile.length();
            if (oldestFile.delete()) {
                this.lastUsageDates.remove(oldestFile);
                return fileSize;
            }
            return 0L;
        }
    }
}

