/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.RequiresPermission;
import android.support.v4.widget.DrawerLayout;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;
import com.blankj.utilcode.util.Utils;
import java.lang.reflect.Method;

public final class BarUtils {
    private static final int DEFAULT_ALPHA = 112;
    private static final String TAG_COLOR = "TAG_COLOR";
    private static final String TAG_ALPHA = "TAG_ALPHA";
    private static final String TAG_OFFSET = "TAG_OFFSET";
    private static final int KEY_OFFSET = -123;

    private BarUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static int getStatusBarHeight() {
        Resources resources = Resources.getSystem();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        return resources.getDimensionPixelSize(resourceId);
    }

    public static void setStatusBarVisibility(@NonNull Activity activity, boolean isVisible) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarVisibility(activity.getWindow(), isVisible);
    }

    public static void setStatusBarVisibility(@NonNull Window window, boolean isVisible) {
        if (window == null) {
            throw new NullPointerException("Argument 'window' of type Window (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (isVisible) {
            window.clearFlags(1024);
            BarUtils.showColorView(window);
            BarUtils.showAlphaView(window);
            BarUtils.addMarginTopEqualStatusBarHeight(window);
        } else {
            window.addFlags(1024);
            BarUtils.hideColorView(window);
            BarUtils.hideAlphaView(window);
            BarUtils.subtractMarginTopEqualStatusBarHeight(window);
        }
    }

    public static boolean isStatusBarVisible(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        int flags = activity.getWindow().getAttributes().flags;
        return (flags & 0x400) == 0;
    }

    public static void setStatusBarLightMode(@NonNull Activity activity, boolean isLightMode) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarLightMode(activity.getWindow(), isLightMode);
    }

    public static void setStatusBarLightMode(@NonNull Window window, boolean isLightMode) {
        View decorView;
        if (window == null) {
            throw new NullPointerException("Argument 'window' of type Window (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT >= 23 && (decorView = window.getDecorView()) != null) {
            int vis = decorView.getSystemUiVisibility();
            if (isLightMode) {
                window.addFlags(Integer.MIN_VALUE);
                vis |= 0x2000;
            } else {
                vis &= 0xFFFFDFFF;
            }
            decorView.setSystemUiVisibility(vis);
        }
    }

    public static void addMarginTopEqualStatusBarHeight(@NonNull View view) {
        if (view == null) {
            throw new NullPointerException("Argument 'view' of type View (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        view.setTag((Object)TAG_OFFSET);
        Object haveSetOffset = view.getTag(-123);
        if (haveSetOffset != null && ((Boolean)haveSetOffset).booleanValue()) {
            return;
        }
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        layoutParams.setMargins(layoutParams.leftMargin, layoutParams.topMargin + BarUtils.getStatusBarHeight(), layoutParams.rightMargin, layoutParams.bottomMargin);
        view.setTag(-123, (Object)true);
    }

    public static void subtractMarginTopEqualStatusBarHeight(@NonNull View view) {
        if (view == null) {
            throw new NullPointerException("Argument 'view' of type View (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        Object haveSetOffset = view.getTag(-123);
        if (haveSetOffset == null || !((Boolean)haveSetOffset).booleanValue()) {
            return;
        }
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        layoutParams.setMargins(layoutParams.leftMargin, layoutParams.topMargin - BarUtils.getStatusBarHeight(), layoutParams.rightMargin, layoutParams.bottomMargin);
        view.setTag(-123, (Object)false);
    }

    private static void addMarginTopEqualStatusBarHeight(Window window) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        View withTag = window.getDecorView().findViewWithTag((Object)TAG_OFFSET);
        if (withTag == null) {
            return;
        }
        BarUtils.addMarginTopEqualStatusBarHeight(withTag);
    }

    private static void subtractMarginTopEqualStatusBarHeight(Window window) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        View withTag = window.getDecorView().findViewWithTag((Object)TAG_OFFSET);
        if (withTag == null) {
            return;
        }
        BarUtils.subtractMarginTopEqualStatusBarHeight(withTag);
    }

    public static void setStatusBarColor(@NonNull Activity activity, @ColorInt int color) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarColor(activity, color, 112, false);
    }

    public static void setStatusBarColor(@NonNull Activity activity, @ColorInt int color, @IntRange(from=0L, to=255L) int alpha) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarColor(activity, color, alpha, false);
    }

    public static void setStatusBarColor(@NonNull Activity activity, @ColorInt int color, @IntRange(from=0L, to=255L) int alpha, boolean isDecor) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        BarUtils.hideAlphaView(activity);
        BarUtils.transparentStatusBar(activity);
        BarUtils.addStatusBarColor(activity, color, alpha, isDecor);
    }

    public static void setStatusBarColor(@NonNull View fakeStatusBar, @ColorInt int color) {
        if (fakeStatusBar == null) {
            throw new NullPointerException("Argument 'fakeStatusBar' of type View (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarColor(fakeStatusBar, color, 112);
    }

    public static void setStatusBarColor(@NonNull View fakeStatusBar, @ColorInt int color, @IntRange(from=0L, to=255L) int alpha) {
        if (fakeStatusBar == null) {
            throw new NullPointerException("Argument 'fakeStatusBar' of type View (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        fakeStatusBar.setVisibility(0);
        BarUtils.transparentStatusBar((Activity)fakeStatusBar.getContext());
        ViewGroup.LayoutParams layoutParams = fakeStatusBar.getLayoutParams();
        layoutParams.width = -1;
        layoutParams.height = BarUtils.getStatusBarHeight();
        fakeStatusBar.setBackgroundColor(BarUtils.getStatusBarColor(color, alpha));
    }

    public static void setStatusBarAlpha(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarAlpha(activity, 112, false);
    }

    public static void setStatusBarAlpha(@NonNull Activity activity, @IntRange(from=0L, to=255L) int alpha) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarAlpha(activity, alpha, false);
    }

    public static void setStatusBarAlpha(@NonNull Activity activity, @IntRange(from=0L, to=255L) int alpha, boolean isDecor) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        BarUtils.hideColorView(activity);
        BarUtils.transparentStatusBar(activity);
        BarUtils.addStatusBarAlpha(activity, alpha, isDecor);
    }

    public static void setStatusBarAlpha(@NonNull View fakeStatusBar) {
        if (fakeStatusBar == null) {
            throw new NullPointerException("Argument 'fakeStatusBar' of type View (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarAlpha(fakeStatusBar, 112);
    }

    public static void setStatusBarAlpha(@NonNull View fakeStatusBar, @IntRange(from=0L, to=255L) int alpha) {
        if (fakeStatusBar == null) {
            throw new NullPointerException("Argument 'fakeStatusBar' of type View (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        fakeStatusBar.setVisibility(0);
        BarUtils.transparentStatusBar((Activity)fakeStatusBar.getContext());
        ViewGroup.LayoutParams layoutParams = fakeStatusBar.getLayoutParams();
        layoutParams.width = -1;
        layoutParams.height = BarUtils.getStatusBarHeight();
        fakeStatusBar.setBackgroundColor(Color.argb((int)alpha, (int)0, (int)0, (int)0));
    }

    public static void setStatusBarColor4Drawer(@NonNull Activity activity, @NonNull DrawerLayout drawer, @NonNull View fakeStatusBar, @ColorInt int color, boolean isTop) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (drawer == null) {
            throw new NullPointerException("Argument 'drawer' of type DrawerLayout (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fakeStatusBar == null) {
            throw new NullPointerException("Argument 'fakeStatusBar' of type View (#2 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarColor4Drawer(activity, drawer, fakeStatusBar, color, 112, isTop);
    }

    public static void setStatusBarColor4Drawer(@NonNull Activity activity, @NonNull DrawerLayout drawer, @NonNull View fakeStatusBar, @ColorInt int color, @IntRange(from=0L, to=255L) int alpha, boolean isTop) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (drawer == null) {
            throw new NullPointerException("Argument 'drawer' of type DrawerLayout (#1 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fakeStatusBar == null) {
            throw new NullPointerException("Argument 'fakeStatusBar' of type View (#2 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        drawer.setFitsSystemWindows(false);
        BarUtils.transparentStatusBar(activity);
        BarUtils.setStatusBarColor(fakeStatusBar, color, isTop ? alpha : 0);
        int len = drawer.getChildCount();
        for (int i = 0; i < len; ++i) {
            drawer.getChildAt(i).setFitsSystemWindows(false);
        }
        if (isTop) {
            BarUtils.hideAlphaView(activity);
        } else {
            BarUtils.addStatusBarAlpha(activity, alpha, false);
        }
    }

    public static void setStatusBarAlpha4Drawer(@NonNull Activity activity, @NonNull DrawerLayout drawer, @NonNull View fakeStatusBar, boolean isTop) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (drawer == null) {
            throw new NullPointerException("Argument 'drawer' of type DrawerLayout (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fakeStatusBar == null) {
            throw new NullPointerException("Argument 'fakeStatusBar' of type View (#2 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarAlpha4Drawer(activity, drawer, fakeStatusBar, 112, isTop);
    }

    public static void setStatusBarAlpha4Drawer(@NonNull Activity activity, @NonNull DrawerLayout drawer, @NonNull View fakeStatusBar, @IntRange(from=0L, to=255L) int alpha, boolean isTop) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (drawer == null) {
            throw new NullPointerException("Argument 'drawer' of type DrawerLayout (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fakeStatusBar == null) {
            throw new NullPointerException("Argument 'fakeStatusBar' of type View (#2 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        drawer.setFitsSystemWindows(false);
        BarUtils.transparentStatusBar(activity);
        BarUtils.setStatusBarAlpha(fakeStatusBar, isTop ? alpha : 0);
        int len = drawer.getChildCount();
        for (int i = 0; i < len; ++i) {
            drawer.getChildAt(i).setFitsSystemWindows(false);
        }
        if (isTop) {
            BarUtils.hideAlphaView(activity);
        } else {
            BarUtils.addStatusBarAlpha(activity, alpha, false);
        }
    }

    private static void addStatusBarColor(Activity activity, int color, int alpha, boolean isDecor) {
        ViewGroup parent = isDecor ? (ViewGroup)activity.getWindow().getDecorView() : (ViewGroup)activity.findViewById(0x1020002);
        View fakeStatusBarView = parent.findViewWithTag((Object)TAG_COLOR);
        if (fakeStatusBarView != null) {
            if (fakeStatusBarView.getVisibility() == 8) {
                fakeStatusBarView.setVisibility(0);
            }
            fakeStatusBarView.setBackgroundColor(BarUtils.getStatusBarColor(color, alpha));
        } else {
            parent.addView(BarUtils.createColorStatusBarView((Context)activity, color, alpha));
        }
    }

    private static void addStatusBarAlpha(Activity activity, int alpha, boolean isDecor) {
        ViewGroup parent = isDecor ? (ViewGroup)activity.getWindow().getDecorView() : (ViewGroup)activity.findViewById(0x1020002);
        View fakeStatusBarView = parent.findViewWithTag((Object)TAG_ALPHA);
        if (fakeStatusBarView != null) {
            if (fakeStatusBarView.getVisibility() == 8) {
                fakeStatusBarView.setVisibility(0);
            }
            fakeStatusBarView.setBackgroundColor(Color.argb((int)alpha, (int)0, (int)0, (int)0));
        } else {
            parent.addView(BarUtils.createAlphaStatusBarView((Context)activity, alpha));
        }
    }

    private static void hideColorView(Activity activity) {
        BarUtils.hideColorView(activity.getWindow());
    }

    private static void hideAlphaView(Activity activity) {
        BarUtils.hideAlphaView(activity.getWindow());
    }

    private static void hideColorView(Window window) {
        ViewGroup decorView = (ViewGroup)window.getDecorView();
        View fakeStatusBarView = decorView.findViewWithTag((Object)TAG_COLOR);
        if (fakeStatusBarView == null) {
            return;
        }
        fakeStatusBarView.setVisibility(8);
    }

    private static void hideAlphaView(Window window) {
        ViewGroup decorView = (ViewGroup)window.getDecorView();
        View fakeStatusBarView = decorView.findViewWithTag((Object)TAG_ALPHA);
        if (fakeStatusBarView == null) {
            return;
        }
        fakeStatusBarView.setVisibility(8);
    }

    private static void showColorView(Window window) {
        ViewGroup decorView = (ViewGroup)window.getDecorView();
        View fakeStatusBarView = decorView.findViewWithTag((Object)TAG_COLOR);
        if (fakeStatusBarView == null) {
            return;
        }
        fakeStatusBarView.setVisibility(0);
    }

    private static void showAlphaView(Window window) {
        ViewGroup decorView = (ViewGroup)window.getDecorView();
        View fakeStatusBarView = decorView.findViewWithTag((Object)TAG_ALPHA);
        if (fakeStatusBarView == null) {
            return;
        }
        fakeStatusBarView.setVisibility(0);
    }

    private static int getStatusBarColor(int color, int alpha) {
        if (alpha == 0) {
            return color;
        }
        float a = 1.0f - (float)alpha / 255.0f;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = (int)((double)((float)red * a) + 0.5);
        green = (int)((double)((float)green * a) + 0.5);
        blue = (int)((double)((float)blue * a) + 0.5);
        return Color.argb((int)255, (int)red, (int)green, (int)blue);
    }

    private static View createColorStatusBarView(Context context, int color, int alpha) {
        View statusBarView = new View(context);
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, BarUtils.getStatusBarHeight()));
        statusBarView.setBackgroundColor(BarUtils.getStatusBarColor(color, alpha));
        statusBarView.setTag((Object)TAG_COLOR);
        return statusBarView;
    }

    private static View createAlphaStatusBarView(Context context, int alpha) {
        View statusBarView = new View(context);
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, BarUtils.getStatusBarHeight()));
        statusBarView.setBackgroundColor(Color.argb((int)alpha, (int)0, (int)0, (int)0));
        statusBarView.setTag((Object)TAG_ALPHA);
        return statusBarView;
    }

    private static void transparentStatusBar(Activity activity) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        Window window = activity.getWindow();
        if (Build.VERSION.SDK_INT >= 21) {
            window.addFlags(Integer.MIN_VALUE);
            int option = 1280;
            window.getDecorView().setSystemUiVisibility(option);
            window.setStatusBarColor(0);
        } else {
            window.addFlags(0x4000000);
        }
    }

    public static int getActionBarHeight() {
        TypedValue tv = new TypedValue();
        if (Utils.getApp().getTheme().resolveAttribute(16843499, tv, true)) {
            return TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)Utils.getApp().getResources().getDisplayMetrics());
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.EXPAND_STATUS_BAR")
    public static void setNotificationBarVisibility(boolean isVisible) {
        String methodName = isVisible ? (Build.VERSION.SDK_INT <= 16 ? "expand" : "expandNotificationsPanel") : (Build.VERSION.SDK_INT <= 16 ? "collapse" : "collapsePanels");
        BarUtils.invokePanels(methodName);
    }

    private static void invokePanels(String methodName) {
        try {
            Object service = Utils.getApp().getSystemService("statusbar");
            Class<?> statusBarManager = Class.forName("android.app.StatusBarManager");
            Method expand = statusBarManager.getMethod(methodName, new Class[0]);
            expand.invoke(service, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getNavBarHeight() {
        Resources res = Resources.getSystem();
        int resourceId = res.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId != 0) {
            return res.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    @RequiresApi(api=19)
    public static void setNavBarVisibility(@NonNull Activity activity, boolean isVisible) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setNavBarVisibility(activity.getWindow(), isVisible);
    }

    @RequiresApi(value=19)
    public static void setNavBarVisibility(@NonNull Window window, boolean isVisible) {
        if (window == null) {
            throw new NullPointerException("Argument 'window' of type Window (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        int uiOptions = 4610;
        View decorView = window.getDecorView();
        if (isVisible) {
            decorView.setSystemUiVisibility(decorView.getSystemUiVisibility() & 0xFFFFEDFD);
        } else {
            decorView.setSystemUiVisibility(decorView.getSystemUiVisibility() | 0x1202);
        }
    }

    public static boolean isNavBarVisible(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return BarUtils.isNavBarVisible(activity.getWindow());
    }

    public static boolean isNavBarVisible(@NonNull Window window) {
        if (window == null) {
            throw new NullPointerException("Argument 'window' of type Window (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        View decorView = window.getDecorView();
        int visibility = decorView.getSystemUiVisibility();
        return (visibility & 2) == 0;
    }

    @RequiresApi(value=21)
    public static void setNavBarColor(@NonNull Activity activity, @ColorInt int color) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setNavBarColor(activity.getWindow(), color);
    }

    @RequiresApi(value=21)
    public static void setNavBarColor(@NonNull Window window, @ColorInt int color) {
        if (window == null) {
            throw new NullPointerException("Argument 'window' of type Window (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        window.setNavigationBarColor(color);
    }

    @RequiresApi(value=21)
    public static int getNavBarColor(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return BarUtils.getNavBarColor(activity.getWindow());
    }

    @RequiresApi(value=21)
    public static int getNavBarColor(@NonNull Window window) {
        if (window == null) {
            throw new NullPointerException("Argument 'window' of type Window (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return window.getNavigationBarColor();
    }

    public static boolean isSupportNavBar() {
        if (Build.VERSION.SDK_INT >= 17) {
            WindowManager wm = (WindowManager)Utils.getApp().getSystemService("window");
            Display display = wm.getDefaultDisplay();
            Point size = new Point();
            Point realSize = new Point();
            display.getSize(size);
            display.getRealSize(realSize);
            return realSize.y != size.y || realSize.x != size.x;
        }
        boolean menu = ViewConfiguration.get((Context)Utils.getApp()).hasPermanentMenuKey();
        boolean back = KeyCharacterMap.deviceHasKey((int)4);
        return !menu && !back;
    }
}

