/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class ZipUtils {
    private static final int BUFFER_LEN = 8192;

    private ZipUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean zipFiles(Collection<String> collection, String string) {
        return ZipUtils.zipFiles(collection, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipFiles(Collection<String> collection, String string, String string2) {
        if (collection == null || string == null) {
            return false;
        }
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            for (String string3 : collection) {
                if (ZipUtils.zipFile(ZipUtils.getFileByPath(string3), "", zipOutputStream, string2)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.finish();
                zipOutputStream.close();
            }
        }
    }

    public static boolean zipFiles(Collection<File> collection, File file) {
        return ZipUtils.zipFiles(collection, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipFiles(Collection<File> collection, File file, String string) {
        if (collection == null || file == null) {
            return false;
        }
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            for (File file2 : collection) {
                if (ZipUtils.zipFile(file2, "", zipOutputStream, string)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.finish();
                zipOutputStream.close();
            }
        }
    }

    public static boolean zipFile(String string, String string2) {
        return ZipUtils.zipFile(ZipUtils.getFileByPath(string), ZipUtils.getFileByPath(string2), null);
    }

    public static boolean zipFile(String string, String string2, String string3) {
        return ZipUtils.zipFile(ZipUtils.getFileByPath(string), ZipUtils.getFileByPath(string2), string3);
    }

    public static boolean zipFile(File file, File file2) {
        return ZipUtils.zipFile(file, file2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipFile(File file, File file2, String string) {
        if (file == null || file2 == null) {
            return false;
        }
        try (ZipOutputStream zipOutputStream = null;){
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            boolean bl = ZipUtils.zipFile(file, "", zipOutputStream, string);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean zipFile(File file, String string, ZipOutputStream zipOutputStream, String string2) {
        string = string + (ZipUtils.isSpace(string) ? "" : File.separator) + file.getName();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null || fileArray.length <= 0) {
                ZipEntry zipEntry = new ZipEntry(string + '/');
                zipEntry.setComment(string2);
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.closeEntry();
            } else {
                for (File file2 : fileArray) {
                    if (ZipUtils.zipFile(file2, string, zipOutputStream, string2)) continue;
                    return false;
                }
            }
        } else {
            try (InputStream inputStream = null;){
                int n;
                inputStream = new BufferedInputStream(new FileInputStream(file));
                ZipEntry zipEntry = new ZipEntry(string);
                zipEntry.setComment(string2);
                zipOutputStream.putNextEntry(zipEntry);
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray, 0, 8192)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                zipOutputStream.closeEntry();
            }
        }
        return true;
    }

    public static List<File> unzipFile(String string, String string2) {
        return ZipUtils.unzipFileByKeyword(string, string2, null);
    }

    public static List<File> unzipFile(File file, File file2) {
        return ZipUtils.unzipFileByKeyword(file, file2, null);
    }

    public static List<File> unzipFileByKeyword(String string, String string2, String string3) {
        return ZipUtils.unzipFileByKeyword(ZipUtils.getFileByPath(string), ZipUtils.getFileByPath(string2), string3);
    }

    public static List<File> unzipFileByKeyword(File file, File file2, String string) {
        if (file == null || file2 == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        if (ZipUtils.isSpace(string)) {
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                if (string2.contains("../")) {
                    Log.e((String)"ZipUtils", (String)"it's dangerous!");
                    return arrayList;
                }
                if (ZipUtils.unzipChildFile(file2, arrayList, zipFile, zipEntry, string2)) continue;
                return arrayList;
            }
        } else {
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string3 = zipEntry.getName();
                if (string3.contains("../")) {
                    Log.e((String)"ZipUtils", (String)"it's dangerous!");
                    return arrayList;
                }
                if (!string3.contains(string) || ZipUtils.unzipChildFile(file2, arrayList, zipFile, zipEntry, string3)) continue;
                return arrayList;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unzipChildFile(File file, List<File> list, ZipFile zipFile, ZipEntry zipEntry, String string) {
        String string2 = file + File.separator + string;
        File file2 = new File(string2);
        list.add(file2);
        if (zipEntry.isDirectory()) {
            if (!ZipUtils.createOrExistsDir(file2)) {
                return false;
            }
        } else {
            if (!ZipUtils.createOrExistsFile(file2)) {
                return false;
            }
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                int n;
                inputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                outputStream = new BufferedOutputStream(new FileOutputStream(file2));
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        return true;
    }

    public static List<String> getFilesPath(String string) {
        return ZipUtils.getFilesPath(ZipUtils.getFileByPath(string));
    }

    public static List<String> getFilesPath(File file) {
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<? extends ZipEntry> enumeration = new ZipFile(file).entries();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement().getName());
        }
        return arrayList;
    }

    public static List<String> getComments(String string) {
        return ZipUtils.getComments(ZipUtils.getFileByPath(string));
    }

    public static List<String> getComments(File file) {
        if (file == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<? extends ZipEntry> enumeration = new ZipFile(file).entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            arrayList.add(zipEntry.getComment());
        }
        return arrayList;
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!ZipUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private static File getFileByPath(String string) {
        return ZipUtils.isSpace(string) ? null : new File(string);
    }

    private static boolean isSpace(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

