/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class TimeUtils {
    @SuppressLint(value={"SimpleDateFormat"})
    private static final DateFormat DEFAULT_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String[] CHINESE_ZODIAC = new String[]{"\u7334", "\u9e21", "\u72d7", "\u732a", "\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a"};
    private static final int[] ZODIAC_FLAGS = new int[]{20, 19, 21, 21, 21, 22, 23, 23, 23, 24, 23, 22};
    private static final String[] ZODIAC = new String[]{"\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u9b54\u7faf\u5ea7"};

    private TimeUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String millis2String(long l) {
        return TimeUtils.millis2String(l, DEFAULT_FORMAT);
    }

    public static String millis2String(long l, @NonNull DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return dateFormat.format(new Date(l));
    }

    public static long string2Millis(String string) {
        return TimeUtils.string2Millis(string, DEFAULT_FORMAT);
    }

    public static long string2Millis(String string, @NonNull DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        try {
            return dateFormat.parse(string).getTime();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return -1L;
        }
    }

    public static Date string2Date(String string) {
        return TimeUtils.string2Date(string, DEFAULT_FORMAT);
    }

    public static Date string2Date(String string, @NonNull DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        try {
            return dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
    }

    public static String date2String(Date date) {
        return TimeUtils.date2String(date, DEFAULT_FORMAT);
    }

    public static String date2String(Date date, @NonNull DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return dateFormat.format(date);
    }

    public static long date2Millis(Date date) {
        return date.getTime();
    }

    public static Date millis2Date(long l) {
        return new Date(l);
    }

    public static long getTimeSpan(String string, String string2, int n) {
        return TimeUtils.getTimeSpan(string, string2, DEFAULT_FORMAT, n);
    }

    public static long getTimeSpan(String string, String string2, @NonNull DateFormat dateFormat, int n) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#2 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.millis2TimeSpan(TimeUtils.string2Millis(string, dateFormat) - TimeUtils.string2Millis(string2, dateFormat), n);
    }

    public static long getTimeSpan(Date date, Date date2, int n) {
        return TimeUtils.millis2TimeSpan(TimeUtils.date2Millis(date) - TimeUtils.date2Millis(date2), n);
    }

    public static long getTimeSpan(long l, long l2, int n) {
        return TimeUtils.millis2TimeSpan(l - l2, n);
    }

    public static String getFitTimeSpan(String string, String string2, int n) {
        long l = TimeUtils.string2Millis(string, DEFAULT_FORMAT) - TimeUtils.string2Millis(string2, DEFAULT_FORMAT);
        return TimeUtils.millis2FitTimeSpan(l, n);
    }

    public static String getFitTimeSpan(String string, String string2, @NonNull DateFormat dateFormat, int n) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#2 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        long l = TimeUtils.string2Millis(string, dateFormat) - TimeUtils.string2Millis(string2, dateFormat);
        return TimeUtils.millis2FitTimeSpan(l, n);
    }

    public static String getFitTimeSpan(Date date, Date date2, int n) {
        return TimeUtils.millis2FitTimeSpan(TimeUtils.date2Millis(date) - TimeUtils.date2Millis(date2), n);
    }

    public static String getFitTimeSpan(long l, long l2, int n) {
        return TimeUtils.millis2FitTimeSpan(l - l2, n);
    }

    public static long getNowMills() {
        return System.currentTimeMillis();
    }

    public static String getNowString() {
        return TimeUtils.millis2String(System.currentTimeMillis(), DEFAULT_FORMAT);
    }

    public static String getNowString(@NonNull DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.millis2String(System.currentTimeMillis(), dateFormat);
    }

    public static Date getNowDate() {
        return new Date();
    }

    public static long getTimeSpanByNow(String string, int n) {
        return TimeUtils.getTimeSpan(string, TimeUtils.getNowString(), DEFAULT_FORMAT, n);
    }

    public static long getTimeSpanByNow(String string, @NonNull DateFormat dateFormat, int n) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.getTimeSpan(string, TimeUtils.getNowString(dateFormat), dateFormat, n);
    }

    public static long getTimeSpanByNow(Date date, int n) {
        return TimeUtils.getTimeSpan(date, new Date(), n);
    }

    public static long getTimeSpanByNow(long l, int n) {
        return TimeUtils.getTimeSpan(l, System.currentTimeMillis(), n);
    }

    public static String getFitTimeSpanByNow(String string, int n) {
        return TimeUtils.getFitTimeSpan(string, TimeUtils.getNowString(), DEFAULT_FORMAT, n);
    }

    public static String getFitTimeSpanByNow(String string, @NonNull DateFormat dateFormat, int n) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.getFitTimeSpan(string, TimeUtils.getNowString(dateFormat), dateFormat, n);
    }

    public static String getFitTimeSpanByNow(Date date, int n) {
        return TimeUtils.getFitTimeSpan(date, TimeUtils.getNowDate(), n);
    }

    public static String getFitTimeSpanByNow(long l, int n) {
        return TimeUtils.getFitTimeSpan(l, System.currentTimeMillis(), n);
    }

    public static String getFriendlyTimeSpanByNow(String string) {
        return TimeUtils.getFriendlyTimeSpanByNow(string, DEFAULT_FORMAT);
    }

    public static String getFriendlyTimeSpanByNow(String string, @NonNull DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.getFriendlyTimeSpanByNow(TimeUtils.string2Millis(string, dateFormat));
    }

    public static String getFriendlyTimeSpanByNow(Date date) {
        return TimeUtils.getFriendlyTimeSpanByNow(date.getTime());
    }

    public static String getFriendlyTimeSpanByNow(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (l3 < 0L) {
            return String.format("%tc", l);
        }
        if (l3 < 1000L) {
            return "\u521a\u521a";
        }
        if (l3 < 60000L) {
            return String.format(Locale.getDefault(), "%d\u79d2\u524d", l3 / 1000L);
        }
        if (l3 < 3600000L) {
            return String.format(Locale.getDefault(), "%d\u5206\u949f\u524d", l3 / 60000L);
        }
        long l4 = TimeUtils.getWeeOfToday();
        if (l >= l4) {
            return String.format("\u4eca\u5929%tR", l);
        }
        if (l >= l4 - 86400000L) {
            return String.format("\u6628\u5929%tR", l);
        }
        return String.format("%tF", l);
    }

    private static long getWeeOfToday() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static long getMillis(long l, long l2, int n) {
        return l + TimeUtils.timeSpan2Millis(l2, n);
    }

    public static long getMillis(String string, long l, int n) {
        return TimeUtils.getMillis(string, DEFAULT_FORMAT, l, n);
    }

    public static long getMillis(String string, @NonNull DateFormat dateFormat, long l, int n) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.string2Millis(string, dateFormat) + TimeUtils.timeSpan2Millis(l, n);
    }

    public static long getMillis(Date date, long l, int n) {
        return TimeUtils.date2Millis(date) + TimeUtils.timeSpan2Millis(l, n);
    }

    public static String getString(long l, long l2, int n) {
        return TimeUtils.getString(l, DEFAULT_FORMAT, l2, n);
    }

    public static String getString(long l, @NonNull DateFormat dateFormat, long l2, int n) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.millis2String(l + TimeUtils.timeSpan2Millis(l2, n), dateFormat);
    }

    public static String getString(String string, long l, int n) {
        return TimeUtils.getString(string, DEFAULT_FORMAT, l, n);
    }

    public static String getString(String string, @NonNull DateFormat dateFormat, long l, int n) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.millis2String(TimeUtils.string2Millis(string, dateFormat) + TimeUtils.timeSpan2Millis(l, n), dateFormat);
    }

    public static String getString(Date date, long l, int n) {
        return TimeUtils.getString(date, DEFAULT_FORMAT, l, n);
    }

    public static String getString(Date date, @NonNull DateFormat dateFormat, long l, int n) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.millis2String(TimeUtils.date2Millis(date) + TimeUtils.timeSpan2Millis(l, n), dateFormat);
    }

    public static Date getDate(long l, long l2, int n) {
        return TimeUtils.millis2Date(l + TimeUtils.timeSpan2Millis(l2, n));
    }

    public static Date getDate(String string, long l, int n) {
        return TimeUtils.getDate(string, DEFAULT_FORMAT, l, n);
    }

    public static Date getDate(String string, @NonNull DateFormat dateFormat, long l, int n) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.millis2Date(TimeUtils.string2Millis(string, dateFormat) + TimeUtils.timeSpan2Millis(l, n));
    }

    public static Date getDate(Date date, long l, int n) {
        return TimeUtils.millis2Date(TimeUtils.date2Millis(date) + TimeUtils.timeSpan2Millis(l, n));
    }

    public static long getMillisByNow(long l, int n) {
        return TimeUtils.getMillis(TimeUtils.getNowMills(), l, n);
    }

    public static String getStringByNow(long l, int n) {
        return TimeUtils.getStringByNow(l, DEFAULT_FORMAT, n);
    }

    public static String getStringByNow(long l, @NonNull DateFormat dateFormat, int n) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.getString(TimeUtils.getNowMills(), dateFormat, l, n);
    }

    public static Date getDateByNow(long l, int n) {
        return TimeUtils.getDate(TimeUtils.getNowMills(), l, n);
    }

    public static boolean isToday(String string) {
        return TimeUtils.isToday(TimeUtils.string2Millis(string, DEFAULT_FORMAT));
    }

    public static boolean isToday(String string, @NonNull DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.isToday(TimeUtils.string2Millis(string, dateFormat));
    }

    public static boolean isToday(Date date) {
        return TimeUtils.isToday(date.getTime());
    }

    public static boolean isToday(long l) {
        long l2 = TimeUtils.getWeeOfToday();
        return l >= l2 && l < l2 + 86400000L;
    }

    public static boolean isLeapYear(String string) {
        return TimeUtils.isLeapYear(TimeUtils.string2Date(string, DEFAULT_FORMAT));
    }

    public static boolean isLeapYear(String string, @NonNull DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.isLeapYear(TimeUtils.string2Date(string, dateFormat));
    }

    public static boolean isLeapYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(1);
        return TimeUtils.isLeapYear(n);
    }

    public static boolean isLeapYear(long l) {
        return TimeUtils.isLeapYear(TimeUtils.millis2Date(l));
    }

    public static boolean isLeapYear(int n) {
        return n % 4 == 0 && n % 100 != 0 || n % 400 == 0;
    }

    public static String getChineseWeek(String string) {
        return TimeUtils.getChineseWeek(TimeUtils.string2Date(string, DEFAULT_FORMAT));
    }

    public static String getChineseWeek(String string, @NonNull DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.getChineseWeek(TimeUtils.string2Date(string, dateFormat));
    }

    public static String getChineseWeek(Date date) {
        return new SimpleDateFormat("E", Locale.CHINA).format(date);
    }

    public static String getChineseWeek(long l) {
        return TimeUtils.getChineseWeek(new Date(l));
    }

    public static String getUSWeek(String string) {
        return TimeUtils.getUSWeek(TimeUtils.string2Date(string, DEFAULT_FORMAT));
    }

    public static String getUSWeek(String string, @NonNull DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.getUSWeek(TimeUtils.string2Date(string, dateFormat));
    }

    public static String getUSWeek(Date date) {
        return new SimpleDateFormat("EEEE", Locale.US).format(date);
    }

    public static String getUSWeek(long l) {
        return TimeUtils.getUSWeek(new Date(l));
    }

    @Deprecated
    public static int getWeekIndex(String string) {
        return TimeUtils.getWeekIndex(TimeUtils.string2Date(string, DEFAULT_FORMAT));
    }

    @Deprecated
    public static int getWeekIndex(String string, @NonNull DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.getWeekIndex(TimeUtils.string2Date(string, dateFormat));
    }

    @Deprecated
    public static int getWeekIndex(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7);
    }

    @Deprecated
    public static int getWeekIndex(long l) {
        return TimeUtils.getWeekIndex(TimeUtils.millis2Date(l));
    }

    @Deprecated
    public static int getWeekOfMonth(String string) {
        return TimeUtils.getWeekOfMonth(TimeUtils.string2Date(string, DEFAULT_FORMAT));
    }

    @Deprecated
    public static int getWeekOfMonth(String string, @NonNull DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.getWeekOfMonth(TimeUtils.string2Date(string, dateFormat));
    }

    @Deprecated
    public static int getWeekOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(4);
    }

    @Deprecated
    public static int getWeekOfMonth(long l) {
        return TimeUtils.getWeekOfMonth(TimeUtils.millis2Date(l));
    }

    @Deprecated
    public static int getWeekOfYear(String string) {
        return TimeUtils.getWeekOfYear(TimeUtils.string2Date(string, DEFAULT_FORMAT));
    }

    @Deprecated
    public static int getWeekOfYear(String string, @NonNull DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.getWeekOfYear(TimeUtils.string2Date(string, dateFormat));
    }

    @Deprecated
    public static int getWeekOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(3);
    }

    @Deprecated
    public static int getWeekOfYear(long l) {
        return TimeUtils.getWeekOfYear(TimeUtils.millis2Date(l));
    }

    public static int getValueByCalendarField(String string, int n) {
        return TimeUtils.getValueByCalendarField(TimeUtils.string2Date(string, DEFAULT_FORMAT), n);
    }

    public static int getValueByCalendarField(String string, @NonNull DateFormat dateFormat, int n) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.getValueByCalendarField(TimeUtils.string2Date(string, dateFormat), n);
    }

    public static int getValueByCalendarField(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(n);
    }

    public static int getValueByCalendarField(long l, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        return calendar.get(n);
    }

    public static String getChineseZodiac(String string) {
        return TimeUtils.getChineseZodiac(TimeUtils.string2Date(string, DEFAULT_FORMAT));
    }

    public static String getChineseZodiac(String string, @NonNull DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.getChineseZodiac(TimeUtils.string2Date(string, dateFormat));
    }

    public static String getChineseZodiac(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return CHINESE_ZODIAC[calendar.get(1) % 12];
    }

    public static String getChineseZodiac(long l) {
        return TimeUtils.getChineseZodiac(TimeUtils.millis2Date(l));
    }

    public static String getChineseZodiac(int n) {
        return CHINESE_ZODIAC[n % 12];
    }

    public static String getZodiac(String string) {
        return TimeUtils.getZodiac(TimeUtils.string2Date(string, DEFAULT_FORMAT));
    }

    public static String getZodiac(String string, @NonNull DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("Argument 'format' of type DateFormat (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return TimeUtils.getZodiac(TimeUtils.string2Date(string, dateFormat));
    }

    public static String getZodiac(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(2) + 1;
        int n2 = calendar.get(5);
        return TimeUtils.getZodiac(n, n2);
    }

    public static String getZodiac(long l) {
        return TimeUtils.getZodiac(TimeUtils.millis2Date(l));
    }

    public static String getZodiac(int n, int n2) {
        return ZODIAC[n2 >= ZODIAC_FLAGS[n - 1] ? n - 1 : (n + 10) % 12];
    }

    private static long timeSpan2Millis(long l, int n) {
        return l * (long)n;
    }

    private static long millis2TimeSpan(long l, int n) {
        return l / (long)n;
    }

    private static String millis2FitTimeSpan(long l, int n) {
        if (n <= 0) {
            return null;
        }
        n = Math.min(n, 5);
        String[] stringArray = new String[]{"\u5929", "\u5c0f\u65f6", "\u5206\u949f", "\u79d2", "\u6beb\u79d2"};
        if (l == 0L) {
            return 0 + stringArray[n - 1];
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (l < 0L) {
            stringBuilder.append("-");
            l = -l;
        }
        int[] nArray = new int[]{86400000, 3600000, 60000, 1000, 1};
        for (int i = 0; i < n; ++i) {
            if (l < (long)nArray[i]) continue;
            long l2 = l / (long)nArray[i];
            l -= l2 * (long)nArray[i];
            stringBuilder.append(l2).append(stringArray[i]);
        }
        return stringBuilder.toString();
    }
}

