/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.util.Log;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadUtils {
    private static final Map<Integer, Map<Integer, ExecutorService>> TYPE_PRIORITY_POOLS = new ConcurrentHashMap<Integer, Map<Integer, ExecutorService>>();
    private static final Map<Task, ScheduledExecutorService> TASK_SCHEDULED = new ConcurrentHashMap<Task, ScheduledExecutorService>();
    private static final byte TYPE_SINGLE = -1;
    private static final byte TYPE_CACHED = -2;
    private static final byte TYPE_IO = -4;
    private static final byte TYPE_CPU = -8;
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();

    public static boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static ExecutorService getFixedPool(@IntRange(from=1L) int n) {
        return ThreadUtils.getPoolByTypeAndPriority(n);
    }

    public static ExecutorService getFixedPool(@IntRange(from=1L) int n, @IntRange(from=1L, to=10L) int n2) {
        return ThreadUtils.getPoolByTypeAndPriority(n, n2);
    }

    public static ExecutorService getSinglePool() {
        return ThreadUtils.getPoolByTypeAndPriority(-1);
    }

    public static ExecutorService getSinglePool(@IntRange(from=1L, to=10L) int n) {
        return ThreadUtils.getPoolByTypeAndPriority(-1, n);
    }

    public static ExecutorService getCachedPool() {
        return ThreadUtils.getPoolByTypeAndPriority(-2);
    }

    public static ExecutorService getCachedPool(@IntRange(from=1L, to=10L) int n) {
        return ThreadUtils.getPoolByTypeAndPriority(-2, n);
    }

    public static ExecutorService getIoPool() {
        return ThreadUtils.getPoolByTypeAndPriority(-2);
    }

    public static ExecutorService getIoPool(@IntRange(from=1L, to=10L) int n) {
        return ThreadUtils.getPoolByTypeAndPriority(-2, n);
    }

    public static ExecutorService getCpuPool() {
        return ThreadUtils.getPoolByTypeAndPriority(-8);
    }

    public static ExecutorService getCpuPool(@IntRange(from=1L, to=10L) int n) {
        return ThreadUtils.getPoolByTypeAndPriority(-8, n);
    }

    public static <T> void executeByFixed(@IntRange(from=1L) int n, Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(n), task);
    }

    public static <T> void executeByFixed(@IntRange(from=1L) int n, Task<T> task, @IntRange(from=1L, to=10L) int n2) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(n, n2), task);
    }

    public static <T> void executeByFixedWithDelay(@IntRange(from=1L) int n, Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(n), task, l, timeUnit);
    }

    public static <T> void executeByFixedWithDelay(@IntRange(from=1L) int n, Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n2) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(n, n2), task, l, timeUnit);
    }

    public static <T> void executeByFixedAtFixRate(@IntRange(from=1L) int n, Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(n), task, 0L, l, timeUnit);
    }

    public static <T> void executeByFixedAtFixRate(@IntRange(from=1L) int n, Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n2) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(n, n2), task, 0L, l, timeUnit);
    }

    public static <T> void executeByFixedAtFixRate(@IntRange(from=1L) int n, Task<T> task, long l, long l2, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(n), task, l, l2, timeUnit);
    }

    public static <T> void executeByFixedAtFixRate(@IntRange(from=1L) int n, Task<T> task, long l, long l2, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n2) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(n, n2), task, l, l2, timeUnit);
    }

    public static <T> void executeBySingle(Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-1), task);
    }

    public static <T> void executeBySingle(Task<T> task, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-1, n), task);
    }

    public static <T> void executeBySingleWithDelay(Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-1), task, l, timeUnit);
    }

    public static <T> void executeBySingleWithDelay(Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-1, n), task, l, timeUnit);
    }

    public static <T> void executeBySingleAtFixRate(Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-1), task, 0L, l, timeUnit);
    }

    public static <T> void executeBySingleAtFixRate(Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-1, n), task, 0L, l, timeUnit);
    }

    public static <T> void executeBySingleAtFixRate(Task<T> task, long l, long l2, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-1), task, l, l2, timeUnit);
    }

    public static <T> void executeBySingleAtFixRate(Task<T> task, long l, long l2, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-1, n), task, l, l2, timeUnit);
    }

    public static <T> void executeByCached(Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-2), task);
    }

    public static <T> void executeByCached(Task<T> task, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-2, n), task);
    }

    public static <T> void executeByCachedWithDelay(Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-2), task, l, timeUnit);
    }

    public static <T> void executeByCachedWithDelay(Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-2, n), task, l, timeUnit);
    }

    public static <T> void executeByCachedAtFixRate(Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-2), task, 0L, l, timeUnit);
    }

    public static <T> void executeByCachedAtFixRate(Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-2, n), task, 0L, l, timeUnit);
    }

    public static <T> void executeByCachedAtFixRate(Task<T> task, long l, long l2, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-2), task, l, l2, timeUnit);
    }

    public static <T> void executeByCachedAtFixRate(Task<T> task, long l, long l2, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-2, n), task, l, l2, timeUnit);
    }

    public static <T> void executeByIo(Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-4), task);
    }

    public static <T> void executeByIo(Task<T> task, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-4, n), task);
    }

    public static <T> void executeByIoWithDelay(Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-4), task, l, timeUnit);
    }

    public static <T> void executeByIoWithDelay(Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-4, n), task, l, timeUnit);
    }

    public static <T> void executeByIoAtFixRate(Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-4), task, 0L, l, timeUnit);
    }

    public static <T> void executeByIoAtFixRate(Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-4, n), task, 0L, l, timeUnit);
    }

    public static <T> void executeByIoAtFixRate(Task<T> task, long l, long l2, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-4), task, l, l2, timeUnit);
    }

    public static <T> void executeByIoAtFixRate(Task<T> task, long l, long l2, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-4, n), task, l, l2, timeUnit);
    }

    public static <T> void executeByCpu(Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-8), task);
    }

    public static <T> void executeByCpu(Task<T> task, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-8, n), task);
    }

    public static <T> void executeByCpuWithDelay(Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-8), task, l, timeUnit);
    }

    public static <T> void executeByCpuWithDelay(Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-8, n), task, l, timeUnit);
    }

    public static <T> void executeByCpuAtFixRate(Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-8), task, 0L, l, timeUnit);
    }

    public static <T> void executeByCpuAtFixRate(Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-8, n), task, 0L, l, timeUnit);
    }

    public static <T> void executeByCpuAtFixRate(Task<T> task, long l, long l2, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-8), task, l, l2, timeUnit);
    }

    public static <T> void executeByCpuAtFixRate(Task<T> task, long l, long l2, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-8, n), task, l, l2, timeUnit);
    }

    public static <T> void executeByCustom(ExecutorService executorService, Task<T> task) {
        ThreadUtils.execute(executorService, task);
    }

    public static <T> void executeByCustomWithDelay(ExecutorService executorService, Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeWithDelay(executorService, task, l, timeUnit);
    }

    public static <T> void executeByCustomAtFixRate(ExecutorService executorService, Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(executorService, task, 0L, l, timeUnit);
    }

    public static <T> void executeByCustomAtFixRate(ExecutorService executorService, Task<T> task, long l, long l2, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(executorService, task, l, l2, timeUnit);
    }

    public static void cancel(Task task) {
        task.cancel();
    }

    private static <T> void execute(ExecutorService executorService, Task<T> task) {
        ThreadUtils.executeWithDelay(executorService, task, 0L, TimeUnit.MILLISECONDS);
    }

    private static <T> void executeWithDelay(final ExecutorService executorService, final Task<T> task, long l, TimeUnit timeUnit) {
        if (l <= 0L) {
            ThreadUtils.getScheduledByTask(task).execute(new Runnable(){

                @Override
                public void run() {
                    executorService.execute(task);
                }
            });
        } else {
            ThreadUtils.getScheduledByTask(task).schedule(new Runnable(){

                @Override
                public void run() {
                    executorService.execute(task);
                }
            }, l, timeUnit);
        }
    }

    private static <T> void executeAtFixedRate(final ExecutorService executorService, final Task<T> task, long l, long l2, TimeUnit timeUnit) {
        ((Task)task).isSchedule = true;
        ThreadUtils.getScheduledByTask(task).scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                executorService.execute(task);
            }
        }, l, l2, timeUnit);
    }

    private static ScheduledExecutorService getScheduledByTask(Task task) {
        ScheduledExecutorService scheduledExecutorService = TASK_SCHEDULED.get(task);
        if (scheduledExecutorService == null) {
            UtilsThreadFactory utilsThreadFactory = new UtilsThreadFactory("scheduled", 10);
            scheduledExecutorService = Executors.newScheduledThreadPool(1, utilsThreadFactory);
            TASK_SCHEDULED.put(task, scheduledExecutorService);
        }
        return scheduledExecutorService;
    }

    private static void removeScheduleByTask(Task task) {
        ScheduledExecutorService scheduledExecutorService = TASK_SCHEDULED.get(task);
        if (scheduledExecutorService != null) {
            TASK_SCHEDULED.remove(task);
            ThreadUtils.shutdownAndAwaitTermination(scheduledExecutorService);
        }
    }

    private static ExecutorService getPoolByTypeAndPriority(int n) {
        return ThreadUtils.getPoolByTypeAndPriority(n, 5);
    }

    private static ExecutorService getPoolByTypeAndPriority(int n, int n2) {
        ExecutorService executorService;
        Map<Integer, ExecutorService> map = TYPE_PRIORITY_POOLS.get(n);
        if (map == null) {
            map = new ConcurrentHashMap<Integer, ExecutorService>();
            executorService = ThreadUtils.createPoolByTypeAndPriority(n, n2);
            map.put(n2, executorService);
            TYPE_PRIORITY_POOLS.put(n, map);
        } else {
            executorService = map.get(n2);
            if (executorService == null) {
                executorService = ThreadUtils.createPoolByTypeAndPriority(n, n2);
                map.put(n2, executorService);
            }
        }
        return executorService;
    }

    private static ExecutorService createPoolByTypeAndPriority(int n, int n2) {
        switch (n) {
            case -1: {
                return Executors.newSingleThreadExecutor(new UtilsThreadFactory("single", n2));
            }
            case -2: {
                return Executors.newCachedThreadPool(new UtilsThreadFactory("cached", n2));
            }
            case -4: {
                return new ThreadPoolExecutor(2 * CPU_COUNT + 1, 2 * CPU_COUNT + 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), new UtilsThreadFactory("io", n2));
            }
            case -8: {
                return new ThreadPoolExecutor(CPU_COUNT + 1, 2 * CPU_COUNT + 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), new UtilsThreadFactory("cpu", n2));
            }
        }
        return Executors.newFixedThreadPool(n, new UtilsThreadFactory("fixed(" + n + ")", n2));
    }

    private static void shutdownAndAwaitTermination(ExecutorService executorService) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
            interruptedException.printStackTrace();
        }
    }

    private static class Deliver {
        private static final Handler MAIN_HANDLER;

        private Deliver() {
        }

        private static void post(Runnable runnable) {
            if (MAIN_HANDLER != null) {
                MAIN_HANDLER.post(runnable);
            } else {
                runnable.run();
            }
        }

        static {
            Looper looper;
            try {
                looper = Looper.getMainLooper();
            }
            catch (Exception exception) {
                looper = null;
            }
            MAIN_HANDLER = looper != null ? new Handler(looper) : null;
        }
    }

    private static final class UtilsThreadFactory
    extends AtomicLong
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final String namePrefix;
        private final int priority;

        UtilsThreadFactory(String string, int n) {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = string + "-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";
            this.priority = n;
        }

        @Override
        public Thread newThread(@NonNull Runnable runnable) {
            if (runnable == null) {
                throw new NullPointerException("Argument 'r' of type Runnable (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
            }
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.getAndIncrement(), 0L){

                @Override
                public void run() {
                    try {
                        super.run();
                    }
                    catch (Throwable throwable) {
                        Log.e((String)"ThreadUtils", (String)"Request threw uncaught throwable", (Throwable)throwable);
                    }
                }
            };
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            thread.setPriority(this.priority);
            return thread;
        }
    }

    public static abstract class Task<T>
    implements Runnable {
        private boolean isSchedule;
        private volatile int state = 0;
        private static final int NEW = 0;
        private static final int COMPLETING = 1;
        private static final int CANCELLED = 2;
        private static final int EXCEPTIONAL = 3;

        public abstract T doInBackground();

        public abstract void onSuccess(T var1);

        public abstract void onCancel();

        public abstract void onFail(Throwable var1);

        @Override
        public void run() {
            try {
                final T t = this.doInBackground();
                if (this.state != 0) {
                    return;
                }
                if (this.isSchedule) {
                    Deliver.post(new Runnable(){

                        @Override
                        public void run() {
                            Task.this.onSuccess(t);
                        }
                    });
                } else {
                    this.state = 1;
                    Deliver.post(new Runnable(){

                        @Override
                        public void run() {
                            Task.this.onSuccess(t);
                            ThreadUtils.removeScheduleByTask(Task.this);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                if (this.state != 0) {
                    return;
                }
                this.state = 3;
                Deliver.post(new Runnable(){

                    @Override
                    public void run() {
                        Task.this.onFail(throwable);
                        ThreadUtils.removeScheduleByTask(Task.this);
                    }
                });
            }
        }

        public void cancel() {
            if (this.state != 0) {
                return;
            }
            this.state = 2;
            Deliver.post(new Runnable(){

                @Override
                public void run() {
                    Task.this.onCancel();
                    ThreadUtils.removeScheduleByTask(Task.this);
                }
            });
        }
    }

    public static abstract class SimpleTask<T>
    extends Task<T> {
        @Override
        public void onCancel() {
            Log.e((String)"ThreadUtils", (String)("onCancel: " + Thread.currentThread()));
        }

        @Override
        public void onFail(Throwable throwable) {
            Log.e((String)"ThreadUtils", (String)"onFail: ", (Throwable)throwable);
        }
    }
}

