/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntRange;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.design.widget.Snackbar;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;

public final class SnackbarUtils {
    public static final int LENGTH_INDEFINITE = -2;
    public static final int LENGTH_SHORT = -1;
    public static final int LENGTH_LONG = 0;
    private static final int COLOR_DEFAULT = -16777217;
    private static final int COLOR_SUCCESS = -13912576;
    private static final int COLOR_WARNING = -16128;
    private static final int COLOR_ERROR = -65536;
    private static final int COLOR_MESSAGE = -1;
    private static WeakReference<Snackbar> sReference;
    private View view;
    private CharSequence message;
    private int messageColor;
    private int bgColor;
    private int bgResource;
    private int duration;
    private CharSequence actionText;
    private int actionTextColor;
    private View.OnClickListener actionListener;
    private int bottomMargin;

    private SnackbarUtils(View view) {
        this.setDefault();
        this.view = view;
    }

    private void setDefault() {
        this.message = "";
        this.messageColor = -16777217;
        this.bgColor = -16777217;
        this.bgResource = -1;
        this.duration = -1;
        this.actionText = "";
        this.actionTextColor = -16777217;
        this.bottomMargin = 0;
    }

    public static SnackbarUtils with(@NonNull View view) {
        if (view == null) {
            throw new NullPointerException("Argument 'view' of type View (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return new SnackbarUtils(view);
    }

    public SnackbarUtils setMessage(@NonNull CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException("Argument 'msg' of type CharSequence (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.message = charSequence;
        return this;
    }

    public SnackbarUtils setMessageColor(@ColorInt int n) {
        this.messageColor = n;
        return this;
    }

    public SnackbarUtils setBgColor(@ColorInt int n) {
        this.bgColor = n;
        return this;
    }

    public SnackbarUtils setBgResource(@DrawableRes int n) {
        this.bgResource = n;
        return this;
    }

    public SnackbarUtils setDuration(int n) {
        this.duration = n;
        return this;
    }

    public SnackbarUtils setAction(@NonNull CharSequence charSequence, @NonNull View.OnClickListener onClickListener) {
        if (charSequence == null) {
            throw new NullPointerException("Argument 'text' of type CharSequence (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (onClickListener == null) {
            throw new NullPointerException("Argument 'listener' of type View.OnClickListener (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.setAction(charSequence, -16777217, onClickListener);
    }

    public SnackbarUtils setAction(@NonNull CharSequence charSequence, @ColorInt int n, @NonNull View.OnClickListener onClickListener) {
        if (charSequence == null) {
            throw new NullPointerException("Argument 'text' of type CharSequence (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (onClickListener == null) {
            throw new NullPointerException("Argument 'listener' of type View.OnClickListener (#2 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.actionText = charSequence;
        this.actionTextColor = n;
        this.actionListener = onClickListener;
        return this;
    }

    public SnackbarUtils setBottomMargin(@IntRange(from=1L) int n) {
        this.bottomMargin = n;
        return this;
    }

    public void show() {
        ForegroundColorSpan foregroundColorSpan;
        SpannableString spannableString;
        View view = this.view;
        if (view == null) {
            return;
        }
        if (this.messageColor != -16777217) {
            spannableString = new SpannableString(this.message);
            foregroundColorSpan = new ForegroundColorSpan(this.messageColor);
            spannableString.setSpan((Object)foregroundColorSpan, 0, spannableString.length(), 33);
            sReference = new WeakReference<Snackbar>(Snackbar.make((View)view, (CharSequence)spannableString, (int)this.duration));
        } else {
            sReference = new WeakReference<Snackbar>(Snackbar.make((View)view, (CharSequence)this.message, (int)this.duration));
        }
        spannableString = (Snackbar)sReference.get();
        foregroundColorSpan = spannableString.getView();
        if (this.bgResource != -1) {
            foregroundColorSpan.setBackgroundResource(this.bgResource);
        } else if (this.bgColor != -16777217) {
            foregroundColorSpan.setBackgroundColor(this.bgColor);
        }
        if (this.bottomMargin != 0) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)foregroundColorSpan.getLayoutParams();
            marginLayoutParams.bottomMargin = this.bottomMargin;
        }
        if (this.actionText.length() > 0 && this.actionListener != null) {
            if (this.actionTextColor != -16777217) {
                spannableString.setActionTextColor(this.actionTextColor);
            }
            spannableString.setAction(this.actionText, this.actionListener);
        }
        spannableString.show();
    }

    public void showSuccess() {
        this.bgColor = -13912576;
        this.messageColor = -1;
        this.actionTextColor = -1;
        this.show();
    }

    public void showWarning() {
        this.bgColor = -16128;
        this.messageColor = -1;
        this.actionTextColor = -1;
        this.show();
    }

    public void showError() {
        this.bgColor = -65536;
        this.messageColor = -1;
        this.actionTextColor = -1;
        this.show();
    }

    public static void dismiss() {
        if (sReference != null && sReference.get() != null) {
            ((Snackbar)sReference.get()).dismiss();
            sReference = null;
        }
    }

    public static View getView() {
        Snackbar snackbar = (Snackbar)sReference.get();
        if (snackbar == null) {
            return null;
        }
        return snackbar.getView();
    }

    public static void addView(@LayoutRes int n, @NonNull ViewGroup.LayoutParams layoutParams) {
        if (layoutParams == null) {
            throw new NullPointerException("Argument 'params' of type ViewGroup.LayoutParams (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        View view = SnackbarUtils.getView();
        if (view != null) {
            view.setPadding(0, 0, 0, 0);
            Snackbar.SnackbarLayout snackbarLayout = (Snackbar.SnackbarLayout)view;
            View view2 = LayoutInflater.from((Context)view.getContext()).inflate(n, null);
            snackbarLayout.addView(view2, -1, layoutParams);
        }
    }

    public static void addView(@NonNull View view, @NonNull ViewGroup.LayoutParams layoutParams) {
        if (view == null) {
            throw new NullPointerException("Argument 'child' of type View (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (layoutParams == null) {
            throw new NullPointerException("Argument 'params' of type ViewGroup.LayoutParams (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        View view2 = SnackbarUtils.getView();
        if (view2 != null) {
            view2.setPadding(0, 0, 0, 0);
            Snackbar.SnackbarLayout snackbarLayout = (Snackbar.SnackbarLayout)view2;
            snackbarLayout.addView(view, layoutParams);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Duration {
    }
}

