/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.v4.util.SimpleArrayMap;
import com.blankj.utilcode.util.Utils;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

@SuppressLint(value={"ApplySharedPref"})
public final class SPUtils {
    private static final SimpleArrayMap<String, SPUtils> SP_UTILS_MAP = new SimpleArrayMap();
    private SharedPreferences sp;

    public static SPUtils getInstance() {
        return SPUtils.getInstance("", 0);
    }

    public static SPUtils getInstance(int n) {
        return SPUtils.getInstance("", n);
    }

    public static SPUtils getInstance(String string) {
        return SPUtils.getInstance(string, 0);
    }

    public static SPUtils getInstance(String string, int n) {
        SPUtils sPUtils;
        if (SPUtils.isSpace(string)) {
            string = "spUtils";
        }
        if ((sPUtils = (SPUtils)SP_UTILS_MAP.get((Object)string)) == null) {
            sPUtils = new SPUtils(string, n);
            SP_UTILS_MAP.put((Object)string, (Object)sPUtils);
        }
        return sPUtils;
    }

    private SPUtils(String string) {
        this.sp = Utils.getApp().getSharedPreferences(string, 0);
    }

    private SPUtils(String string, int n) {
        this.sp = Utils.getApp().getSharedPreferences(string, n);
    }

    public void put(@NonNull String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, string2, false);
    }

    public void put(@NonNull String string, String string2, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (bl) {
            this.sp.edit().putString(string, string2).commit();
        } else {
            this.sp.edit().putString(string, string2).apply();
        }
    }

    public String getString(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getString(string, "");
    }

    public String getString(@NonNull String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.sp.getString(string, string2);
    }

    public void put(@NonNull String string, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, n, false);
    }

    public void put(@NonNull String string, int n, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (bl) {
            this.sp.edit().putInt(string, n).commit();
        } else {
            this.sp.edit().putInt(string, n).apply();
        }
    }

    public int getInt(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getInt(string, -1);
    }

    public int getInt(@NonNull String string, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.sp.getInt(string, n);
    }

    public void put(@NonNull String string, long l) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, l, false);
    }

    public void put(@NonNull String string, long l, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (bl) {
            this.sp.edit().putLong(string, l).commit();
        } else {
            this.sp.edit().putLong(string, l).apply();
        }
    }

    public long getLong(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getLong(string, -1L);
    }

    public long getLong(@NonNull String string, long l) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.sp.getLong(string, l);
    }

    public void put(@NonNull String string, float f) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, f, false);
    }

    public void put(@NonNull String string, float f, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (bl) {
            this.sp.edit().putFloat(string, f).commit();
        } else {
            this.sp.edit().putFloat(string, f).apply();
        }
    }

    public float getFloat(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getFloat(string, -1.0f);
    }

    public float getFloat(@NonNull String string, float f) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.sp.getFloat(string, f);
    }

    public void put(@NonNull String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, bl, false);
    }

    public void put(@NonNull String string, boolean bl, boolean bl2) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (bl2) {
            this.sp.edit().putBoolean(string, bl).commit();
        } else {
            this.sp.edit().putBoolean(string, bl).apply();
        }
    }

    public boolean getBoolean(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(@NonNull String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.sp.getBoolean(string, bl);
    }

    public void put(@NonNull String string, Set<String> set) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, set, false);
    }

    public void put(@NonNull String string, Set<String> set, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (bl) {
            this.sp.edit().putStringSet(string, set).commit();
        } else {
            this.sp.edit().putStringSet(string, set).apply();
        }
    }

    public Set<String> getStringSet(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getStringSet(string, Collections.emptySet());
    }

    public Set<String> getStringSet(@NonNull String string, Set<String> set) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.sp.getStringSet(string, set);
    }

    public Map<String, ?> getAll() {
        return this.sp.getAll();
    }

    public boolean contains(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.sp.contains(string);
    }

    public void remove(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.remove(string, false);
    }

    public void remove(@NonNull String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (bl) {
            this.sp.edit().remove(string).commit();
        } else {
            this.sp.edit().remove(string).apply();
        }
    }

    public void clear() {
        this.clear(false);
    }

    public void clear(boolean bl) {
        if (bl) {
            this.sp.edit().clear().commit();
        } else {
            this.sp.edit().clear().apply();
        }
    }

    private static boolean isSpace(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

