/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegexUtils {
    private RegexUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isMobileSimple(CharSequence charSequence) {
        return RegexUtils.isMatch("^[1]\\d{10}$", charSequence);
    }

    public static boolean isMobileExact(CharSequence charSequence) {
        return RegexUtils.isMatch("^((13[0-9])|(14[5,7])|(15[0-3,5-9])|(16[6])|(17[0,1,3,5-8])|(18[0-9])|(19[8,9]))\\d{8}$", charSequence);
    }

    public static boolean isTel(CharSequence charSequence) {
        return RegexUtils.isMatch("^0\\d{2,3}[- ]?\\d{7,8}", charSequence);
    }

    public static boolean isIDCard15(CharSequence charSequence) {
        return RegexUtils.isMatch("^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$", charSequence);
    }

    public static boolean isIDCard18(CharSequence charSequence) {
        return RegexUtils.isMatch("^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])$", charSequence);
    }

    public static boolean isEmail(CharSequence charSequence) {
        return RegexUtils.isMatch("^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$", charSequence);
    }

    public static boolean isURL(CharSequence charSequence) {
        return RegexUtils.isMatch("[a-zA-z]+://[^\\s]*", charSequence);
    }

    public static boolean isZh(CharSequence charSequence) {
        return RegexUtils.isMatch("^[\\u4e00-\\u9fa5]+$", charSequence);
    }

    public static boolean isUsername(CharSequence charSequence) {
        return RegexUtils.isMatch("^[\\w\\u4e00-\\u9fa5]{6,20}(?<!_)$", charSequence);
    }

    public static boolean isDate(CharSequence charSequence) {
        return RegexUtils.isMatch("^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$", charSequence);
    }

    public static boolean isIP(CharSequence charSequence) {
        return RegexUtils.isMatch("((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)", charSequence);
    }

    public static boolean isMatch(String string, CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0 && Pattern.matches(string, charSequence);
    }

    public static List<String> getMatches(String string, CharSequence charSequence) {
        if (charSequence == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(charSequence);
        while (matcher.find()) {
            arrayList.add(matcher.group());
        }
        return arrayList;
    }

    public static String[] getSplits(String string, String string2) {
        if (string == null) {
            return new String[0];
        }
        return string.split(string2);
    }

    public static String getReplaceFirst(String string, String string2, String string3) {
        if (string == null) {
            return "";
        }
        return Pattern.compile(string2).matcher(string).replaceFirst(string3);
    }

    public static String getReplaceAll(String string, String string2, String string3) {
        if (string == null) {
            return "";
        }
        return Pattern.compile(string2).matcher(string).replaceAll(string3);
    }
}

