/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.blankj.utilcode.util.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ProcessUtils {
    private ProcessUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String getForegroundProcessName() {
        ActivityManager activityManager = (ActivityManager)Utils.getApp().getSystemService("activity");
        if (activityManager == null) {
            return null;
        }
        List list = activityManager.getRunningAppProcesses();
        if (list != null && list.size() > 0) {
            for (Intent intent : list) {
                if (intent.importance != 100) continue;
                return intent.processName;
            }
        }
        if (Build.VERSION.SDK_INT > 21) {
            Intent intent;
            PackageManager packageManager = Utils.getApp().getPackageManager();
            intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
            List list2 = packageManager.queryIntentActivities(intent, 65536);
            Log.i((String)"ProcessUtils", (String)list2.toString());
            if (list2.size() <= 0) {
                Log.i((String)"ProcessUtils", (String)"getForegroundProcessName: noun of access to usage information.");
                return "";
            }
            try {
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo(Utils.getApp().getPackageName(), 0);
                AppOpsManager appOpsManager = (AppOpsManager)Utils.getApp().getSystemService("appops");
                if (appOpsManager != null) {
                    if (appOpsManager.checkOpNoThrow("android:get_usage_stats", applicationInfo.uid, applicationInfo.packageName) != 0) {
                        intent.addFlags(0x10000000);
                        Utils.getApp().startActivity(intent);
                    }
                    if (appOpsManager.checkOpNoThrow("android:get_usage_stats", applicationInfo.uid, applicationInfo.packageName) != 0) {
                        Log.i((String)"ProcessUtils", (String)"getForegroundProcessName: refuse to device usage stats.");
                        return "";
                    }
                }
                UsageStatsManager usageStatsManager = (UsageStatsManager)Utils.getApp().getSystemService("usagestats");
                List list3 = null;
                if (usageStatsManager != null) {
                    long l = System.currentTimeMillis();
                    long l2 = l - 604800000L;
                    list3 = usageStatsManager.queryUsageStats(4, l2, l);
                }
                if (list3 == null || list3.isEmpty()) {
                    return null;
                }
                UsageStats usageStats = null;
                for (UsageStats usageStats2 : list3) {
                    if (usageStats != null && usageStats2.getLastTimeUsed() <= usageStats.getLastTimeUsed()) continue;
                    usageStats = usageStats2;
                }
                return usageStats == null ? null : usageStats.getPackageName();
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
        }
        return "";
    }

    @RequiresPermission(value="android.permission.KILL_BACKGROUND_PROCESSES")
    public static Set<String> getAllBackgroundProcesses() {
        ActivityManager activityManager = (ActivityManager)Utils.getApp().getSystemService("activity");
        if (activityManager == null) {
            return Collections.emptySet();
        }
        List list = activityManager.getRunningAppProcesses();
        HashSet<String> hashSet = new HashSet<String>();
        if (list != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                Collections.addAll(hashSet, runningAppProcessInfo.pkgList);
            }
        }
        return hashSet;
    }

    @RequiresPermission(value="android.permission.KILL_BACKGROUND_PROCESSES")
    public static Set<String> killAllBackgroundProcesses() {
        ActivityManager activityManager = (ActivityManager)Utils.getApp().getSystemService("activity");
        if (activityManager == null) {
            return Collections.emptySet();
        }
        List list = activityManager.getRunningAppProcesses();
        HashSet<String> hashSet = new HashSet<String>();
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            for (String string : runningAppProcessInfo.pkgList) {
                activityManager.killBackgroundProcesses(string);
                hashSet.add(string);
            }
        }
        list = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            for (String string : runningAppProcessInfo.pkgList) {
                hashSet.remove(string);
            }
        }
        return hashSet;
    }

    @RequiresPermission(value="android.permission.KILL_BACKGROUND_PROCESSES")
    public static boolean killBackgroundProcesses(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'packageName' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityManager activityManager = (ActivityManager)Utils.getApp().getSystemService("activity");
        if (activityManager == null) {
            return false;
        }
        List list = activityManager.getRunningAppProcesses();
        if (list == null || list.size() == 0) {
            return true;
        }
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            if (!Arrays.asList(runningAppProcessInfo.pkgList).contains(string)) continue;
            activityManager.killBackgroundProcesses(string);
        }
        list = activityManager.getRunningAppProcesses();
        if (list == null || list.size() == 0) {
            return true;
        }
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            if (!Arrays.asList(runningAppProcessInfo.pkgList).contains(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean isMainProcess() {
        return Utils.getApp().getPackageName().equals(ProcessUtils.getCurrentProcessName());
    }

    public static String getCurrentProcessName() {
        ActivityManager activityManager = (ActivityManager)Utils.getApp().getSystemService("activity");
        if (activityManager == null) {
            return null;
        }
        List list = activityManager.getRunningAppProcesses();
        if (list == null || list.size() == 0) {
            return null;
        }
        int n = Process.myPid();
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            if (runningAppProcessInfo.pid != n || runningAppProcessInfo.processName == null) continue;
            return runningAppProcessInfo.processName;
        }
        return "";
    }
}

