/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.ExifInterface;
import android.os.Build;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.view.View;
import com.blankj.utilcode.util.Utils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ImageUtils {
    private ImageUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static byte[] bitmap2Bytes(Bitmap bitmap, Bitmap.CompressFormat compressFormat) {
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(compressFormat, 100, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Bitmap bytes2Bitmap(byte[] byArray) {
        return byArray == null || byArray.length == 0 ? null : BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
    }

    public static Bitmap drawable2Bitmap(Drawable drawable) {
        BitmapDrawable bitmapDrawable;
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        bitmapDrawable = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565)) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas((Bitmap)bitmapDrawable);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmapDrawable;
    }

    public static Drawable bitmap2Drawable(Bitmap bitmap) {
        return bitmap == null ? null : new BitmapDrawable(Utils.getApp().getResources(), bitmap);
    }

    public static byte[] drawable2Bytes(Drawable drawable, Bitmap.CompressFormat compressFormat) {
        return drawable == null ? null : ImageUtils.bitmap2Bytes(ImageUtils.drawable2Bitmap(drawable), compressFormat);
    }

    public static Drawable bytes2Drawable(byte[] byArray) {
        return ImageUtils.bitmap2Drawable(ImageUtils.bytes2Bitmap(byArray));
    }

    public static Bitmap view2Bitmap(View view) {
        if (view == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Drawable drawable = view.getBackground();
        if (drawable != null) {
            drawable.draw(canvas);
        } else {
            canvas.drawColor(-1);
        }
        view.draw(canvas);
        return bitmap;
    }

    public static Bitmap getBitmap(File file) {
        if (file == null) {
            return null;
        }
        return BitmapFactory.decodeFile((String)file.getAbsolutePath());
    }

    public static Bitmap getBitmap(File file, int n, int n2) {
        if (file == null) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtils.calculateInSampleSize(options, n, n2);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
    }

    public static Bitmap getBitmap(String string) {
        if (ImageUtils.isSpace(string)) {
            return null;
        }
        return BitmapFactory.decodeFile((String)string);
    }

    public static Bitmap getBitmap(String string, int n, int n2) {
        if (ImageUtils.isSpace(string)) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtils.calculateInSampleSize(options, n, n2);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
    }

    public static Bitmap getBitmap(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        return BitmapFactory.decodeStream((InputStream)inputStream);
    }

    public static Bitmap getBitmap(InputStream inputStream, int n, int n2) {
        if (inputStream == null) {
            return null;
        }
        byte[] byArray = ImageUtils.input2Byte(inputStream);
        return ImageUtils.getBitmap(byArray, 0, n, n2);
    }

    public static Bitmap getBitmap(byte[] byArray, int n) {
        if (byArray.length == 0) {
            return null;
        }
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)n, (int)byArray.length);
    }

    public static Bitmap getBitmap(byte[] byArray, int n, int n2, int n3) {
        if (byArray.length == 0) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])byArray, (int)n, (int)byArray.length, (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtils.calculateInSampleSize(options, n2, n3);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)n, (int)byArray.length, (BitmapFactory.Options)options);
    }

    public static Bitmap getBitmap(@DrawableRes int n) {
        Drawable drawable = ContextCompat.getDrawable((Context)Utils.getApp(), (int)n);
        Canvas canvas = new Canvas();
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        canvas.setBitmap(bitmap);
        drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    public static Bitmap getBitmap(@DrawableRes int n, int n2, int n3) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        Resources resources = Utils.getApp().getResources();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)resources, (int)n, (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtils.calculateInSampleSize(options, n2, n3);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)resources, (int)n, (BitmapFactory.Options)options);
    }

    public static Bitmap getBitmap(FileDescriptor fileDescriptor) {
        if (fileDescriptor == null) {
            return null;
        }
        return BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor);
    }

    public static Bitmap getBitmap(FileDescriptor fileDescriptor, int n, int n2) {
        if (fileDescriptor == null) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtils.calculateInSampleSize(options, n, n2);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
    }

    public static Bitmap drawColor(@NonNull Bitmap bitmap, @ColorInt int n) {
        if (bitmap == null) {
            throw new NullPointerException("Argument 'src' of type Bitmap (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return ImageUtils.drawColor(bitmap, n, false);
    }

    public static Bitmap drawColor(@NonNull Bitmap bitmap, @ColorInt int n, boolean bl) {
        if (bitmap == null) {
            throw new NullPointerException("Argument 'src' of type Bitmap (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (ImageUtils.isEmptyBitmap(bitmap)) {
            return null;
        }
        Bitmap bitmap2 = bl ? bitmap : bitmap.copy(bitmap.getConfig(), true);
        Canvas canvas = new Canvas(bitmap2);
        canvas.drawColor(n, PorterDuff.Mode.DARKEN);
        return bitmap2;
    }

    public static Bitmap scale(Bitmap bitmap, int n, int n2) {
        return ImageUtils.scale(bitmap, n, n2, false);
    }

    public static Bitmap scale(Bitmap bitmap, int n, int n2, boolean bl) {
        if (ImageUtils.isEmptyBitmap(bitmap)) {
            return null;
        }
        Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n, (int)n2, (boolean)true);
        if (bl && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return bitmap2;
    }

    public static Bitmap scale(Bitmap bitmap, float f, float f2) {
        return ImageUtils.scale(bitmap, f, f2, false);
    }

    public static Bitmap scale(Bitmap bitmap, float f, float f2, boolean bl) {
        if (ImageUtils.isEmptyBitmap(bitmap)) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.setScale(f, f2);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        if (bl && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return bitmap2;
    }

    public static Bitmap clip(Bitmap bitmap, int n, int n2, int n3, int n4) {
        return ImageUtils.clip(bitmap, n, n2, n3, n4, false);
    }

    public static Bitmap clip(Bitmap bitmap, int n, int n2, int n3, int n4, boolean bl) {
        if (ImageUtils.isEmptyBitmap(bitmap)) {
            return null;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)n, (int)n2, (int)n3, (int)n4);
        if (bl && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return bitmap2;
    }

    public static Bitmap skew(Bitmap bitmap, float f, float f2) {
        return ImageUtils.skew(bitmap, f, f2, 0.0f, 0.0f, false);
    }

    public static Bitmap skew(Bitmap bitmap, float f, float f2, boolean bl) {
        return ImageUtils.skew(bitmap, f, f2, 0.0f, 0.0f, bl);
    }

    public static Bitmap skew(Bitmap bitmap, float f, float f2, float f3, float f4) {
        return ImageUtils.skew(bitmap, f, f2, f3, f4, false);
    }

    public static Bitmap skew(Bitmap bitmap, float f, float f2, float f3, float f4, boolean bl) {
        if (ImageUtils.isEmptyBitmap(bitmap)) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.setSkew(f, f2, f3, f4);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        if (bl && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return bitmap2;
    }

    public static Bitmap rotate(Bitmap bitmap, int n, float f, float f2) {
        return ImageUtils.rotate(bitmap, n, f, f2, false);
    }

    public static Bitmap rotate(Bitmap bitmap, int n, float f, float f2, boolean bl) {
        if (ImageUtils.isEmptyBitmap(bitmap)) {
            return null;
        }
        if (n == 0) {
            return bitmap;
        }
        Matrix matrix = new Matrix();
        matrix.setRotate((float)n, f, f2);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        if (bl && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return bitmap2;
    }

    public static int getRotateDegree(String string) {
        try {
            ExifInterface exifInterface = new ExifInterface(string);
            int n = exifInterface.getAttributeInt("Orientation", 1);
            switch (n) {
                case 6: {
                    return 90;
                }
                case 3: {
                    return 180;
                }
                case 8: {
                    return 270;
                }
            }
            return 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
    }

    public static Bitmap toRound(Bitmap bitmap) {
        return ImageUtils.toRound(bitmap, 0, 0, false);
    }

    public static Bitmap toRound(Bitmap bitmap, boolean bl) {
        return ImageUtils.toRound(bitmap, 0, 0, bl);
    }

    public static Bitmap toRound(Bitmap bitmap, @IntRange(from=0L) int n, @ColorInt int n2) {
        return ImageUtils.toRound(bitmap, n, n2, false);
    }

    public static Bitmap toRound(Bitmap bitmap, @IntRange(from=0L) int n, @ColorInt int n2, boolean bl) {
        if (ImageUtils.isEmptyBitmap(bitmap)) {
            return null;
        }
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        int n5 = Math.min(n3, n4);
        Paint paint = new Paint(1);
        Bitmap bitmap2 = Bitmap.createBitmap((int)n3, (int)n4, (Bitmap.Config)bitmap.getConfig());
        float f = (float)n5 / 2.0f;
        RectF rectF = new RectF(0.0f, 0.0f, (float)n3, (float)n4);
        rectF.inset((float)(n3 - n5) / 2.0f, (float)(n4 - n5) / 2.0f);
        Matrix matrix = new Matrix();
        matrix.setTranslate(rectF.left, rectF.top);
        matrix.preScale((float)n5 / (float)n3, (float)n5 / (float)n4);
        BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        bitmapShader.setLocalMatrix(matrix);
        paint.setShader((Shader)bitmapShader);
        Canvas canvas = new Canvas(bitmap2);
        canvas.drawRoundRect(rectF, f, f, paint);
        if (n > 0) {
            paint.setShader(null);
            paint.setColor(n2);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth((float)n);
            float f2 = f - (float)n / 2.0f;
            canvas.drawCircle((float)n3 / 2.0f, (float)n4 / 2.0f, f2, paint);
        }
        if (bl && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return bitmap2;
    }

    public static Bitmap toRoundCorner(Bitmap bitmap, float f) {
        return ImageUtils.toRoundCorner(bitmap, f, 0, 0, false);
    }

    public static Bitmap toRoundCorner(Bitmap bitmap, float f, boolean bl) {
        return ImageUtils.toRoundCorner(bitmap, f, 0, 0, bl);
    }

    public static Bitmap toRoundCorner(Bitmap bitmap, float f, @IntRange(from=0L) int n, @ColorInt int n2) {
        return ImageUtils.toRoundCorner(bitmap, f, n, n2, false);
    }

    public static Bitmap toRoundCorner(Bitmap bitmap, float f, @IntRange(from=0L) int n, @ColorInt int n2, boolean bl) {
        if (ImageUtils.isEmptyBitmap(bitmap)) {
            return null;
        }
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        Paint paint = new Paint(1);
        Bitmap bitmap2 = Bitmap.createBitmap((int)n3, (int)n4, (Bitmap.Config)bitmap.getConfig());
        BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        paint.setShader((Shader)bitmapShader);
        Canvas canvas = new Canvas(bitmap2);
        RectF rectF = new RectF(0.0f, 0.0f, (float)n3, (float)n4);
        float f2 = (float)n / 2.0f;
        rectF.inset(f2, f2);
        canvas.drawRoundRect(rectF, f, f, paint);
        if (n > 0) {
            paint.setShader(null);
            paint.setColor(n2);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth((float)n);
            paint.setStrokeCap(Paint.Cap.ROUND);
            canvas.drawRoundRect(rectF, f, f, paint);
        }
        if (bl && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return bitmap2;
    }

    public static Bitmap addCornerBorder(Bitmap bitmap, @IntRange(from=1L) int n, @ColorInt int n2, @FloatRange(from=0.0) float f) {
        return ImageUtils.addBorder(bitmap, n, n2, false, f, false);
    }

    public static Bitmap addCornerBorder(Bitmap bitmap, @IntRange(from=1L) int n, @ColorInt int n2, @FloatRange(from=0.0) float f, boolean bl) {
        return ImageUtils.addBorder(bitmap, n, n2, false, f, bl);
    }

    public static Bitmap addCircleBorder(Bitmap bitmap, @IntRange(from=1L) int n, @ColorInt int n2) {
        return ImageUtils.addBorder(bitmap, n, n2, true, 0.0f, false);
    }

    public static Bitmap addCircleBorder(Bitmap bitmap, @IntRange(from=1L) int n, @ColorInt int n2, boolean bl) {
        return ImageUtils.addBorder(bitmap, n, n2, true, 0.0f, bl);
    }

    private static Bitmap addBorder(Bitmap bitmap, @IntRange(from=1L) int n, @ColorInt int n2, boolean bl, float f, boolean bl2) {
        if (ImageUtils.isEmptyBitmap(bitmap)) {
            return null;
        }
        Bitmap bitmap2 = bl2 ? bitmap : bitmap.copy(bitmap.getConfig(), true);
        int n3 = bitmap2.getWidth();
        int n4 = bitmap2.getHeight();
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint(1);
        paint.setColor(n2);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth((float)n);
        if (bl) {
            float f2 = (float)Math.min(n3, n4) / 2.0f - (float)n / 2.0f;
            canvas.drawCircle((float)n3 / 2.0f, (float)n4 / 2.0f, f2, paint);
        } else {
            int n5 = n >> 1;
            RectF rectF = new RectF((float)n5, (float)n5, (float)(n3 - n5), (float)(n4 - n5));
            canvas.drawRoundRect(rectF, f, f, paint);
        }
        return bitmap2;
    }

    public static Bitmap addReflection(Bitmap bitmap, int n) {
        return ImageUtils.addReflection(bitmap, n, false);
    }

    public static Bitmap addReflection(Bitmap bitmap, int n, boolean bl) {
        if (ImageUtils.isEmptyBitmap(bitmap)) {
            return null;
        }
        boolean bl2 = false;
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.preScale(1.0f, -1.0f);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)(n3 - n), (int)n2, (int)n, (Matrix)matrix, (boolean)false);
        Bitmap bitmap3 = Bitmap.createBitmap((int)n2, (int)(n3 + n), (Bitmap.Config)bitmap.getConfig());
        Canvas canvas = new Canvas(bitmap3);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        canvas.drawBitmap(bitmap2, 0.0f, (float)(n3 + 0), null);
        Paint paint = new Paint(1);
        LinearGradient linearGradient = new LinearGradient(0.0f, (float)n3, 0.0f, (float)(bitmap3.getHeight() + 0), 0x70FFFFFF, 0xFFFFFF, Shader.TileMode.MIRROR);
        paint.setShader((Shader)linearGradient);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        canvas.drawRect(0.0f, (float)(n3 + 0), (float)n2, (float)bitmap3.getHeight(), paint);
        if (!bitmap2.isRecycled()) {
            bitmap2.recycle();
        }
        if (bl && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return bitmap3;
    }

    public static Bitmap addTextWatermark(Bitmap bitmap, String string, int n, @ColorInt int n2, float f, float f2) {
        return ImageUtils.addTextWatermark(bitmap, string, n, n2, f, f2, false);
    }

    public static Bitmap addTextWatermark(Bitmap bitmap, String string, float f, @ColorInt int n, float f2, float f3, boolean bl) {
        if (ImageUtils.isEmptyBitmap(bitmap) || string == null) {
            return null;
        }
        Bitmap bitmap2 = bitmap.copy(bitmap.getConfig(), true);
        Paint paint = new Paint(1);
        Canvas canvas = new Canvas(bitmap2);
        paint.setColor(n);
        paint.setTextSize(f);
        Rect rect = new Rect();
        paint.getTextBounds(string, 0, string.length(), rect);
        canvas.drawText(string, f2, f3 + f, paint);
        if (bl && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return bitmap2;
    }

    public static Bitmap addImageWatermark(Bitmap bitmap, Bitmap bitmap2, int n, int n2, int n3) {
        return ImageUtils.addImageWatermark(bitmap, bitmap2, n, n2, n3, false);
    }

    public static Bitmap addImageWatermark(Bitmap bitmap, Bitmap bitmap2, int n, int n2, int n3, boolean bl) {
        if (ImageUtils.isEmptyBitmap(bitmap)) {
            return null;
        }
        Bitmap bitmap3 = bitmap.copy(bitmap.getConfig(), true);
        if (!ImageUtils.isEmptyBitmap(bitmap2)) {
            Paint paint = new Paint(1);
            Canvas canvas = new Canvas(bitmap3);
            paint.setAlpha(n3);
            canvas.drawBitmap(bitmap2, (float)n, (float)n2, paint);
        }
        if (bl && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return bitmap3;
    }

    public static Bitmap toAlpha(Bitmap bitmap) {
        return ImageUtils.toAlpha(bitmap, false);
    }

    public static Bitmap toAlpha(Bitmap bitmap, Boolean bl) {
        if (ImageUtils.isEmptyBitmap(bitmap)) {
            return null;
        }
        Bitmap bitmap2 = bitmap.extractAlpha();
        if (bl.booleanValue() && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return bitmap2;
    }

    public static Bitmap toGray(Bitmap bitmap) {
        return ImageUtils.toGray(bitmap, false);
    }

    public static Bitmap toGray(Bitmap bitmap, boolean bl) {
        if (ImageUtils.isEmptyBitmap(bitmap)) {
            return null;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)bitmap.getConfig());
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(0.0f);
        ColorMatrixColorFilter colorMatrixColorFilter = new ColorMatrixColorFilter(colorMatrix);
        paint.setColorFilter((ColorFilter)colorMatrixColorFilter);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        if (bl && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return bitmap2;
    }

    public static Bitmap fastBlur(Bitmap bitmap, @FloatRange(from=0.0, to=1.0, fromInclusive=false) float f, @FloatRange(from=0.0, to=25.0, fromInclusive=false) float f2) {
        return ImageUtils.fastBlur(bitmap, f, f2, false);
    }

    public static Bitmap fastBlur(Bitmap bitmap, @FloatRange(from=0.0, to=1.0, fromInclusive=false) float f, @FloatRange(from=0.0, to=25.0, fromInclusive=false) float f2, boolean bl) {
        if (ImageUtils.isEmptyBitmap(bitmap)) {
            return null;
        }
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.setScale(f, f);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Paint paint = new Paint(3);
        Canvas canvas = new Canvas();
        PorterDuffColorFilter porterDuffColorFilter = new PorterDuffColorFilter(0, PorterDuff.Mode.SRC_ATOP);
        paint.setColorFilter((ColorFilter)porterDuffColorFilter);
        canvas.scale(f, f);
        canvas.drawBitmap(bitmap2, 0.0f, 0.0f, paint);
        bitmap2 = Build.VERSION.SDK_INT >= 17 ? ImageUtils.renderScriptBlur(bitmap2, f2, bl) : ImageUtils.stackBlur(bitmap2, (int)f2, bl);
        if (f == 1.0f) {
            if (bl && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
            return bitmap2;
        }
        Bitmap bitmap3 = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)n, (int)n2, (boolean)true);
        if (!bitmap2.isRecycled()) {
            bitmap2.recycle();
        }
        if (bl && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return bitmap3;
    }

    @RequiresApi(value=17)
    public static Bitmap renderScriptBlur(Bitmap bitmap, @FloatRange(from=0.0, to=25.0, fromInclusive=false) float f) {
        return ImageUtils.renderScriptBlur(bitmap, f, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=17)
    public static Bitmap renderScriptBlur(Bitmap bitmap, @FloatRange(from=0.0, to=25.0, fromInclusive=false) float f, boolean bl) {
        RenderScript renderScript = null;
        Bitmap bitmap2 = bl ? bitmap : bitmap.copy(bitmap.getConfig(), true);
        try {
            renderScript = RenderScript.create((Context)Utils.getApp());
            renderScript.setMessageHandler(new RenderScript.RSMessageHandler());
            Allocation allocation = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)bitmap2, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)1);
            Allocation allocation2 = Allocation.createTyped((RenderScript)renderScript, (Type)allocation.getType());
            ScriptIntrinsicBlur scriptIntrinsicBlur = ScriptIntrinsicBlur.create((RenderScript)renderScript, (Element)Element.U8_4((RenderScript)renderScript));
            scriptIntrinsicBlur.setInput(allocation);
            scriptIntrinsicBlur.setRadius(f);
            scriptIntrinsicBlur.forEach(allocation2);
            allocation2.copyTo(bitmap2);
        }
        finally {
            if (renderScript != null) {
                renderScript.destroy();
            }
        }
        return bitmap2;
    }

    public static Bitmap stackBlur(Bitmap bitmap, int n) {
        return ImageUtils.stackBlur(bitmap, n, false);
    }

    public static Bitmap stackBlur(Bitmap bitmap, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        Bitmap bitmap2;
        Bitmap bitmap3 = bitmap2 = bl ? bitmap : bitmap.copy(bitmap.getConfig(), true);
        if (n < 1) {
            n = 1;
        }
        int n18 = bitmap2.getWidth();
        int n19 = bitmap2.getHeight();
        int[] nArray2 = new int[n18 * n19];
        bitmap2.getPixels(nArray2, 0, n18, 0, 0, n18, n19);
        int n20 = n18 - 1;
        int n21 = n19 - 1;
        int n22 = n18 * n19;
        int n23 = n + n + 1;
        int[] nArray3 = new int[n22];
        int[] nArray4 = new int[n22];
        int[] nArray5 = new int[n22];
        int[] nArray6 = new int[Math.max(n18, n19)];
        int n24 = n23 + 1 >> 1;
        n24 *= n24;
        int[] nArray7 = new int[256 * n24];
        for (n17 = 0; n17 < 256 * n24; ++n17) {
            nArray7[n17] = n17 / n24;
        }
        int n25 = 0;
        int n26 = 0;
        int[][] nArray8 = new int[n23][3];
        int n27 = n + 1;
        for (n16 = 0; n16 < n19; ++n16) {
            n15 = 0;
            n14 = 0;
            n13 = 0;
            n12 = 0;
            n11 = 0;
            n10 = 0;
            n9 = 0;
            n8 = 0;
            n7 = 0;
            for (n17 = -n; n17 <= n; ++n17) {
                n6 = nArray2[n25 + Math.min(n20, Math.max(n17, 0))];
                nArray = nArray8[n17 + n];
                nArray[0] = (n6 & 0xFF0000) >> 16;
                nArray[1] = (n6 & 0xFF00) >> 8;
                nArray[2] = n6 & 0xFF;
                n5 = n27 - Math.abs(n17);
                n13 += nArray[0] * n5;
                n14 += nArray[1] * n5;
                n15 += nArray[2] * n5;
                if (n17 > 0) {
                    n7 += nArray[0];
                    n8 += nArray[1];
                    n9 += nArray[2];
                    continue;
                }
                n10 += nArray[0];
                n11 += nArray[1];
                n12 += nArray[2];
            }
            n4 = n;
            for (n3 = 0; n3 < n18; ++n3) {
                nArray3[n25] = nArray7[n13];
                nArray4[n25] = nArray7[n14];
                nArray5[n25] = nArray7[n15];
                n13 -= n10;
                n14 -= n11;
                n15 -= n12;
                n2 = n4 - n + n23;
                nArray = nArray8[n2 % n23];
                n10 -= nArray[0];
                n11 -= nArray[1];
                n12 -= nArray[2];
                if (n16 == 0) {
                    nArray6[n3] = Math.min(n3 + n + 1, n20);
                }
                n6 = nArray2[n26 + nArray6[n3]];
                nArray[0] = (n6 & 0xFF0000) >> 16;
                nArray[1] = (n6 & 0xFF00) >> 8;
                nArray[2] = n6 & 0xFF;
                n13 += (n7 += nArray[0]);
                n14 += (n8 += nArray[1]);
                n15 += (n9 += nArray[2]);
                n4 = (n4 + 1) % n23;
                nArray = nArray8[n4 % n23];
                n10 += nArray[0];
                n11 += nArray[1];
                n12 += nArray[2];
                n7 -= nArray[0];
                n8 -= nArray[1];
                n9 -= nArray[2];
                ++n25;
            }
            n26 += n18;
        }
        for (n3 = 0; n3 < n18; ++n3) {
            n15 = 0;
            n14 = 0;
            n13 = 0;
            n12 = 0;
            n11 = 0;
            n10 = 0;
            n9 = 0;
            n8 = 0;
            n7 = 0;
            int n28 = -n * n18;
            for (n17 = -n; n17 <= n; ++n17) {
                n25 = Math.max(0, n28) + n3;
                nArray = nArray8[n17 + n];
                nArray[0] = nArray3[n25];
                nArray[1] = nArray4[n25];
                nArray[2] = nArray5[n25];
                n5 = n27 - Math.abs(n17);
                n13 += nArray3[n25] * n5;
                n14 += nArray4[n25] * n5;
                n15 += nArray5[n25] * n5;
                if (n17 > 0) {
                    n7 += nArray[0];
                    n8 += nArray[1];
                    n9 += nArray[2];
                } else {
                    n10 += nArray[0];
                    n11 += nArray[1];
                    n12 += nArray[2];
                }
                if (n17 >= n21) continue;
                n28 += n18;
            }
            n25 = n3;
            n4 = n;
            for (n16 = 0; n16 < n19; ++n16) {
                nArray2[n25] = 0xFF000000 & nArray2[n25] | nArray7[n13] << 16 | nArray7[n14] << 8 | nArray7[n15];
                n13 -= n10;
                n14 -= n11;
                n15 -= n12;
                n2 = n4 - n + n23;
                nArray = nArray8[n2 % n23];
                n10 -= nArray[0];
                n11 -= nArray[1];
                n12 -= nArray[2];
                if (n3 == 0) {
                    nArray6[n16] = Math.min(n16 + n27, n21) * n18;
                }
                n6 = n3 + nArray6[n16];
                nArray[0] = nArray3[n6];
                nArray[1] = nArray4[n6];
                nArray[2] = nArray5[n6];
                n13 += (n7 += nArray[0]);
                n14 += (n8 += nArray[1]);
                n15 += (n9 += nArray[2]);
                n4 = (n4 + 1) % n23;
                nArray = nArray8[n4];
                n10 += nArray[0];
                n11 += nArray[1];
                n12 += nArray[2];
                n7 -= nArray[0];
                n8 -= nArray[1];
                n9 -= nArray[2];
                n25 += n18;
            }
        }
        bitmap2.setPixels(nArray2, 0, n18, 0, 0, n18, n19);
        return bitmap2;
    }

    public static boolean save(Bitmap bitmap, String string, Bitmap.CompressFormat compressFormat) {
        return ImageUtils.save(bitmap, ImageUtils.getFileByPath(string), compressFormat, false);
    }

    public static boolean save(Bitmap bitmap, File file, Bitmap.CompressFormat compressFormat) {
        return ImageUtils.save(bitmap, file, compressFormat, false);
    }

    public static boolean save(Bitmap bitmap, String string, Bitmap.CompressFormat compressFormat, boolean bl) {
        return ImageUtils.save(bitmap, ImageUtils.getFileByPath(string), compressFormat, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(Bitmap bitmap, File file, Bitmap.CompressFormat compressFormat, boolean bl) {
        if (ImageUtils.isEmptyBitmap(bitmap) || !ImageUtils.createFileByDeleteOldFile(file)) {
            return false;
        }
        OutputStream outputStream = null;
        boolean bl2 = false;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            bl2 = bitmap.compress(compressFormat, 100, outputStream);
            if (bl && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl2;
    }

    public static boolean isImage(File file) {
        return file != null && ImageUtils.isImage(file.getPath());
    }

    public static boolean isImage(String string) {
        String string2 = string.toUpperCase();
        return string2.endsWith(".PNG") || string2.endsWith(".JPG") || string2.endsWith(".JPEG") || string2.endsWith(".BMP") || string2.endsWith(".GIF") || string2.endsWith(".WEBP");
    }

    public static String getImageType(String string) {
        return ImageUtils.getImageType(ImageUtils.getFileByPath(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageType(File file) {
        if (file == null) {
            return "";
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            String string = ImageUtils.getImageType(fileInputStream);
            if (string != null) {
                String string2 = string;
                return string2;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return ImageUtils.getFileExtension(file.getAbsolutePath()).toUpperCase();
    }

    private static String getFileExtension(String string) {
        if (ImageUtils.isSpace(string)) {
            return string;
        }
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(File.separator);
        if (n == -1 || n2 >= n) {
            return "";
        }
        return string.substring(n + 1);
    }

    private static String getImageType(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try {
            byte[] byArray = new byte[8];
            return inputStream.read(byArray, 0, 8) != -1 ? ImageUtils.getImageType(byArray) : null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static String getImageType(byte[] byArray) {
        if (ImageUtils.isJPEG(byArray)) {
            return "JPEG";
        }
        if (ImageUtils.isGIF(byArray)) {
            return "GIF";
        }
        if (ImageUtils.isPNG(byArray)) {
            return "PNG";
        }
        if (ImageUtils.isBMP(byArray)) {
            return "BMP";
        }
        return null;
    }

    private static boolean isJPEG(byte[] byArray) {
        return byArray.length >= 2 && byArray[0] == -1 && byArray[1] == -40;
    }

    private static boolean isGIF(byte[] byArray) {
        return byArray.length >= 6 && byArray[0] == 71 && byArray[1] == 73 && byArray[2] == 70 && byArray[3] == 56 && (byArray[4] == 55 || byArray[4] == 57) && byArray[5] == 97;
    }

    private static boolean isPNG(byte[] byArray) {
        return byArray.length >= 8 && byArray[0] == -119 && byArray[1] == 80 && byArray[2] == 78 && byArray[3] == 71 && byArray[4] == 13 && byArray[5] == 10 && byArray[6] == 26 && byArray[7] == 10;
    }

    private static boolean isBMP(byte[] byArray) {
        return byArray.length >= 2 && byArray[0] == 66 && byArray[1] == 77;
    }

    private static boolean isEmptyBitmap(Bitmap bitmap) {
        return bitmap == null || bitmap.getWidth() == 0 || bitmap.getHeight() == 0;
    }

    public static Bitmap compressByScale(Bitmap bitmap, int n, int n2) {
        return ImageUtils.scale(bitmap, n, n2, false);
    }

    public static Bitmap compressByScale(Bitmap bitmap, int n, int n2, boolean bl) {
        return ImageUtils.scale(bitmap, n, n2, bl);
    }

    public static Bitmap compressByScale(Bitmap bitmap, float f, float f2) {
        return ImageUtils.scale(bitmap, f, f2, false);
    }

    public static Bitmap compressByScale(Bitmap bitmap, float f, float f2, boolean bl) {
        return ImageUtils.scale(bitmap, f, f2, bl);
    }

    public static Bitmap compressByQuality(Bitmap bitmap, @IntRange(from=0L, to=100L) int n) {
        return ImageUtils.compressByQuality(bitmap, n, false);
    }

    public static Bitmap compressByQuality(Bitmap bitmap, @IntRange(from=0L, to=100L) int n, boolean bl) {
        if (ImageUtils.isEmptyBitmap(bitmap)) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, n, (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (bl && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
    }

    public static Bitmap compressByQuality(Bitmap bitmap, long l) {
        return ImageUtils.compressByQuality(bitmap, l, false);
    }

    public static Bitmap compressByQuality(Bitmap bitmap, long l, boolean bl) {
        byte[] byArray;
        if (ImageUtils.isEmptyBitmap(bitmap) || l <= 0L) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
        if ((long)byteArrayOutputStream.size() <= l) {
            byArray = byteArrayOutputStream.toByteArray();
        } else {
            byteArrayOutputStream.reset();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 0, (OutputStream)byteArrayOutputStream);
            if ((long)byteArrayOutputStream.size() >= l) {
                byArray = byteArrayOutputStream.toByteArray();
            } else {
                int n = 0;
                int n2 = 100;
                int n3 = 0;
                while (n < n2) {
                    n3 = (n + n2) / 2;
                    byteArrayOutputStream.reset();
                    bitmap.compress(Bitmap.CompressFormat.JPEG, n3, (OutputStream)byteArrayOutputStream);
                    int n4 = byteArrayOutputStream.size();
                    if ((long)n4 == l) break;
                    if ((long)n4 > l) {
                        n2 = n3 - 1;
                        continue;
                    }
                    n = n3 + 1;
                }
                if (n2 == n3 - 1) {
                    byteArrayOutputStream.reset();
                    bitmap.compress(Bitmap.CompressFormat.JPEG, n, (OutputStream)byteArrayOutputStream);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
        }
        if (bl && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
    }

    public static Bitmap compressBySampleSize(Bitmap bitmap, int n) {
        return ImageUtils.compressBySampleSize(bitmap, n, false);
    }

    public static Bitmap compressBySampleSize(Bitmap bitmap, int n, boolean bl) {
        if (ImageUtils.isEmptyBitmap(bitmap)) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (bl && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
    }

    public static Bitmap compressBySampleSize(Bitmap bitmap, int n, int n2) {
        return ImageUtils.compressBySampleSize(bitmap, n, n2, false);
    }

    public static Bitmap compressBySampleSize(Bitmap bitmap, int n, int n2, boolean bl) {
        if (ImageUtils.isEmptyBitmap(bitmap)) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtils.calculateInSampleSize(options, n, n2);
        options.inJustDecodeBounds = false;
        if (bl && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
    }

    private static File getFileByPath(String string) {
        return ImageUtils.isSpace(string) ? null : new File(string);
    }

    private static boolean createFileByDeleteOldFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists() && !file.delete()) {
            return false;
        }
        if (!ImageUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean isSpace(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int n, int n2) {
        int n3 = options.outHeight;
        int n4 = options.outWidth;
        int n5 = 1;
        while ((n4 >>= 1) >= n && (n3 >>= 1) >= n2) {
            n5 <<= 1;
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] input2Byte(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray, 0, 1024)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

