/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public final class FileIOUtils {
    private static int sBufferSize = 8192;

    private FileIOUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean writeFileFromIS(String string, InputStream inputStream) {
        return FileIOUtils.writeFileFromIS(FileIOUtils.getFileByPath(string), inputStream, false);
    }

    public static boolean writeFileFromIS(String string, InputStream inputStream, boolean bl) {
        return FileIOUtils.writeFileFromIS(FileIOUtils.getFileByPath(string), inputStream, bl);
    }

    public static boolean writeFileFromIS(File file, InputStream inputStream) {
        return FileIOUtils.writeFileFromIS(file, inputStream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromIS(File file, InputStream inputStream, boolean bl) {
        if (!FileIOUtils.createOrExistsFile(file) || inputStream == null) {
            return false;
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file, bl));
            byte[] byArray = new byte[sBufferSize];
            while ((n = inputStream.read(byArray, 0, sBufferSize)) != -1) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                if (bufferedOutputStream != null) {
                    ((OutputStream)bufferedOutputStream).close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static boolean writeFileFromBytesByStream(String string, byte[] byArray) {
        return FileIOUtils.writeFileFromBytesByStream(FileIOUtils.getFileByPath(string), byArray, false);
    }

    public static boolean writeFileFromBytesByStream(String string, byte[] byArray, boolean bl) {
        return FileIOUtils.writeFileFromBytesByStream(FileIOUtils.getFileByPath(string), byArray, bl);
    }

    public static boolean writeFileFromBytesByStream(File file, byte[] byArray) {
        return FileIOUtils.writeFileFromBytesByStream(file, byArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromBytesByStream(File file, byte[] byArray, boolean bl) {
        if (byArray == null || !FileIOUtils.createOrExistsFile(file)) {
            return false;
        }
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file, bl));
            filterOutputStream.write(byArray);
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static boolean writeFileFromBytesByChannel(String string, byte[] byArray, boolean bl) {
        return FileIOUtils.writeFileFromBytesByChannel(FileIOUtils.getFileByPath(string), byArray, false, bl);
    }

    public static boolean writeFileFromBytesByChannel(String string, byte[] byArray, boolean bl, boolean bl2) {
        return FileIOUtils.writeFileFromBytesByChannel(FileIOUtils.getFileByPath(string), byArray, bl, bl2);
    }

    public static boolean writeFileFromBytesByChannel(File file, byte[] byArray, boolean bl) {
        return FileIOUtils.writeFileFromBytesByChannel(file, byArray, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromBytesByChannel(File file, byte[] byArray, boolean bl, boolean bl2) {
        if (byArray == null) {
            return false;
        }
        FileChannel fileChannel = null;
        try {
            fileChannel = new FileOutputStream(file, bl).getChannel();
            fileChannel.position(fileChannel.size());
            fileChannel.write(ByteBuffer.wrap(byArray));
            if (bl2) {
                fileChannel.force(true);
            }
            boolean bl3 = true;
            return bl3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            boolean bl4 = false;
            return bl4;
        }
        finally {
            try {
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static boolean writeFileFromBytesByMap(String string, byte[] byArray, boolean bl) {
        return FileIOUtils.writeFileFromBytesByMap(string, byArray, false, bl);
    }

    public static boolean writeFileFromBytesByMap(String string, byte[] byArray, boolean bl, boolean bl2) {
        return FileIOUtils.writeFileFromBytesByMap(FileIOUtils.getFileByPath(string), byArray, bl, bl2);
    }

    public static boolean writeFileFromBytesByMap(File file, byte[] byArray, boolean bl) {
        return FileIOUtils.writeFileFromBytesByMap(file, byArray, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromBytesByMap(File file, byte[] byArray, boolean bl, boolean bl2) {
        if (byArray == null || !FileIOUtils.createOrExistsFile(file)) {
            return false;
        }
        FileChannel fileChannel = null;
        try {
            fileChannel = new FileOutputStream(file, bl).getChannel();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, fileChannel.size(), byArray.length);
            mappedByteBuffer.put(byArray);
            if (bl2) {
                mappedByteBuffer.force();
            }
            boolean bl3 = true;
            return bl3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            boolean bl4 = false;
            return bl4;
        }
        finally {
            try {
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static boolean writeFileFromString(String string, String string2) {
        return FileIOUtils.writeFileFromString(FileIOUtils.getFileByPath(string), string2, false);
    }

    public static boolean writeFileFromString(String string, String string2, boolean bl) {
        return FileIOUtils.writeFileFromString(FileIOUtils.getFileByPath(string), string2, bl);
    }

    public static boolean writeFileFromString(File file, String string) {
        return FileIOUtils.writeFileFromString(file, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromString(File file, String string, boolean bl) {
        if (file == null || string == null) {
            return false;
        }
        if (!FileIOUtils.createOrExistsFile(file)) {
            return false;
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file, bl));
            bufferedWriter.write(string);
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static List<String> readFile2List(String string) {
        return FileIOUtils.readFile2List(FileIOUtils.getFileByPath(string), null);
    }

    public static List<String> readFile2List(String string, String string2) {
        return FileIOUtils.readFile2List(FileIOUtils.getFileByPath(string), string2);
    }

    public static List<String> readFile2List(File file) {
        return FileIOUtils.readFile2List(file, 0, Integer.MAX_VALUE, null);
    }

    public static List<String> readFile2List(File file, String string) {
        return FileIOUtils.readFile2List(file, 0, Integer.MAX_VALUE, string);
    }

    public static List<String> readFile2List(String string, int n, int n2) {
        return FileIOUtils.readFile2List(FileIOUtils.getFileByPath(string), n, n2, null);
    }

    public static List<String> readFile2List(String string, int n, int n2, String string2) {
        return FileIOUtils.readFile2List(FileIOUtils.getFileByPath(string), n, n2, string2);
    }

    public static List<String> readFile2List(File file, int n, int n2) {
        return FileIOUtils.readFile2List(file, n, n2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile2List(File file, int n, int n2, String string) {
        if (!FileIOUtils.isFileExists(file)) {
            return null;
        }
        if (n > n2) {
            return null;
        }
        BufferedReader bufferedReader = null;
        try {
            String string2;
            ArrayList<String> arrayList = new ArrayList<String>();
            bufferedReader = FileIOUtils.isSpace(string) ? new BufferedReader(new InputStreamReader(new FileInputStream(file))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
            for (int i = 1; (string2 = bufferedReader.readLine()) != null && i <= n2; ++i) {
                if (n > i || i > n2) continue;
                arrayList.add(string2);
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            List<String> list = null;
            return list;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static String readFile2String(String string) {
        return FileIOUtils.readFile2String(FileIOUtils.getFileByPath(string), null);
    }

    public static String readFile2String(String string, String string2) {
        return FileIOUtils.readFile2String(FileIOUtils.getFileByPath(string), string2);
    }

    public static String readFile2String(File file) {
        return FileIOUtils.readFile2String(file, null);
    }

    public static String readFile2String(File file, String string) {
        byte[] byArray = FileIOUtils.readFile2BytesByStream(file);
        if (byArray == null) {
            return null;
        }
        if (FileIOUtils.isSpace(string)) {
            return new String(byArray);
        }
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return "";
        }
    }

    public static byte[] readFile2BytesByStream(String string) {
        return FileIOUtils.readFile2BytesByStream(FileIOUtils.getFileByPath(string));
    }

    public static byte[] readFile2BytesByStream(File file) {
        if (!FileIOUtils.isFileExists(file)) {
            return null;
        }
        try {
            return FileIOUtils.is2Bytes(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return null;
        }
    }

    public static byte[] readFile2BytesByChannel(String string) {
        return FileIOUtils.readFile2BytesByChannel(FileIOUtils.getFileByPath(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile2BytesByChannel(File file) {
        if (!FileIOUtils.isFileExists(file)) {
            return null;
        }
        FileChannel fileChannel = null;
        try {
            fileChannel = new RandomAccessFile(file, "r").getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)fileChannel.size());
            while (fileChannel.read(byteBuffer) > 0) {
            }
            byte[] byArray = byteBuffer.array();
            return byArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static byte[] readFile2BytesByMap(String string) {
        return FileIOUtils.readFile2BytesByMap(FileIOUtils.getFileByPath(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile2BytesByMap(File file) {
        if (!FileIOUtils.isFileExists(file)) {
            return null;
        }
        FileChannel fileChannel = null;
        try {
            fileChannel = new RandomAccessFile(file, "r").getChannel();
            int n = (int)fileChannel.size();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, n).load();
            byte[] byArray = new byte[n];
            mappedByteBuffer.get(byArray, 0, n);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void setBufferSize(int n) {
        sBufferSize = n;
    }

    private static File getFileByPath(String string) {
        return FileIOUtils.isSpace(string) ? null : new File(string);
    }

    private static boolean createOrExistsFile(String string) {
        return FileIOUtils.createOrExistsFile(FileIOUtils.getFileByPath(string));
    }

    private static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!FileIOUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    private static boolean isSpace(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] is2Bytes(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n;
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[sBufferSize];
            while ((n = inputStream.read(byArray, 0, sBufferSize)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

