/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.util.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class EncryptUtils {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private EncryptUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String encryptMD2ToString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptMD2ToString(string.getBytes());
    }

    public static String encryptMD2ToString(byte[] byArray) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD2(byArray));
    }

    public static byte[] encryptMD2(byte[] byArray) {
        return EncryptUtils.hashTemplate(byArray, "MD2");
    }

    public static String encryptMD5ToString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptMD5ToString(string.getBytes());
    }

    public static String encryptMD5ToString(String string, String string2) {
        if (string == null && string2 == null) {
            return "";
        }
        if (string2 == null) {
            return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD5(string.getBytes()));
        }
        if (string == null) {
            return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD5(string2.getBytes()));
        }
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD5((string + string2).getBytes()));
    }

    public static String encryptMD5ToString(byte[] byArray) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD5(byArray));
    }

    public static String encryptMD5ToString(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return "";
        }
        if (byArray2 == null) {
            return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD5(byArray));
        }
        if (byArray == null) {
            return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD5(byArray2));
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD5(byArray3));
    }

    public static byte[] encryptMD5(byte[] byArray) {
        return EncryptUtils.hashTemplate(byArray, "MD5");
    }

    public static String encryptMD5File2String(String string) {
        File file = EncryptUtils.isSpace(string) ? null : new File(string);
        return EncryptUtils.encryptMD5File2String(file);
    }

    public static byte[] encryptMD5File(String string) {
        File file = EncryptUtils.isSpace(string) ? null : new File(string);
        return EncryptUtils.encryptMD5File(file);
    }

    public static String encryptMD5File2String(File file) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD5File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encryptMD5File(File file) {
        if (file == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(fileInputStream, messageDigest);
            byte[] byArray = new byte[262144];
            while (digestInputStream.read(byArray) > 0) {
            }
            messageDigest = digestInputStream.getMessageDigest();
            byte[] byArray2 = messageDigest.digest();
            return byArray2;
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            exception.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static String encryptSHA1ToString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptSHA1ToString(string.getBytes());
    }

    public static String encryptSHA1ToString(byte[] byArray) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptSHA1(byArray));
    }

    public static byte[] encryptSHA1(byte[] byArray) {
        return EncryptUtils.hashTemplate(byArray, "SHA1");
    }

    public static String encryptSHA224ToString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptSHA224ToString(string.getBytes());
    }

    public static String encryptSHA224ToString(byte[] byArray) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptSHA224(byArray));
    }

    public static byte[] encryptSHA224(byte[] byArray) {
        return EncryptUtils.hashTemplate(byArray, "SHA224");
    }

    public static String encryptSHA256ToString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptSHA256ToString(string.getBytes());
    }

    public static String encryptSHA256ToString(byte[] byArray) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptSHA256(byArray));
    }

    public static byte[] encryptSHA256(byte[] byArray) {
        return EncryptUtils.hashTemplate(byArray, "SHA256");
    }

    public static String encryptSHA384ToString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptSHA384ToString(string.getBytes());
    }

    public static String encryptSHA384ToString(byte[] byArray) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptSHA384(byArray));
    }

    public static byte[] encryptSHA384(byte[] byArray) {
        return EncryptUtils.hashTemplate(byArray, "SHA384");
    }

    public static String encryptSHA512ToString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptSHA512ToString(string.getBytes());
    }

    public static String encryptSHA512ToString(byte[] byArray) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptSHA512(byArray));
    }

    public static byte[] encryptSHA512(byte[] byArray) {
        return EncryptUtils.hashTemplate(byArray, "SHA512");
    }

    private static byte[] hashTemplate(byte[] byArray, String string) {
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
    }

    public static String encryptHmacMD5ToString(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptHmacMD5ToString(string.getBytes(), string2.getBytes());
    }

    public static String encryptHmacMD5ToString(byte[] byArray, byte[] byArray2) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptHmacMD5(byArray, byArray2));
    }

    public static byte[] encryptHmacMD5(byte[] byArray, byte[] byArray2) {
        return EncryptUtils.hmacTemplate(byArray, byArray2, "HmacMD5");
    }

    public static String encryptHmacSHA1ToString(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptHmacSHA1ToString(string.getBytes(), string2.getBytes());
    }

    public static String encryptHmacSHA1ToString(byte[] byArray, byte[] byArray2) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptHmacSHA1(byArray, byArray2));
    }

    public static byte[] encryptHmacSHA1(byte[] byArray, byte[] byArray2) {
        return EncryptUtils.hmacTemplate(byArray, byArray2, "HmacSHA1");
    }

    public static String encryptHmacSHA224ToString(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptHmacSHA224ToString(string.getBytes(), string2.getBytes());
    }

    public static String encryptHmacSHA224ToString(byte[] byArray, byte[] byArray2) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptHmacSHA224(byArray, byArray2));
    }

    public static byte[] encryptHmacSHA224(byte[] byArray, byte[] byArray2) {
        return EncryptUtils.hmacTemplate(byArray, byArray2, "HmacSHA224");
    }

    public static String encryptHmacSHA256ToString(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptHmacSHA256ToString(string.getBytes(), string2.getBytes());
    }

    public static String encryptHmacSHA256ToString(byte[] byArray, byte[] byArray2) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptHmacSHA256(byArray, byArray2));
    }

    public static byte[] encryptHmacSHA256(byte[] byArray, byte[] byArray2) {
        return EncryptUtils.hmacTemplate(byArray, byArray2, "HmacSHA256");
    }

    public static String encryptHmacSHA384ToString(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptHmacSHA384ToString(string.getBytes(), string2.getBytes());
    }

    public static String encryptHmacSHA384ToString(byte[] byArray, byte[] byArray2) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptHmacSHA384(byArray, byArray2));
    }

    public static byte[] encryptHmacSHA384(byte[] byArray, byte[] byArray2) {
        return EncryptUtils.hmacTemplate(byArray, byArray2, "HmacSHA384");
    }

    public static String encryptHmacSHA512ToString(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptHmacSHA512ToString(string.getBytes(), string2.getBytes());
    }

    public static String encryptHmacSHA512ToString(byte[] byArray, byte[] byArray2) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptHmacSHA512(byArray, byArray2));
    }

    public static byte[] encryptHmacSHA512(byte[] byArray, byte[] byArray2) {
        return EncryptUtils.hmacTemplate(byArray, byArray2, "HmacSHA512");
    }

    private static byte[] hmacTemplate(byte[] byArray, byte[] byArray2, String string) {
        if (byArray == null || byArray.length == 0 || byArray2 == null || byArray2.length == 0) {
            return null;
        }
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, string);
            Mac mac = Mac.getInstance(string);
            mac.init(secretKeySpec);
            return mac.doFinal(byArray);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            generalSecurityException.printStackTrace();
            return null;
        }
    }

    public static byte[] encryptDES2Base64(byte[] byArray, byte[] byArray2, String string, byte[] byArray3) {
        return EncryptUtils.base64Encode(EncryptUtils.encryptDES(byArray, byArray2, string, byArray3));
    }

    public static String encryptDES2HexString(byte[] byArray, byte[] byArray2, String string, byte[] byArray3) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptDES(byArray, byArray2, string, byArray3));
    }

    public static byte[] encryptDES(byte[] byArray, byte[] byArray2, String string, byte[] byArray3) {
        return EncryptUtils.symmetricTemplate(byArray, byArray2, "DES", string, byArray3, true);
    }

    public static byte[] decryptBase64DES(byte[] byArray, byte[] byArray2, String string, byte[] byArray3) {
        return EncryptUtils.decryptDES(EncryptUtils.base64Decode(byArray), byArray2, string, byArray3);
    }

    public static byte[] decryptHexStringDES(String string, byte[] byArray, String string2, byte[] byArray2) {
        return EncryptUtils.decryptDES(EncryptUtils.hexString2Bytes(string), byArray, string2, byArray2);
    }

    public static byte[] decryptDES(byte[] byArray, byte[] byArray2, String string, byte[] byArray3) {
        return EncryptUtils.symmetricTemplate(byArray, byArray2, "DES", string, byArray3, false);
    }

    public static byte[] encrypt3DES2Base64(byte[] byArray, byte[] byArray2, String string, byte[] byArray3) {
        return EncryptUtils.base64Encode(EncryptUtils.encrypt3DES(byArray, byArray2, string, byArray3));
    }

    public static String encrypt3DES2HexString(byte[] byArray, byte[] byArray2, String string, byte[] byArray3) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encrypt3DES(byArray, byArray2, string, byArray3));
    }

    public static byte[] encrypt3DES(byte[] byArray, byte[] byArray2, String string, byte[] byArray3) {
        return EncryptUtils.symmetricTemplate(byArray, byArray2, "DESede", string, byArray3, true);
    }

    public static byte[] decryptBase64_3DES(byte[] byArray, byte[] byArray2, String string, byte[] byArray3) {
        return EncryptUtils.decrypt3DES(EncryptUtils.base64Decode(byArray), byArray2, string, byArray3);
    }

    public static byte[] decryptHexString3DES(String string, byte[] byArray, String string2, byte[] byArray2) {
        return EncryptUtils.decrypt3DES(EncryptUtils.hexString2Bytes(string), byArray, string2, byArray2);
    }

    public static byte[] decrypt3DES(byte[] byArray, byte[] byArray2, String string, byte[] byArray3) {
        return EncryptUtils.symmetricTemplate(byArray, byArray2, "DESede", string, byArray3, false);
    }

    public static byte[] encryptAES2Base64(byte[] byArray, byte[] byArray2, String string, byte[] byArray3) {
        return EncryptUtils.base64Encode(EncryptUtils.encryptAES(byArray, byArray2, string, byArray3));
    }

    public static String encryptAES2HexString(byte[] byArray, byte[] byArray2, String string, byte[] byArray3) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptAES(byArray, byArray2, string, byArray3));
    }

    public static byte[] encryptAES(byte[] byArray, byte[] byArray2, String string, byte[] byArray3) {
        return EncryptUtils.symmetricTemplate(byArray, byArray2, "AES", string, byArray3, true);
    }

    public static byte[] decryptBase64AES(byte[] byArray, byte[] byArray2, String string, byte[] byArray3) {
        return EncryptUtils.decryptAES(EncryptUtils.base64Decode(byArray), byArray2, string, byArray3);
    }

    public static byte[] decryptHexStringAES(String string, byte[] byArray, String string2, byte[] byArray2) {
        return EncryptUtils.decryptAES(EncryptUtils.hexString2Bytes(string), byArray, string2, byArray2);
    }

    public static byte[] decryptAES(byte[] byArray, byte[] byArray2, String string, byte[] byArray3) {
        return EncryptUtils.symmetricTemplate(byArray, byArray2, "AES", string, byArray3, false);
    }

    private static byte[] symmetricTemplate(byte[] byArray, byte[] byArray2, String string, String string2, byte[] byArray3, boolean bl) {
        if (byArray == null || byArray.length == 0 || byArray2 == null || byArray2.length == 0) {
            return null;
        }
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, string);
            Cipher cipher = Cipher.getInstance(string2);
            if (byArray3 == null || byArray3.length == 0) {
                cipher.init(bl ? 1 : 2, secretKeySpec);
            } else {
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
                cipher.init(bl ? 1 : 2, (Key)secretKeySpec, ivParameterSpec);
            }
            return cipher.doFinal(byArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static byte[] encryptRSA2Base64(byte[] byArray, byte[] byArray2, boolean bl, String string) {
        return EncryptUtils.base64Encode(EncryptUtils.encryptRSA(byArray, byArray2, bl, string));
    }

    public static String encryptRSA2HexString(byte[] byArray, byte[] byArray2, boolean bl, String string) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptRSA(byArray, byArray2, bl, string));
    }

    public static byte[] encryptRSA(byte[] byArray, byte[] byArray2, boolean bl, String string) {
        return EncryptUtils.rsaTemplate(byArray, byArray2, bl, string, true);
    }

    public static byte[] decryptBase64RSA(byte[] byArray, byte[] byArray2, boolean bl, String string) {
        return EncryptUtils.decryptRSA(EncryptUtils.base64Decode(byArray), byArray2, bl, string);
    }

    public static byte[] decryptHexStringRSA(String string, byte[] byArray, boolean bl, String string2) {
        return EncryptUtils.decryptRSA(EncryptUtils.hexString2Bytes(string), byArray, bl, string2);
    }

    public static byte[] decryptRSA(byte[] byArray, byte[] byArray2, boolean bl, String string) {
        return EncryptUtils.rsaTemplate(byArray, byArray2, bl, string, false);
    }

    private static byte[] rsaTemplate(byte[] byArray, byte[] byArray2, boolean bl, String string, boolean bl2) {
        if (byArray == null || byArray.length == 0 || byArray2 == null || byArray2.length == 0) {
            return null;
        }
        try {
            Key key;
            Object object;
            if (bl) {
                object = new X509EncodedKeySpec(byArray2);
                key = KeyFactory.getInstance("RSA").generatePublic((KeySpec)object);
            } else {
                object = new PKCS8EncodedKeySpec(byArray2);
                key = KeyFactory.getInstance("RSA").generatePrivate((KeySpec)object);
            }
            if (key == null) {
                return null;
            }
            object = Cipher.getInstance(string);
            ((Cipher)object).init(bl2 ? 1 : 2, key);
            int n = byArray.length;
            int n2 = bl2 ? 117 : 128;
            int n3 = n / n2;
            if (n3 > 0) {
                int n4;
                byte[] byArray3 = new byte[]{};
                byte[] byArray4 = new byte[n2];
                int n5 = 0;
                for (n4 = 0; n4 < n3; ++n4) {
                    System.arraycopy(byArray, n5, byArray4, 0, n2);
                    byArray3 = EncryptUtils.joins(byArray3, ((Cipher)object).doFinal(byArray4));
                    n5 += n2;
                }
                if (n5 != n) {
                    n4 = n - n5;
                    byArray4 = new byte[n4];
                    System.arraycopy(byArray, n5, byArray4, 0, n4);
                    byArray3 = EncryptUtils.joins(byArray3, ((Cipher)object).doFinal(byArray4));
                }
                return byArray3;
            }
            return ((Cipher)object).doFinal(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            noSuchPaddingException.printStackTrace();
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        catch (BadPaddingException badPaddingException) {
            badPaddingException.printStackTrace();
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            illegalBlockSizeException.printStackTrace();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            invalidKeySpecException.printStackTrace();
        }
        return null;
    }

    private static byte[] joins(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    private static String bytes2HexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        int n = byArray.length;
        if (n <= 0) {
            return "";
        }
        char[] cArray = new char[n << 1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            cArray[n2++] = HEX_DIGITS[byArray[i] >> 4 & 0xF];
            cArray[n2++] = HEX_DIGITS[byArray[i] & 0xF];
        }
        return new String(cArray);
    }

    private static byte[] hexString2Bytes(String string) {
        if (EncryptUtils.isSpace(string)) {
            return null;
        }
        int n = string.length();
        if (n % 2 != 0) {
            string = "0" + string;
            ++n;
        }
        char[] cArray = string.toUpperCase().toCharArray();
        byte[] byArray = new byte[n >> 1];
        for (int i = 0; i < n; i += 2) {
            byArray[i >> 1] = (byte)(EncryptUtils.hex2Dec(cArray[i]) << 4 | EncryptUtils.hex2Dec(cArray[i + 1]));
        }
        return byArray;
    }

    private static int hex2Dec(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException();
    }

    private static byte[] base64Encode(byte[] byArray) {
        return Base64.encode((byte[])byArray, (int)2);
    }

    private static byte[] base64Decode(byte[] byArray) {
        return Base64.decode((byte[])byArray, (int)2);
    }

    private static boolean isSpace(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

