/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.os.Build;
import android.text.Html;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public final class EncodeUtils {
    private EncodeUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String urlEncode(String string) {
        return EncodeUtils.urlEncode(string, "UTF-8");
    }

    public static String urlEncode(String string, String string2) {
        if (string == null || string.length() == 0) {
            return "";
        }
        try {
            return URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    public static String urlDecode(String string) {
        return EncodeUtils.urlDecode(string, "UTF-8");
    }

    public static String urlDecode(String string, String string2) {
        if (string == null || string.length() == 0) {
            return "";
        }
        try {
            return URLDecoder.decode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    public static byte[] base64Encode(String string) {
        return EncodeUtils.base64Encode(string.getBytes());
    }

    public static byte[] base64Encode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return new byte[0];
        }
        return Base64.encode((byte[])byArray, (int)2);
    }

    public static String base64Encode2String(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        return Base64.encodeToString((byte[])byArray, (int)2);
    }

    public static byte[] base64Decode(String string) {
        if (string == null || string.length() == 0) {
            return new byte[0];
        }
        return Base64.decode((String)string, (int)2);
    }

    public static byte[] base64Decode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return new byte[0];
        }
        return Base64.decode((byte[])byArray, (int)2);
    }

    public static String htmlEncode(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = charSequence.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static CharSequence htmlDecode(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        if (Build.VERSION.SDK_INT >= 24) {
            return Html.fromHtml((String)string, (int)0);
        }
        return Html.fromHtml((String)string);
    }
}

