/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import com.blankj.utilcode.util.ShellUtils;
import com.blankj.utilcode.util.Utils;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public final class DeviceUtils {
    private DeviceUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isDeviceRooted() {
        String[] stringArray;
        String string = "su";
        for (String string2 : stringArray = new String[]{"/system/bin/", "/system/xbin/", "/sbin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/xbin/", "/data/local/bin/", "/data/local/"}) {
            if (!new File(string2 + string).exists()) continue;
            return true;
        }
        return false;
    }

    public static String getSDKVersionName() {
        return Build.VERSION.RELEASE;
    }

    public static int getSDKVersionCode() {
        return Build.VERSION.SDK_INT;
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getAndroidID() {
        String string = Settings.Secure.getString((ContentResolver)Utils.getApp().getContentResolver(), (String)"android_id");
        return string == null ? "" : string;
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.INTERNET"})
    public static String getMacAddress() {
        return DeviceUtils.getMacAddress(null);
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.INTERNET"})
    public static String getMacAddress(String ... stringArray) {
        String string = DeviceUtils.getMacAddressByWifiInfo();
        if (DeviceUtils.isAddressNotInExcepts(string, stringArray)) {
            return string;
        }
        string = DeviceUtils.getMacAddressByNetworkInterface();
        if (DeviceUtils.isAddressNotInExcepts(string, stringArray)) {
            return string;
        }
        string = DeviceUtils.getMacAddressByInetAddress();
        if (DeviceUtils.isAddressNotInExcepts(string, stringArray)) {
            return string;
        }
        string = DeviceUtils.getMacAddressByFile();
        if (DeviceUtils.isAddressNotInExcepts(string, stringArray)) {
            return string;
        }
        return "";
    }

    private static boolean isAddressNotInExcepts(String string, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return !"02:00:00:00:00:00".equals(string);
        }
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return false;
        }
        return true;
    }

    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    private static String getMacAddressByWifiInfo() {
        try {
            WifiInfo wifiInfo;
            Context context = Utils.getApp().getApplicationContext();
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            if (wifiManager != null && (wifiInfo = wifiManager.getConnectionInfo()) != null) {
                return wifiInfo.getMacAddress();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static String getMacAddressByNetworkInterface() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                byte[] byArray;
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface == null || !networkInterface.getName().equalsIgnoreCase("wlan0") || (byArray = networkInterface.getHardwareAddress()) == null || byArray.length <= 0) continue;
                StringBuilder stringBuilder = new StringBuilder();
                for (byte by : byArray) {
                    stringBuilder.append(String.format("%02x:", by));
                }
                return stringBuilder.substring(0, stringBuilder.length() - 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static String getMacAddressByInetAddress() {
        try {
            byte[] byArray;
            NetworkInterface networkInterface;
            InetAddress inetAddress = DeviceUtils.getInetAddress();
            if (inetAddress != null && (networkInterface = NetworkInterface.getByInetAddress(inetAddress)) != null && (byArray = networkInterface.getHardwareAddress()) != null && byArray.length > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (byte by : byArray) {
                    stringBuilder.append(String.format("%02x:", by));
                }
                return stringBuilder.substring(0, stringBuilder.length() - 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static InetAddress getInetAddress() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (!networkInterface.isUp()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    String string;
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress() || (string = inetAddress.getHostAddress()).indexOf(58) >= 0) continue;
                    return inetAddress;
                }
            }
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        return null;
    }

    private static String getMacAddressByFile() {
        String string;
        ShellUtils.CommandResult commandResult = ShellUtils.execCmd("getprop wifi.interface", false);
        if (commandResult.result == 0 && (string = commandResult.successMsg) != null) {
            String string2;
            commandResult = ShellUtils.execCmd("cat /sys/class/net/" + string + "/address", false);
            if (commandResult.result == 0 && (string2 = commandResult.successMsg) != null && string2.length() > 0) {
                return string2;
            }
        }
        return "02:00:00:00:00:00";
    }

    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getModel() {
        String string = Build.MODEL;
        string = string != null ? string.trim().replaceAll("\\s*", "") : "";
        return string;
    }

    public static String[] getABIs() {
        if (Build.VERSION.SDK_INT >= 21) {
            return Build.SUPPORTED_ABIS;
        }
        if (!TextUtils.isEmpty((CharSequence)Build.CPU_ABI2)) {
            return new String[]{Build.CPU_ABI, Build.CPU_ABI2};
        }
        return new String[]{Build.CPU_ABI};
    }

    public static void shutdown() {
        ShellUtils.execCmd("reboot -p", true);
        Intent intent = new Intent("android.intent.action.ACTION_REQUEST_SHUTDOWN");
        intent.putExtra("android.intent.extra.KEY_CONFIRM", false);
        Utils.getApp().startActivity(intent.addFlags(0x10000000));
    }

    public static void reboot() {
        ShellUtils.execCmd("reboot", true);
        Intent intent = new Intent("android.intent.action.REBOOT");
        intent.putExtra("nowait", 1);
        intent.putExtra("interval", 1);
        intent.putExtra("window", 0);
        Utils.getApp().sendBroadcast(intent);
    }

    public static void reboot(String string) {
        PowerManager powerManager = (PowerManager)Utils.getApp().getSystemService("power");
        try {
            if (powerManager == null) {
                return;
            }
            powerManager.reboot(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void reboot2Recovery() {
        ShellUtils.execCmd("reboot recovery", true);
    }

    public static void reboot2Bootloader() {
        ShellUtils.execCmd("reboot bootloader", true);
    }
}

