/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.blankj.utilcode.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class ConvertUtils {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private ConvertUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String bytes2Bits(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            for (int i = 7; i >= 0; --i) {
                stringBuilder.append((by >> i & 1) == 0 ? (char)'0' : '1');
            }
        }
        return stringBuilder.toString();
    }

    public static byte[] bits2Bytes(String string) {
        int n = string.length() % 8;
        int n2 = string.length() / 8;
        if (n != 0) {
            for (int i = n; i < 8; ++i) {
                string = "0" + string;
            }
            ++n2;
        }
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n3 = i;
                byArray[n3] = (byte)(byArray[n3] << 1);
                int n4 = i;
                byArray[n4] = (byte)(byArray[n4] | string.charAt(i * 8 + j) - 48);
            }
        }
        return byArray;
    }

    public static char[] bytes2Chars(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        if (n <= 0) {
            return null;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return cArray;
    }

    public static byte[] chars2Bytes(char[] cArray) {
        if (cArray == null || cArray.length <= 0) {
            return null;
        }
        int n = cArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    public static String bytes2HexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        int n = byArray.length;
        if (n <= 0) {
            return "";
        }
        char[] cArray = new char[n << 1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            cArray[n2++] = hexDigits[byArray[i] >> 4 & 0xF];
            cArray[n2++] = hexDigits[byArray[i] & 0xF];
        }
        return new String(cArray);
    }

    public static byte[] hexString2Bytes(String string) {
        if (ConvertUtils.isSpace(string)) {
            return null;
        }
        int n = string.length();
        if (n % 2 != 0) {
            string = "0" + string;
            ++n;
        }
        char[] cArray = string.toUpperCase().toCharArray();
        byte[] byArray = new byte[n >> 1];
        for (int i = 0; i < n; i += 2) {
            byArray[i >> 1] = (byte)(ConvertUtils.hex2Int(cArray[i]) << 4 | ConvertUtils.hex2Int(cArray[i + 1]));
        }
        return byArray;
    }

    private static int hex2Int(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException();
    }

    public static long memorySize2Byte(long l, int n) {
        if (l < 0L) {
            return -1L;
        }
        return l * (long)n;
    }

    public static double byte2MemorySize(long l, int n) {
        if (l < 0L) {
            return -1.0;
        }
        return (double)l / (double)n;
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String byte2FitMemorySize(long l) {
        if (l < 0L) {
            return "shouldn't be less than zero!";
        }
        if (l < 1024L) {
            return String.format("%.3fB", l);
        }
        if (l < 0x100000L) {
            return String.format("%.3fKB", (double)l / 1024.0);
        }
        if (l < 0x40000000L) {
            return String.format("%.3fMB", (double)l / 1048576.0);
        }
        return String.format("%.3fGB", (double)l / 1.073741824E9);
    }

    public static long timeSpan2Millis(long l, int n) {
        return l * (long)n;
    }

    public static long millis2TimeSpan(long l, int n) {
        return l / (long)n;
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String millis2FitTimeSpan(long l, int n) {
        if (l <= 0L || n <= 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = new String[]{"\u5929", "\u5c0f\u65f6", "\u5206\u949f", "\u79d2", "\u6beb\u79d2"};
        int[] nArray = new int[]{86400000, 3600000, 60000, 1000, 1};
        n = Math.min(n, 5);
        for (int i = 0; i < n; ++i) {
            if (l < (long)nArray[i]) continue;
            long l2 = l / (long)nArray[i];
            l -= l2 * (long)nArray[i];
            stringBuilder.append(l2).append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream input2OutputStream(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray, 0, 1024)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            return byteArrayOutputStream2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            ByteArrayOutputStream byteArrayOutputStream = null;
            return byteArrayOutputStream;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public ByteArrayInputStream output2InputStream(OutputStream outputStream) {
        if (outputStream == null) {
            return null;
        }
        return new ByteArrayInputStream(((ByteArrayOutputStream)outputStream).toByteArray());
    }

    public static byte[] inputStream2Bytes(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        return ConvertUtils.input2OutputStream(inputStream).toByteArray();
    }

    public static InputStream bytes2InputStream(byte[] byArray) {
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    public static byte[] outputStream2Bytes(OutputStream outputStream) {
        if (outputStream == null) {
            return null;
        }
        return ((ByteArrayOutputStream)outputStream).toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream bytes2OutputStream(byte[] byArray) {
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(byArray);
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            return byteArrayOutputStream2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            OutputStream outputStream = null;
            return outputStream;
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static String inputStream2String(InputStream inputStream, String string) {
        if (inputStream == null || ConvertUtils.isSpace(string)) {
            return "";
        }
        try {
            return new String(ConvertUtils.inputStream2Bytes(inputStream), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return "";
        }
    }

    public static InputStream string2InputStream(String string, String string2) {
        if (string == null || ConvertUtils.isSpace(string2)) {
            return null;
        }
        try {
            return new ByteArrayInputStream(string.getBytes(string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public static String outputStream2String(OutputStream outputStream, String string) {
        if (outputStream == null || ConvertUtils.isSpace(string)) {
            return "";
        }
        try {
            return new String(ConvertUtils.outputStream2Bytes(outputStream), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return "";
        }
    }

    public static OutputStream string2OutputStream(String string, String string2) {
        if (string == null || ConvertUtils.isSpace(string2)) {
            return null;
        }
        try {
            return ConvertUtils.bytes2OutputStream(string.getBytes(string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public static byte[] bitmap2Bytes(Bitmap bitmap, Bitmap.CompressFormat compressFormat) {
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(compressFormat, 100, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Bitmap bytes2Bitmap(byte[] byArray) {
        return byArray == null || byArray.length == 0 ? null : BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
    }

    public static Bitmap drawable2Bitmap(Drawable drawable) {
        BitmapDrawable bitmapDrawable;
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        bitmapDrawable = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565)) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas((Bitmap)bitmapDrawable);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmapDrawable;
    }

    public static Drawable bitmap2Drawable(Bitmap bitmap) {
        return bitmap == null ? null : new BitmapDrawable(Utils.getApp().getResources(), bitmap);
    }

    public static byte[] drawable2Bytes(Drawable drawable, Bitmap.CompressFormat compressFormat) {
        return drawable == null ? null : ConvertUtils.bitmap2Bytes(ConvertUtils.drawable2Bitmap(drawable), compressFormat);
    }

    public static Drawable bytes2Drawable(byte[] byArray) {
        return byArray == null ? null : ConvertUtils.bitmap2Drawable(ConvertUtils.bytes2Bitmap(byArray));
    }

    public static Bitmap view2Bitmap(View view) {
        if (view == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Drawable drawable = view.getBackground();
        if (drawable != null) {
            drawable.draw(canvas);
        } else {
            canvas.drawColor(-1);
        }
        view.draw(canvas);
        return bitmap;
    }

    public static int dp2px(float f) {
        float f2 = Utils.getApp().getResources().getDisplayMetrics().density;
        return (int)(f * f2 + 0.5f);
    }

    public static int px2dp(float f) {
        float f2 = Utils.getApp().getResources().getDisplayMetrics().density;
        return (int)(f / f2 + 0.5f);
    }

    public static int sp2px(float f) {
        float f2 = Utils.getApp().getResources().getDisplayMetrics().scaledDensity;
        return (int)(f * f2 + 0.5f);
    }

    public static int px2sp(float f) {
        float f2 = Utils.getApp().getResources().getDisplayMetrics().scaledDensity;
        return (int)(f / f2 + 0.5f);
    }

    private static boolean isSpace(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

