/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.os.Environment;
import com.blankj.utilcode.util.Utils;
import java.io.File;

public final class CleanUtils {
    private CleanUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean cleanInternalCache() {
        return CleanUtils.deleteFilesInDir(Utils.getApp().getCacheDir());
    }

    public static boolean cleanInternalFiles() {
        return CleanUtils.deleteFilesInDir(Utils.getApp().getFilesDir());
    }

    public static boolean cleanInternalDbs() {
        return CleanUtils.deleteFilesInDir(new File(Utils.getApp().getFilesDir().getParent(), "databases"));
    }

    public static boolean cleanInternalDbByName(String string) {
        return Utils.getApp().deleteDatabase(string);
    }

    public static boolean cleanInternalSp() {
        return CleanUtils.deleteFilesInDir(new File(Utils.getApp().getFilesDir().getParent(), "shared_prefs"));
    }

    public static boolean cleanExternalCache() {
        return "mounted".equals(Environment.getExternalStorageState()) && CleanUtils.deleteFilesInDir(Utils.getApp().getExternalCacheDir());
    }

    public static boolean cleanCustomDir(String string) {
        return CleanUtils.deleteFilesInDir(string);
    }

    public static boolean cleanCustomDir(File file) {
        return CleanUtils.deleteFilesInDir(file);
    }

    public static boolean deleteFilesInDir(String string) {
        return CleanUtils.deleteFilesInDir(CleanUtils.getFileByPath(string));
    }

    private static boolean deleteFilesInDir(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length != 0) {
            for (File file2 : fileArray) {
                if (!(file2.isFile() ? !file2.delete() : file2.isDirectory() && !CleanUtils.deleteDir(file2))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean deleteDir(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length != 0) {
            for (File file2 : fileArray) {
                if (!(file2.isFile() ? !file2.delete() : file2.isDirectory() && !CleanUtils.deleteDir(file2))) continue;
                return false;
            }
        }
        return file.delete();
    }

    private static File getFileByPath(String string) {
        return CleanUtils.isSpace(string) ? null : new File(string);
    }

    private static boolean isSpace(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

