/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.util.SimpleArrayMap;
import com.blankj.utilcode.constant.CacheConstants;
import com.blankj.utilcode.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONArray;
import org.json.JSONObject;

@Deprecated
public class CacheUtils
implements CacheConstants {
    private static final long DEFAULT_MAX_SIZE = Long.MAX_VALUE;
    private static final int DEFAULT_MAX_COUNT = Integer.MAX_VALUE;
    private static final SimpleArrayMap<String, CacheUtils> CACHE_MAP = new SimpleArrayMap();
    private final String mCacheKey;
    private final DiskCacheManager mDiskCacheManager;

    public static CacheUtils getInstance() {
        return CacheUtils.getInstance("", Long.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static CacheUtils getInstance(String string) {
        return CacheUtils.getInstance(string, Long.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static CacheUtils getInstance(long l, int n) {
        return CacheUtils.getInstance("", l, n);
    }

    public static CacheUtils getInstance(String string, long l, int n) {
        if (CacheUtils.isSpace(string)) {
            string = "cacheUtils";
        }
        File file = new File(Utils.getApp().getCacheDir(), string);
        return CacheUtils.getInstance(file, l, n);
    }

    public static CacheUtils getInstance(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("Argument 'cacheDir' of type File (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return CacheUtils.getInstance(file, Long.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static CacheUtils getInstance(@NonNull File file, long l, int n) {
        if (file == null) {
            throw new NullPointerException("Argument 'cacheDir' of type File (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        String string = file.getAbsoluteFile() + "_" + n + "_" + n;
        CacheUtils cacheUtils = (CacheUtils)CACHE_MAP.get((Object)string);
        if (cacheUtils == null) {
            if (!file.exists() && !file.mkdirs()) {
                throw new RuntimeException("can't make dirs in " + file.getAbsolutePath());
            }
            cacheUtils = new CacheUtils(string, new DiskCacheManager(file, l, n));
            CACHE_MAP.put((Object)string, (Object)cacheUtils);
        }
        return cacheUtils;
    }

    private CacheUtils(String string, DiskCacheManager diskCacheManager) {
        this.mCacheKey = string;
        this.mDiskCacheManager = diskCacheManager;
    }

    public String toString() {
        return this.mCacheKey + "@" + Integer.toHexString(this.hashCode());
    }

    public void put(@NonNull String string, byte[] byArray) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, byArray, -1);
    }

    public void put(@NonNull String string, byte[] byArray, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (byArray == null || byArray.length <= 0) {
            return;
        }
        if (n >= 0) {
            byArray = DiskCacheHelper.newByteArrayWithTime(n, byArray);
        }
        File file = this.mDiskCacheManager.getFileBeforePut(string);
        DiskCacheHelper.writeFileFromBytes(file, byArray);
        this.mDiskCacheManager.updateModify(file);
        this.mDiskCacheManager.put(file);
    }

    public byte[] getBytes(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getBytes(string, null);
    }

    public byte[] getBytes(@NonNull String string, byte[] byArray) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        File file = this.mDiskCacheManager.getFileIfExists(string);
        if (file == null) {
            return byArray;
        }
        byte[] byArray2 = DiskCacheHelper.readFile2Bytes(file);
        if (DiskCacheHelper.isDue(byArray2)) {
            this.mDiskCacheManager.removeByKey(string);
            return byArray;
        }
        this.mDiskCacheManager.updateModify(file);
        return DiskCacheHelper.getDataWithoutDueTime(byArray2);
    }

    public void put(@NonNull String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, string2, -1);
    }

    public void put(@NonNull String string, String string2, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, CacheUtils.string2Bytes(string2), n);
    }

    public String getString(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getString(string, null);
    }

    public String getString(@NonNull String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        byte[] byArray = this.getBytes(string);
        if (byArray == null) {
            return string2;
        }
        return CacheUtils.bytes2String(byArray);
    }

    public void put(@NonNull String string, JSONObject jSONObject) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, jSONObject, -1);
    }

    public void put(@NonNull String string, JSONObject jSONObject, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, CacheUtils.jsonObject2Bytes(jSONObject), n);
    }

    public JSONObject getJSONObject(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getJSONObject(string, null);
    }

    public JSONObject getJSONObject(@NonNull String string, JSONObject jSONObject) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        byte[] byArray = this.getBytes(string);
        if (byArray == null) {
            return jSONObject;
        }
        return CacheUtils.bytes2JSONObject(byArray);
    }

    public void put(@NonNull String string, JSONArray jSONArray) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, jSONArray, -1);
    }

    public void put(@NonNull String string, JSONArray jSONArray, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, CacheUtils.jsonArray2Bytes(jSONArray), n);
    }

    public JSONArray getJSONArray(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getJSONArray(string, null);
    }

    public JSONArray getJSONArray(@NonNull String string, JSONArray jSONArray) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        byte[] byArray = this.getBytes(string);
        if (byArray == null) {
            return jSONArray;
        }
        return CacheUtils.bytes2JSONArray(byArray);
    }

    public void put(@NonNull String string, Bitmap bitmap) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, bitmap, -1);
    }

    public void put(@NonNull String string, Bitmap bitmap, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, CacheUtils.bitmap2Bytes(bitmap), n);
    }

    public Bitmap getBitmap(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getBitmap(string, null);
    }

    public Bitmap getBitmap(@NonNull String string, Bitmap bitmap) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        byte[] byArray = this.getBytes(string);
        if (byArray == null) {
            return bitmap;
        }
        return CacheUtils.bytes2Bitmap(byArray);
    }

    public void put(@NonNull String string, Drawable drawable) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, drawable, -1);
    }

    public void put(@NonNull String string, Drawable drawable, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, CacheUtils.drawable2Bytes(drawable), n);
    }

    public Drawable getDrawable(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getDrawable(string, null);
    }

    public Drawable getDrawable(@NonNull String string, Drawable drawable) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        byte[] byArray = this.getBytes(string);
        if (byArray == null) {
            return drawable;
        }
        return CacheUtils.bytes2Drawable(byArray);
    }

    public void put(@NonNull String string, Parcelable parcelable) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, parcelable, -1);
    }

    public void put(@NonNull String string, Parcelable parcelable, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, CacheUtils.parcelable2Bytes(parcelable), n);
    }

    public <T> T getParcelable(@NonNull String string, @NonNull Parcelable.Creator<T> creator) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (creator == null) {
            throw new NullPointerException("Argument 'creator' of type Parcelable.Creator<T> (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getParcelable(string, creator, null);
    }

    public <T> T getParcelable(@NonNull String string, @NonNull Parcelable.Creator<T> creator, T t) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (creator == null) {
            throw new NullPointerException("Argument 'creator' of type Parcelable.Creator<T> (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        byte[] byArray = this.getBytes(string);
        if (byArray == null) {
            return t;
        }
        return CacheUtils.bytes2Parcelable(byArray, creator);
    }

    public void put(@NonNull String string, Serializable serializable) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, serializable, -1);
    }

    public void put(@NonNull String string, Serializable serializable, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, CacheUtils.serializable2Bytes(serializable), n);
    }

    public Object getSerializable(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getSerializable(string, null);
    }

    public Object getSerializable(@NonNull String string, Object object) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        byte[] byArray = this.getBytes(string);
        if (byArray == null) {
            return object;
        }
        return CacheUtils.bytes2Object(this.getBytes(string));
    }

    public long getCacheSize() {
        return this.mDiskCacheManager.getCacheSize();
    }

    public int getCacheCount() {
        return this.mDiskCacheManager.getCacheCount();
    }

    public boolean remove(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.mDiskCacheManager.removeByKey(string);
    }

    public boolean clear() {
        return this.mDiskCacheManager.clear();
    }

    private static byte[] string2Bytes(String string) {
        if (string == null) {
            return null;
        }
        return string.getBytes();
    }

    private static String bytes2String(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    private static byte[] jsonObject2Bytes(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        return jSONObject.toString().getBytes();
    }

    private static JSONObject bytes2JSONObject(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        try {
            return new JSONObject(new String(byArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static byte[] jsonArray2Bytes(JSONArray jSONArray) {
        if (jSONArray == null) {
            return null;
        }
        return jSONArray.toString().getBytes();
    }

    private static JSONArray bytes2JSONArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        try {
            return new JSONArray(new String(byArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static byte[] parcelable2Bytes(Parcelable parcelable) {
        if (parcelable == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        parcelable.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        return byArray;
    }

    private static <T> T bytes2Parcelable(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        Object object = creator.createFromParcel(parcel);
        parcel.recycle();
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] serializable2Bytes(Serializable serializable) {
        if (serializable == null) {
            return null;
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object bytes2Object(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Object var3_5 = null;
            return var3_5;
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static byte[] bitmap2Bytes(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static Bitmap bytes2Bitmap(byte[] byArray) {
        return byArray == null || byArray.length <= 0 ? null : BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
    }

    private static byte[] drawable2Bytes(Drawable drawable) {
        return drawable == null ? null : CacheUtils.bitmap2Bytes(CacheUtils.drawable2Bitmap(drawable));
    }

    private static Drawable bytes2Drawable(byte[] byArray) {
        return byArray == null ? null : CacheUtils.bitmap2Drawable(CacheUtils.bytes2Bitmap(byArray));
    }

    private static Bitmap drawable2Bitmap(Drawable drawable) {
        BitmapDrawable bitmapDrawable;
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        bitmapDrawable = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565)) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas((Bitmap)bitmapDrawable);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmapDrawable;
    }

    private static Drawable bitmap2Drawable(Bitmap bitmap) {
        return bitmap == null ? null : new BitmapDrawable(Utils.getApp().getResources(), bitmap);
    }

    private static boolean isSpace(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static final class DiskCacheHelper {
        static final int TIME_INFO_LEN = 14;

        private DiskCacheHelper() {
        }

        private static byte[] newByteArrayWithTime(int n, byte[] byArray) {
            byte[] byArray2 = DiskCacheHelper.createDueTime(n).getBytes();
            byte[] byArray3 = new byte[byArray2.length + byArray.length];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
            return byArray3;
        }

        private static String createDueTime(int n) {
            return String.format(Locale.getDefault(), "_$%010d$_", System.currentTimeMillis() / 1000L + (long)n);
        }

        private static boolean isDue(byte[] byArray) {
            long l = DiskCacheHelper.getDueTime(byArray);
            return l != -1L && System.currentTimeMillis() > l;
        }

        private static long getDueTime(byte[] byArray) {
            if (DiskCacheHelper.hasTimeInfo(byArray)) {
                String string = new String(DiskCacheHelper.copyOfRange(byArray, 2, 12));
                try {
                    return Long.parseLong(string) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                    return -1L;
                }
            }
            return -1L;
        }

        private static byte[] getDataWithoutDueTime(byte[] byArray) {
            if (DiskCacheHelper.hasTimeInfo(byArray)) {
                return DiskCacheHelper.copyOfRange(byArray, 14, byArray.length);
            }
            return byArray;
        }

        private static byte[] copyOfRange(byte[] byArray, int n, int n2) {
            int n3 = n2 - n;
            if (n3 < 0) {
                throw new IllegalArgumentException(n + " > " + n2);
            }
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n, byArray2, 0, Math.min(byArray.length - n, n3));
            return byArray2;
        }

        private static boolean hasTimeInfo(byte[] byArray) {
            return byArray != null && byArray.length >= 14 && byArray[0] == 95 && byArray[1] == 36 && byArray[12] == 36 && byArray[13] == 95;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void writeFileFromBytes(File file, byte[] byArray) {
            FileChannel fileChannel = null;
            try {
                fileChannel = new FileOutputStream(file, false).getChannel();
                fileChannel.write(ByteBuffer.wrap(byArray));
                fileChannel.force(true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    if (fileChannel != null) {
                        fileChannel.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static byte[] readFile2Bytes(File file) {
            FileChannel fileChannel = null;
            try {
                fileChannel = new RandomAccessFile(file, "r").getChannel();
                int n = (int)fileChannel.size();
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, n).load();
                byte[] byArray = new byte[n];
                mappedByteBuffer.get(byArray, 0, n);
                byte[] byArray2 = byArray;
                return byArray2;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                byte[] byArray = null;
                return byArray;
            }
            finally {
                try {
                    if (fileChannel != null) {
                        fileChannel.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private static final class DiskCacheManager {
        private final AtomicLong cacheSize;
        private final AtomicInteger cacheCount;
        private final long sizeLimit;
        private final int countLimit;
        private final Map<File, Long> lastUsageDates = Collections.synchronizedMap(new HashMap());
        private final File cacheDir;
        private final Thread mThread;

        private DiskCacheManager(final File file, long l, int n) {
            this.cacheDir = file;
            this.sizeLimit = l;
            this.countLimit = n;
            this.cacheSize = new AtomicLong();
            this.cacheCount = new AtomicInteger();
            this.mThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int n = 0;
                    int n2 = 0;
                    File[] fileArray = file.listFiles();
                    if (fileArray != null) {
                        for (File file2 : fileArray) {
                            n = (int)((long)n + file2.length());
                            ++n2;
                            DiskCacheManager.this.lastUsageDates.put(file2, file2.lastModified());
                        }
                        DiskCacheManager.this.cacheSize.getAndAdd(n);
                        DiskCacheManager.this.cacheCount.getAndAdd(n2);
                    }
                }
            });
            this.mThread.start();
        }

        private long getCacheSize() {
            try {
                this.mThread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return this.cacheSize.get();
        }

        private int getCacheCount() {
            try {
                this.mThread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return this.cacheCount.get();
        }

        private File getFileBeforePut(String string) {
            File file = new File(this.cacheDir, String.valueOf(string.hashCode()));
            if (file.exists()) {
                this.cacheCount.addAndGet(-1);
                this.cacheSize.addAndGet(-file.length());
            }
            return file;
        }

        private File getFileIfExists(String string) {
            File file = new File(this.cacheDir, String.valueOf(string.hashCode()));
            if (!file.exists()) {
                return null;
            }
            return file;
        }

        private void put(File file) {
            this.cacheCount.addAndGet(1);
            this.cacheSize.addAndGet(file.length());
            while (this.cacheCount.get() > this.countLimit || this.cacheSize.get() > this.sizeLimit) {
                this.cacheSize.addAndGet(-this.removeOldest());
                this.cacheCount.addAndGet(-1);
            }
        }

        private void updateModify(File file) {
            Long l = System.currentTimeMillis();
            file.setLastModified(l);
            this.lastUsageDates.put(file, l);
        }

        private boolean removeByKey(String string) {
            File file = this.getFileIfExists(string);
            if (file == null) {
                return true;
            }
            if (!file.delete()) {
                return false;
            }
            this.cacheSize.addAndGet(-file.length());
            this.cacheCount.addAndGet(-1);
            this.lastUsageDates.remove(file);
            return true;
        }

        private boolean clear() {
            File[] fileArray = this.cacheDir.listFiles();
            if (fileArray == null || fileArray.length <= 0) {
                return true;
            }
            boolean bl = true;
            for (File file : fileArray) {
                if (!file.delete()) {
                    bl = false;
                    continue;
                }
                this.cacheSize.addAndGet(-file.length());
                this.cacheCount.addAndGet(-1);
                this.lastUsageDates.remove(file);
            }
            if (bl) {
                this.lastUsageDates.clear();
                this.cacheSize.set(0L);
                this.cacheCount.set(0);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long removeOldest() {
            if (this.lastUsageDates.isEmpty()) {
                return 0L;
            }
            Long l = Long.MAX_VALUE;
            File file = null;
            Set<Map.Entry<File, Long>> set = this.lastUsageDates.entrySet();
            Map<File, Long> map = this.lastUsageDates;
            synchronized (map) {
                for (Map.Entry<File, Long> entry : set) {
                    Long l2 = entry.getValue();
                    if (l2 >= l) continue;
                    l = l2;
                    file = entry.getKey();
                }
            }
            if (file == null) {
                return 0L;
            }
            long l3 = file.length();
            if (file.delete()) {
                this.lastUsageDates.remove(file);
                return l3;
            }
            return 0L;
        }
    }
}

