/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.support.annotation.NonNull;
import android.support.v4.util.LruCache;
import android.support.v4.util.SimpleArrayMap;
import com.blankj.utilcode.constant.CacheConstants;
import java.lang.reflect.Array;

public final class CacheMemoryUtils
implements CacheConstants {
    private static final int DEFAULT_MAX_COUNT = 256;
    private static final SimpleArrayMap<String, CacheMemoryUtils> CACHE_MAP = new SimpleArrayMap();
    private final String mCacheKey;
    private final LruCache<String, CacheValue> mMemoryCache;

    public static CacheMemoryUtils getInstance() {
        return CacheMemoryUtils.getInstance(256);
    }

    public static CacheMemoryUtils getInstance(int n) {
        String string = String.valueOf(n);
        CacheMemoryUtils cacheMemoryUtils = (CacheMemoryUtils)CACHE_MAP.get((Object)string);
        if (cacheMemoryUtils == null) {
            cacheMemoryUtils = new CacheMemoryUtils(string, (LruCache<String, CacheValue>)new LruCache(n));
            CACHE_MAP.put((Object)string, (Object)cacheMemoryUtils);
        }
        return cacheMemoryUtils;
    }

    private CacheMemoryUtils(String string, LruCache<String, CacheValue> lruCache) {
        this.mCacheKey = string;
        this.mMemoryCache = lruCache;
    }

    public String toString() {
        return this.mCacheKey + "@" + Integer.toHexString(this.hashCode());
    }

    public void put(@NonNull String string, Object object) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, object, -1);
    }

    public void put(@NonNull String string, Object object, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (object == null) {
            return;
        }
        if (object.getClass().isArray() && Array.getLength(object) <= 0) {
            return;
        }
        long l = n < 0 ? -1L : System.currentTimeMillis() + (long)(n * 1000);
        this.mMemoryCache.put((Object)string, (Object)new CacheValue(l, object));
    }

    public <T> T get(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.get(string, null);
    }

    public <T> T get(@NonNull String string, T t) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        CacheValue cacheValue = (CacheValue)this.mMemoryCache.get((Object)string);
        if (cacheValue == null) {
            return t;
        }
        if (cacheValue.dueTime == -1L || cacheValue.dueTime >= System.currentTimeMillis()) {
            return (T)cacheValue.value;
        }
        this.mMemoryCache.remove((Object)string);
        return t;
    }

    public int getCacheCount() {
        return this.mMemoryCache.size();
    }

    public Object remove(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        CacheValue cacheValue = (CacheValue)this.mMemoryCache.remove((Object)string);
        if (cacheValue == null) {
            return null;
        }
        return cacheValue.value;
    }

    public void clear() {
        this.mMemoryCache.evictAll();
    }

    private static final class CacheValue {
        long dueTime;
        Object value;

        private CacheValue(long l, Object object) {
            this.dueTime = l;
            this.value = object;
        }
    }
}

