/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.RequiresPermission;
import android.support.v4.widget.DrawerLayout;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.LinearLayout;
import com.blankj.utilcode.util.Utils;
import java.lang.reflect.Method;

public final class BarUtils {
    private static final int DEFAULT_ALPHA = 112;
    private static final String TAG_COLOR = "TAG_COLOR";
    private static final String TAG_ALPHA = "TAG_ALPHA";
    private static final int TAG_OFFSET = -123;

    private BarUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static int getStatusBarHeight() {
        Resources resources = Utils.getApp().getResources();
        int n = resources.getIdentifier("status_bar_height", "dimen", "android");
        return resources.getDimensionPixelSize(n);
    }

    public static void setStatusBarVisibility(@NonNull Activity activity, boolean bl) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarVisibility(activity.getWindow(), bl);
    }

    public static void setStatusBarVisibility(@NonNull Window window, boolean bl) {
        if (window == null) {
            throw new NullPointerException("Argument 'window' of type Window (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (bl) {
            window.clearFlags(1024);
        } else {
            window.addFlags(1024);
        }
    }

    public static boolean isStatusBarVisible(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        int n = activity.getWindow().getAttributes().flags;
        return (n & 0x400) == 0;
    }

    public static void setStatusBarLightMode(@NonNull Activity activity, boolean bl) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarLightMode(activity.getWindow(), bl);
    }

    public static void setStatusBarLightMode(@NonNull Window window, boolean bl) {
        View view;
        if (window == null) {
            throw new NullPointerException("Argument 'window' of type Window (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT >= 23 && (view = window.getDecorView()) != null) {
            int n = view.getSystemUiVisibility();
            if (bl) {
                window.addFlags(Integer.MIN_VALUE);
                n |= 0x2000;
            } else {
                n &= 0xFFFFDFFF;
            }
            view.setSystemUiVisibility(n);
        }
    }

    public static void addMarginTopEqualStatusBarHeight(@NonNull View view) {
        if (view == null) {
            throw new NullPointerException("Argument 'view' of type View (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        Object object = view.getTag(-123);
        if (object != null && ((Boolean)object).booleanValue()) {
            return;
        }
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        marginLayoutParams.setMargins(marginLayoutParams.leftMargin, marginLayoutParams.topMargin + BarUtils.getStatusBarHeight(), marginLayoutParams.rightMargin, marginLayoutParams.bottomMargin);
        view.setTag(-123, (Object)true);
    }

    public static void subtractMarginTopEqualStatusBarHeight(@NonNull View view) {
        if (view == null) {
            throw new NullPointerException("Argument 'view' of type View (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        Object object = view.getTag(-123);
        if (object == null || !((Boolean)object).booleanValue()) {
            return;
        }
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        marginLayoutParams.setMargins(marginLayoutParams.leftMargin, marginLayoutParams.topMargin - BarUtils.getStatusBarHeight(), marginLayoutParams.rightMargin, marginLayoutParams.bottomMargin);
        view.setTag(-123, (Object)false);
    }

    public static void setStatusBarColor(@NonNull Activity activity, @ColorInt int n) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarColor(activity, n, 112, false);
    }

    public static void setStatusBarColor(@NonNull Activity activity, @ColorInt int n, @IntRange(from=0L, to=255L) int n2) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarColor(activity, n, n2, false);
    }

    public static void setStatusBarColor(@NonNull Activity activity, @ColorInt int n, @IntRange(from=0L, to=255L) int n2, boolean bl) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        BarUtils.hideAlphaView(activity);
        BarUtils.transparentStatusBar(activity);
        BarUtils.addStatusBarColor(activity, n, n2, bl);
    }

    public static void setStatusBarColor(@NonNull View view, @ColorInt int n) {
        if (view == null) {
            throw new NullPointerException("Argument 'fakeStatusBar' of type View (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarColor(view, n, 112);
    }

    public static void setStatusBarColor(@NonNull View view, @ColorInt int n, @IntRange(from=0L, to=255L) int n2) {
        if (view == null) {
            throw new NullPointerException("Argument 'fakeStatusBar' of type View (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        view.setVisibility(0);
        BarUtils.transparentStatusBar((Activity)view.getContext());
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        layoutParams.width = -1;
        layoutParams.height = BarUtils.getStatusBarHeight();
        view.setBackgroundColor(BarUtils.getStatusBarColor(n, n2));
    }

    public static void setStatusBarAlpha(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarAlpha(activity, 112, false);
    }

    public static void setStatusBarAlpha(@NonNull Activity activity, @IntRange(from=0L, to=255L) int n) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarAlpha(activity, n, false);
    }

    public static void setStatusBarAlpha(@NonNull Activity activity, @IntRange(from=0L, to=255L) int n, boolean bl) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        BarUtils.hideColorView(activity);
        BarUtils.transparentStatusBar(activity);
        BarUtils.addStatusBarAlpha(activity, n, bl);
    }

    public static void setStatusBarAlpha(@NonNull View view) {
        if (view == null) {
            throw new NullPointerException("Argument 'fakeStatusBar' of type View (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarAlpha(view, 112);
    }

    public static void setStatusBarAlpha(@NonNull View view, @IntRange(from=0L, to=255L) int n) {
        if (view == null) {
            throw new NullPointerException("Argument 'fakeStatusBar' of type View (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        view.setVisibility(0);
        BarUtils.transparentStatusBar((Activity)view.getContext());
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        layoutParams.width = -1;
        layoutParams.height = BarUtils.getStatusBarHeight();
        view.setBackgroundColor(Color.argb((int)n, (int)0, (int)0, (int)0));
    }

    public static void setStatusBarColor4Drawer(@NonNull Activity activity, @NonNull DrawerLayout drawerLayout, @NonNull View view, @ColorInt int n, boolean bl) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (drawerLayout == null) {
            throw new NullPointerException("Argument 'drawer' of type DrawerLayout (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (view == null) {
            throw new NullPointerException("Argument 'fakeStatusBar' of type View (#2 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarColor4Drawer(activity, drawerLayout, view, n, 112, bl);
    }

    public static void setStatusBarColor4Drawer(@NonNull Activity activity, @NonNull DrawerLayout drawerLayout, @NonNull View view, @ColorInt int n, @IntRange(from=0L, to=255L) int n2, boolean bl) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (drawerLayout == null) {
            throw new NullPointerException("Argument 'drawer' of type DrawerLayout (#1 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (view == null) {
            throw new NullPointerException("Argument 'fakeStatusBar' of type View (#2 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        drawerLayout.setFitsSystemWindows(false);
        BarUtils.transparentStatusBar(activity);
        BarUtils.setStatusBarColor(view, n, bl ? n2 : 0);
        int n3 = drawerLayout.getChildCount();
        for (int i = 0; i < n3; ++i) {
            drawerLayout.getChildAt(i).setFitsSystemWindows(false);
        }
        if (bl) {
            BarUtils.hideAlphaView(activity);
        } else {
            BarUtils.addStatusBarAlpha(activity, n2, false);
        }
    }

    public static void setStatusBarAlpha4Drawer(@NonNull Activity activity, @NonNull DrawerLayout drawerLayout, @NonNull View view, boolean bl) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (drawerLayout == null) {
            throw new NullPointerException("Argument 'drawer' of type DrawerLayout (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (view == null) {
            throw new NullPointerException("Argument 'fakeStatusBar' of type View (#2 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setStatusBarAlpha4Drawer(activity, drawerLayout, view, 112, bl);
    }

    public static void setStatusBarAlpha4Drawer(@NonNull Activity activity, @NonNull DrawerLayout drawerLayout, @NonNull View view, @IntRange(from=0L, to=255L) int n, boolean bl) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (drawerLayout == null) {
            throw new NullPointerException("Argument 'drawer' of type DrawerLayout (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (view == null) {
            throw new NullPointerException("Argument 'fakeStatusBar' of type View (#2 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        drawerLayout.setFitsSystemWindows(false);
        BarUtils.transparentStatusBar(activity);
        BarUtils.setStatusBarAlpha(view, bl ? n : 0);
        int n2 = drawerLayout.getChildCount();
        for (int i = 0; i < n2; ++i) {
            drawerLayout.getChildAt(i).setFitsSystemWindows(false);
        }
        if (bl) {
            BarUtils.hideAlphaView(activity);
        } else {
            BarUtils.addStatusBarAlpha(activity, n, false);
        }
    }

    private static void addStatusBarColor(Activity activity, int n, int n2, boolean bl) {
        ViewGroup viewGroup = bl ? (ViewGroup)activity.getWindow().getDecorView() : (ViewGroup)activity.findViewById(0x1020002);
        View view = viewGroup.findViewWithTag((Object)TAG_COLOR);
        if (view != null) {
            if (view.getVisibility() == 8) {
                view.setVisibility(0);
            }
            view.setBackgroundColor(BarUtils.getStatusBarColor(n, n2));
        } else {
            viewGroup.addView(BarUtils.createColorStatusBarView(viewGroup.getContext(), n, n2));
        }
    }

    private static void addStatusBarAlpha(Activity activity, int n, boolean bl) {
        ViewGroup viewGroup = bl ? (ViewGroup)activity.getWindow().getDecorView() : (ViewGroup)activity.findViewById(0x1020002);
        View view = viewGroup.findViewWithTag((Object)TAG_ALPHA);
        if (view != null) {
            if (view.getVisibility() == 8) {
                view.setVisibility(0);
            }
            view.setBackgroundColor(Color.argb((int)n, (int)0, (int)0, (int)0));
        } else {
            viewGroup.addView(BarUtils.createAlphaStatusBarView(viewGroup.getContext(), n));
        }
    }

    private static void hideColorView(Activity activity) {
        ViewGroup viewGroup = (ViewGroup)activity.getWindow().getDecorView();
        View view = viewGroup.findViewWithTag((Object)TAG_COLOR);
        if (view == null) {
            return;
        }
        view.setVisibility(8);
    }

    private static void hideAlphaView(Activity activity) {
        ViewGroup viewGroup = (ViewGroup)activity.getWindow().getDecorView();
        View view = viewGroup.findViewWithTag((Object)TAG_ALPHA);
        if (view == null) {
            return;
        }
        view.setVisibility(8);
    }

    private static int getStatusBarColor(int n, int n2) {
        if (n2 == 0) {
            return n;
        }
        float f = 1.0f - (float)n2 / 255.0f;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        n3 = (int)((double)((float)n3 * f) + 0.5);
        n4 = (int)((double)((float)n4 * f) + 0.5);
        n5 = (int)((double)((float)n5 * f) + 0.5);
        return Color.argb((int)255, (int)n3, (int)n4, (int)n5);
    }

    private static View createColorStatusBarView(Context context, int n, int n2) {
        View view = new View(context);
        view.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, BarUtils.getStatusBarHeight()));
        view.setBackgroundColor(BarUtils.getStatusBarColor(n, n2));
        view.setTag((Object)TAG_COLOR);
        return view;
    }

    private static View createAlphaStatusBarView(Context context, int n) {
        View view = new View(context);
        view.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, BarUtils.getStatusBarHeight()));
        view.setBackgroundColor(Color.argb((int)n, (int)0, (int)0, (int)0));
        view.setTag((Object)TAG_ALPHA);
        return view;
    }

    private static void transparentStatusBar(Activity activity) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        Window window = activity.getWindow();
        if (Build.VERSION.SDK_INT >= 21) {
            window.addFlags(Integer.MIN_VALUE);
            int n = 1280;
            window.getDecorView().setSystemUiVisibility(n);
            window.setStatusBarColor(0);
        } else {
            window.addFlags(0x4000000);
        }
    }

    public static int getActionBarHeight() {
        TypedValue typedValue = new TypedValue();
        if (Utils.getApp().getTheme().resolveAttribute(16843499, typedValue, true)) {
            return TypedValue.complexToDimensionPixelSize((int)typedValue.data, (DisplayMetrics)Utils.getApp().getResources().getDisplayMetrics());
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.EXPAND_STATUS_BAR")
    public static void setNotificationBarVisibility(boolean bl) {
        String string = bl ? (Build.VERSION.SDK_INT <= 16 ? "expand" : "expandNotificationsPanel") : (Build.VERSION.SDK_INT <= 16 ? "collapse" : "collapsePanels");
        BarUtils.invokePanels(string);
    }

    private static void invokePanels(String string) {
        try {
            Object object = Utils.getApp().getSystemService("statusbar");
            Class<?> clazz = Class.forName("android.app.StatusBarManager");
            Method method = clazz.getMethod(string, new Class[0]);
            method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static int getNavBarHeight() {
        Resources resources = Utils.getApp().getResources();
        int n = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (n != 0) {
            return resources.getDimensionPixelSize(n);
        }
        return 0;
    }

    public static void setNavBarVisibility(@NonNull Activity activity, boolean bl) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setNavBarVisibility(activity.getWindow(), bl);
    }

    public static void setNavBarVisibility(@NonNull Window window, boolean bl) {
        if (window == null) {
            throw new NullPointerException("Argument 'window' of type Window (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (bl) {
            window.clearFlags(512);
        } else {
            window.addFlags(512);
            View view = window.getDecorView();
            if (Build.VERSION.SDK_INT >= 19) {
                int n = view.getSystemUiVisibility();
                view.setSystemUiVisibility(n & 0xFFFFEFFF);
            }
        }
    }

    @RequiresApi(value=19)
    public static void setNavBarImmersive(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setNavBarImmersive(activity.getWindow());
    }

    @RequiresApi(value=19)
    public static void setNavBarImmersive(@NonNull Window window) {
        if (window == null) {
            throw new NullPointerException("Argument 'window' of type Window (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        View view = window.getDecorView();
        window.clearFlags(512);
        int n = 4610;
        view.setSystemUiVisibility(n);
    }

    @RequiresApi(value=21)
    public static void setNavBarColor(@NonNull Activity activity, @ColorInt int n) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        BarUtils.setNavBarColor(activity.getWindow(), n);
    }

    @RequiresApi(value=21)
    public static void setNavBarColor(@NonNull Window window, @ColorInt int n) {
        if (window == null) {
            throw new NullPointerException("Argument 'window' of type Window (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        window.setNavigationBarColor(n);
    }

    @RequiresApi(value=21)
    public static int getNavBarColor(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return BarUtils.getNavBarColor(activity.getWindow());
    }

    @RequiresApi(value=21)
    public static int getNavBarColor(@NonNull Window window) {
        if (window == null) {
            throw new NullPointerException("Argument 'window' of type Window (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return window.getNavigationBarColor();
    }

    public static boolean isNavBarVisible(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return BarUtils.isNavBarVisible(activity.getWindow());
    }

    public static boolean isNavBarVisible(@NonNull Window window) {
        boolean bl;
        if (window == null) {
            throw new NullPointerException("Argument 'window' of type Window (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        boolean bl2 = bl = (window.getAttributes().flags & 0x200) != 0;
        if (bl) {
            return false;
        }
        View view = window.getDecorView();
        int n = view.getSystemUiVisibility();
        return (n & 2) == 0;
    }
}

