/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.util.Log;
import com.blankj.utilcode.util.IntentUtils;
import com.blankj.utilcode.util.ProcessUtils;
import com.blankj.utilcode.util.ShellUtils;
import com.blankj.utilcode.util.Utils;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class AppUtils {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private AppUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void registerAppStatusChangedListener(@NonNull Object object, @NonNull Utils.OnAppStatusChangedListener onAppStatusChangedListener) {
        if (object == null) {
            throw new NullPointerException("Argument 'obj' of type Object (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (onAppStatusChangedListener == null) {
            throw new NullPointerException("Argument 'listener' of type OnAppStatusChangedListener (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Utils.getActivityLifecycle().addListener(object, onAppStatusChangedListener);
    }

    public static void unregisterAppStatusChangedListener(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("Argument 'obj' of type Object (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Utils.getActivityLifecycle().removeListener(object);
    }

    public static void installApp(String string) {
        AppUtils.installApp(AppUtils.getFileByPath(string));
    }

    public static void installApp(File file) {
        if (!AppUtils.isFileExists(file)) {
            return;
        }
        Utils.getApp().startActivity(IntentUtils.getInstallAppIntent(file, true));
    }

    @Deprecated
    public static void installApp(String string, String string2) {
        AppUtils.installApp(AppUtils.getFileByPath(string), string2);
    }

    @Deprecated
    public static void installApp(File file, String string) {
        if (!AppUtils.isFileExists(file)) {
            return;
        }
        Utils.getApp().startActivity(IntentUtils.getInstallAppIntent(file, string, true));
    }

    public static void installApp(Activity activity, String string, int n) {
        AppUtils.installApp(activity, AppUtils.getFileByPath(string), n);
    }

    public static void installApp(Activity activity, File file, int n) {
        if (!AppUtils.isFileExists(file)) {
            return;
        }
        activity.startActivityForResult(IntentUtils.getInstallAppIntent(file), n);
    }

    @Deprecated
    public static void installApp(Activity activity, String string, String string2, int n) {
        AppUtils.installApp(activity, AppUtils.getFileByPath(string), string2, n);
    }

    @Deprecated
    public static void installApp(Activity activity, File file, String string, int n) {
        if (!AppUtils.isFileExists(file)) {
            return;
        }
        activity.startActivityForResult(IntentUtils.getInstallAppIntent(file, string), n);
    }

    public static boolean installAppSilent(String string) {
        return AppUtils.installAppSilent(AppUtils.getFileByPath(string), null);
    }

    public static boolean installAppSilent(File file) {
        return AppUtils.installAppSilent(file, null);
    }

    public static boolean installAppSilent(String string, String string2) {
        return AppUtils.installAppSilent(AppUtils.getFileByPath(string), string2);
    }

    public static boolean installAppSilent(File file, String string) {
        return AppUtils.installAppSilent(file, string, AppUtils.isDeviceRooted());
    }

    public static boolean installAppSilent(File file, String string, boolean bl) {
        if (!AppUtils.isFileExists(file)) {
            return false;
        }
        String string2 = '\"' + file.getAbsolutePath() + '\"';
        String string3 = "LD_LIBRARY_PATH=/vendor/lib*:/system/lib* pm install " + (string == null ? "" : string + " ") + string2;
        ShellUtils.CommandResult commandResult = ShellUtils.execCmd(string3, bl);
        if (commandResult.successMsg != null && commandResult.successMsg.toLowerCase().contains("success")) {
            return true;
        }
        Log.e((String)"AppUtils", (String)("installAppSilent successMsg: " + commandResult.successMsg + ", errorMsg: " + commandResult.errorMsg));
        return false;
    }

    public static void uninstallApp(String string) {
        if (AppUtils.isSpace(string)) {
            return;
        }
        Utils.getApp().startActivity(IntentUtils.getUninstallAppIntent(string, true));
    }

    public static void uninstallApp(Activity activity, String string, int n) {
        if (AppUtils.isSpace(string)) {
            return;
        }
        activity.startActivityForResult(IntentUtils.getUninstallAppIntent(string), n);
    }

    public static boolean uninstallAppSilent(String string) {
        return AppUtils.uninstallAppSilent(string, false);
    }

    public static boolean uninstallAppSilent(String string, boolean bl) {
        return AppUtils.uninstallAppSilent(string, bl, AppUtils.isDeviceRooted());
    }

    public static boolean uninstallAppSilent(String string, boolean bl, boolean bl2) {
        if (AppUtils.isSpace(string)) {
            return false;
        }
        String string2 = "LD_LIBRARY_PATH=/vendor/lib*:/system/lib* pm uninstall " + (bl ? "-k " : "") + string;
        ShellUtils.CommandResult commandResult = ShellUtils.execCmd(string2, bl2);
        if (commandResult.successMsg != null && commandResult.successMsg.toLowerCase().contains("success")) {
            return true;
        }
        Log.e((String)"AppUtils", (String)("uninstallAppSilent successMsg: " + commandResult.successMsg + ", errorMsg: " + commandResult.errorMsg));
        return false;
    }

    public static boolean isAppInstalled(@NonNull String string, @NonNull String string2) {
        if (string == null) {
            throw new NullPointerException("Argument 'action' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'category' of type String (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Intent intent = new Intent(string);
        intent.addCategory(string2);
        PackageManager packageManager = Utils.getApp().getPackageManager();
        ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 0);
        return resolveInfo != null;
    }

    public static boolean isAppInstalled(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'packageName' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return !AppUtils.isSpace(string) && IntentUtils.getLaunchAppIntent(string) != null;
    }

    public static boolean isAppRoot() {
        ShellUtils.CommandResult commandResult = ShellUtils.execCmd("echo root", true);
        if (commandResult.result == 0) {
            return true;
        }
        if (commandResult.errorMsg != null) {
            Log.d((String)"AppUtils", (String)("isAppRoot() called" + commandResult.errorMsg));
        }
        return false;
    }

    public static boolean isAppDebug() {
        return AppUtils.isAppDebug(Utils.getApp().getPackageName());
    }

    public static boolean isAppDebug(String string) {
        if (AppUtils.isSpace(string)) {
            return false;
        }
        try {
            PackageManager packageManager = Utils.getApp().getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string, 0);
            return applicationInfo != null && (applicationInfo.flags & 2) != 0;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return false;
        }
    }

    public static boolean isAppSystem() {
        return AppUtils.isAppSystem(Utils.getApp().getPackageName());
    }

    public static boolean isAppSystem(String string) {
        if (AppUtils.isSpace(string)) {
            return false;
        }
        try {
            PackageManager packageManager = Utils.getApp().getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string, 0);
            return applicationInfo != null && (applicationInfo.flags & 1) != 0;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return false;
        }
    }

    public static boolean isAppForeground() {
        return Utils.isAppForeground();
    }

    public static boolean isAppForeground(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'packageName' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return !AppUtils.isSpace(string) && string.equals(ProcessUtils.getForegroundProcessName());
    }

    public static void launchApp(String string) {
        if (AppUtils.isSpace(string)) {
            return;
        }
        Utils.getApp().startActivity(IntentUtils.getLaunchAppIntent(string, true));
    }

    public static void launchApp(Activity activity, String string, int n) {
        if (AppUtils.isSpace(string)) {
            return;
        }
        activity.startActivityForResult(IntentUtils.getLaunchAppIntent(string), n);
    }

    public static void relaunchApp() {
        PackageManager packageManager = Utils.getApp().getPackageManager();
        Intent intent = packageManager.getLaunchIntentForPackage(Utils.getApp().getPackageName());
        if (intent == null) {
            return;
        }
        ComponentName componentName = intent.getComponent();
        Intent intent2 = Intent.makeRestartActivityTask((ComponentName)componentName);
        Utils.getApp().startActivity(intent2);
        System.exit(0);
    }

    public static void launchAppDetailsSettings() {
        AppUtils.launchAppDetailsSettings(Utils.getApp().getPackageName());
    }

    public static void launchAppDetailsSettings(String string) {
        if (AppUtils.isSpace(string)) {
            return;
        }
        Utils.getApp().startActivity(IntentUtils.getLaunchAppDetailsSettingsIntent(string, true));
    }

    public static void exitApp() {
        LinkedList<Activity> linkedList = Utils.getActivityList();
        for (int i = linkedList.size() - 1; i >= 0; --i) {
            Activity activity = (Activity)linkedList.get(i);
            activity.finish();
        }
        System.exit(0);
    }

    public static Drawable getAppIcon() {
        return AppUtils.getAppIcon(Utils.getApp().getPackageName());
    }

    public static Drawable getAppIcon(String string) {
        if (AppUtils.isSpace(string)) {
            return null;
        }
        try {
            PackageManager packageManager = Utils.getApp().getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 0);
            return packageInfo == null ? null : packageInfo.applicationInfo.loadIcon(packageManager);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return null;
        }
    }

    public static String getAppPackageName() {
        return Utils.getApp().getPackageName();
    }

    public static String getAppName() {
        return AppUtils.getAppName(Utils.getApp().getPackageName());
    }

    public static String getAppName(String string) {
        if (AppUtils.isSpace(string)) {
            return "";
        }
        try {
            PackageManager packageManager = Utils.getApp().getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 0);
            return packageInfo == null ? null : packageInfo.applicationInfo.loadLabel(packageManager).toString();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return "";
        }
    }

    public static String getAppPath() {
        return AppUtils.getAppPath(Utils.getApp().getPackageName());
    }

    public static String getAppPath(String string) {
        if (AppUtils.isSpace(string)) {
            return "";
        }
        try {
            PackageManager packageManager = Utils.getApp().getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 0);
            return packageInfo == null ? null : packageInfo.applicationInfo.sourceDir;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return "";
        }
    }

    public static String getAppVersionName() {
        return AppUtils.getAppVersionName(Utils.getApp().getPackageName());
    }

    public static String getAppVersionName(String string) {
        if (AppUtils.isSpace(string)) {
            return "";
        }
        try {
            PackageManager packageManager = Utils.getApp().getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 0);
            return packageInfo == null ? null : packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return "";
        }
    }

    public static int getAppVersionCode() {
        return AppUtils.getAppVersionCode(Utils.getApp().getPackageName());
    }

    public static int getAppVersionCode(String string) {
        if (AppUtils.isSpace(string)) {
            return -1;
        }
        try {
            PackageManager packageManager = Utils.getApp().getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 0);
            return packageInfo == null ? -1 : packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return -1;
        }
    }

    public static Signature[] getAppSignature() {
        return AppUtils.getAppSignature(Utils.getApp().getPackageName());
    }

    public static Signature[] getAppSignature(String string) {
        if (AppUtils.isSpace(string)) {
            return null;
        }
        try {
            PackageManager packageManager = Utils.getApp().getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 64);
            return packageInfo == null ? null : packageInfo.signatures;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return null;
        }
    }

    public static String getAppSignatureSHA1() {
        return AppUtils.getAppSignatureSHA1(Utils.getApp().getPackageName());
    }

    public static String getAppSignatureSHA1(String string) {
        if (AppUtils.isSpace(string)) {
            return "";
        }
        Signature[] signatureArray = AppUtils.getAppSignature(string);
        if (signatureArray == null || signatureArray.length <= 0) {
            return "";
        }
        return AppUtils.encryptSHA1ToString(signatureArray[0].toByteArray()).replaceAll("(?<=[0-9A-F]{2})[0-9A-F]{2}", ":$0");
    }

    public static AppInfo getAppInfo() {
        return AppUtils.getAppInfo(Utils.getApp().getPackageName());
    }

    public static AppInfo getAppInfo(String string) {
        try {
            PackageManager packageManager = Utils.getApp().getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 0);
            return AppUtils.getBean(packageManager, packageInfo);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return null;
        }
    }

    public static List<AppInfo> getAppsInfo() {
        ArrayList<AppInfo> arrayList = new ArrayList<AppInfo>();
        PackageManager packageManager = Utils.getApp().getPackageManager();
        List list = packageManager.getInstalledPackages(0);
        for (PackageInfo packageInfo : list) {
            AppInfo appInfo = AppUtils.getBean(packageManager, packageInfo);
            if (appInfo == null) continue;
            arrayList.add(appInfo);
        }
        return arrayList;
    }

    private static AppInfo getBean(PackageManager packageManager, PackageInfo packageInfo) {
        if (packageManager == null || packageInfo == null) {
            return null;
        }
        ApplicationInfo applicationInfo = packageInfo.applicationInfo;
        String string = packageInfo.packageName;
        String string2 = applicationInfo.loadLabel(packageManager).toString();
        Drawable drawable = applicationInfo.loadIcon(packageManager);
        String string3 = applicationInfo.sourceDir;
        String string4 = packageInfo.versionName;
        int n = packageInfo.versionCode;
        boolean bl = (1 & applicationInfo.flags) != 0;
        return new AppInfo(string, string2, drawable, string3, string4, n, bl);
    }

    private static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    private static File getFileByPath(String string) {
        return AppUtils.isSpace(string) ? null : new File(string);
    }

    private static boolean isSpace(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isDeviceRooted() {
        String[] stringArray;
        String string = "su";
        for (String string2 : stringArray = new String[]{"/system/bin/", "/system/xbin/", "/sbin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/xbin/", "/data/local/bin/", "/data/local/"}) {
            if (!new File(string2 + string).exists()) continue;
            return true;
        }
        return false;
    }

    private static String encryptSHA1ToString(byte[] byArray) {
        return AppUtils.bytes2HexString(AppUtils.encryptSHA1(byArray));
    }

    private static byte[] encryptSHA1(byte[] byArray) {
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
    }

    private static String bytes2HexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        int n = byArray.length;
        if (n <= 0) {
            return "";
        }
        char[] cArray = new char[n << 1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            cArray[n2++] = HEX_DIGITS[byArray[i] >> 4 & 0xF];
            cArray[n2++] = HEX_DIGITS[byArray[i] & 0xF];
        }
        return new String(cArray);
    }

    public static class AppInfo {
        private String packageName;
        private String name;
        private Drawable icon;
        private String packagePath;
        private String versionName;
        private int versionCode;
        private boolean isSystem;

        public Drawable getIcon() {
            return this.icon;
        }

        public void setIcon(Drawable drawable) {
            this.icon = drawable;
        }

        public boolean isSystem() {
            return this.isSystem;
        }

        public void setSystem(boolean bl) {
            this.isSystem = bl;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String string) {
            this.packageName = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getPackagePath() {
            return this.packagePath;
        }

        public void setPackagePath(String string) {
            this.packagePath = string;
        }

        public int getVersionCode() {
            return this.versionCode;
        }

        public void setVersionCode(int n) {
            this.versionCode = n;
        }

        public String getVersionName() {
            return this.versionName;
        }

        public void setVersionName(String string) {
            this.versionName = string;
        }

        public AppInfo(String string, String string2, Drawable drawable, String string3, String string4, int n, boolean bl) {
            this.setName(string2);
            this.setIcon(drawable);
            this.setPackageName(string);
            this.setPackagePath(string3);
            this.setVersionName(string4);
            this.setVersionCode(n);
            this.setSystem(bl);
        }

        public String toString() {
            return "pkg name: " + this.getPackageName() + "\napp icon: " + this.getIcon() + "\napp name: " + this.getName() + "\napp path: " + this.getPackagePath() + "\napp v name: " + this.getVersionName() + "\napp v code: " + this.getVersionCode() + "\nis system: " + this.isSystem();
        }
    }
}

