/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.blankj.utilcode.util.PermissionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class Utils {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Application sApplication;
    private static final ActivityLifecycleImpl ACTIVITY_LIFECYCLE;

    private Utils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void init(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("Argument 'context' of type Context (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Utils.init((Application)context.getApplicationContext());
    }

    public static void init(@NonNull Application application) {
        if (application == null) {
            throw new NullPointerException("Argument 'app' of type Application (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (sApplication == null) {
            sApplication = application;
            sApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)ACTIVITY_LIFECYCLE);
        }
    }

    public static Application getApp() {
        if (sApplication != null) {
            return sApplication;
        }
        try {
            Class<?> clazz = Class.forName("android.app.ActivityThread");
            Object object = clazz.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Object object2 = clazz.getMethod("getApplication", new Class[0]).invoke(object, new Object[0]);
            if (object2 == null) {
                throw new NullPointerException("u should init first");
            }
            Utils.init((Application)object2);
            return sApplication;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        throw new NullPointerException("u should init first");
    }

    static ActivityLifecycleImpl getActivityLifecycle() {
        return ACTIVITY_LIFECYCLE;
    }

    static LinkedList<Activity> getActivityList() {
        return Utils.ACTIVITY_LIFECYCLE.mActivityList;
    }

    static Context getTopActivityOrApp() {
        if (Utils.isAppForeground()) {
            Activity activity = ACTIVITY_LIFECYCLE.getTopActivity();
            return activity == null ? Utils.getApp() : activity;
        }
        return Utils.getApp();
    }

    static boolean isAppForeground() {
        ActivityManager activityManager = (ActivityManager)Utils.getApp().getSystemService("activity");
        if (activityManager == null) {
            return false;
        }
        List list = activityManager.getRunningAppProcesses();
        if (list == null || list.size() == 0) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            if (runningAppProcessInfo.importance != 100) continue;
            return runningAppProcessInfo.processName.equals(Utils.getApp().getPackageName());
        }
        return false;
    }

    static {
        ACTIVITY_LIFECYCLE = new ActivityLifecycleImpl();
    }

    public static interface OnAppStatusChangedListener {
        public void onForeground();

        public void onBackground();
    }

    static class ActivityLifecycleImpl
    implements Application.ActivityLifecycleCallbacks {
        final LinkedList<Activity> mActivityList = new LinkedList();
        final HashMap<Object, OnAppStatusChangedListener> mStatusListenerMap = new HashMap();
        private int mForegroundCount = 0;
        private int mConfigCount = 0;

        ActivityLifecycleImpl() {
        }

        void addListener(Object object, OnAppStatusChangedListener onAppStatusChangedListener) {
            this.mStatusListenerMap.put(object, onAppStatusChangedListener);
        }

        void removeListener(Object object) {
            this.mStatusListenerMap.remove(object);
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
            this.setTopActivity(activity);
        }

        public void onActivityStarted(Activity activity) {
            this.setTopActivity(activity);
            if (this.mForegroundCount <= 0) {
                this.postStatus(true);
            }
            if (this.mConfigCount < 0) {
                ++this.mConfigCount;
            } else {
                ++this.mForegroundCount;
            }
        }

        public void onActivityResumed(Activity activity) {
            this.setTopActivity(activity);
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            if (activity.isChangingConfigurations()) {
                --this.mConfigCount;
            } else {
                --this.mForegroundCount;
                if (this.mForegroundCount <= 0) {
                    this.postStatus(false);
                }
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
            this.mActivityList.remove(activity);
        }

        private void postStatus(boolean bl) {
            if (this.mStatusListenerMap.isEmpty()) {
                return;
            }
            for (OnAppStatusChangedListener onAppStatusChangedListener : this.mStatusListenerMap.values()) {
                if (onAppStatusChangedListener == null) {
                    return;
                }
                if (bl) {
                    onAppStatusChangedListener.onForeground();
                    continue;
                }
                onAppStatusChangedListener.onBackground();
            }
        }

        private void setTopActivity(Activity activity) {
            if (activity.getClass() == PermissionUtils.PermissionActivity.class) {
                return;
            }
            if (this.mActivityList.contains(activity)) {
                if (!this.mActivityList.getLast().equals(activity)) {
                    this.mActivityList.remove(activity);
                    this.mActivityList.addLast(activity);
                }
            } else {
                this.mActivityList.addLast(activity);
            }
        }

        Activity getTopActivity() {
            Activity activity;
            if (!this.mActivityList.isEmpty() && (activity = this.mActivityList.getLast()) != null) {
                return activity;
            }
            try {
                activity = Class.forName("android.app.ActivityThread");
                Object object = activity.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
                Field field = activity.getDeclaredField("mActivityList");
                field.setAccessible(true);
                Map map = (Map)field.get(object);
                if (map == null) {
                    return null;
                }
                for (Object v : map.values()) {
                    Class<?> clazz = v.getClass();
                    Field field2 = clazz.getDeclaredField("paused");
                    field2.setAccessible(true);
                    if (field2.getBoolean(v)) continue;
                    Field field3 = clazz.getDeclaredField("activity");
                    field3.setAccessible(true);
                    Activity activity2 = (Activity)field3.get(v);
                    this.setTopActivity(activity2);
                    return activity2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
            return null;
        }
    }
}

