/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.util.Log;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.TextView;
import android.widget.Toast;
import com.blankj.utilcode.util.Utils;
import java.lang.reflect.Field;

public final class ToastUtils {
    private static final int COLOR_DEFAULT = -16777217;
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private static Toast sToast;
    private static int sGravity;
    private static int sXOffset;
    private static int sYOffset;
    private static int sBgColor;
    private static int sBgResource;
    private static int sMsgColor;
    private static int sMsgTextSize;

    private ToastUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void setGravity(int n, int n2, int n3) {
        sGravity = n;
        sXOffset = n2;
        sYOffset = n3;
    }

    public static void setBgColor(@ColorInt int n) {
        sBgColor = n;
    }

    public static void setBgResource(@DrawableRes int n) {
        sBgResource = n;
    }

    public static void setMsgColor(@ColorInt int n) {
        sMsgColor = n;
    }

    public static void setMsgTextSize(int n) {
        sMsgTextSize = n;
    }

    public static void showShort(@NonNull CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException("Argument 'text' of type CharSequence (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ToastUtils.show(charSequence, 0);
    }

    public static void showShort(@StringRes int n) {
        ToastUtils.show(n, 0);
    }

    public static void showShort(@StringRes int n, Object ... objectArray) {
        if (objectArray != null && objectArray.length == 0) {
            ToastUtils.show(n, 0);
        } else {
            ToastUtils.show(n, 0, objectArray);
        }
    }

    public static void showShort(String string, Object ... objectArray) {
        if (objectArray != null && objectArray.length == 0) {
            ToastUtils.show(string, 0);
        } else {
            ToastUtils.show(string, 0, objectArray);
        }
    }

    public static void showLong(@NonNull CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException("Argument 'text' of type CharSequence (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ToastUtils.show(charSequence, 1);
    }

    public static void showLong(@StringRes int n) {
        ToastUtils.show(n, 1);
    }

    public static void showLong(@StringRes int n, Object ... objectArray) {
        if (objectArray != null && objectArray.length == 0) {
            ToastUtils.show(n, 0);
        } else {
            ToastUtils.show(n, 1, objectArray);
        }
    }

    public static void showLong(String string, Object ... objectArray) {
        if (objectArray != null && objectArray.length == 0) {
            ToastUtils.show(string, 0);
        } else {
            ToastUtils.show(string, 1, objectArray);
        }
    }

    public static View showCustomShort(@LayoutRes int n) {
        View view = ToastUtils.getView(n);
        ToastUtils.show(view, 0);
        return view;
    }

    public static View showCustomLong(@LayoutRes int n) {
        View view = ToastUtils.getView(n);
        ToastUtils.show(view, 1);
        return view;
    }

    public static void cancel() {
        if (sToast != null) {
            sToast.cancel();
        }
    }

    private static void show(@StringRes int n, int n2) {
        ToastUtils.show(Utils.getApp().getResources().getText(n).toString(), n2);
    }

    private static void show(@StringRes int n, int n2, Object ... objectArray) {
        ToastUtils.show(String.format(Utils.getApp().getResources().getString(n), objectArray), n2);
    }

    private static void show(String string, int n, Object ... objectArray) {
        ToastUtils.show(String.format(string, objectArray), n);
    }

    private static void show(final CharSequence charSequence, final int n) {
        HANDLER.post(new Runnable(){

            @Override
            @SuppressLint(value={"ShowToast"})
            public void run() {
                ToastUtils.cancel();
                sToast = Toast.makeText((Context)Utils.getApp(), (CharSequence)charSequence, (int)n);
                TextView textView = (TextView)sToast.getView().findViewById(16908299);
                if (sMsgColor != -16777217) {
                    textView.setTextColor(sMsgColor);
                }
                if (sMsgTextSize != -1) {
                    textView.setTextSize((float)sMsgTextSize);
                }
                if (sGravity != -1 || sXOffset != -1 || sYOffset != -1) {
                    sToast.setGravity(sGravity, sXOffset, sYOffset);
                }
                ToastUtils.setBg(textView);
                ToastUtils.showToast();
            }
        });
    }

    private static void show(final View view, final int n) {
        HANDLER.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.cancel();
                sToast = new Toast((Context)Utils.getApp());
                sToast.setView(view);
                sToast.setDuration(n);
                if (sGravity != -1 || sXOffset != -1 || sYOffset != -1) {
                    sToast.setGravity(sGravity, sXOffset, sYOffset);
                }
                ToastUtils.setBg();
                ToastUtils.showToast();
            }
        });
    }

    private static void showToast() {
        if (Build.VERSION.SDK_INT == 25) {
            try {
                Field field = View.class.getDeclaredField("mContext");
                field.setAccessible(true);
                field.set(sToast.getView(), (Object)new ApplicationContextWrapperForApi25());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        sToast.show();
    }

    private static void setBg() {
        if (sBgResource != -1) {
            View view = sToast.getView();
            view.setBackgroundResource(sBgResource);
        } else if (sBgColor != -16777217) {
            View view = sToast.getView();
            Drawable drawable = view.getBackground();
            if (drawable != null) {
                drawable.setColorFilter((ColorFilter)new PorterDuffColorFilter(sBgColor, PorterDuff.Mode.SRC_IN));
            } else if (Build.VERSION.SDK_INT >= 16) {
                view.setBackground((Drawable)new ColorDrawable(sBgColor));
            } else {
                view.setBackgroundDrawable((Drawable)new ColorDrawable(sBgColor));
            }
        }
    }

    private static void setBg(TextView textView) {
        if (sBgResource != -1) {
            View view = sToast.getView();
            view.setBackgroundResource(sBgResource);
            textView.setBackgroundColor(0);
        } else if (sBgColor != -16777217) {
            View view = sToast.getView();
            Drawable drawable = view.getBackground();
            Drawable drawable2 = textView.getBackground();
            if (drawable != null && drawable2 != null) {
                drawable.setColorFilter((ColorFilter)new PorterDuffColorFilter(sBgColor, PorterDuff.Mode.SRC_IN));
                textView.setBackgroundColor(0);
            } else if (drawable != null) {
                drawable.setColorFilter((ColorFilter)new PorterDuffColorFilter(sBgColor, PorterDuff.Mode.SRC_IN));
            } else if (drawable2 != null) {
                drawable2.setColorFilter((ColorFilter)new PorterDuffColorFilter(sBgColor, PorterDuff.Mode.SRC_IN));
            } else {
                view.setBackgroundColor(sBgColor);
            }
        }
    }

    private static View getView(@LayoutRes int n) {
        LayoutInflater layoutInflater = (LayoutInflater)Utils.getApp().getSystemService("layout_inflater");
        return layoutInflater != null ? layoutInflater.inflate(n, null) : null;
    }

    static {
        sGravity = -1;
        sXOffset = -1;
        sYOffset = -1;
        sBgColor = -16777217;
        sBgResource = -1;
        sMsgColor = -16777217;
        sMsgTextSize = -1;
    }

    private static final class ApplicationContextWrapperForApi25
    extends ContextWrapper {
        ApplicationContextWrapperForApi25() {
            super((Context)Utils.getApp());
        }

        public Context getApplicationContext() {
            return this;
        }

        public Object getSystemService(@NonNull String string) {
            if (string == null) {
                throw new NullPointerException("Argument 'name' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
            }
            if ("window".equals(string)) {
                return new WindowManagerWrapper((WindowManager)this.getBaseContext().getSystemService(string));
            }
            return super.getSystemService(string);
        }

        private static final class WindowManagerWrapper
        implements WindowManager {
            private final WindowManager base;

            private WindowManagerWrapper(@NonNull WindowManager windowManager) {
                if (windowManager == null) {
                    throw new NullPointerException("Argument 'base' of type WindowManager (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
                }
                this.base = windowManager;
            }

            public Display getDefaultDisplay() {
                return this.base.getDefaultDisplay();
            }

            public void removeViewImmediate(View view) {
                this.base.removeViewImmediate(view);
            }

            public void addView(View view, ViewGroup.LayoutParams layoutParams) {
                try {
                    this.base.addView(view, layoutParams);
                }
                catch (WindowManager.BadTokenException badTokenException) {
                    Log.e((String)"WindowManagerWrapper", (String)badTokenException.getMessage());
                }
                catch (Throwable throwable) {
                    Log.e((String)"WindowManagerWrapper", (String)"[addView]", (Throwable)throwable);
                }
            }

            public void updateViewLayout(View view, ViewGroup.LayoutParams layoutParams) {
                this.base.updateViewLayout(view, layoutParams);
            }

            public void removeView(View view) {
                this.base.removeView(view);
            }
        }
    }
}

