/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.CharacterStyle;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.MaskFilterSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.ReplacementSpan;
import android.text.style.ScaleXSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.text.style.UpdateAppearance;
import android.util.Log;
import com.blankj.utilcode.util.Utils;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;

public final class SpanUtils {
    private static final int COLOR_DEFAULT = -16777217;
    public static final int ALIGN_BOTTOM = 0;
    public static final int ALIGN_BASELINE = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_TOP = 3;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private CharSequence mText = "";
    private int flag;
    private int foregroundColor;
    private int backgroundColor;
    private int lineHeight;
    private int alignLine;
    private int quoteColor;
    private int stripeWidth;
    private int quoteGapWidth;
    private int first;
    private int rest;
    private int bulletColor;
    private int bulletRadius;
    private int bulletGapWidth;
    private int fontSize;
    private boolean fontSizeIsDp;
    private float proportion;
    private float xProportion;
    private boolean isStrikethrough;
    private boolean isUnderline;
    private boolean isSuperscript;
    private boolean isSubscript;
    private boolean isBold;
    private boolean isItalic;
    private boolean isBoldItalic;
    private String fontFamily;
    private Typeface typeface;
    private Layout.Alignment alignment;
    private ClickableSpan clickSpan;
    private String url;
    private float blurRadius;
    private BlurMaskFilter.Blur style;
    private Shader shader;
    private float shadowRadius;
    private float shadowDx;
    private float shadowDy;
    private int shadowColor;
    private Object[] spans;
    private Bitmap imageBitmap;
    private Drawable imageDrawable;
    private Uri imageUri;
    private int imageResourceId;
    private int alignImage;
    private int spaceSize;
    private int spaceColor;
    private SpannableStringBuilder mBuilder = new SpannableStringBuilder();
    private int mType;
    private final int mTypeCharSequence = 0;
    private final int mTypeImage = 1;
    private final int mTypeSpace = 2;

    public SpanUtils() {
        this.setDefault();
    }

    private void setDefault() {
        this.flag = 33;
        this.foregroundColor = -16777217;
        this.backgroundColor = -16777217;
        this.lineHeight = -1;
        this.quoteColor = -16777217;
        this.first = -1;
        this.bulletColor = -16777217;
        this.fontSize = -1;
        this.proportion = -1.0f;
        this.xProportion = -1.0f;
        this.isStrikethrough = false;
        this.isUnderline = false;
        this.isSuperscript = false;
        this.isSubscript = false;
        this.isBold = false;
        this.isItalic = false;
        this.isBoldItalic = false;
        this.fontFamily = null;
        this.typeface = null;
        this.alignment = null;
        this.clickSpan = null;
        this.url = null;
        this.blurRadius = -1.0f;
        this.shader = null;
        this.shadowRadius = -1.0f;
        this.spans = null;
        this.imageBitmap = null;
        this.imageDrawable = null;
        this.imageUri = null;
        this.imageResourceId = -1;
        this.spaceSize = -1;
    }

    public SpanUtils setFlag(int n) {
        this.flag = n;
        return this;
    }

    public SpanUtils setForegroundColor(@ColorInt int n) {
        this.foregroundColor = n;
        return this;
    }

    public SpanUtils setBackgroundColor(@ColorInt int n) {
        this.backgroundColor = n;
        return this;
    }

    public SpanUtils setLineHeight(@IntRange(from=0L) int n) {
        return this.setLineHeight(n, 2);
    }

    public SpanUtils setLineHeight(@IntRange(from=0L) int n, int n2) {
        this.lineHeight = n;
        this.alignLine = n2;
        return this;
    }

    public SpanUtils setQuoteColor(@ColorInt int n) {
        return this.setQuoteColor(n, 2, 2);
    }

    public SpanUtils setQuoteColor(@ColorInt int n, @IntRange(from=1L) int n2, @IntRange(from=0L) int n3) {
        this.quoteColor = n;
        this.stripeWidth = n2;
        this.quoteGapWidth = n3;
        return this;
    }

    public SpanUtils setLeadingMargin(@IntRange(from=0L) int n, @IntRange(from=0L) int n2) {
        this.first = n;
        this.rest = n2;
        return this;
    }

    public SpanUtils setBullet(@IntRange(from=0L) int n) {
        return this.setBullet(0, 3, n);
    }

    public SpanUtils setBullet(@ColorInt int n, @IntRange(from=0L) int n2, @IntRange(from=0L) int n3) {
        this.bulletColor = n;
        this.bulletRadius = n2;
        this.bulletGapWidth = n3;
        return this;
    }

    public SpanUtils setFontSize(@IntRange(from=0L) int n) {
        return this.setFontSize(n, false);
    }

    public SpanUtils setFontSize(@IntRange(from=0L) int n, boolean bl) {
        this.fontSize = n;
        this.fontSizeIsDp = bl;
        return this;
    }

    public SpanUtils setFontProportion(float f) {
        this.proportion = f;
        return this;
    }

    public SpanUtils setFontXProportion(float f) {
        this.xProportion = f;
        return this;
    }

    public SpanUtils setStrikethrough() {
        this.isStrikethrough = true;
        return this;
    }

    public SpanUtils setUnderline() {
        this.isUnderline = true;
        return this;
    }

    public SpanUtils setSuperscript() {
        this.isSuperscript = true;
        return this;
    }

    public SpanUtils setSubscript() {
        this.isSubscript = true;
        return this;
    }

    public SpanUtils setBold() {
        this.isBold = true;
        return this;
    }

    public SpanUtils setItalic() {
        this.isItalic = true;
        return this;
    }

    public SpanUtils setBoldItalic() {
        this.isBoldItalic = true;
        return this;
    }

    public SpanUtils setFontFamily(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'fontFamily' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.fontFamily = string;
        return this;
    }

    public SpanUtils setTypeface(@NonNull Typeface typeface) {
        if (typeface == null) {
            throw new NullPointerException("Argument 'typeface' of type Typeface (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.typeface = typeface;
        return this;
    }

    public SpanUtils setAlign(@NonNull Layout.Alignment alignment) {
        if (alignment == null) {
            throw new NullPointerException("Argument 'alignment' of type Alignment (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.alignment = alignment;
        return this;
    }

    public SpanUtils setClickSpan(@NonNull ClickableSpan clickableSpan) {
        if (clickableSpan == null) {
            throw new NullPointerException("Argument 'clickSpan' of type ClickableSpan (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.clickSpan = clickableSpan;
        return this;
    }

    public SpanUtils setUrl(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'url' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.url = string;
        return this;
    }

    public SpanUtils setBlur(@FloatRange(from=0.0, fromInclusive=false) float f, BlurMaskFilter.Blur blur) {
        this.blurRadius = f;
        this.style = blur;
        return this;
    }

    public SpanUtils setShader(@NonNull Shader shader) {
        if (shader == null) {
            throw new NullPointerException("Argument 'shader' of type Shader (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.shader = shader;
        return this;
    }

    public SpanUtils setShadow(@FloatRange(from=0.0, fromInclusive=false) float f, float f2, float f3, int n) {
        this.shadowRadius = f;
        this.shadowDx = f2;
        this.shadowDy = f3;
        this.shadowColor = n;
        return this;
    }

    public SpanUtils setSpans(Object ... objectArray) {
        if (objectArray == null) {
            throw new NullPointerException("Argument 'spans' of type Object[] (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (objectArray.length > 0) {
            this.spans = objectArray;
        }
        return this;
    }

    public SpanUtils append(@NonNull CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException("Argument 'text' of type CharSequence (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.apply(0);
        this.mText = charSequence;
        return this;
    }

    public SpanUtils appendLine() {
        this.apply(0);
        this.mText = LINE_SEPARATOR;
        return this;
    }

    public SpanUtils appendLine(@NonNull CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException("Argument 'text' of type CharSequence (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.apply(0);
        this.mText = charSequence + LINE_SEPARATOR;
        return this;
    }

    public SpanUtils appendImage(@NonNull Bitmap bitmap) {
        if (bitmap == null) {
            throw new NullPointerException("Argument 'bitmap' of type Bitmap (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.appendImage(bitmap, 0);
    }

    public SpanUtils appendImage(@NonNull Bitmap bitmap, int n) {
        if (bitmap == null) {
            throw new NullPointerException("Argument 'bitmap' of type Bitmap (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.apply(1);
        this.imageBitmap = bitmap;
        this.alignImage = n;
        return this;
    }

    public SpanUtils appendImage(@NonNull Drawable drawable) {
        if (drawable == null) {
            throw new NullPointerException("Argument 'drawable' of type Drawable (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.appendImage(drawable, 0);
    }

    public SpanUtils appendImage(@NonNull Drawable drawable, int n) {
        if (drawable == null) {
            throw new NullPointerException("Argument 'drawable' of type Drawable (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.apply(1);
        this.imageDrawable = drawable;
        this.alignImage = n;
        return this;
    }

    public SpanUtils appendImage(@NonNull Uri uri) {
        if (uri == null) {
            throw new NullPointerException("Argument 'uri' of type Uri (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.appendImage(uri, 0);
    }

    public SpanUtils appendImage(@NonNull Uri uri, int n) {
        if (uri == null) {
            throw new NullPointerException("Argument 'uri' of type Uri (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.apply(1);
        this.imageUri = uri;
        this.alignImage = n;
        return this;
    }

    public SpanUtils appendImage(@DrawableRes int n) {
        return this.appendImage(n, 0);
    }

    public SpanUtils appendImage(@DrawableRes int n, int n2) {
        this.append(Character.toString('\u0000'));
        this.apply(1);
        this.imageResourceId = n;
        this.alignImage = n2;
        return this;
    }

    public SpanUtils appendSpace(@IntRange(from=0L) int n) {
        return this.appendSpace(n, 0);
    }

    public SpanUtils appendSpace(@IntRange(from=0L) int n, @ColorInt int n2) {
        this.apply(2);
        this.spaceSize = n;
        this.spaceColor = n2;
        return this;
    }

    private void apply(int n) {
        this.applyLast();
        this.mType = n;
    }

    public SpannableStringBuilder create() {
        this.applyLast();
        return this.mBuilder;
    }

    private void applyLast() {
        if (this.mType == 0) {
            this.updateCharCharSequence();
        } else if (this.mType == 1) {
            this.updateImage();
        } else if (this.mType == 2) {
            this.updateSpace();
        }
        this.setDefault();
    }

    private void updateCharCharSequence() {
        if (this.mText.length() == 0) {
            return;
        }
        int n = this.mBuilder.length();
        this.mBuilder.append(this.mText);
        int n2 = this.mBuilder.length();
        if (this.foregroundColor != -16777217) {
            this.mBuilder.setSpan((Object)new ForegroundColorSpan(this.foregroundColor), n, n2, this.flag);
        }
        if (this.backgroundColor != -16777217) {
            this.mBuilder.setSpan((Object)new BackgroundColorSpan(this.backgroundColor), n, n2, this.flag);
        }
        if (this.first != -1) {
            this.mBuilder.setSpan((Object)new LeadingMarginSpan.Standard(this.first, this.rest), n, n2, this.flag);
        }
        if (this.quoteColor != -16777217) {
            this.mBuilder.setSpan((Object)new CustomQuoteSpan(this.quoteColor, this.stripeWidth, this.quoteGapWidth), n, n2, this.flag);
        }
        if (this.bulletColor != -16777217) {
            this.mBuilder.setSpan((Object)new CustomBulletSpan(this.bulletColor, this.bulletRadius, this.bulletGapWidth), n, n2, this.flag);
        }
        if (this.fontSize != -1) {
            this.mBuilder.setSpan((Object)new AbsoluteSizeSpan(this.fontSize, this.fontSizeIsDp), n, n2, this.flag);
        }
        if (this.proportion != -1.0f) {
            this.mBuilder.setSpan((Object)new RelativeSizeSpan(this.proportion), n, n2, this.flag);
        }
        if (this.xProportion != -1.0f) {
            this.mBuilder.setSpan((Object)new ScaleXSpan(this.xProportion), n, n2, this.flag);
        }
        if (this.lineHeight != -1) {
            this.mBuilder.setSpan((Object)new CustomLineHeightSpan(this.lineHeight, this.alignLine), n, n2, this.flag);
        }
        if (this.isStrikethrough) {
            this.mBuilder.setSpan((Object)new StrikethroughSpan(), n, n2, this.flag);
        }
        if (this.isUnderline) {
            this.mBuilder.setSpan((Object)new UnderlineSpan(), n, n2, this.flag);
        }
        if (this.isSuperscript) {
            this.mBuilder.setSpan((Object)new SuperscriptSpan(), n, n2, this.flag);
        }
        if (this.isSubscript) {
            this.mBuilder.setSpan((Object)new SubscriptSpan(), n, n2, this.flag);
        }
        if (this.isBold) {
            this.mBuilder.setSpan((Object)new StyleSpan(1), n, n2, this.flag);
        }
        if (this.isItalic) {
            this.mBuilder.setSpan((Object)new StyleSpan(2), n, n2, this.flag);
        }
        if (this.isBoldItalic) {
            this.mBuilder.setSpan((Object)new StyleSpan(3), n, n2, this.flag);
        }
        if (this.fontFamily != null) {
            this.mBuilder.setSpan((Object)new TypefaceSpan(this.fontFamily), n, n2, this.flag);
        }
        if (this.typeface != null) {
            this.mBuilder.setSpan((Object)new CustomTypefaceSpan(this.typeface), n, n2, this.flag);
        }
        if (this.alignment != null) {
            this.mBuilder.setSpan((Object)new AlignmentSpan.Standard(this.alignment), n, n2, this.flag);
        }
        if (this.clickSpan != null) {
            this.mBuilder.setSpan((Object)this.clickSpan, n, n2, this.flag);
        }
        if (this.url != null) {
            this.mBuilder.setSpan((Object)new URLSpan(this.url), n, n2, this.flag);
        }
        if (this.blurRadius != -1.0f) {
            this.mBuilder.setSpan((Object)new MaskFilterSpan((MaskFilter)new BlurMaskFilter(this.blurRadius, this.style)), n, n2, this.flag);
        }
        if (this.shader != null) {
            this.mBuilder.setSpan((Object)new ShaderSpan(this.shader), n, n2, this.flag);
        }
        if (this.shadowRadius != -1.0f) {
            this.mBuilder.setSpan((Object)new ShadowSpan(this.shadowRadius, this.shadowDx, this.shadowDy, this.shadowColor), n, n2, this.flag);
        }
        if (this.spans != null) {
            for (Object object : this.spans) {
                this.mBuilder.setSpan(object, n, n2, this.flag);
            }
        }
    }

    private void updateImage() {
        int n = this.mBuilder.length();
        this.mBuilder.append((CharSequence)"<img>");
        int n2 = n + 5;
        if (this.imageBitmap != null) {
            this.mBuilder.setSpan((Object)new CustomImageSpan(this.imageBitmap, this.alignImage), n, n2, this.flag);
        } else if (this.imageDrawable != null) {
            this.mBuilder.setSpan((Object)new CustomImageSpan(this.imageDrawable, this.alignImage), n, n2, this.flag);
        } else if (this.imageUri != null) {
            this.mBuilder.setSpan((Object)new CustomImageSpan(this.imageUri, this.alignImage), n, n2, this.flag);
        } else if (this.imageResourceId != -1) {
            this.mBuilder.setSpan((Object)new CustomImageSpan(this.imageResourceId, this.alignImage), n, n2, this.flag);
        }
    }

    private void updateSpace() {
        int n = this.mBuilder.length();
        this.mBuilder.append((CharSequence)"< >");
        int n2 = n + 3;
        this.mBuilder.setSpan((Object)new SpaceSpan(this.spaceSize, this.spaceColor), n, n2, this.flag);
    }

    class ShadowSpan
    extends CharacterStyle
    implements UpdateAppearance {
        private float radius;
        private float dx;
        private float dy;
        private int shadowColor;

        private ShadowSpan(float f, float f2, float f3, int n) {
            this.radius = f;
            this.dx = f2;
            this.dy = f3;
            this.shadowColor = n;
        }

        public void updateDrawState(TextPaint textPaint) {
            textPaint.setShadowLayer(this.radius, this.dx, this.dy, this.shadowColor);
        }
    }

    class ShaderSpan
    extends CharacterStyle
    implements UpdateAppearance {
        private Shader mShader;

        private ShaderSpan(Shader shader) {
            this.mShader = shader;
        }

        public void updateDrawState(TextPaint textPaint) {
            textPaint.setShader(this.mShader);
        }
    }

    abstract class CustomDynamicDrawableSpan
    extends ReplacementSpan {
        static final int ALIGN_BOTTOM = 0;
        static final int ALIGN_BASELINE = 1;
        static final int ALIGN_CENTER = 2;
        static final int ALIGN_TOP = 3;
        final int mVerticalAlignment;
        private WeakReference<Drawable> mDrawableRef;

        private CustomDynamicDrawableSpan() {
            this.mVerticalAlignment = 0;
        }

        private CustomDynamicDrawableSpan(int n) {
            this.mVerticalAlignment = n;
        }

        public abstract Drawable getDrawable();

        public int getSize(@NonNull Paint paint, CharSequence charSequence, int n, int n2, Paint.FontMetricsInt fontMetricsInt) {
            int n3;
            if (paint == null) {
                throw new NullPointerException("Argument 'paint' of type Paint (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
            }
            Drawable drawable = this.getCachedDrawable();
            Rect rect = drawable.getBounds();
            if (fontMetricsInt != null && (n3 = fontMetricsInt.bottom - fontMetricsInt.top) < rect.height()) {
                if (this.mVerticalAlignment == 3) {
                    fontMetricsInt.top = fontMetricsInt.top;
                    fontMetricsInt.bottom = rect.height() + fontMetricsInt.top;
                } else if (this.mVerticalAlignment == 2) {
                    fontMetricsInt.top = -rect.height() / 2 - n3 / 4;
                    fontMetricsInt.bottom = rect.height() / 2 - n3 / 4;
                } else {
                    fontMetricsInt.top = -rect.height() + fontMetricsInt.bottom;
                    fontMetricsInt.bottom = fontMetricsInt.bottom;
                }
                fontMetricsInt.ascent = fontMetricsInt.top;
                fontMetricsInt.descent = fontMetricsInt.bottom;
            }
            return rect.right;
        }

        public void draw(@NonNull Canvas canvas, CharSequence charSequence, int n, int n2, float f, int n3, int n4, int n5, @NonNull Paint paint) {
            if (canvas == null) {
                throw new NullPointerException("Argument 'canvas' of type Canvas (#0 out of 9, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
            }
            if (paint == null) {
                throw new NullPointerException("Argument 'paint' of type Paint (#8 out of 9, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
            }
            Drawable drawable = this.getCachedDrawable();
            Rect rect = drawable.getBounds();
            canvas.save();
            int n6 = n5 - n3;
            if (rect.height() < n6) {
                float f2 = this.mVerticalAlignment == 3 ? (float)n3 : (this.mVerticalAlignment == 2 ? (float)((n5 + n3 - rect.height()) / 2) : (this.mVerticalAlignment == 1 ? (float)(n4 - rect.height()) : (float)(n5 - rect.height())));
                canvas.translate(f, f2);
            } else {
                canvas.translate(f, (float)n3);
            }
            drawable.draw(canvas);
            canvas.restore();
        }

        private Drawable getCachedDrawable() {
            WeakReference<Drawable> weakReference = this.mDrawableRef;
            Drawable drawable = null;
            if (weakReference != null) {
                drawable = (Drawable)weakReference.get();
            }
            if (drawable == null) {
                drawable = this.getDrawable();
                this.mDrawableRef = new WeakReference<Drawable>(drawable);
            }
            return drawable;
        }
    }

    class CustomImageSpan
    extends CustomDynamicDrawableSpan {
        private Drawable mDrawable;
        private Uri mContentUri;
        private int mResourceId;

        private CustomImageSpan(Bitmap bitmap, int n) {
            super(n);
            this.mDrawable = new BitmapDrawable(Utils.getApp().getResources(), bitmap);
            this.mDrawable.setBounds(0, 0, this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
        }

        private CustomImageSpan(Drawable drawable, int n) {
            super(n);
            this.mDrawable = drawable;
            this.mDrawable.setBounds(0, 0, this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
        }

        private CustomImageSpan(Uri uri, int n) {
            super(n);
            this.mContentUri = uri;
        }

        private CustomImageSpan(@DrawableRes int n, int n2) {
            super(n2);
            this.mResourceId = n;
        }

        @Override
        public Drawable getDrawable() {
            Drawable drawable = null;
            if (this.mDrawable != null) {
                drawable = this.mDrawable;
            } else if (this.mContentUri != null) {
                try {
                    InputStream inputStream = Utils.getApp().getContentResolver().openInputStream(this.mContentUri);
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
                    drawable = new BitmapDrawable(Utils.getApp().getResources(), bitmap);
                    drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"sms", (String)("Failed to loaded content " + this.mContentUri), (Throwable)exception);
                }
            } else {
                try {
                    drawable = ContextCompat.getDrawable((Context)Utils.getApp(), (int)this.mResourceId);
                    drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
                }
                catch (Exception exception) {
                    Log.e((String)"sms", (String)("Unable to find resource: " + this.mResourceId));
                }
            }
            return drawable;
        }
    }

    @SuppressLint(value={"ParcelCreator"})
    class CustomTypefaceSpan
    extends TypefaceSpan {
        private final Typeface newType;

        private CustomTypefaceSpan(Typeface typeface) {
            super("");
            this.newType = typeface;
        }

        public void updateDrawState(TextPaint textPaint) {
            this.apply((Paint)textPaint, this.newType);
        }

        public void updateMeasureState(TextPaint textPaint) {
            this.apply((Paint)textPaint, this.newType);
        }

        private void apply(Paint paint, Typeface typeface) {
            Typeface typeface2 = paint.getTypeface();
            int n = typeface2 == null ? 0 : typeface2.getStyle();
            int n2 = n & ~typeface.getStyle();
            if ((n2 & 1) != 0) {
                paint.setFakeBoldText(true);
            }
            if ((n2 & 2) != 0) {
                paint.setTextSkewX(-0.25f);
            }
            paint.getShader();
            paint.setTypeface(typeface);
        }
    }

    class CustomBulletSpan
    implements LeadingMarginSpan {
        private final int color;
        private final int radius;
        private final int gapWidth;
        private Path sBulletPath = null;

        private CustomBulletSpan(int n, int n2, int n3) {
            this.color = n;
            this.radius = n2;
            this.gapWidth = n3;
        }

        public int getLeadingMargin(boolean bl) {
            return 2 * this.radius + this.gapWidth;
        }

        public void drawLeadingMargin(Canvas canvas, Paint paint, int n, int n2, int n3, int n4, int n5, CharSequence charSequence, int n6, int n7, boolean bl, Layout layout) {
            if (((Spanned)charSequence).getSpanStart((Object)this) == n6) {
                Paint.Style style = paint.getStyle();
                int n8 = 0;
                n8 = paint.getColor();
                paint.setColor(this.color);
                paint.setStyle(Paint.Style.FILL);
                if (canvas.isHardwareAccelerated()) {
                    if (this.sBulletPath == null) {
                        this.sBulletPath = new Path();
                        this.sBulletPath.addCircle(0.0f, 0.0f, (float)this.radius, Path.Direction.CW);
                    }
                    canvas.save();
                    canvas.translate((float)(n + n2 * this.radius), (float)(n3 + n5) / 2.0f);
                    canvas.drawPath(this.sBulletPath, paint);
                    canvas.restore();
                } else {
                    canvas.drawCircle((float)(n + n2 * this.radius), (float)(n3 + n5) / 2.0f, (float)this.radius, paint);
                }
                paint.setColor(n8);
                paint.setStyle(style);
            }
        }
    }

    class CustomQuoteSpan
    implements LeadingMarginSpan {
        private final int color;
        private final int stripeWidth;
        private final int gapWidth;

        private CustomQuoteSpan(int n, int n2, int n3) {
            this.color = n;
            this.stripeWidth = n2;
            this.gapWidth = n3;
        }

        public int getLeadingMargin(boolean bl) {
            return this.stripeWidth + this.gapWidth;
        }

        public void drawLeadingMargin(Canvas canvas, Paint paint, int n, int n2, int n3, int n4, int n5, CharSequence charSequence, int n6, int n7, boolean bl, Layout layout) {
            Paint.Style style = paint.getStyle();
            int n8 = paint.getColor();
            paint.setStyle(Paint.Style.FILL);
            paint.setColor(this.color);
            canvas.drawRect((float)n, (float)n3, (float)(n + n2 * this.stripeWidth), (float)n5, paint);
            paint.setStyle(style);
            paint.setColor(n8);
        }
    }

    class SpaceSpan
    extends ReplacementSpan {
        private final int width;
        private final int color;

        private SpaceSpan(int n) {
            this(n, 0);
        }

        private SpaceSpan(int n, int n2) {
            this.width = n;
            this.color = n2;
        }

        public int getSize(@NonNull Paint paint, CharSequence charSequence, @IntRange(from=0L) int n, @IntRange(from=0L) int n2, @Nullable Paint.FontMetricsInt fontMetricsInt) {
            if (paint == null) {
                throw new NullPointerException("Argument 'paint' of type Paint (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
            }
            return this.width;
        }

        public void draw(@NonNull Canvas canvas, CharSequence charSequence, @IntRange(from=0L) int n, @IntRange(from=0L) int n2, float f, int n3, int n4, int n5, @NonNull Paint paint) {
            if (canvas == null) {
                throw new NullPointerException("Argument 'canvas' of type Canvas (#0 out of 9, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
            }
            if (paint == null) {
                throw new NullPointerException("Argument 'paint' of type Paint (#8 out of 9, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
            }
            Paint.Style style = paint.getStyle();
            int n6 = paint.getColor();
            paint.setStyle(Paint.Style.FILL);
            paint.setColor(this.color);
            canvas.drawRect(f, (float)n3, f + (float)this.width, (float)n5, paint);
            paint.setStyle(style);
            paint.setColor(n6);
        }
    }

    class CustomLineHeightSpan
    extends CharacterStyle
    implements LineHeightSpan {
        private final int height;
        static final int ALIGN_CENTER = 2;
        static final int ALIGN_TOP = 3;
        final int mVerticalAlignment;

        CustomLineHeightSpan(int n, int n2) {
            this.height = n;
            this.mVerticalAlignment = n2;
        }

        public void chooseHeight(CharSequence charSequence, int n, int n2, int n3, int n4, Paint.FontMetricsInt fontMetricsInt) {
            int n5 = this.height - (n4 + fontMetricsInt.descent - fontMetricsInt.ascent - n3);
            if (this.mVerticalAlignment == 3) {
                fontMetricsInt.descent += n5;
            } else if (this.mVerticalAlignment == 2) {
                fontMetricsInt.descent += n5 / 2;
                fontMetricsInt.ascent -= n5 / 2;
            } else {
                fontMetricsInt.ascent -= n5;
            }
            n5 = this.height - (n4 + fontMetricsInt.bottom - fontMetricsInt.top - n3);
            if (this.mVerticalAlignment == 3) {
                fontMetricsInt.top += n5;
            } else if (this.mVerticalAlignment == 2) {
                fontMetricsInt.bottom += n5 / 2;
                fontMetricsInt.top -= n5 / 2;
            } else {
                fontMetricsInt.top -= n5;
            }
        }

        public void updateDrawState(TextPaint textPaint) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Align {
    }
}

