/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import com.blankj.utilcode.util.Utils;

public final class SizeUtils {
    private SizeUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static int dp2px(float f) {
        float f2 = Utils.getApp().getResources().getDisplayMetrics().density;
        return (int)(f * f2 + 0.5f);
    }

    public static int px2dp(float f) {
        float f2 = Utils.getApp().getResources().getDisplayMetrics().density;
        return (int)(f / f2 + 0.5f);
    }

    public static int sp2px(float f) {
        float f2 = Utils.getApp().getResources().getDisplayMetrics().scaledDensity;
        return (int)(f * f2 + 0.5f);
    }

    public static int px2sp(float f) {
        float f2 = Utils.getApp().getResources().getDisplayMetrics().scaledDensity;
        return (int)(f / f2 + 0.5f);
    }

    public static float applyDimension(float f, int n) {
        DisplayMetrics displayMetrics = Utils.getApp().getResources().getDisplayMetrics();
        switch (n) {
            case 0: {
                return f;
            }
            case 1: {
                return f * displayMetrics.density;
            }
            case 2: {
                return f * displayMetrics.scaledDensity;
            }
            case 3: {
                return f * displayMetrics.xdpi * 0.013888889f;
            }
            case 4: {
                return f * displayMetrics.xdpi;
            }
            case 5: {
                return f * displayMetrics.xdpi * 0.03937008f;
            }
        }
        return 0.0f;
    }

    public static void forceGetViewSize(final View view, final onGetSizeListener onGetSizeListener2) {
        view.post(new Runnable(){

            @Override
            public void run() {
                if (onGetSizeListener2 != null) {
                    onGetSizeListener2.onGetSize(view);
                }
            }
        });
    }

    public static int getMeasuredWidth(View view) {
        return SizeUtils.measureView(view)[0];
    }

    public static int getMeasuredHeight(View view) {
        return SizeUtils.measureView(view)[1];
    }

    public static int[] measureView(View view) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new ViewGroup.LayoutParams(-1, -2);
        }
        int n = ViewGroup.getChildMeasureSpec((int)0, (int)0, (int)layoutParams.width);
        int n2 = layoutParams.height;
        int n3 = n2 > 0 ? View.MeasureSpec.makeMeasureSpec((int)n2, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(n, n3);
        return new int[]{view.getMeasuredWidth(), view.getMeasuredHeight()};
    }

    public static interface onGetSizeListener {
        public void onGetSize(View var1);
    }
}

