/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

public final class ShellUtils {
    private static final String LINE_SEP = System.getProperty("line.separator");

    private ShellUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static CommandResult execCmd(String string, boolean bl) {
        return ShellUtils.execCmd(new String[]{string}, bl, true);
    }

    public static CommandResult execCmd(List<String> list, boolean bl) {
        return ShellUtils.execCmd(list == null ? null : list.toArray(new String[0]), bl, true);
    }

    public static CommandResult execCmd(String[] stringArray, boolean bl) {
        return ShellUtils.execCmd(stringArray, bl, true);
    }

    public static CommandResult execCmd(String string, boolean bl, boolean bl2) {
        return ShellUtils.execCmd(new String[]{string}, bl, bl2);
    }

    public static CommandResult execCmd(List<String> list, boolean bl, boolean bl2) {
        return ShellUtils.execCmd(list == null ? null : list.toArray(new String[0]), bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommandResult execCmd(String[] stringArray, boolean bl, boolean bl2) {
        int n = -1;
        if (stringArray == null || stringArray.length == 0) {
            return new CommandResult(n, null, null);
        }
        Process process = null;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        StringBuilder stringBuilder = null;
        StringBuilder stringBuilder2 = null;
        FilterOutputStream filterOutputStream = null;
        try {
            process = Runtime.getRuntime().exec(bl ? "su" : "sh");
            filterOutputStream = new DataOutputStream(process.getOutputStream());
            for (String string : stringArray) {
                if (string == null) continue;
                filterOutputStream.write(string.getBytes());
                ((DataOutputStream)filterOutputStream).writeBytes(LINE_SEP);
                ((DataOutputStream)filterOutputStream).flush();
            }
            ((DataOutputStream)filterOutputStream).writeBytes("exit" + LINE_SEP);
            ((DataOutputStream)filterOutputStream).flush();
            n = process.waitFor();
            if (bl2) {
                String exception;
                stringBuilder = new StringBuilder();
                stringBuilder2 = new StringBuilder();
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
                bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream(), "UTF-8"));
                String string = bufferedReader.readLine();
                if (string != null) {
                    String string2;
                    stringBuilder.append(string);
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuilder.append(LINE_SEP).append(string2);
                    }
                }
                if ((exception = bufferedReader2.readLine()) != null) {
                    String string3;
                    stringBuilder2.append(exception);
                    while ((string3 = bufferedReader2.readLine()) != null) {
                        stringBuilder2.append(LINE_SEP).append(string3);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                if (bufferedReader2 != null) {
                    bufferedReader2.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (process != null) {
                process.destroy();
            }
        }
        return new CommandResult(n, stringBuilder == null ? null : stringBuilder.toString(), stringBuilder2 == null ? null : stringBuilder2.toString());
    }

    public static class CommandResult {
        public int result;
        public String successMsg;
        public String errorMsg;

        public CommandResult(int n, String string, String string2) {
            this.result = n;
            this.successMsg = string;
            this.errorMsg = string2;
        }
    }
}

