/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import com.blankj.utilcode.util.Utils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ServiceUtils {
    private ServiceUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Set getAllRunningServices() {
        ActivityManager activityManager = (ActivityManager)Utils.getApp().getSystemService("activity");
        if (activityManager == null) {
            return Collections.emptySet();
        }
        List list = activityManager.getRunningServices(Integer.MAX_VALUE);
        HashSet<String> hashSet = new HashSet<String>();
        if (list == null || list.size() == 0) {
            return null;
        }
        for (ActivityManager.RunningServiceInfo runningServiceInfo : list) {
            hashSet.add(runningServiceInfo.service.getClassName());
        }
        return hashSet;
    }

    public static void startService(String string) {
        try {
            ServiceUtils.startService(Class.forName(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void startService(Class<?> clazz) {
        Intent intent = new Intent((Context)Utils.getApp(), clazz);
        Utils.getApp().startService(intent);
    }

    public static boolean stopService(String string) {
        try {
            return ServiceUtils.stopService(Class.forName(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean stopService(Class<?> clazz) {
        Intent intent = new Intent((Context)Utils.getApp(), clazz);
        return Utils.getApp().stopService(intent);
    }

    public static void bindService(String string, ServiceConnection serviceConnection, int n) {
        try {
            ServiceUtils.bindService(Class.forName(string), serviceConnection, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void bindService(Class<?> clazz, ServiceConnection serviceConnection, int n) {
        Intent intent = new Intent((Context)Utils.getApp(), clazz);
        Utils.getApp().bindService(intent, serviceConnection, n);
    }

    public static void unbindService(ServiceConnection serviceConnection) {
        Utils.getApp().unbindService(serviceConnection);
    }

    public static boolean isServiceRunning(Class<?> clazz) {
        return ServiceUtils.isServiceRunning(clazz.getName());
    }

    public static boolean isServiceRunning(String string) {
        ActivityManager activityManager = (ActivityManager)Utils.getApp().getSystemService("activity");
        if (activityManager == null) {
            return false;
        }
        List list = activityManager.getRunningServices(Integer.MAX_VALUE);
        if (list == null || list.size() == 0) {
            return false;
        }
        for (ActivityManager.RunningServiceInfo runningServiceInfo : list) {
            if (!string.equals(runningServiceInfo.service.getClassName())) continue;
            return true;
        }
        return false;
    }
}

