/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.Activity;
import android.app.KeyguardManager;
import android.content.ContentResolver;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import com.blankj.utilcode.util.Utils;

public final class ScreenUtils {
    private ScreenUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static int getScreenWidth() {
        WindowManager windowManager = (WindowManager)Utils.getApp().getSystemService("window");
        if (windowManager == null) {
            return Utils.getApp().getResources().getDisplayMetrics().widthPixels;
        }
        Point point = new Point();
        if (Build.VERSION.SDK_INT >= 17) {
            windowManager.getDefaultDisplay().getRealSize(point);
        } else {
            windowManager.getDefaultDisplay().getSize(point);
        }
        return point.x;
    }

    public static int getScreenHeight() {
        WindowManager windowManager = (WindowManager)Utils.getApp().getSystemService("window");
        if (windowManager == null) {
            return Utils.getApp().getResources().getDisplayMetrics().heightPixels;
        }
        Point point = new Point();
        if (Build.VERSION.SDK_INT >= 17) {
            windowManager.getDefaultDisplay().getRealSize(point);
        } else {
            windowManager.getDefaultDisplay().getSize(point);
        }
        return point.y;
    }

    public static float getScreenDensity() {
        return Utils.getApp().getResources().getDisplayMetrics().density;
    }

    public static int getScreenDensityDpi() {
        return Utils.getApp().getResources().getDisplayMetrics().densityDpi;
    }

    public static void setFullScreen(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        activity.getWindow().addFlags(1536);
    }

    public static void setLandscape(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        activity.setRequestedOrientation(0);
    }

    public static void setPortrait(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        activity.setRequestedOrientation(1);
    }

    public static boolean isLandscape() {
        return Utils.getApp().getResources().getConfiguration().orientation == 2;
    }

    public static boolean isPortrait() {
        return Utils.getApp().getResources().getConfiguration().orientation == 1;
    }

    public static int getScreenRotation(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        switch (activity.getWindowManager().getDefaultDisplay().getRotation()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public static Bitmap screenShot(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return ScreenUtils.screenShot(activity, false);
    }

    public static Bitmap screenShot(@NonNull Activity activity, boolean bl) {
        Bitmap bitmap;
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        View view = activity.getWindow().getDecorView();
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bitmap2 = view.getDrawingCache();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        if (bl) {
            Resources resources = activity.getResources();
            int n = resources.getIdentifier("status_bar_height", "dimen", "android");
            int n2 = resources.getDimensionPixelSize(n);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)n2, (int)displayMetrics.widthPixels, (int)(displayMetrics.heightPixels - n2));
        } else {
            bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)displayMetrics.widthPixels, (int)displayMetrics.heightPixels);
        }
        view.destroyDrawingCache();
        return bitmap;
    }

    public static boolean isScreenLock() {
        KeyguardManager keyguardManager = (KeyguardManager)Utils.getApp().getSystemService("keyguard");
        return keyguardManager != null && keyguardManager.inKeyguardRestrictedInputMode();
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setSleepDuration(int n) {
        Settings.System.putInt((ContentResolver)Utils.getApp().getContentResolver(), (String)"screen_off_timeout", (int)n);
    }

    public static int getSleepDuration() {
        try {
            return Settings.System.getInt((ContentResolver)Utils.getApp().getContentResolver(), (String)"screen_off_timeout");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            settingNotFoundException.printStackTrace();
            return -123;
        }
    }

    public static boolean isTablet() {
        return (Utils.getApp().getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }
}

