/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.os.Environment;
import android.os.storage.StorageManager;
import com.blankj.utilcode.util.Utils;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SDCardUtils {
    private SDCardUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isSDCardEnableByEnvironment() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    public static String getSDCardPathByEnvironment() {
        if ("mounted".equals(Environment.getExternalStorageState())) {
            return Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        return "";
    }

    public static boolean isSDCardEnable() {
        return !SDCardUtils.getSDCardPaths().isEmpty();
    }

    public static List<String> getSDCardPaths(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StorageManager storageManager = (StorageManager)Utils.getApp().getSystemService("storage");
        try {
            Class<?> clazz = Class.forName("android.os.storage.StorageVolume");
            Method method = StorageManager.class.getMethod("getVolumeList", new Class[0]);
            Method method2 = clazz.getMethod("getPath", new Class[0]);
            Method method3 = clazz.getMethod("isRemovable", new Class[0]);
            Object object = method.invoke((Object)storageManager, new Object[0]);
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = Array.get(object, i);
                String string = (String)method2.invoke(object2, new Object[0]);
                boolean bl2 = (Boolean)method3.invoke(object2, new Object[0]);
                if (bl != bl2) continue;
                arrayList.add(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return arrayList;
    }

    public static List<String> getSDCardPaths() {
        StorageManager storageManager = (StorageManager)Utils.getApp().getSystemService("storage");
        List<String> list = new ArrayList<String>();
        try {
            Method method = StorageManager.class.getMethod("getVolumePaths", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke((Object)storageManager, new Object[0]);
            list = Arrays.asList((String[])object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return list;
    }
}

