/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.support.annotation.RawRes;
import com.blankj.utilcode.util.Utils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public final class ResourceUtils {
    private static final int BUFFER_SIZE = 8192;

    private ResourceUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean copyFileFromAssets(String string, String string2) {
        boolean bl = true;
        try {
            String[] stringArray = Utils.getApp().getAssets().list(string);
            if (stringArray.length > 0) {
                for (String string3 : stringArray) {
                    bl &= ResourceUtils.copyFileFromAssets(string + "/" + string3, string2 + "/" + string3);
                }
            } else {
                bl = ResourceUtils.writeFileFromIS(string2, Utils.getApp().getAssets().open(string), false);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public static String readAssets2String(String string) {
        return ResourceUtils.readAssets2String(string, null);
    }

    public static String readAssets2String(String string, String string2) {
        InputStream inputStream;
        try {
            inputStream = Utils.getApp().getAssets().open(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        byte[] byArray = ResourceUtils.is2Bytes(inputStream);
        if (byArray == null) {
            return null;
        }
        if (ResourceUtils.isSpace(string2)) {
            return new String(byArray);
        }
        try {
            return new String(byArray, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return "";
        }
    }

    public static List<String> readAssets2List(String string) {
        return ResourceUtils.readAssets2List(string, null);
    }

    public static List<String> readAssets2List(String string, String string2) {
        try {
            return ResourceUtils.is2List(Utils.getApp().getResources().getAssets().open(string), string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static boolean copyFileFromRaw(@RawRes int n, String string) {
        return ResourceUtils.writeFileFromIS(string, Utils.getApp().getResources().openRawResource(n), false);
    }

    public static String readRaw2String(@RawRes int n) {
        return ResourceUtils.readRaw2String(n, null);
    }

    public static String readRaw2String(@RawRes int n, String string) {
        InputStream inputStream = Utils.getApp().getResources().openRawResource(n);
        byte[] byArray = ResourceUtils.is2Bytes(inputStream);
        if (byArray == null) {
            return null;
        }
        if (ResourceUtils.isSpace(string)) {
            return new String(byArray);
        }
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return "";
        }
    }

    public static List<String> readRaw2List(@RawRes int n) {
        return ResourceUtils.readRaw2List(n, null);
    }

    public static List<String> readRaw2List(@RawRes int n, String string) {
        return ResourceUtils.is2List(Utils.getApp().getResources().openRawResource(n), string);
    }

    private static boolean writeFileFromIS(String string, InputStream inputStream, boolean bl) {
        return ResourceUtils.writeFileFromIS(ResourceUtils.getFileByPath(string), inputStream, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeFileFromIS(File file, InputStream inputStream, boolean bl) {
        if (!ResourceUtils.createOrExistsFile(file) || inputStream == null) {
            return false;
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file, bl));
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray, 0, 8192)) != -1) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                if (bufferedOutputStream != null) {
                    ((OutputStream)bufferedOutputStream).close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static File getFileByPath(String string) {
        return ResourceUtils.isSpace(string) ? null : new File(string);
    }

    private static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!ResourceUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean isSpace(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] is2Bytes(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n;
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray, 0, 8192)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> is2List(InputStream inputStream, String string) {
        BufferedReader bufferedReader = null;
        try {
            String string2;
            ArrayList<String> arrayList = new ArrayList<String>();
            bufferedReader = ResourceUtils.isSpace(string) ? new BufferedReader(new InputStreamReader(inputStream)) : new BufferedReader(new InputStreamReader(inputStream, string));
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(string2);
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            List<String> list = null;
            return list;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

